/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.internet;

import com.genexus.CommonUtil;
import com.genexus.GXBCCollection;
import com.genexus.GXBaseCollection;
import com.genexus.GXSimpleCollection;
import com.genexus.GXutil;
import com.genexus.GxSilentTrnSdt;
import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.internet.HttpClient;
import com.genexus.internet.IGxJSONSerializable;
import com.genexus.internet.Location;
import com.genexus.xml.GXXMLSerializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import json.org.json.JSONArray;
import json.org.json.JSONException;
import json.org.json.JSONObject;

public class GXRestAPIClient {
    public static final ILogger logger = LogManager.getLogger(GXRestAPIClient.class);
    private HttpClient httpClient;
    private String name;
    private Location location;
    private String protocol = "REST";
    private String httpMethod = "GET";
    private int statusCode;
    private int errorCode;
    private String errorMessage;
    private Integer responseCode = 0;
    private String responseMessage = "";
    private String contentType = "application/json; charset=utf-8";
    private String queryString = "";
    private String bodyString = "";
    private JSONObject jsonResponse;
    private HashMap<String, String> queryVars = new HashMap();
    private HashMap<String, String> bodyVars = new HashMap();
    private HashMap<String, String> responseData = new HashMap();
    static final String DATE_FMT = "yyyy-MM-dd";
    static final String DATETIME_FMT = "yyyy-MM-dd'T'HH:mm:ss";
    static final String DATETIME_FMT_MS = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    static final String DATE_NULL = "0000-00-00";
    static final String DATETIME_NULL = "0000-00-00T00:00:00";
    static final int RESPONSE_ERROR_CODE = 2;
    static final int PARSING_ERROR_CODE = 3;
    static final int DESERIALIZING_ERROR_CODE = 4;
    static final String RESPONSE_ERROR_MSG = "Invalid response";
    static final String PARSING_ERROR_MSG = "Error parsing response";
    static final String DESERIALIZING_ERROR_MSG = "Error serializing/deserializing object";

    public GXRestAPIClient() {
        this.httpClient = new HttpClient();
        this.location = new Location();
    }

    public String getName() {
        return this.name;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setLocation(Location value) {
        this.location = value;
    }

    public void setProtocol(String value) {
        this.protocol = value;
    }

    public void setHttpMethod(String value) {
        this.httpMethod = value;
    }

    public void setStatusCode(int value) {
        this.statusCode = value;
    }

    public void setErrorCode(int value) {
        this.errorCode = value;
    }

    public void setErrorMessage(String value) {
        this.errorMessage = value;
    }

    public void addQueryVar(String varName, String varValue) {
        this.queryVars.put(varName, GXutil.URLEncode(varValue));
    }

    public void addQueryVar(String varName, int varValue) {
        this.queryVars.put(varName, Integer.toString(varValue));
    }

    public void addQueryVar(String varName, short varValue) {
        this.queryVars.put(varName, String.valueOf(varValue));
    }

    public void addQueryVar(String varName, long varValue) {
        this.queryVars.put(varName, String.valueOf(varValue));
    }

    public void addQueryVar(String varName, double varValue) {
        this.queryVars.put(varName, Double.toString(varValue));
    }

    public void addQueryVar(String varName, Date varValue) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FMT);
        this.queryVars.put(varName, df.format(varValue));
    }

    public void addQueryVar(String varName, Date varValue, boolean hasMilliseconds) {
        String fmt = DATETIME_FMT;
        if (hasMilliseconds) {
            fmt = DATETIME_FMT_MS;
        }
        SimpleDateFormat df = new SimpleDateFormat(fmt);
        this.queryVars.put(varName, df.format(varValue));
    }

    public void addQueryVar(String varName, UUID varValue) {
        this.queryVars.put(varName, varValue.toString());
    }

    public void addQueryVar(String varName, Boolean varValue) {
        this.queryVars.put(varName, varValue.toString());
    }

    public void addQueryVar(String varName, BigDecimal varValue) {
        this.queryVars.put(varName, varValue.toString());
    }

    public void addQueryVar(String varName, GXXMLSerializable varValue) {
        if (varValue != null) {
            this.queryVars.put(varName, varValue.toJSonString(false));
        }
    }

    public void addQueryVar(String varName, IGxJSONSerializable varValue) {
        this.queryVars.put(varName, GXutil.URLEncode(varValue.toJSonString()));
    }

    private String quoteString(String value) {
        return "\"" + value + "\"";
    }

    public <T extends GXXMLSerializable> void addBodyVar(String varName, GXBaseCollection<T> varValue) {
        if (varValue != null) {
            this.bodyVars.put(varName, varValue.toJSonString(false));
        }
    }

    public void addBodyVar(String varName, GXXMLSerializable varValue) {
        if (varValue != null) {
            this.bodyVars.put(varName, varValue.toJSonString(false));
        }
    }

    public void addBodyVar(String varName, String varValue) {
        this.bodyVars.put(varName, this.quoteString(varValue));
    }

    public void addBodyVar(String varName, double varValue) {
        this.bodyVars.put(varName, this.quoteString(Double.toString(varValue)));
    }

    public void addBodyVar(String varName, Date varValue) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FMT);
        this.bodyVars.put(varName, this.quoteString(df.format(varValue)));
    }

    public void addBodyVar(String varName, Date varValue, boolean hasMilliseconds) {
        String fmt = DATETIME_FMT;
        if (hasMilliseconds) {
            fmt = DATETIME_FMT_MS;
        }
        SimpleDateFormat df = new SimpleDateFormat(fmt);
        this.bodyVars.put(varName, this.quoteString(df.format(varValue)));
    }

    public void addBodyVar(String varName, short varValue) {
        this.bodyVars.put(varName, Short.toString(varValue));
    }

    public void addBodyVar(String varName, int varValue) {
        this.bodyVars.put(varName, Integer.toString(varValue));
    }

    public void addBodyVar(String varName, long varValue) {
        this.bodyVars.put(varName, Long.toString(varValue));
    }

    public void addBodyVar(String varName, Boolean varValue) {
        this.bodyVars.put(varName, varValue.toString());
    }

    public void addBodyVar(String varName, BigDecimal varValue) {
        this.bodyVars.put(varName, varValue.toString());
    }

    public void addBodyVar(String varName, UUID varValue) {
        this.bodyVars.put(varName, this.quoteString(varValue.toString()));
    }

    public void addBodyVar(String varName, IGxJSONSerializable varValue) {
        this.bodyVars.put(varName, this.quoteString(varValue.toJSonString()));
    }

    public String getBodyString(String varName) {
        return this.getJsonStr(varName);
    }

    public Date getBodyDate(String varName) {
        try {
            String val = this.getJsonStr(varName);
            if (val.startsWith(DATE_NULL)) {
                return CommonUtil.newNullDate();
            }
            return new SimpleDateFormat(DATE_FMT).parse(val);
        }
        catch (ParseException e) {
            return CommonUtil.newNullDate();
        }
    }

    public Date getBodyDateTime(String varName, Boolean hasMilliseconds) {
        try {
            String val = this.getJsonStr(varName);
            String fmt = DATETIME_FMT;
            if (hasMilliseconds.booleanValue()) {
                fmt = DATETIME_FMT_MS;
            }
            if (val.startsWith(DATETIME_NULL)) {
                return CommonUtil.newNullDate();
            }
            return new SimpleDateFormat(fmt).parse(val);
        }
        catch (ParseException e) {
            return CommonUtil.newNullDate();
        }
    }

    public boolean getBodyBool(String varName) {
        return Boolean.parseBoolean(this.getJsonStr(varName));
    }

    public UUID getBodyGuid(String varName) {
        return UUID.fromString(this.getJsonStr(varName));
    }

    public <T extends IGxJSONSerializable> T getBodyGeospatial(String varName, Class<T> sdtClass) {
        try {
            IGxJSONSerializable sdt = (IGxJSONSerializable)sdtClass.newInstance();
            sdt.fromJSonString(this.getJsonStr(varName));
            return (T)sdt;
        }
        catch (Exception e) {
            this.errorCode = 4;
            this.errorMessage = DESERIALIZING_ERROR_MSG;
            logger.error("Error serializing/deserializing object " + sdtClass, (Throwable)e);
            return null;
        }
    }

    public Double getBodyDouble(String varName) {
        return Double.parseDouble(this.getJsonStr(varName));
    }

    public BigDecimal getBodyNum(String varName) {
        return new BigDecimal(this.getJsonStr(varName));
    }

    public long getBodyLong(String varName) {
        long value = 0L;
        try {
            value = Long.parseLong(this.getJsonStr(varName));
        }
        catch (NumberFormatException ex) {
            value = Double.valueOf(this.getJsonStr(varName)).longValue();
        }
        return value;
    }

    public int getBodyInt(String varName) {
        return Integer.parseInt(this.getJsonStr(varName));
    }

    public short getBodyShort(String varName) {
        return Short.parseShort(this.getJsonStr(varName));
    }

    public String getJsonStr(String varName) {
        String jsonstr = "";
        try {
            if (this.jsonResponse != null) {
                if (this.jsonResponse.has(varName)) {
                    jsonstr = this.jsonResponse.getString(varName);
                } else if (this.jsonResponse.length() == 1 && this.jsonResponse.has("")) {
                    jsonstr = this.jsonResponse.getString("");
                }
            } else {
                this.errorCode = 2;
                this.errorMessage = RESPONSE_ERROR_MSG;
                logger.error(RESPONSE_ERROR_MSG);
            }
        }
        catch (JSONException e) {
            this.errorCode = 3;
            this.errorMessage = PARSING_ERROR_MSG;
            logger.error(PARSING_ERROR_MSG, (Throwable)e);
        }
        return jsonstr;
    }

    public <T extends GXXMLSerializable> T getBodyObj(String varName, Class<T> sdtClass) {
        GXXMLSerializable sdt;
        block12: {
            try {
                sdt = (GXXMLSerializable)sdtClass.newInstance();
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
            try {
                if (this.jsonResponse != null) {
                    Boolean dSuccess = false;
                    if (this.jsonResponse.has(varName) && this.jsonResponse.length() == 1) {
                        dSuccess = sdt.fromJSonString(this.jsonResponse.getString(varName), null);
                    } else if (this.jsonResponse.length() == 1 && this.jsonResponse.has("")) {
                        dSuccess = sdt.fromJSonString(this.jsonResponse.getString(""), null);
                    } else if (this.jsonResponse.length() >= 1) {
                        dSuccess = sdt.fromJSonString(this.httpClient.getString(), null);
                    }
                    if (!dSuccess.booleanValue()) {
                        this.errorCode = 2;
                        this.errorMessage = RESPONSE_ERROR_MSG;
                        logger.error("Invalid response " + sdtClass);
                        return null;
                    }
                    break block12;
                }
                this.errorCode = 2;
                this.errorMessage = RESPONSE_ERROR_MSG;
                logger.error("Invalid response " + sdtClass);
                return null;
            }
            catch (JSONException e) {
                this.errorCode = 3;
                this.errorMessage = PARSING_ERROR_MSG;
                logger.error("Error parsing response " + sdtClass, (Throwable)e);
                return null;
            }
        }
        return (T)sdt;
    }

    public <T extends GxSilentTrnSdt> GXBCCollection<T> getBodyBCCollection(String varName, Class<T> elementClass) {
        GXBCCollection col = new GXBCCollection();
        this.fillCollection(varName, elementClass, (GXBaseCollection)col);
        return col;
    }

    public <T extends GXXMLSerializable> GXBaseCollection<T> getBodyObjCollection(String varName, Class<T> elementClass) {
        GXBaseCollection col = new GXBaseCollection();
        this.fillCollection(varName, elementClass, col);
        return col;
    }

    private <T extends GXXMLSerializable> void fillCollection(String varName, Class<T> elementClass, GXBaseCollection col) {
        JSONArray jsonarr = new JSONArray();
        try {
            if (this.jsonResponse.has(varName)) {
                jsonarr = this.jsonResponse.getJSONArray(varName);
            } else if (this.jsonResponse.length() == 1 && this.jsonResponse.has("")) {
                jsonarr = this.jsonResponse.getJSONArray("");
            }
            if (jsonarr != null) {
                for (int i = 0; i < jsonarr.length(); ++i) {
                    JSONObject o = jsonarr.getJSONObject(i);
                    GXXMLSerializable sdt = (GXXMLSerializable)elementClass.newInstance();
                    sdt.fromJSonString(o.toString(), null);
                    col.add(sdt);
                }
            } else {
                this.errorCode = 2;
                this.errorMessage = RESPONSE_ERROR_MSG;
                logger.error("Invalid response " + elementClass);
            }
        }
        catch (JSONException e) {
            this.errorCode = 3;
            this.errorMessage = PARSING_ERROR_MSG;
            logger.error("Error parsing response " + elementClass, (Throwable)e);
        }
        catch (Exception e) {
            this.errorCode = 4;
            this.errorMessage = DESERIALIZING_ERROR_MSG;
            logger.error("Error serializing/deserializing object " + elementClass, (Throwable)e);
        }
    }

    public <T> GXSimpleCollection<T> getBodyCollection(String varName, Class<T> elementClasss) {
        GXSimpleCollection coll;
        try {
            coll = new GXSimpleCollection();
        }
        catch (Exception e) {
            return null;
        }
        try {
            if (this.jsonResponse.has(varName)) {
                coll.fromJSonString(this.jsonResponse.getString(varName), null);
            } else if (this.jsonResponse.length() == 1 && this.jsonResponse.has("")) {
                coll.fromJSonString(this.jsonResponse.getString(varName), null);
            }
        }
        catch (JSONException e) {
            this.errorCode = 3;
            this.errorMessage = PARSING_ERROR_MSG;
            logger.error("Error parsing response " + elementClasss, (Throwable)e);
        }
        return coll;
    }

    public void addUploadFile(String filePath, String fileName) {
        String mimeType;
        this.httpClient.addFile(filePath, fileName);
        this.contentType = mimeType = SpecificImplementation.Application.getContentType(filePath);
    }

    public void RestExecute() {
        String separator = "";
        this.queryString = "";
        if (this.queryVars.size() > 0) {
            separator = "?";
            for (Map.Entry<String, String> entry : this.queryVars.entrySet()) {
                this.queryString = this.queryString + String.format("%s%s=%s", separator, entry.getKey(), entry.getValue());
                separator = "&";
            }
        }
        this.bodyString = "";
        if (this.bodyVars.size() > 0) {
            separator = "";
            for (Map.Entry<String, String> entry : this.bodyVars.entrySet()) {
                this.bodyString = this.bodyString + separator + "\"" + entry.getKey() + "\":" + entry.getValue() + "";
                separator = ",";
            }
        }
        if (this.bodyString.length() > 0) {
            this.bodyString = "{" + this.bodyString + "}";
            this.httpClient.addString(this.bodyString);
            this.httpClient.addHeader("Content-Type", this.contentType);
        } else if (this.httpMethod == "POST" || this.httpMethod == "PUT") {
            this.bodyString = "{}";
            this.httpClient.addString(this.bodyString);
            this.httpClient.addHeader("Content-Type", this.contentType);
        }
        String serviceuri = (this.location.getSecure() > 0 ? "https" : "http") + "://" + this.location.getHost();
        serviceuri = serviceuri + (this.location.getPort() != 80 ? ":" + Integer.toString(this.location.getPort()) : "");
        serviceuri = serviceuri + "/" + this.location.getBaseURL() + "/" + this.location.getResourceName();
        serviceuri = serviceuri + this.queryString;
        this.httpClient.execute(this.httpMethod, serviceuri);
        if (this.httpClient.getStatusCode() >= 300 || this.httpClient.getErrCode() > 0) {
            this.errorCode = this.httpClient.getErrCode() == 0 ? 1 : (int)this.httpClient.getErrCode();
            this.errorMessage = this.httpClient.getErrDescription();
            this.statusCode = this.httpClient.getStatusCode();
        } else {
            this.statusCode = this.httpClient.getStatusCode();
            try {
                this.jsonResponse = new JSONObject(this.httpClient.getString());
            }
            catch (JSONException e) {
                this.errorCode = 3;
                this.errorMessage = PARSING_ERROR_MSG;
                logger.error(PARSING_ERROR_MSG, (Throwable)e);
                this.jsonResponse = new JSONObject();
            }
        }
    }
}

