/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.internet;

import com.genexus.ModelContext;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.internet.HttpContext;
import com.genexus.internet.websocket.GXWebSocketService;
import com.genexus.internet.websocket.SendResponseType;
import com.genexus.xml.GXXMLSerializable;

public class GXWebNotification {
    public static final ILogger logger = LogManager.getLogger(GXWebNotification.class);
    private GXWebSocketService wsService = GXWebSocketService.getService();
    private HttpContext httpContext;
    private short errCode;
    private String errDescription;

    public short getErrCode() {
        return this.errCode;
    }

    public String getErrDescription() {
        return this.errDescription;
    }

    public GXWebNotification(ModelContext gxContext) {
        this.httpContext = (HttpContext)gxContext.getHttpContext();
    }

    public short notifyClient(String clientId, String message) {
        return this.notifyClientImpl(clientId, message);
    }

    public short notifyClient(String clientId, GXXMLSerializable message) {
        String msg = message.toJSonString();
        return this.notifyClientImpl(clientId, msg);
    }

    public short notifyClientImpl(String clientId, String message) {
        SendResponseType result = this.wsService.send(clientId.trim(), message);
        switch (result) {
            case OK: {
                this.setError((short)0);
                break;
            }
            case SessionNotFound: {
                this.setError((short)2);
                break;
            }
            case SessionInvalid: {
                this.setError((short)3);
                break;
            }
            case SendFailed: {
                this.setError((short)4);
                break;
            }
        }
        return this.errCode;
    }

    public short notify(String message) {
        return this.notifyClient(this.httpContext.getClientId(), message);
    }

    public short notify(GXXMLSerializable message) {
        return this.notifyClient(this.httpContext.getClientId(), message);
    }

    public void broadcast(GXXMLSerializable message) {
        this.broadcastImpl(message.toJSonString());
    }

    public void broadcast(String message) {
        this.broadcastImpl(message);
    }

    private void broadcastImpl(String message) {
        this.wsService.broadcast(message);
        this.setError((short)0);
    }

    private void setError(short i) {
        this.errCode = i;
        switch (i) {
            case 0: {
                this.errDescription = "OK";
                break;
            }
            case 1: {
                this.errDescription = "WebSocket Server has not been initialized yet. No incoming connections were received";
                break;
            }
            case 2: {
                this.errDescription = "WebSocket Session not found. The client is not connected to socket server";
                break;
            }
            case 3: {
                this.errDescription = "WebSocket Session was found, but it's state was closed or invalid";
                break;
            }
            case 4: {
                this.errDescription = "Message could not be delivered to client because of a connection error";
                break;
            }
            default: {
                this.errDescription = "Unknown error";
            }
        }
    }

    public String getClientId() {
        return this.httpContext.getClientId();
    }
}

