/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.internet;

import com.genexus.CommonUtil;
import com.genexus.IHttpContext;
import com.genexus.ModelContext;
import com.genexus.internet.GXHttpClient;
import com.genexus.specific.java.HttpConnectMethod;
import com.genexus.specific.java.HttpDeleteWithBody;
import com.genexus.specific.java.HttpGetWithBody;
import com.genexus.specific.java.HttpHeadWithBody;
import com.genexus.specific.java.HttpOptionsWithBody;
import com.genexus.util.IniFile;
import com.genexus.webpanels.HttpContextWeb;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpClientJavaLib
extends GXHttpClient {
    private static Logger logger = LogManager.getLogger(HttpClientJavaLib.class);
    private static PoolingHttpClientConnectionManager connManager = null;
    private Integer statusCode = 0;
    private String reasonLine = "";
    private HttpClientBuilder httpClientBuilder;
    private HttpClientContext httpClientContext = null;
    private CloseableHttpResponse response = null;
    private CredentialsProvider credentialsProvider = null;
    private RequestConfig reqConfig = null;
    private CookieStore cookies;
    private ByteArrayEntity entity = null;
    BufferedReader reader = null;
    private Boolean lastAuthIsBasic = null;
    private Boolean lastAuthProxyIsBasic = null;
    private static IniFile clientCfg = new ModelContext(ModelContext.getModelContextPackageClass()).getPreferences().getIniFile();
    private static final String SET_COOKIE = "Set-Cookie";
    private static final String COOKIE = "Cookie";
    private Vector<InputStream> streamsToClose;
    private boolean eof;

    public HttpClientJavaLib() {
        HttpClientJavaLib.getPoolInstance();
        ConnectionKeepAliveStrategy myStrategy = this.generateKeepAliveStrategy();
        this.httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setConnectionManagerShared(true).setKeepAliveStrategy(myStrategy);
        this.cookies = new BasicCookieStore();
        logger.info("Using apache http client implementation");
        this.streamsToClose = new Vector();
    }

    private static void getPoolInstance() {
        if (connManager == null) {
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)HttpClientJavaLib.getSSLSecureInstance()).build();
            connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            connManager.setMaxTotal((int)CommonUtil.val((String)clientCfg.getProperty("Client", "HTTPCLIENT_MAX_SIZE", "1000")));
            connManager.setDefaultMaxPerRoute((int)CommonUtil.val((String)clientCfg.getProperty("Client", "HTTPCLIENT_MAX_PER_ROUTE", "1000")));
        } else {
            connManager.closeExpiredConnections();
        }
    }

    private ConnectionKeepAliveStrategy generateKeepAliveStrategy() {
        return new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                    return Long.parseLong(value) * 1000L;
                }
                return HttpClientJavaLib.this.getTimeout() * 1000;
            }
        };
    }

    public void setTimeout(int timeout) {
        super.setTimeout(timeout);
        ConnectionKeepAliveStrategy myStrategy = this.generateKeepAliveStrategy();
        this.httpClientBuilder.setKeepAliveStrategy(myStrategy);
    }

    private void closeOpenedStreams() {
        Enumeration<InputStream> e = this.streamsToClose.elements();
        while (e.hasMoreElements()) {
            try {
                e.nextElement().close();
            }
            catch (IOException ioex) {
                logger.error("Error closing stream: " + ioex.getMessage());
            }
        }
        this.streamsToClose.removeAllElements();
    }

    private void resetExecParams() {
        this.statusCode = 0;
        this.reasonLine = "";
        this.resetErrorsAndConnParams();
        this.setErrCode(0);
        this.setErrDescription("");
        this.entity = null;
    }

    private void resetErrorsAndConnParams() {
        if (this.response != null) {
            try {
                EntityUtils.consume((HttpEntity)this.response.getEntity());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void addAuthentication(int type, String realm, String name, String value) {
        this.lastAuthIsBasic = type == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        super.addAuthentication(type, realm, name, value);
    }

    public void addProxyAuthentication(int type, String realm, String name, String value) {
        this.lastAuthProxyIsBasic = type == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        super.addProxyAuthentication(type, realm, name, value);
    }

    private void resetStateAdapted() {
        this.resetState();
        this.getheadersToSend().clear();
    }

    public void setURL(String stringURL) {
        try {
            URI url = new URI(stringURL);
            this.setHost(url.getHost());
            this.setPort(url.getPort());
            this.setBaseURL(url.getPath());
            this.setSecure(url.getScheme().equalsIgnoreCase("https") ? 1 : 0);
        }
        catch (URISyntaxException e) {
            System.err.println("E " + e + " " + stringURL);
            e.printStackTrace();
        }
    }

    private String getURLValid(String url) {
        try {
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException _) {
                url = CommonUtil.escapeUnsafeChars((String)url);
                uri = new URI(url);
            }
            if (!uri.isAbsolute()) {
                return url;
            }
            this.setPrevURLhost(this.getHost());
            this.setPrevURLbaseURL(this.getBaseURL());
            this.setPrevURLport(this.getPort());
            this.setPrevURLsecure(this.getSecure());
            this.setIsURL(true);
            this.setURL(url);
            StringBuilder relativeUri = new StringBuilder();
            if (uri.getRawPath() != null) {
                relativeUri.append(uri.getRawPath());
            }
            if (uri.getRawQuery() != null) {
                relativeUri.append('?').append(uri.getRawQuery());
            }
            if (uri.getRawFragment() != null) {
                relativeUri.append('#').append(uri.getRawFragment());
            }
            return relativeUri.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return url;
        }
    }

    private static SSLConnectionSocketFactory getSSLSecureInstance() {
        try {
            SSLContextBuilder sslContextBuilder = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy());
            String pathToKeystore = System.getProperty("javax.net.ssl.keyStore");
            String keystorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
            if (pathToKeystore != null && keystorePassword != null) {
                sslContextBuilder.loadKeyMaterial(new File(pathToKeystore), keystorePassword.toCharArray(), keystorePassword.toCharArray());
            }
            String pathToTruststore = System.getProperty("javax.net.ssl.trustStore");
            String truststorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
            if (pathToTruststore != null && truststorePassword != null) {
                sslContextBuilder.loadTrustMaterial(new File(pathToTruststore), truststorePassword.toCharArray());
            }
            SSLContext sslContext = sslContextBuilder.build();
            return new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            e.printStackTrace();
            return new SSLConnectionSocketFactory(SSLContexts.createDefault(), new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        }
    }

    private CookieStore setAllStoredCookies() {
        BasicCookieStore cookiesToSend = new BasicCookieStore();
        if (!ModelContext.getModelContext().isNullHttpContext()) {
            String selfWebCookie = ((HttpContextWeb)ModelContext.getModelContext().getHttpContext()).getCookie(SET_COOKIE);
            if (!selfWebCookie.isEmpty()) {
                this.addHeader(COOKIE, selfWebCookie.replace("+", ";"));
            }
        } else {
            if (!this.getIncludeCookies()) {
                this.cookies.clear();
            }
            if (this.cookies.getCookies().isEmpty()) {
                return new BasicCookieStore();
            }
            this.cookies.clearExpired(new Date());
            for (Cookie c : this.cookies.getCookies()) {
                if (!this.getHost().equalsIgnoreCase(c.getDomain()) && !this.getHost().substring(4).equalsIgnoreCase(c.getDomain())) continue;
                cookiesToSend.addCookie(c);
            }
        }
        return cookiesToSend;
    }

    private void SetCookieAtr(CookieStore cookiesToSend) {
        block7: {
            if (cookiesToSend == null) break block7;
            if (ModelContext.getModelContext().isNullHttpContext()) {
                for (Cookie c : cookiesToSend.getCookies()) {
                    this.cookies.addCookie(c);
                }
            } else {
                try {
                    HttpContextWeb webcontext = (HttpContextWeb)ModelContext.getModelContext().getHttpContext();
                    Header[] headers = this.response.getHeaders(SET_COOKIE);
                    if (headers.length > 0) {
                        String webcontextCookieHeader = "";
                        for (Header header : headers) {
                            String[] cookieParts = header.getValue().split(";");
                            String[] cookieKeyAndValue = cookieParts[0].split("=");
                            webcontextCookieHeader = webcontextCookieHeader + cookieKeyAndValue[0];
                            webcontextCookieHeader = cookieKeyAndValue.length > 1 ? webcontextCookieHeader + "=" + cookieKeyAndValue[1] + "; " : webcontextCookieHeader + "; ";
                        }
                        webcontextCookieHeader = webcontextCookieHeader.trim().substring(0, webcontextCookieHeader.length() - 2);
                        webcontext.setCookie(SET_COOKIE, webcontextCookieHeader, "", CommonUtil.nullDate(), "", this.getSecure());
                    }
                    ModelContext.getModelContext().setHttpContext((IHttpContext)webcontext);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void addBasicAuthHeader(String user, String password, Boolean isProxy) {
        Boolean typeAuth;
        Boolean bl = typeAuth = isProxy != false ? this.lastAuthProxyIsBasic : this.lastAuthIsBasic;
        if (typeAuth.booleanValue()) {
            String auth = user + ":" + password;
            String authHeader = "Basic " + Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.ISO_8859_1));
            this.addHeader(isProxy != false ? "Proxy-Authorization" : "Authorization", authHeader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String method, String url) {
        this.resetExecParams();
        url = this.getURLValid(url).trim();
        try {
            GXHttpClient.HttpClientPrincipal p;
            Enumeration en;
            CookieStore cookiesToSend = null;
            if (this.getHostChanged()) {
                if (this.getSecure() == 1 && this.getPort() == 80) {
                    this.setPort(443);
                }
                SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(this.getTcpNoDelay()).build();
                this.httpClientBuilder.setDefaultSocketConfig(socketConfig);
                cookiesToSend = this.setAllStoredCookies();
                this.httpClientBuilder.setDefaultCookieStore(cookiesToSend);
            }
            int msTimeout = this.getTimeout() * 1000;
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setCookieSpec("standard").setSocketTimeout(msTimeout).setConnectionRequestTimeout(msTimeout).setConnectTimeout(msTimeout);
            this.httpClientBuilder.setRoutePlanner(null);
            if (this.getProxyInfoChanged() && !this.getProxyServerHost().isEmpty() && this.getProxyServerPort() != 0) {
                HttpHost proxy = new HttpHost(this.getProxyServerHost(), (int)this.getProxyServerPort());
                this.httpClientBuilder.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(proxy));
                requestConfigBuilder.setProxy(proxy);
            }
            this.reqConfig = requestConfigBuilder.build();
            if (this.getHostChanged() || this.getAuthorizationChanged()) {
                this.credentialsProvider = new BasicCredentialsProvider();
                en = this.getBasicAuthorization().elements();
                while (en.hasMoreElements()) {
                    p = (GXHttpClient.HttpClientPrincipal)en.nextElement();
                    this.addBasicAuthHeader(p.user, p.password, false);
                }
                en = this.getDigestAuthorization().elements();
                while (en.hasMoreElements()) {
                    p = (GXHttpClient.HttpClientPrincipal)en.nextElement();
                    this.credentialsProvider.setCredentials(new AuthScope(this.getHost(), this.getPort(), p.realm, "Digest"), (Credentials)new UsernamePasswordCredentials(p.user, p.password));
                }
                en = this.getNTLMAuthorization().elements();
                while (en.hasMoreElements()) {
                    p = (GXHttpClient.HttpClientPrincipal)en.nextElement();
                    this.httpClientBuilder.setDefaultAuthSchemeRegistry((Lookup)RegistryBuilder.create().register("NTLM", (Object)new NTLMSchemeFactory()).register("Negotiate", (Object)new SPNegoSchemeFactory(true)).build());
                    try {
                        this.credentialsProvider.setCredentials(new AuthScope(this.getHost(), this.getPort(), p.realm, "NTLM"), (Credentials)new NTCredentials(p.user, p.password, InetAddress.getLocalHost().getHostName(), this.getHost()));
                    }
                    catch (UnknownHostException e) {
                        this.credentialsProvider.setCredentials(new AuthScope(this.getHost(), this.getPort(), p.realm, "NTLM"), (Credentials)new NTCredentials(p.user, p.password, "localhost", this.getHost()));
                    }
                }
            }
            this.setHostChanged(false);
            this.setAuthorizationChanged(false);
            if (this.getProxyInfoChanged() || this.getAuthorizationProxyChanged()) {
                if (this.credentialsProvider == null) {
                    this.credentialsProvider = new BasicCredentialsProvider();
                }
                en = this.getBasicProxyAuthorization().elements();
                while (en.hasMoreElements()) {
                    p = (GXHttpClient.HttpClientPrincipal)en.nextElement();
                    this.addBasicAuthHeader(p.user, p.password, true);
                }
                en = this.getDigestProxyAuthorization().elements();
                while (en.hasMoreElements()) {
                    p = (GXHttpClient.HttpClientPrincipal)en.nextElement();
                    this.credentialsProvider.setCredentials(new AuthScope(this.getProxyServerHost(), (int)this.getProxyServerPort(), p.realm, "Digest"), (Credentials)new UsernamePasswordCredentials(p.user, p.password));
                }
                en = this.getNTLMProxyAuthorization().elements();
                while (en.hasMoreElements()) {
                    p = (GXHttpClient.HttpClientPrincipal)en.nextElement();
                    try {
                        this.credentialsProvider.setCredentials(new AuthScope(this.getProxyServerHost(), (int)this.getProxyServerPort(), p.realm, "NTLM"), (Credentials)new NTCredentials(p.user, p.password, InetAddress.getLocalHost().getHostName(), this.getProxyServerHost()));
                    }
                    catch (UnknownHostException e) {
                        this.credentialsProvider.setCredentials(new AuthScope(this.getProxyServerHost(), (int)this.getProxyServerPort(), p.realm, "NTLM"), (Credentials)new NTCredentials(p.user, p.password, "localhost", this.getProxyServerHost()));
                    }
                }
            }
            this.setProxyInfoChanged(false);
            this.setAuthorizationProxyChanged(false);
            if (this.credentialsProvider != null) {
                this.httpClientContext = HttpClientContext.create();
                this.httpClientContext.setCredentialsProvider(this.credentialsProvider);
            }
            url = this.setPathUrl(url);
            url = CommonUtil.escapeUnsafeChars((String)url);
            url = this.getSecure() == 1 ? (url.startsWith("https://") ? url : "https://" + this.getHost() + (this.getPort() != 443 ? ":" + this.getPort() : "") + url) : (url.startsWith("http://") ? url : "http://" + this.getHost() + ":" + (this.getPort() == -1 ? "80" : Integer.valueOf(this.getPort())) + url);
            try (CloseableHttpClient httpClient = this.httpClientBuilder.build();){
                if (method.equalsIgnoreCase("GET")) {
                    HttpGetWithBody httpget = new HttpGetWithBody(url.trim());
                    httpget.setConfig(this.reqConfig);
                    Set keys = this.getheadersToSend().keySet();
                    for (String header : keys) {
                        httpget.addHeader(header, (String)this.getheadersToSend().get(header));
                    }
                    httpget.setEntity((HttpEntity)new ByteArrayEntity(this.getData()));
                    this.response = httpClient.execute((HttpUriRequest)httpget, (HttpContext)this.httpClientContext);
                } else if (method.equalsIgnoreCase("POST")) {
                    HttpPost httpPost = new HttpPost(url.trim());
                    httpPost.setConfig(this.reqConfig);
                    Set keys = this.getheadersToSend().keySet();
                    boolean hasConentType = false;
                    for (String header : keys) {
                        httpPost.addHeader(header, (String)this.getheadersToSend().get(header));
                        if (!header.equalsIgnoreCase("Content-type")) continue;
                        hasConentType = true;
                    }
                    if (!hasConentType) {
                        httpPost.addHeader("Content-type", "application/x-www-form-urlencoded");
                    }
                    ByteArrayEntity dataToSend = !this.getIsMultipart() && this.getVariablesToSend().size() > 0 ? new ByteArrayEntity(CommonUtil.hashtable2query((Hashtable)this.getVariablesToSend()).getBytes()) : new ByteArrayEntity(this.getData());
                    httpPost.setEntity((HttpEntity)dataToSend);
                    this.response = httpClient.execute((HttpUriRequest)httpPost, (HttpContext)this.httpClientContext);
                } else if (method.equalsIgnoreCase("PUT")) {
                    HttpPut httpPut = new HttpPut(url.trim());
                    httpPut.setConfig(this.reqConfig);
                    Set keys = this.getheadersToSend().keySet();
                    for (String header : keys) {
                        httpPut.addHeader(header, (String)this.getheadersToSend().get(header));
                    }
                    httpPut.setEntity((HttpEntity)new ByteArrayEntity(this.getData()));
                    this.response = httpClient.execute((HttpUriRequest)httpPut, (HttpContext)this.httpClientContext);
                } else if (method.equalsIgnoreCase("DELETE")) {
                    HttpDeleteWithBody httpDelete = new HttpDeleteWithBody(url.trim());
                    httpDelete.setConfig(this.reqConfig);
                    Set keys = this.getheadersToSend().keySet();
                    for (String header : keys) {
                        httpDelete.addHeader(header, (String)this.getheadersToSend().get(header));
                    }
                    if (this.getVariablesToSend().size() > 0 || this.getContentToSend().size() > 0) {
                        httpDelete.setEntity((HttpEntity)new ByteArrayEntity(this.getData()));
                    }
                    this.response = httpClient.execute((HttpUriRequest)httpDelete, (HttpContext)this.httpClientContext);
                } else if (method.equalsIgnoreCase("HEAD")) {
                    HttpHeadWithBody httpHead = new HttpHeadWithBody(url.trim());
                    httpHead.setConfig(this.reqConfig);
                    Set keys = this.getheadersToSend().keySet();
                    for (String header : keys) {
                        httpHead.addHeader(header, (String)this.getheadersToSend().get(header));
                    }
                    httpHead.setEntity((HttpEntity)new ByteArrayEntity(this.getData()));
                    this.response = httpClient.execute((HttpUriRequest)httpHead, (HttpContext)this.httpClientContext);
                } else if (method.equalsIgnoreCase("CONNECT")) {
                    HttpConnectMethod httpConnect = new HttpConnectMethod(url.trim());
                    httpConnect.setConfig(this.reqConfig);
                    Set keys = this.getheadersToSend().keySet();
                    for (String header : keys) {
                        httpConnect.addHeader(header, (String)this.getheadersToSend().get(header));
                    }
                    this.response = httpClient.execute((HttpUriRequest)httpConnect, (HttpContext)this.httpClientContext);
                } else if (method.equalsIgnoreCase("OPTIONS")) {
                    HttpOptionsWithBody httpOptions = new HttpOptionsWithBody(url.trim());
                    httpOptions.setConfig(this.reqConfig);
                    Set keys = this.getheadersToSend().keySet();
                    for (String header : keys) {
                        httpOptions.addHeader(header, (String)this.getheadersToSend().get(header));
                    }
                    httpOptions.setEntity((HttpEntity)new ByteArrayEntity(this.getData()));
                    this.response = httpClient.execute((HttpUriRequest)httpOptions, (HttpContext)this.httpClientContext);
                } else if (method.equalsIgnoreCase("TRACE")) {
                    HttpTrace httpTrace = new HttpTrace(url.trim());
                    httpTrace.setConfig(this.reqConfig);
                    Set keys = this.getheadersToSend().keySet();
                    for (String header : keys) {
                        httpTrace.addHeader(header, (String)this.getheadersToSend().get(header));
                    }
                    this.response = httpClient.execute((HttpUriRequest)httpTrace, (HttpContext)this.httpClientContext);
                } else if (method.equalsIgnoreCase("PATCH")) {
                    HttpPatch httpPatch = new HttpPatch(url.trim());
                    httpPatch.setConfig(this.reqConfig);
                    Set keys = this.getheadersToSend().keySet();
                    for (String header : keys) {
                        httpPatch.addHeader(header, (String)this.getheadersToSend().get(header));
                    }
                    ByteArrayEntity dataToSend = new ByteArrayEntity(this.getData());
                    httpPatch.setEntity((HttpEntity)dataToSend);
                    this.response = httpClient.execute((HttpUriRequest)httpPatch, (HttpContext)this.httpClientContext);
                }
            }
            this.statusCode = this.response.getStatusLine().getStatusCode();
            this.reasonLine = this.response.getStatusLine().getReasonPhrase();
            this.SetCookieAtr(cookiesToSend);
            if (this.response.containsHeader("Transfer-Encoding")) {
                this.isChunkedResponse = this.response.getFirstHeader("Transfer-Encoding").getValue().equalsIgnoreCase("chunked");
            }
        }
        catch (IOException e) {
            this.setExceptionsCatch(e);
            this.statusCode = 0;
            this.reasonLine = "";
        }
        finally {
            if (this.getIsURL()) {
                this.setHost(this.getPrevURLhost());
                this.setBaseURL(this.getPrevURLbaseURL());
                this.setPort(this.getPrevURLport());
                this.setSecure(this.getPrevURLsecure());
                this.setIsURL(false);
            }
            this.resetStateAdapted();
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonLine() {
        return this.reasonLine;
    }

    public void getHeader(String name, long[] value) {
        if (this.response == null || this.response.getHeaders(name).length == 0 || this.response.getHeaders(name) == null) {
            return;
        }
        Header[] headers = this.response.getHeaders(name);
        if (headers == null) {
            throw new NumberFormatException("null");
        }
        value[0] = Integer.parseInt(headers[0].getValue());
    }

    public String getHeader(String name) {
        if (this.response == null || this.response.getHeaders(name).length == 0 || this.response.getHeaders(name) == null) {
            return "";
        }
        return this.response.getHeaders(name)[0].getValue();
    }

    public void getHeader(String name, String[] value) {
        if (this.response == null || this.response.getHeaders(name).length == 0 || this.response.getHeaders(name) == null) {
            return;
        }
        Header[] headers = this.response.getHeaders(name);
        value[0] = headers[0].getValue();
    }

    public void getHeader(String name, Date[] value) {
        if (this.response == null) {
            return;
        }
        try {
            value[0] = CommonUtil.getHeaderAsDate((String)this.response.getFirstHeader(name).getValue());
        }
        catch (IOException e) {
            this.setExceptionsCatch(e);
        }
    }

    public void getHeader(String name, double[] value) {
        if (this.response == null || this.response.getHeaders(name).length == 0 || this.response.getHeaders(name) == null) {
            return;
        }
        value[0] = CommonUtil.val((String)this.response.getHeaders(name)[0].getValue());
    }

    public InputStream getInputStream() throws IOException {
        if (this.response != null) {
            this.setEntity();
            InputStream content = this.entity.getContent();
            this.streamsToClose.addElement(content);
            return content;
        }
        return null;
    }

    private void setEntity() throws IOException {
        if (this.entity == null) {
            this.entity = new ByteArrayEntity(EntityUtils.toByteArray((HttpEntity)this.response.getEntity()));
        }
    }

    private void setEntityReader() throws IOException {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader(this.response.getEntity().getContent()));
        }
    }

    public String getString() {
        if (this.response == null) {
            return "";
        }
        try {
            this.setEntity();
            String res = EntityUtils.toString((HttpEntity)this.entity, (String)"UTF-8");
            this.eof = true;
            return res;
        }
        catch (IOException e) {
            this.setExceptionsCatch(e);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return "";
    }

    public boolean getEof() {
        return this.eof;
    }

    public String readChunk() {
        if (!this.isChunkedResponse) {
            return this.getString();
        }
        if (this.response == null) {
            return "";
        }
        try {
            this.setEntityReader();
            String res = this.reader.readLine();
            if (res == null) {
                this.eof = true;
                res = "";
            }
            return res;
        }
        catch (IOException e) {
            this.setExceptionsCatch(e);
            return "";
        }
    }

    public void toFile(String fileName) {
        if (this.response == null) {
            return;
        }
        try {
            this.setEntity();
            CommonUtil.InputStreamToFile((InputStream)this.entity.getContent(), (String)fileName);
        }
        catch (IOException e) {
            this.setExceptionsCatch(e);
        }
    }

    public void cleanup() {
        this.resetErrorsAndConnParams();
    }

    protected void finalize() {
        this.closeOpenedStreams();
    }
}

