/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.internet;

import com.genexus.Application;
import com.genexus.CommonUtil;
import com.genexus.GXutil;
import com.genexus.IHttpContext;
import com.genexus.ImagesPath;
import com.genexus.Messages;
import com.genexus.ModelContext;
import com.genexus.Preferences;
import com.genexus.db.IDataStoreProvider;
import com.genexus.diagnostics.Log;
import com.genexus.internet.GXNavigationHelper;
import com.genexus.internet.HttpRequest;
import com.genexus.internet.HttpResponse;
import com.genexus.internet.IGxJSONAble;
import com.genexus.internet.MsgList;
import com.genexus.servlet.http.ICookie;
import com.genexus.servlet.http.IHttpServletRequest;
import com.genexus.servlet.http.IHttpServletResponse;
import com.genexus.util.Encryption;
import com.genexus.util.FastByteArrayOutputStream;
import com.genexus.webpanels.HttpContextWeb;
import com.genexus.webpanels.WebSession;
import com.genexus.xml.XMLWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.UUID;
import json.org.json.IJsonFormattable;
import json.org.json.JSONArray;
import json.org.json.JSONException;
import json.org.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HttpContext
implements IHttpContext {
    private static Logger logger = LogManager.getLogger(HttpContext.class);
    public static int SPA_NOT_SUPPORTED_STATUS_CODE = 530;
    private static String GX_SPA_REQUEST_HEADER = "X-SPA-REQUEST";
    protected static String GX_SPA_REDIRECT_URL = "X-SPA-REDIRECT-URL";
    private static String GX_SOAP_ACTION_HEADER = "SOAPAction";
    public static String GXTheme = "GXTheme";
    public static String GXLanguage = "GXLanguage";
    protected boolean PortletMode = false;
    protected boolean AjaxCallMode = false;
    protected boolean AjaxEventMode = false;
    protected boolean fullAjaxMode = false;
    protected boolean ajaxRefreshAsGET = false;
    public MsgList GX_msglist = new MsgList();
    public byte wbGlbDoneStart = 0;
    public HttpResponse GX_webresponse;
    protected String clientId = "";
    public String wjLoc = "";
    public int wjLocDisableFrm = 0;
    public String sCallerURL = "";
    public int nUserReturn = 0;
    public int wbHandled = 0;
    public XMLWriter GX_xmlwrt = new XMLWriter();
    protected FastByteArrayOutputStream buffer;
    protected boolean buffered;
    protected boolean compressed;
    protected boolean doNotCompress;
    protected ModelContext context;
    protected boolean isEnabled = true;
    private OutputStream out;
    private PrintWriter writer;
    private String userId;
    private boolean isBinary = false;
    private Boolean mustUseWriter;
    protected boolean isCrawlerRequest = false;
    private boolean responseCommited = false;
    protected boolean wrapped = false;
    protected int drawGridsAtServer = -1;
    private boolean ignoreSpa = false;
    private boolean isChunked = false;
    private static HashMap<String, Messages> cachedMessages = new HashMap();
    protected String currentLanguage = null;
    public static String GX_NAV_HELPER = "GX_NAV_HELPER";
    private static String CLIENT_ID_HEADER = "GX_CLIENT_ID";
    public boolean useUtf8 = false;
    protected String staticContentBase = "";
    private String theme = "";
    private boolean isDSO = false;
    int GX_NULL_TIMEZONEOFFSET = 9999;
    protected boolean restService = false;
    private static final String[][] contentTypes = new String[][]{{"txt", "text/plain"}, {"rtx", "text/richtext"}, {"htm", "text/html"}, {"html", "text/html"}, {"xml", "text/xml"}, {"aif", "audio/x-aiff"}, {"au", "audio/basic"}, {"wav", "audio/wav"}, {"bmp", "image/bmp"}, {"gif", "image/gif"}, {"jpe", "image/jpeg"}, {"jpeg", "image/jpeg"}, {"jpg", "image/jpeg"}, {"jfif", "image/pjpeg"}, {"tif", "image/tiff"}, {"tiff", "image/tiff"}, {"png", "image/x-png"}, {"3gp", "video/3gpp"}, {"3g2", "video/3gpp2"}, {"mpg", "video/mpeg"}, {"mpeg", "video/mpeg"}, {"mov", "video/quicktime"}, {"qt", "video/quicktime"}, {"avi", "video/x-msvideo"}, {"exe", "application/octet-stream"}, {"dll", "application/x-msdownload"}, {"ps", "application/postscript"}, {"pdf", "application/pdf"}, {"svg", "image/svg+xml"}, {"tgz", "application/x-compressed"}, {"zip", "application/x-zip-compressed"}, {"gz", "application/x-gzip"}, {"json", "application/json"}};

    public MsgList getMessageList() {
        return this.GX_msglist;
    }

    public void setFullAjaxMode() {
        this.fullAjaxMode = true;
    }

    public boolean isFullAjaxMode() {
        return this.fullAjaxMode;
    }

    public void setPortletMode() {
        this.PortletMode = true;
    }

    public void setAjaxCallMode() {
        this.AjaxCallMode = true;
    }

    public void setAjaxEventMode() {
        this.AjaxEventMode = true;
    }

    public boolean isPortletMode() {
        return this.PortletMode;
    }

    public boolean isAjaxCallMode() {
        return this.AjaxCallMode;
    }

    public boolean isAjaxEventMode() {
        return this.AjaxEventMode;
    }

    public boolean isAjaxRequest() {
        return this.isAjaxCallMode() || this.isAjaxEventMode() || this.isPortletMode();
    }

    public boolean isSpaRequest(boolean ignoreFlag) {
        String header;
        if (!ignoreFlag && this.ignoreSpa) {
            return false;
        }
        String string = header = this.getRequest() != null ? this.getRequest().getHeader(GX_SPA_REQUEST_HEADER) : null;
        if (header != null) {
            return header.compareTo("1") == 0;
        }
        return false;
    }

    public boolean isSpaRequest() {
        return this.isSpaRequest(false);
    }

    public void disableSpaRequest() {
        this.ignoreSpa = true;
    }

    public void setChunked() {
        this.isChunked = true;
    }

    public boolean isSoapRequest() {
        return this.getRequest() != null && this.getRequest().getHeader(GX_SOAP_ACTION_HEADER) != null;
    }

    public boolean isOutputEnabled() {
        return this.isEnabled;
    }

    public void disableOutput() {
        this.isEnabled = false;
    }

    public void enableOutput() {
        this.isEnabled = true;
    }

    public ModelContext getContext() {
        return this.context;
    }

    public void setContext(ModelContext context) {
        this.context = context;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String id) {
        this.clientId = id;
    }

    protected void copyCommon(HttpContext ctx) {
        ctx.wjLoc = this.wjLoc;
        ctx.sCallerURL = this.sCallerURL;
        ctx.nUserReturn = this.nUserReturn;
        ctx.wbHandled = this.wbHandled;
        ctx.GX_msglist = this.GX_msglist;
        ctx.GX_xmlwrt = this.GX_xmlwrt;
        ctx.buffer = this.buffer;
        ctx.buffered = this.buffered;
        ctx.compressed = this.compressed;
        ctx.out = this.out;
        ctx.writer = this.writer;
        ctx.userId = this.userId;
        ctx.staticContentBase = this.staticContentBase;
        ctx.isBinary = this.isBinary;
        ctx.mustUseWriter = this.mustUseWriter;
        ctx.responseCommited = this.responseCommited;
    }

    public abstract void cleanup();

    public abstract String getResourceRelative(String var1);

    public abstract String getResourceRelative(String var1, boolean var2);

    public abstract String getResource(String var1);

    public abstract String GetNextPar();

    public abstract String GetPar(String var1);

    public abstract String GetFirstPar(String var1);

    public abstract HttpContext copy();

    public abstract byte setHeader(String var1, String var2);

    public abstract void setDateHeader(String var1, int var2);

    public abstract void setRequestMethod(String var1);

    public abstract String getRequestMethod();

    public abstract String getReferer();

    public abstract short setWrkSt(int var1, String var2);

    public abstract String getWorkstationId(int var1);

    public abstract String getApplicationId(int var1);

    public abstract short setUserId(int var1, String var2, String var3);

    public abstract String getUserId(String var1, ModelContext var2, int var3, String var4);

    public abstract String getUserId(String var1, ModelContext var2, int var3, IDataStoreProvider var4);

    public abstract String getRemoteAddr();

    public abstract boolean isLocalStorageSupported();

    public abstract boolean exposeMetadata();

    public abstract boolean isSmartDevice();

    public abstract int getBrowserType();

    public abstract boolean isIE55();

    public abstract String getDefaultPath();

    public abstract void setDefaultPath(String var1);

    public abstract String getBrowserVersion();

    public abstract Object getSessionValue(String var1);

    public abstract void webPutSessionValue(String var1, Object var2);

    public abstract void webPutSessionValue(String var1, long var2);

    public abstract void webPutSessionValue(String var1, double var2);

    public abstract void webSessionId(String[] var1);

    public abstract String getContextPath();

    public abstract void setContextPath(String var1);

    public abstract String webSessionId();

    public abstract String getCookie(String var1);

    public abstract ICookie[] getCookies();

    public abstract byte setCookie(String var1, String var2, String var3, Date var4, String var5, double var6, Boolean var8);

    public abstract byte setCookie(String var1, String var2, String var3, Date var4, String var5, double var6);

    public abstract byte setCookieRaw(String var1, String var2, String var3, Date var4, String var5, double var6);

    public abstract String getServerName();

    public abstract int getServerPort();

    public abstract String getScriptPath();

    public abstract int getHttpSecure();

    public abstract byte setContentType(String var1);

    public abstract byte responseContentType(String var1);

    public abstract String getHeader(String var1);

    public abstract void sendError(int var1);

    public abstract void setQueryString(String var1);

    public abstract String getQueryString();

    public abstract String getPackage();

    public abstract String cgiGetFileName(String var1);

    public abstract String cgiGetFileType(String var1);

    public abstract void getMultimediaValue(String var1, String[] var2, String[] var3);

    public abstract String cgiGet(String var1);

    public abstract void changePostValue(String var1, String var2);

    public abstract boolean isFileParm(String var1);

    public abstract void parseGXState(JSONObject var1);

    public abstract void deletePostValue(String var1);

    public abstract void DeletePostValuePrefix(String var1);

    public abstract HttpResponse getHttpResponse();

    public abstract HttpRequest getHttpRequest();

    public abstract void setHttpRequest(HttpRequest var1);

    public abstract IHttpServletRequest getRequest();

    public abstract IHttpServletResponse getResponse();

    public abstract void setRequest(IHttpServletRequest var1);

    public abstract Hashtable getPostData();

    public abstract WebSession getWebSession();

    public abstract void setStream();

    public abstract void flushStream();

    public abstract boolean isHttpContextNull();

    public abstract boolean isHttpContextWeb();

    public abstract void redirect(String var1);

    public void setWrapped(boolean wrapped) {
        this.wrapped = wrapped;
    }

    public boolean getWrapped() {
        return this.wrapped || this.isCrawlerRequest;
    }

    public boolean isCrawlerRequest() {
        return this.getRequest() != null && this.getRequest().getQueryString() != null && this.getRequest().getQueryString().contains("_escaped_fragment_");
    }

    public void setResponseCommited() {
        this.responseCommited = true;
    }

    public boolean getResponseCommited() {
        return this.responseCommited;
    }

    protected GXNavigationHelper getNavigationHelper() {
        return this.getNavigationHelper(true);
    }

    protected GXNavigationHelper getNavigationHelper(boolean useWebSession) {
        GXNavigationHelper helper;
        try {
            helper = (GXNavigationHelper)this.getSessionValue(GX_NAV_HELPER);
        }
        catch (Exception e) {
            helper = null;
        }
        if (helper == null) {
            helper = new GXNavigationHelper();
            if (useWebSession) {
                this.webPutSessionValue(GX_NAV_HELPER, helper);
            }
        }
        return helper;
    }

    protected String getRequestNavUrl() {
        String sUrl = "";
        if (this.isAjaxRequest()) {
            sUrl = this.getRequest().getHeader("REFERER");
        } else {
            String query;
            sUrl = this.getRequest().getRequestURI();
            if (sUrl.indexOf(63) == -1 && (query = this.getRequest().getQueryString()) != null) {
                sUrl = sUrl + "?" + this.getRequest().getQueryString();
            }
        }
        sUrl = sUrl != null ? sUrl : "";
        return sUrl;
    }

    public void deleteReferer(String popupLevel) {
        this.getNavigationHelper(false).deleteStack(popupLevel);
    }

    public void deleteReferer() {
        this.deleteReferer(this.getNavigationHelper(false).getUrlPopupLevel(this.getRequestNavUrl()));
    }

    public void pushCurrentUrl() {
        if (this.getRequestMethod().equals("GET") && !this.isAjaxRequest()) {
            String sUrl = this.getRequestNavUrl().trim();
            String topUrl = this.getNavigationHelper().peekUrl(sUrl);
            if (!topUrl.equals(sUrl) && !sUrl.equals("")) {
                this.getNavigationHelper().pushUrl(sUrl);
            }
        }
    }

    public void sendResponseStatus(int statusCode, String statusDescription) {
        block4: {
            if (statusCode < 200 || statusCode >= 300) {
                this.getResponse().setHeader("Content-Encoding", "");
                if (statusCode != SPA_NOT_SUPPORTED_STATUS_CODE) {
                    CommonUtil.writeLog((String)("sendResponseStatus " + Integer.toString(statusCode) + " " + statusDescription));
                }
            }
            this.getResponse().setStatus(statusCode);
            try {
                this.getResponse().sendError(statusCode, statusDescription);
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block4;
                logger.error("Could not send Response Error Code", (Throwable)e);
            }
        }
        this.setAjaxCallMode();
        this.disableOutput();
    }

    public void initClientId() {
        if (!this.isSoapRequest() && this.getWebSession() != null && this.getClientId().equals("")) {
            String _clientId = this.getCookie(CLIENT_ID_HEADER);
            if (_clientId == null || _clientId.equals("")) {
                _clientId = UUID.randomUUID().toString();
                this.setCookie(CLIENT_ID_HEADER, _clientId, "/", new Date(Long.MAX_VALUE), "", this.getHttpSecure());
            }
            this.setClientId(_clientId);
        }
    }

    public boolean useBase64ViewState() {
        return ((Preferences)this.context.getPreferences()).getProperty("UseBase64ViewState", "n").equals("y");
    }

    public boolean useSecurityTokenValidation() {
        return ((Preferences)this.context.getPreferences()).getProperty("ValidateSecurityToken", "y").equals("y");
    }

    public String getEncryptedSignature(String value, String key) {
        return this.encrypt64(CommonUtil.getHash((String)GXutil.StripInvalidChars(value), (String)CommonUtil.SECURITY_HASH_ALGORITHM), key);
    }

    public String encrypt64(String value, String key) {
        String sRet = "";
        try {
            sRet = Encryption.encrypt64((String)value, (String)key);
        }
        catch (Encryption.InvalidGXKeyException e) {
            this.setCookie("GX_SESSION_ID", "", "", new Date(Long.MIN_VALUE), "", this.getHttpSecure());
            Log.debug((String)"440 Invalid encryption key");
            this.sendResponseStatus(440, "Session timeout");
        }
        return sRet;
    }

    public String decrypt64(String value, String key) {
        String sRet = "";
        try {
            sRet = Encryption.decrypt64((String)value, (String)key);
        }
        catch (Encryption.InvalidGXKeyException e) {
            this.setCookie("GX_SESSION_ID", "", "", new Date(Long.MIN_VALUE), "", this.getHttpSecure());
            Log.debug((String)"440 Invalid encryption key");
            this.sendResponseStatus(440, "Session timeout");
        }
        return sRet;
    }

    public void webGetSessionValue(String name, byte[] value) {
        Object o = this.getSessionValue(name);
        if (o != null) {
            value[0] = ((Long)o).byteValue();
        }
    }

    public void webGetSessionValue(String name, short[] value) {
        Object o = this.getSessionValue(name);
        if (o != null) {
            value[0] = ((Long)o).shortValue();
        }
    }

    public void webGetSessionValue(String name, int[] value) {
        Object o = this.getSessionValue(name);
        if (o != null) {
            value[0] = ((Long)o).intValue();
        }
    }

    public void webGetSessionValue(String name, long[] value) {
        Object o = this.getSessionValue(name);
        if (o != null) {
            value[0] = (Long)o;
        }
    }

    public void webGetSessionValue(String name, float[] value) {
        Object o = this.getSessionValue(name);
        if (o != null) {
            value[0] = ((Double)o).floatValue();
        }
    }

    public void webGetSessionValue(String name, double[] value) {
        Object o = this.getSessionValue(name);
        if (o != null) {
            value[0] = (Double)o;
        }
    }

    public void webGetSessionValue(String name, String[] value) {
        Object o = this.getSessionValue(name);
        if (o != null) {
            value[0] = (String)o;
        }
    }

    public String getSubscriberId() {
        return this.getHeader("HTTP_X_UP_SUBNO");
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void _writeText(String text) {
        this._writeText(text, false);
    }

    public void _writeText(String text, boolean ignoreCommitedResponse) {
        if (!ignoreCommitedResponse && this.getResponseCommited()) {
            return;
        }
        try {
            if (this.mustUseWriter()) {
                this.writer.print(text);
            } else {
                this.writeBytes(this.useUtf8 ? text.getBytes("UTF8") : text.getBytes());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setBinary(boolean isBinary) {
        this.isBinary = isBinary;
    }

    public boolean mustUseWriter() {
        if (this.isBinary) {
            return false;
        }
        if (this.mustUseWriter == null) {
            this.mustUseWriter = new Boolean(System.getProperty("os.name").startsWith("OS/390"));
        }
        return this.mustUseWriter;
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.out.write(bytes);
        if (this.isChunked || this.getHttpResponse().getHeader("Transfer-Encoding").equalsIgnoreCase("chunked")) {
            this.out.flush();
        }
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void closeWriter() {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public void closeOutputStream() {
        block3: {
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("ERROR: When Closing Output Stream.", (Throwable)e);
                }
            }
        }
    }

    public void setBuffered(boolean buffered) {
        this.buffered = buffered;
    }

    public void setCompression(boolean compressed) {
        this.compressed = this.doNotCompress ? false : compressed;
    }

    public void doNotCompress(boolean doNotCompress) {
        this.doNotCompress = doNotCompress;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setStaticContentBase(String staticContentBase) {
        this.staticContentBase = staticContentBase;
    }

    public String getStaticContentBase() {
        return this.staticContentBase;
    }

    public String getTheme() {
        HashMap cThemeMap;
        WebSession session = this.getWebSession();
        if (session != null && (cThemeMap = (HashMap)session.getObjectAttribute(GXTheme)) != null && cThemeMap.containsKey(this.theme)) {
            return (String)cThemeMap.get(this.theme);
        }
        if (this.theme.trim().length() == 0) {
            this.theme = Preferences.getDefaultPreferences().getDefaultTheme();
        }
        return this.theme;
    }

    public boolean getThemeisDSO() {
        return this.isDSO;
    }

    public void setDefaultTheme(String t) {
        this.setDefaultTheme(t, false);
    }

    public void setDefaultTheme(String t, boolean isDSO) {
        this.theme = t;
        this.isDSO = isDSO;
    }

    public int setTheme(String t) {
        WebSession session = this.getWebSession();
        if (session == null || t == null || t.equals("")) {
            return 0;
        }
        HashMap<String, String> cThemeMap = (HashMap<String, String>)session.getObjectAttribute(GXTheme);
        if (cThemeMap == null) {
            cThemeMap = new HashMap<String, String>();
        }
        cThemeMap.put(this.theme, t);
        session.setObjectAttribute(GXTheme, cThemeMap);
        return 1;
    }

    public String getImagePath(String file, String KBId, String theme) {
        String result = ImagesPath.getImagePath((String)file, (String)theme, (String)KBId, (IHttpContext)this);
        if (result == null) {
            return file;
        }
        if (this instanceof HttpContextWeb) {
            return this.staticContentBase + result;
        }
        return result;
    }

    public String getImageSrcSet(String baseImage) {
        return ImagesPath.getImageSrcSet((IHttpContext)this, (String)baseImage);
    }

    public String getBuildNumber(int buildN) {
        return this.context.getClientPreferences().getBUILD_NUMBER(buildN);
    }

    public String convertURL(String file) {
        int idx;
        String url = "";
        if (file.equals("")) {
            return "";
        }
        url = file.indexOf(".") != -1 ? this.oldConvertURL(file) : this.oldConvertURL(this.getImagePath(file, "", this.getTheme()));
        if (!(!this.getWrapped() || this.isCrawlerRequest() || this.drawGridsAtServer == 1 || file.startsWith("http:") || file.startsWith("//") || file.length() > 2 && file.charAt(1) == ':' || (idx = url.lastIndexOf("/")) <= 0)) {
            url = url.substring(idx + 1, url.length());
        }
        return url;
    }

    public String oldConvertURL(String file) {
        String out = file.trim();
        if (file.startsWith("http:") || file.startsWith("https:") || file.startsWith("data:") || file.startsWith("about:") || file.startsWith("//") || file.length() > 2 && file.charAt(1) == ':') {
            return out;
        }
        if (file.startsWith("/")) {
            if (file.startsWith(this.getContextPath()) || file.startsWith(this.getDefaultPath())) {
                return out;
            }
            return this.getContextPath() + out;
        }
        if (this.staticContentBase.startsWith("http") || this.staticContentBase.length() > 2 && this.staticContentBase.charAt(1) == ':') {
            return this.staticContentBase + out;
        }
        if (this instanceof HttpContextWeb) {
            return this.getContextPath() + this.staticContentBase + out;
        }
        return out;
    }

    public String getMessage(String code, String language) {
        if (language == null || language.equals("")) {
            return this.getMessage(code);
        }
        String languageCode = Application.getClientPreferences().getProperty("language|" + language.toLowerCase(), "code", "");
        if (languageCode == null || languageCode.equals("")) {
            languageCode = language.toLowerCase();
        }
        String resourceName = "messages." + languageCode.toLowerCase() + ".txt";
        Messages msgs = Messages.getMessages((String)resourceName, (Locale)Application.getClientLocalUtil().getLocale());
        return msgs.getMessage(code);
    }

    public String getMessage(String code) {
        String language = this.getLanguage();
        Messages messages = cachedMessages.get(language);
        if (messages == null) {
            String languageCode = Application.getClientPreferences().getProperty("language|" + language, "code", Application.getClientPreferences().getProperty("LANGUAGE", "eng"));
            messages = Messages.getMessages((String)("messages." + languageCode.toLowerCase() + ".txt"), (Locale)Application.getClientLocalUtil().getLocale());
            this.addCachedLanguageMessage(language, messages);
        }
        return messages.getMessage(code);
    }

    private synchronized void addCachedLanguageMessage(String language, Messages msg) {
        cachedMessages.putIfAbsent(language, msg);
    }

    public int getYearLimit() {
        return Application.getClientPreferences().getYEAR_LIMIT();
    }

    public int getStorageTimezone() {
        return Application.getClientPreferences().getStorageTimezonePty();
    }

    public String getLanguageProperty(String property) {
        String _language = this.getLanguage();
        return Application.getClientPreferences().getProperty("language|" + _language, property, "");
    }

    public String getLanguage() {
        if (this.currentLanguage == null) {
            WebSession session = this.getWebSession();
            String language = session != null ? session.getAttribute(GXLanguage) : null;
            this.currentLanguage = language != null && !language.equals("") ? language : Application.getClientPreferences().getProperty("LANG_NAME", "English");
        }
        return this.currentLanguage;
    }

    public int setLanguage(String language) {
        if (!language.isEmpty() && Application.getClientPreferences().getProperty("language|" + language, "code", null) != null) {
            this.currentLanguage = language;
            this.getWebSession().setAttribute(GXLanguage, language);
            this.ajaxRefreshAsGET = true;
            return 0;
        }
        return 1;
    }

    public boolean checkContentType(String contentKey, String contentType, String fullPath) {
        int lastDot;
        if (contentType.trim().equals("") && (lastDot = fullPath.lastIndexOf(".")) != -1) {
            String ext = fullPath.substring(lastDot + 1);
            contentType = HttpContext.getContentFromExt(ext);
        }
        if (contentType != null) {
            return contentType.toLowerCase().startsWith(contentKey.toLowerCase() + "/");
        }
        return false;
    }

    public static boolean isKnownContentType(String type) {
        if (type != null) {
            for (int i = 0; i < contentTypes.length; ++i) {
                if (contentTypes[i].length < 2 || !type.equalsIgnoreCase(contentTypes[i][1])) continue;
                return true;
            }
        }
        return false;
    }

    public static String getContentFromExt(String extension) {
        if (extension != null) {
            extension = extension.toLowerCase();
            for (int i = 0; i < contentTypes.length; ++i) {
                if (!contentTypes[i][0].equals(extension.trim())) continue;
                return contentTypes[i][1];
            }
        }
        return null;
    }

    public void setRestService() {
        this.restService = true;
    }

    public boolean isRestService() {
        return this.restService;
    }

    public boolean willRedirect() {
        return this.wjLoc != null && this.wjLoc.trim().length() != 0;
    }

    public void readJsonSdtValue(String jsonStr, Object SdtObj) {
        try {
            Object jsonObj = jsonStr.startsWith("[") ? new JSONArray(jsonStr) : new JSONObject(jsonStr);
            ((IGxJSONAble)SdtObj).FromJSONObject((IJsonFormattable)jsonObj);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

