/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.internet;

import com.genexus.CommonUtil;
import com.genexus.internet.HttpContext;
import com.genexus.internet.IHttpRequest;
import com.genexus.webpanels.FileItemCollection;
import com.genexus.webpanels.HttpContextWeb;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;

public abstract class HttpRequest
implements IHttpRequest {
    public final int ERROR_IO = 1;
    private int errCode;
    private String errDescription;
    private String Referrer = "";
    protected HttpContext httpContext;

    public HttpRequest(HttpContext httpContext) {
        this.httpContext = httpContext;
        this.resetErrors();
    }

    public FileItemCollection getPostedparts() {
        return ((HttpContextWeb)this.httpContext).getPostedparts();
    }

    public String getMethod() {
        return this.httpContext.getRequestMethod();
    }

    public abstract String getRequestURL();

    public String getHeader(String name) {
        String ret = this.httpContext.getHeader(name);
        return ret == null ? "" : ret;
    }

    public void getHeader(String name, String[] value) {
        String ret = this.httpContext.getHeader(name);
        value[0] = ret == null ? "" : ret;
    }

    public String getQuerystring() {
        return this.httpContext.getQueryString();
    }

    public void setReferrer(String value) {
        this.Referrer = value;
    }

    public String getReferer() {
        String referer = this.httpContext.getReferer();
        return "".equals(referer) ? this.Referrer : referer;
    }

    public String getReferrer() {
        return this.getReferer();
    }

    public String getServerHost() {
        return this.httpContext.getServerName();
    }

    public int getServerPort() {
        return this.httpContext.getServerPort();
    }

    public byte getSecure() {
        return (byte)this.httpContext.getHttpSecure();
    }

    public String getScriptPath() {
        return this.httpContext.getScriptPath();
    }

    public String getRemoteAddress() {
        return this.httpContext.getRemoteAddr();
    }

    public abstract String getScriptName();

    public String getBaseURL() {
        int port = this.getServerPort();
        String portS = port == 80 || port == 443 ? "" : ":" + port;
        return (this.getSecure() == 0 ? "http://" : "https://") + this.getServerHost() + portS + this.getScriptPath();
    }

    public void getHeader(String name, long[] value) {
        String header = this.httpContext.getHeader(name);
        if (header != null) {
            try {
                value[0] = (long)CommonUtil.val((String)header);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        value[0] = 0L;
    }

    public void getHeader(String name, double[] value) {
        String header = this.httpContext.getHeader(name);
        if (header != null) {
            try {
                value[0] = CommonUtil.val((String)header);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        value[0] = 0.0;
    }

    public void getHeader(String name, Date[] value) {
        String raw_date = this.httpContext.getHeader(name);
        value[0] = CommonUtil.nullDate();
        if (raw_date == null) {
            return;
        }
        if (raw_date.toUpperCase().indexOf("GMT") == -1) {
            raw_date = raw_date + " GMT";
        }
        Date date = CommonUtil.nullDate();
        try {
            try {
                date = DateFormat.getDateInstance().parse(raw_date);
            }
            catch (ParseException iae) {
                long time;
                try {
                    time = Long.parseLong(raw_date);
                }
                catch (NumberFormatException nfe) {
                    throw iae;
                }
                if (time < 0L) {
                    time = 0L;
                }
                date = new Date(time * 1000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getVariable(String key) {
        return this.httpContext.cgiGet(key);
    }

    public void getVariable(String key, String[] value) {
        value[0] = this.getVariable(key);
    }

    public void getVariable(String key, int[] value) {
        value[0] = (int)CommonUtil.val((String)this.getVariable(key));
    }

    public void getVariable(String key, double[] value) {
        value[0] = CommonUtil.val((String)this.getVariable(key));
    }

    public String[] getVariables() {
        String[] keys = new String[this.httpContext.getPostData().size()];
        int idx = 0;
        Enumeration en = this.httpContext.getPostData().keys();
        while (en.hasMoreElements()) {
            keys[idx++] = (String)en.nextElement();
        }
        return keys;
    }

    public abstract Reader getReader() throws IOException;

    public abstract InputStream getInputStream() throws IOException;

    public abstract int getContentLength();

    public abstract String getString();

    public abstract void setSoapMessageBody(String var1);

    public abstract void toFile(String var1);

    private void resetErrors() {
        this.errCode = 0;
        this.errDescription = "";
    }

    public int getErrCode() {
        return this.errCode;
    }

    public String getErrDescription() {
        return this.errDescription;
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public void setErrDescription(String errDsc) {
        this.errDescription = errDsc;
    }
}

