/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.internet;

import com.genexus.PrivateUtilities;
import com.genexus.WrapperUtils;
import com.genexus.internet.HttpRequest;
import com.genexus.webpanels.HttpContextWeb;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;

public class HttpRequestWeb
extends HttpRequest {
    private String messageBody;
    byte[] streamByteArray = null;

    public HttpRequestWeb(HttpContextWeb httpContext) {
        super(httpContext);
    }

    @Override
    public String getScriptName() {
        String servletPath;
        if (this.httpContext.getRequest() != null && (servletPath = this.httpContext.getRequest().getServletPath()) != null) {
            return servletPath.substring(servletPath.lastIndexOf("/") + 1, servletPath.length());
        }
        return "";
    }

    @Override
    public void toFile(String fileName) {
        try {
            PrivateUtilities.InputStreamToFile(this.getInputStream(), fileName);
        }
        catch (Throwable e) {
            this.setErrCode(1);
            this.setErrDescription(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getString() {
        String restRequestBody;
        if (this.messageBody != null) {
            return this.messageBody;
        }
        if (this.httpContext.isRestService() && (restRequestBody = (String)WrapperUtils.requestBodyThreadLocal.get()) != null) {
            return restRequestBody;
        }
        try (InputStream is = this.getInputStream();){
            String requestEncoding = "UTF-8";
            if (this.httpContext.getRequest().getCharacterEncoding() != null && this.httpContext.getRequest().getCharacterEncoding().length() > 0) {
                requestEncoding = this.httpContext.getRequest().getCharacterEncoding();
            }
            String string = new String(PrivateUtilities.readToByteArray(is), requestEncoding);
            return string;
        }
        catch (IOException e) {
            this.setErrCode(1);
            this.setErrDescription(e.getMessage());
            return "";
        }
    }

    @Override
    public void setSoapMessageBody(String messageBody) {
        this.messageBody = messageBody;
    }

    @Override
    public String getRequestURL() {
        if (this.httpContext.getRequest() != null) {
            return this.httpContext.getRequest().getRequestURL().toString();
        }
        return "";
    }

    @Override
    public Reader getReader() throws IOException {
        return this.httpContext.getRequest().getReader();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.streamByteArray == null) {
            this.streamByteArray = IOUtils.toByteArray((InputStream)this.httpContext.getRequest().getInputStream().getInputStream());
        }
        return new ByteArrayInputStream(this.streamByteArray);
    }

    @Override
    public int getContentLength() {
        return this.httpContext.getRequest().getContentLength();
    }
}

