/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.internet;

import com.genexus.CommonUtil;
import com.genexus.IHttpContext;
import com.genexus.ModelContext;
import com.genexus.PrivateUtilities;
import com.genexus.com.IHttpResponse;
import com.genexus.internet.HttpContext;
import com.genexus.internet.HttpCookie;
import com.genexus.webpanels.FileItemCollection;
import com.genexus.webpanels.HttpContextWeb;
import com.genexus.webpanels.WebUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpResponse
implements IHttpResponse {
    private static Logger log = LogManager.getLogger(HttpResponse.class);
    private final int ERROR_IO = 1;
    private Hashtable<String, String> headers = new Hashtable();
    private int errCode;
    private String errDescription;
    private HttpContextWeb httpContext;

    public HttpResponse(HttpContext httpContext) {
        this.httpContext = (HttpContextWeb)httpContext;
        this.resetErrors();
    }

    public FileItemCollection getPostedparts() {
        return this.httpContext.getPostedparts();
    }

    public void addHeader(String name, String value) {
        if (name.equalsIgnoreCase("Content-Disposition")) {
            value = WebUtils.getEncodedContentDisposition(value, this.httpContext.getBrowserType());
        }
        this.httpContext.setHeader(name, value);
        this.headers.put(name.toUpperCase(), value);
        if (name.equalsIgnoreCase("Content-type")) {
            this.httpContext.setContentType(value);
        } else if (name.equalsIgnoreCase("Content-length")) {
            this.httpContext.getResponse().setContentLength((int)CommonUtil.val((String)value));
        }
    }

    public boolean isText() {
        return this.getHeader("Content-Type").startsWith("text/");
    }

    public String getHeader(String name) {
        String ret = this.headers.get(name.toUpperCase());
        return ret == null ? "" : ret;
    }

    public PrintWriter getWriter() throws IOException {
        return new PrintWriter(this.httpContext.getOutputStream());
    }

    public OutputStream getOutputStream() throws IOException {
        return this.httpContext.getOutputStream();
    }

    public void addString(String value) {
        this.httpContext._writeText(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(String fileName) {
        this.resetErrors();
        InputStream source = null;
        try {
            int bytes_read;
            IHttpContext webContext;
            if (ModelContext.getModelContext() != null && !new File(fileName).isAbsolute() && (webContext = ModelContext.getModelContext().getHttpContext()) != null && webContext instanceof HttpContextWeb && !fileName.isEmpty()) {
                fileName = ModelContext.getModelContext().getHttpContext().getDefaultPath() + File.separator + fileName;
            }
            source = new BufferedInputStream(new FileInputStream(fileName));
            byte[] buffer = new byte[1024];
            while ((bytes_read = source.read(buffer)) != -1) {
                this.httpContext.getOutputStream().write(buffer, 0, bytes_read);
            }
            source.close();
        }
        catch (FileNotFoundException e) {
            this.errCode = 1;
            this.errDescription = e.getMessage();
        }
        catch (IOException e) {
            this.errCode = 1;
            this.errDescription = e.getMessage();
        }
        finally {
            try {
                if (source != null) {
                    source.close();
                }
            }
            catch (IOException ioe) {
                log.error("Failed to close source buffered input stream ", (Throwable)ioe);
            }
        }
    }

    private void resetErrors() {
        this.errCode = 0;
        this.errDescription = "";
    }

    public void setContentTypeType(String file) {
        this.httpContext.setContentType(HttpResponse.getContentType(file));
    }

    public static String getContentType(String file) {
        if (HttpContext.isKnownContentType(file)) {
            return file;
        }
        String contentType = HttpContext.getContentFromExt(file);
        if (contentType != null) {
            return contentType;
        }
        String ext = PrivateUtilities.getExtension(file);
        contentType = HttpContext.getContentFromExt(ext);
        if (contentType == null) {
            return "text/html";
        }
        return contentType;
    }

    public byte respondFile(String file) {
        this.setContentTypeType(file);
        this.addFile(file);
        return 1;
    }

    public int getErrCode() {
        return this.errCode;
    }

    public String getErrDescription() {
        return this.errDescription;
    }

    public byte setCookie(HttpCookie cookie) {
        return this.httpContext.setCookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getExpirationdate(), cookie.getDomain(), cookie.getSecure() ? 1.0 : 0.0, cookie.httpOnly);
    }
}

