/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.internet;

import com.genexus.internet.IFTPClient;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class NetComponentsFTPClient
implements IFTPClient {
    private FTPClient ftp = new FTPClient();
    private static final int OK = 1;
    private static final int FAIL = 0;
    private int lastError;
    private boolean passive = false;

    private int onFailure() {
        if (this.ftp.isConnected()) {
            this.disconnect();
        }
        this.lastError = 0;
        return 0;
    }

    @Override
    public int connect(String host, String user, String password) {
        if (this.ftp.isConnected()) {
            return 0;
        }
        try {
            this.ftp.connect(host);
            int reply = this.ftp.getReplyCode();
            if (FTPReply.isPositiveCompletion((int)reply)) {
                if (user.trim().length() == 0) {
                    user = "anonymous";
                    if (password.trim().length() == 0) {
                        password = "anonymous@";
                    }
                }
                if (this.ftp.login(user, password)) {
                    if (this.passive) {
                        this.ftp.enterLocalPassiveMode();
                    }
                    this.lastError = 1;
                    return 1;
                }
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        return this.onFailure();
    }

    @Override
    public int command(String cmd) {
        try {
            this.ftp.sendSiteCommand(cmd);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            return this.onFailure();
        }
        return 1;
    }

    @Override
    public int disconnect() {
        this.lastError = 0;
        if (this.ftp.isConnected()) {
            try {
                this.ftp.disconnect();
                this.lastError = FTPReply.isPositiveCompletion((int)this.ftp.getReplyCode()) ? 1 : 0;
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        return this.lastError;
    }

    @Override
    public String status() {
        if (this.ftp.isConnected()) {
            return this.ftp.getReplyString();
        }
        return "";
    }

    @Override
    public void status(String[] status) {
        status[0] = this.status();
    }

    private void setFileType(String mode) throws IOException {
        if (mode.charAt(0) == 'a' || mode.charAt(0) == 'A') {
            this.ftp.setFileType(0);
        } else {
            this.ftp.setFileType(2);
        }
    }

    @Override
    public int get(String source, String target, String mode) {
        this.lastError = 0;
        if (this.ftp.isConnected()) {
            target = this.normalizeName(source, target, '/', File.separatorChar);
            try (FileOutputStream targetOutputStream = new FileOutputStream(target);){
                this.setFileType(mode);
                BufferedOutputStream o = new BufferedOutputStream(targetOutputStream);
                if (this.ftp.retrieveFile(source, (OutputStream)o)) {
                    ((OutputStream)o).close();
                    this.lastError = 1;
                }
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        return this.lastError;
    }

    @Override
    public int delete(String source) {
        this.lastError = 0;
        if (this.ftp.isConnected()) {
            try {
                if (this.ftp.deleteFile(source)) {
                    this.lastError = 1;
                }
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        return this.lastError;
    }

    @Override
    public int put(String source, String target, String mode) {
        this.lastError = 0;
        if (this.ftp.isConnected()) {
            target = this.normalizeName(source, target, File.separatorChar, '/');
            try (FileInputStream fileInputStream = new FileInputStream(source);){
                this.setFileType(mode);
                BufferedInputStream file = new BufferedInputStream(fileInputStream);
                if (this.ftp.storeFile(target, (InputStream)file)) {
                    this.lastError = 1;
                }
                ((InputStream)file).close();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        return this.lastError;
    }

    private String getFileName(String path, char sep) {
        return path.substring(path.lastIndexOf(sep) + 1);
    }

    private String normalizeName(String oriName, String normName, char oriSep, char destSep) {
        if (normName.trim().length() == 0) {
            return this.getFileName(oriName, oriSep);
        }
        if (this.getFileName(normName, destSep).trim().length() == 0) {
            return normName.trim() + this.getFileName(oriName, oriSep);
        }
        return normName;
    }

    @Override
    public int mkdir(String path) {
        this.lastError = 0;
        if (this.ftp.isConnected()) {
            try {
                this.lastError = this.ftp.makeDirectory(path) ? 1 : 0;
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        return this.lastError;
    }

    @Override
    public void lastError(int[] lastError) {
        lastError[0] = this.lastError;
    }

    @Override
    public void setPassive(boolean passive) {
        this.passive = passive;
    }
}

