/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.internet.websocket;

import com.genexus.Application;
import com.genexus.GXutil;
import com.genexus.ModelContext;
import com.genexus.db.DynamicExecute;
import com.genexus.db.Namespace;
import com.genexus.db.UserInformation;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.internet.websocket.GXWebSocketSession;
import com.genexus.internet.websocket.GXWebSocketSessionCollection;
import com.genexus.internet.websocket.SendResponseType;
import com.genexus.util.GXService;
import com.genexus.util.GXServices;
import com.genexus.websocket.ISession;
import com.genexus.xml.GXXMLSerializable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import json.org.json.IJsonFormattable;
import json.org.json.JSONException;
import json.org.json.JSONObject;

public class GXWebSocketService {
    public static final ILogger logger = LogManager.getLogger(GXWebSocketService.class);
    private static GXWebSocketService instance;
    private String[] handlerCache = new String[HandlerType.values().length];
    private GXWebSocketSessionCollection wsClients = new GXWebSocketSessionCollection();
    private ConcurrentHashMap<Integer, GXWebSocketSession> sessions = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GXWebSocketService getService() {
        if (instance != null) return instance;
        Class<GXWebSocketService> clazz = GXWebSocketService.class;
        synchronized (GXWebSocketService.class) {
            if (instance != null) return instance;
            instance = new GXWebSocketService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void closedSession(GXWebSocketSession session) {
        this.wsClients.remove(session);
    }

    protected void onOpen(ISession session) {
        logger.debug(String.format("WebSocket - Connection opened '%s'", session.getId()));
        GXWebSocketSession client = this.getGXWebSocketSession(session);
        this.wsClients.put(client);
        Object[] parms = new Object[]{client.getId()};
        this.executeHandler(HandlerType.OnOpen, parms);
    }

    protected void onMessage(String txt, ISession session) {
        logger.debug(String.format("WebSocket - New Message received '%s'", session.getId()));
        Object[] parameters = new Object[2];
        parameters[0] = this.getGXWebSocketSession(session).getId();
        try {
            GXXMLSerializable nInfo = (GXXMLSerializable)Class.forName("com.genexuscore.genexus.server.SdtNotificationInfo").getConstructor(new Class[0]).newInstance(new Object[0]);
            JSONObject jInfo = new JSONObject();
            jInfo.put("Message", (Object)txt);
            nInfo.FromJSONObject((IJsonFormattable)jInfo);
            parameters[1] = nInfo;
            this.executeHandler(HandlerType.ReceivedMessage, parameters);
        }
        catch (ClassNotFoundException e) {
            logger.error("WebSocket - SdtNotificationInfo class not found", (Throwable)e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | JSONException e) {
            logger.error("WebSocket - General error ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeHandler(HandlerType type, Object[] parameters) {
        String handler = this.getHandlerClassName(type);
        if (handler != null) {
            ModelContext modelContext = ModelContext.getModelContext((Class)Application.gxCfg);
            UserInformation ui = Application.getConnectionManager().createUserInformation(Namespace.getNamespace(modelContext.getNAME_SPACE()));
            int remoteHandle = ui.getHandle();
            try {
                if (!DynamicExecute.dynamicExecute((ModelContext)modelContext, (int)remoteHandle, Application.class, (String)handler, (Object[])parameters)) {
                    logger.error(String.format("WebSocket - Handler '%s' failed to execute", handler));
                }
            }
            catch (Exception e) {
                logger.error(String.format("WebSocket - Handler '%s' failed to execute", handler));
            }
            finally {
                Application.cleanupConnection(remoteHandle);
            }
        }
    }

    private String getPtyTypeName(HandlerType type) {
        String typeName = "";
        switch (type) {
            case ReceivedMessage: {
                typeName = "WEBNOTIFICATIONS_RECEIVED_HANDLER";
                break;
            }
            case OnClose: {
                typeName = "WEBNOTIFICATIONS_ONCLOSE_HANDLER";
                break;
            }
            case OnError: {
                typeName = "WEBNOTIFICATIONS_ONERROR_HANDLER";
                break;
            }
            case OnOpen: {
                typeName = "WEBNOTIFICATIONS_ONOPEN_HANDLER";
            }
        }
        return typeName;
    }

    private String getHandlerClassName(HandlerType hType) {
        int idx = hType.ordinal();
        String handlerClassName = this.handlerCache[idx];
        if (handlerClassName == null) {
            String className;
            String type = this.getPtyTypeName(hType);
            GXService service = GXServices.getInstance().get("WebNotifications");
            if (service != null && service.getProperties() != null && (className = service.getProperties().get(type)) != null && className.length() > 0) {
                this.handlerCache[idx] = handlerClassName = GXutil.getClassName(className.toLowerCase());
            }
        }
        return handlerClassName;
    }

    protected void onClose(ISession session) {
        logger.debug(String.format("WebSocket - Connection closed '%s'", session.getId()));
        GXWebSocketSession client = this.getGXWebSocketSession(session);
        this.closedSession(client);
        Object[] parms = new Object[]{client.getId()};
        this.executeHandler(HandlerType.OnClose, parms);
        this.sessions.remove(client.getSession().getHashCode());
    }

    protected void onError(Throwable exception, ISession session) {
        logger.debug(String.format("WebSocket - Connection error '%s'", session.getId()));
        Object[] parms = new Object[]{this.getGXWebSocketSession(session).getId(), exception.getMessage()};
        this.executeHandler(HandlerType.OnError, parms);
    }

    public SendResponseType send(String clientId, String message) {
        logger.debug(String.format("WebSocket - Try send message to '%s'", clientId));
        SendResponseType result = SendResponseType.SessionNotFound;
        List<GXWebSocketSession> list = this.wsClients.getById(clientId);
        if (list != null) {
            for (GXWebSocketSession session : list) {
                result = this.sendMessage(session, message);
            }
        }
        return result;
    }

    private SendResponseType sendMessage(GXWebSocketSession session, String message) {
        SendResponseType result = SendResponseType.SessionInvalid;
        if (session != null) {
            if (session.getSession().isOpen()) {
                try {
                    session.getSession().sendEndPointText(message);
                    result = SendResponseType.OK;
                }
                catch (IOException e) {
                    result = SendResponseType.SendFailed;
                    logger.warn("WebSocket - sendMessage failed", (Throwable)e);
                }
            } else {
                logger.warn("WebSocket - sendMessage failed because session was invalid");
            }
        } else {
            result = SendResponseType.SessionNotFound;
        }
        return result;
    }

    public void broadcast(String message) {
        for (GXWebSocketSession session : this.wsClients.getAll()) {
            this.sendMessage(session, message);
        }
    }

    private GXWebSocketSession getGXWebSocketSession(ISession session) {
        if (this.sessions.containsKey(session.getHashCode())) {
            return this.sessions.get(session.getHashCode());
        }
        GXWebSocketSession socketSession = new GXWebSocketSession(session);
        this.sessions.put(socketSession.getSession().getHashCode(), socketSession);
        return socketSession;
    }

    public static enum HandlerType {
        ReceivedMessage,
        OnOpen,
        OnClose,
        OnError;

    }
}

