/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.management;

import com.genexus.db.CacheValue;
import com.genexus.management.CacheItemJMXMBean;
import com.genexus.management.MBeanUtils;
import java.util.Date;

public class CacheItemJMX
implements CacheItemJMXMBean {
    private CacheValue cacheValue;

    public CacheItemJMX(CacheValue cacheValue) {
        this.cacheValue = cacheValue;
    }

    public static void CreateCacheItemJMX(CacheValue cacheValue) {
        try {
            MBeanUtils.createMBean(cacheValue);
        }
        catch (Exception e) {
            System.err.println("Cannot register Cache Item MBean." + e.toString());
        }
    }

    public static void DestroyCacheItemJMX(CacheValue cacheValue) {
        try {
            MBeanUtils.destroyMBean(cacheValue);
        }
        catch (Exception e) {
            System.err.println("Cannot destroy cacheValue MBean." + e.toString());
        }
    }

    @Override
    public String getSQLSentence() {
        return this.cacheValue.getKey().getKey();
    }

    @Override
    public Object[] getParemeters() {
        return this.cacheValue.getKey().getParameters();
    }

    @Override
    public long getSize() {
        return this.cacheValue.getSize();
    }

    @Override
    public int getHitCount() {
        return this.cacheValue.getHitCount();
    }

    @Override
    public int getExpiryHitsCount() {
        return this.cacheValue.getExpiryHits();
    }

    @Override
    public Date getExpiryTime() {
        if (this.cacheValue.getExpiryTimeMilliseconds() == 0L) {
            return null;
        }
        return new Date(this.cacheValue.getTimestamp() + this.cacheValue.getExpiryTimeMilliseconds());
    }

    @Override
    public Date getTimeCreated() {
        return this.cacheValue.getTimeCreated();
    }
}

