/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.management;

import com.genexus.CacheFactory;
import com.genexus.Preferences;
import com.genexus.db.CacheValue;
import com.genexus.db.InProcessCache;
import com.genexus.management.CacheItemJMX;
import com.genexus.management.CacheJMXMBean;
import com.genexus.management.MBeanUtils;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

public class CacheJMX
implements CacheJMXMBean {
    private InProcessCache resultCache;

    public CacheJMX(InProcessCache resultCache) {
        this.resultCache = resultCache;
    }

    public static void CreateCacheJMX(InProcessCache resultCache) {
        try {
            MBeanUtils.createMBean(resultCache);
        }
        catch (Exception e) {
            System.err.println("Cannot register Cache MBean." + e.toString());
        }
    }

    public static void DestroyCacheJMX() {
        try {
            MBeanUtils.destroyMBeanCache();
        }
        catch (Exception e) {
            System.err.println("Cannot destroy Cache MBean." + e.toString());
        }
    }

    @Override
    public long getStorageSize() {
        return this.resultCache.getCacheStorageSize();
    }

    @Override
    public long getCurrentSize() {
        return this.resultCache.getCacheCurrentSize();
    }

    @Override
    public boolean getEnabled() {
        return this.resultCache.isEnabled();
    }

    @Override
    public void setEnabled(boolean value) {
        this.resultCache.setEnabled(value);
    }

    @Override
    public int[] getTimeToLive() {
        return Preferences.TTL;
    }

    @Override
    public void setTimeToLive(int[] value) {
        this.resultCache.setTimeToLive(value);
    }

    @Override
    public int[] getHitsToLive() {
        return Preferences.HTL;
    }

    @Override
    public void setHitsToLive(int[] value) {
        this.resultCache.setHitsToLive(value);
    }

    @Override
    public void restart() {
        ConcurrentHashMap<String, CacheValue> cache = this.resultCache.getCache();
        Enumeration<CacheValue> enumera = cache.elements();
        while (enumera.hasMoreElements()) {
            CacheValue value = enumera.nextElement();
            CacheItemJMX.DestroyCacheItemJMX(value);
        }
        CacheFactory.restartCache();
    }
}

