/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.management;

import com.genexus.db.driver.GXConnection;
import com.genexus.management.ConnectionJMXMBean;
import com.genexus.management.MBeanUtils;
import java.util.Date;

public class ConnectionJMX
implements ConnectionJMXMBean {
    GXConnection connection;

    public ConnectionJMX(GXConnection connection) {
        this.connection = connection;
    }

    public static void CreateConnectionJMX(GXConnection connection) {
        try {
            MBeanUtils.createMBean(connection);
        }
        catch (Exception e) {
            System.err.println("Cannot register Connection MBean." + e.toString());
        }
    }

    public static void DestroyConnectionJMX(GXConnection connection) {
        try {
            MBeanUtils.destroyMBean(connection);
        }
        catch (Exception e) {
            System.err.println("Cannot destroy Connection MBean." + e.toString());
        }
    }

    @Override
    public int getId() {
        return this.connection.getId();
    }

    @Override
    public String getPhysicalId() {
        return this.connection.getDBMSId();
    }

    @Override
    public Date getCreateTime() {
        return this.connection.getTimeCreated();
    }

    @Override
    public Date getLastAssignedTime() {
        return this.connection.getTimeAssigned();
    }

    @Override
    public int getLastUserAssigned() {
        return this.connection.getLastUserAssigned();
    }

    @Override
    public boolean getError() {
        return this.connection.getError();
    }

    public boolean getInAssigment() {
        return this.connection.getInAssigment();
    }

    @Override
    public boolean getAvailable() {
        return !this.getInAssigment() && this.getOpenCursorCount() == 0 && !this.getUncommitedChanges();
    }

    @Override
    public int getOpenCursorCount() {
        return this.connection.getOpenCursorsJMX();
    }

    @Override
    public boolean getUncommitedChanges() {
        return this.connection.getUncommitedChanges();
    }

    @Override
    public int getRequestCount() {
        return this.connection.getNumberRequest();
    }

    @Override
    public Date getLastSQLStatementTime() {
        return this.connection.getTimeLastRequest();
    }

    @Override
    public String getLastSQLStatement() {
        return this.connection.getSentenceLastRequest();
    }

    @Override
    public String getLastObject() {
        return this.connection.getLastObjectExecuted();
    }

    @Override
    public boolean getLastSQLStatementEnded() {
        return this.connection.getFinishExecute();
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
    }

    @Override
    public void dumpConnectionInformation() {
        this.connection.dump();
    }
}

