/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.management;

import com.genexus.db.driver.ConnectionPool;
import com.genexus.management.ConnectionPoolJMXMBean;
import com.genexus.management.MBeanUtils;
import java.util.Date;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;

public class ConnectionPoolJMX
extends NotificationBroadcasterSupport
implements ConnectionPoolJMXMBean {
    private long sequenceNumber = 0L;
    ConnectionPool connectionPool;
    private long lastUserWaitingForLongTimeNotif = 0L;
    private long lastPoollsFullNotif = 0L;

    public ConnectionPoolJMX(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
        connectionPool.setConnectionPoolJMX(this);
    }

    public static void CreateConnectionPoolJMX(ConnectionPool connectionPool) {
        try {
            MBeanUtils.createMBean(connectionPool);
        }
        catch (Exception e) {
            System.err.println("Cannot register ConnectionPool MBean." + e.toString());
        }
    }

    @Override
    public int getSize() {
        return this.connectionPool.getMaxPoolSize();
    }

    @Override
    public void setSize(int maxPoolSize) {
        this.connectionPool.setMaxPoolSize(maxPoolSize);
    }

    @Override
    public boolean getUnlimitedSize() {
        return this.connectionPool.getUnlimitedSize();
    }

    @Override
    public int getConnectionCount() {
        return this.connectionPool.getActualPoolSize();
    }

    @Override
    public int getFreeConnectionCount() {
        return this.connectionPool.getFreeConnectionCount();
    }

    @Override
    public int getCreatedConnectionCount() {
        return this.connectionPool.getNumberConnectionsCreated();
    }

    @Override
    public int getRecycledConnectionCount() {
        return this.connectionPool.getNumberConnectionsRecycled();
    }

    @Override
    public int getDroppedConnectionCount() {
        return this.connectionPool.getNumberConnectionsDeleted();
    }

    @Override
    public int getRequestCount() {
        return this.connectionPool.getNumberRequest();
    }

    @Override
    public float getAverageRequestPerSec() {
        return this.connectionPool.getAverageNumberRequest();
    }

    @Override
    public Date getLastRequestTime() {
        return this.connectionPool.getTimeLastRequest();
    }

    @Override
    public int getWaitedUserCount() {
        return this.connectionPool.getNumberUsersWaits();
    }

    @Override
    public int getWaitingUserCount() {
        return this.connectionPool.getNumberUsersWaiting();
    }

    @Override
    public long getMaxUserWaitTime() {
        return this.connectionPool.getMaxUserWaitingTime();
    }

    @Override
    public float getAverageUserWaitTime() {
        return this.connectionPool.getAverageUserWaitingTime();
    }

    @Override
    public long getBeforeNotificationWaitTime() {
        return this.connectionPool.getUserMaxTimeWaitingBeforeNotif();
    }

    @Override
    public void setBeforeNotificationWaitTime(long value) {
        this.connectionPool.setUserMaxTimeWaitingBeforeNotif(value);
    }

    @Override
    public void dumpPoolInformation() {
        this.connectionPool.dumpPoolInformation();
    }

    @Override
    public void Recycle() {
        this.connectionPool.PoolRecycle();
    }

    @Override
    public boolean getNotificationEnabled() {
        return this.connectionPool.getEnableNotifications();
    }

    @Override
    public void setNotificationEnabled(boolean value) {
        this.connectionPool.setEnableNotifications(value);
    }

    public void PoolIsFull() {
        if (System.currentTimeMillis() - this.lastPoollsFullNotif > 1000L) {
            this.lastPoollsFullNotif = System.currentTimeMillis();
            Notification n = new Notification("com.genexus.managment.fullpool", this, this.sequenceNumber++, System.currentTimeMillis(), "The Connection Pool does not have available connections ");
            this.sendNotification(n);
        }
    }

    public void UserWaitingForLongTime() {
        if (System.currentTimeMillis() - this.lastUserWaitingForLongTimeNotif > 1000L) {
            this.lastUserWaitingForLongTimeNotif = System.currentTimeMillis();
            Notification n = new Notification("com.genexus.managment.longtimeuserwaiting", this, this.sequenceNumber++, System.currentTimeMillis(), "User waiting a connection for a long time");
            this.sendNotification(n);
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"com.genexus.managment.fullpool"};
        String name = Notification.class.getName();
        String description = "The Connection Pool does not have available connections ";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, name, description);
        types = new String[]{"com.genexus.managment.longtimeuserwaiting"};
        description = "User waiting a connection for a long time";
        MBeanNotificationInfo info1 = new MBeanNotificationInfo(types, name, description);
        return new MBeanNotificationInfo[]{info, info1};
    }
}

