/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.management;

import com.genexus.ModelContext;
import com.genexus.db.CacheValue;
import com.genexus.db.InProcessCache;
import com.genexus.db.LocalUserInformation;
import com.genexus.db.Namespace;
import com.genexus.db.ServerUserInformation;
import com.genexus.db.driver.ConnectionPool;
import com.genexus.db.driver.DataSource;
import com.genexus.db.driver.GXConnection;
import com.genexus.management.CacheItemJMX;
import com.genexus.management.CacheJMX;
import com.genexus.management.ConnectionJMX;
import com.genexus.management.ConnectionPoolJMX;
import com.genexus.management.DataSourceJMX;
import com.genexus.management.LocalUserInformationJMX;
import com.genexus.management.NamespaceJMX;
import com.genexus.management.ServerUserInformationJMX;
import java.util.ArrayList;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class MBeanUtils {
    private static MBeanServer mbs = null;
    private static Vector<ObjectName> registeredObjects = new Vector();

    private static MBeanServer getMBeanServer() {
        if (mbs == null) {
            try {
                ArrayList<MBeanServer> list = MBeanServerFactory.findMBeanServer(null);
                if (list.size() > 0) {
                    mbs = list.get(0);
                }
            }
            catch (Throwable t) {
                t.printStackTrace(System.out);
                System.exit(1);
            }
        }
        return mbs;
    }

    public static void registerBean(Object mbean, String sName) {
        ObjectName name = null;
        try {
            name = new ObjectName(sName);
        }
        catch (MalformedObjectNameException e1) {
            System.out.println(e1);
        }
        if (name == null) {
            return;
        }
        try {
            mbs.getObjectInstance(name);
        }
        catch (InstanceNotFoundException ex) {
            try {
                mbs.registerMBean(mbean, name);
                registeredObjects.addElement(name);
            }
            catch (InstanceAlreadyExistsException e) {
                System.out.println(e);
            }
            catch (MBeanRegistrationException e) {
                System.out.println(e);
            }
            catch (NotCompliantMBeanException e) {
                System.out.println(e);
            }
        }
    }

    public static void createMBean(Namespace namespace) {
        MBeanServer mbs = MBeanUtils.getMBeanServer();
        if (mbs == null) {
            return;
        }
        NamespaceJMX mbean = new NamespaceJMX(namespace);
        MBeanUtils.registerBean(mbean, "com.genexus.management:type=GeneXusApplicationServer.ApplicationName,name= " + namespace.getName());
    }

    public static void createMBean(ServerUserInformation serverUserInfo, ModelContext context) {
        MBeanServer mbs = MBeanUtils.getMBeanServer();
        if (mbs == null) {
            return;
        }
        ServerUserInformationJMX mbean = new ServerUserInformationJMX(serverUserInfo, context);
        MBeanUtils.registerBean(mbean, "com.genexus.management:type=GeneXusApplicationServer.ApplicationName.User,ApplicationName=" + serverUserInfo.getNamespace().getName() + ",name=User " + serverUserInfo.getHandle());
    }

    public static void createMBean(LocalUserInformation localUserInfo) {
        MBeanServer mbs = MBeanUtils.getMBeanServer();
        if (mbs == null) {
            return;
        }
        LocalUserInformationJMX mbean = new LocalUserInformationJMX(localUserInfo);
        MBeanUtils.registerBean(mbean, "com.genexus.management:type=GeneXusApplicationServer.ApplicationName.User,ApplicationName=" + localUserInfo.getNamespace().getName() + ",name=User " + localUserInfo.getHandle());
    }

    public static void createMBean(DataSource dataSource) {
        MBeanServer mbs = MBeanUtils.getMBeanServer();
        if (mbs == null) {
            return;
        }
        DataSourceJMX mbean = new DataSourceJMX(dataSource);
        MBeanUtils.registerBean(mbean, "com.genexus.management:type=GeneXusApplicationServer.ApplicationName.DataStore,ApplicationName=" + dataSource.getNamespace() + ",name=DataStore " + dataSource.name);
    }

    public static void createMBean(ConnectionPool connectionPool) {
        MBeanServer mbs = MBeanUtils.getMBeanServer();
        if (mbs == null) {
            return;
        }
        ConnectionPoolJMX mbean = new ConnectionPoolJMX(connectionPool);
        MBeanUtils.registerBean(mbean, "com.genexus.management:type=GeneXusApplicationServer.ApplicationName.DataStore.ConnectionPool,ApplicationName=" + connectionPool.getDataSource().getNamespace() + ",DataStore=" + connectionPool.getDataSource().name + ",name=R/W pool");
    }

    public static void createMBean(GXConnection connection) {
        MBeanServer mbs = MBeanUtils.getMBeanServer();
        if (mbs == null) {
            return;
        }
        ConnectionJMX mbean = new ConnectionJMX(connection);
        MBeanUtils.registerBean(mbean, "com.genexus.management:type=GeneXusApplicationServer.ApplicationName.DataStore.ConnectionPool.Connection,ApplicationName=" + connection.getDataSource().getNamespace() + ",DataStore=" + connection.getDataSource().name + ",ConnectionPool=R/W pool,name=" + connection.getId());
    }

    public static void createMBean(InProcessCache cache) {
        MBeanServer mbs = MBeanUtils.getMBeanServer();
        if (mbs == null) {
            return;
        }
        CacheJMX mbean = new CacheJMX(cache);
        MBeanUtils.registerBean(mbean, "com.genexus.management:type=InProcessCache");
    }

    public static void createMBean(CacheValue cacheValue) {
        MBeanServer mbs = MBeanUtils.getMBeanServer();
        if (mbs == null) {
            return;
        }
        CacheItemJMX mbean = new CacheItemJMX(cacheValue);
        MBeanUtils.registerBean(mbean, "com.genexus.management:type=InProcessCache.Item,name=" + cacheValue.hashCode());
    }

    public static void destroyMBean(ServerUserInformation serverUserInfo) {
        MBeanServer mbs = MBeanUtils.getMBeanServer();
        if (mbs == null) {
            return;
        }
        try {
            ObjectName name = new ObjectName("com.genexus.management:type=GeneXusApplicationServer.ApplicationName.User,ApplicationName=" + serverUserInfo.getNamespace().getName() + ",name=User " + serverUserInfo.getHandle());
            registeredObjects.removeElement(name);
            mbs.unregisterMBean(name);
        }
        catch (MalformedObjectNameException e) {
            System.out.println(e);
        }
        catch (InstanceNotFoundException e) {
            System.out.println(e);
        }
        catch (MBeanRegistrationException e) {
            System.out.println(e);
        }
    }

    public static void destroyMBean(LocalUserInformation localUserInfo) {
        MBeanServer mbs = MBeanUtils.getMBeanServer();
        if (mbs == null) {
            return;
        }
        try {
            ObjectName name = new ObjectName("com.genexus.management:type=GeneXusApplicationServer.ApplicationName.User,ApplicationName=" + localUserInfo.getNamespace().getName() + ",name=User " + localUserInfo.getHandle());
            registeredObjects.removeElement(name);
            mbs.unregisterMBean(name);
        }
        catch (MalformedObjectNameException e) {
            System.out.println(e);
        }
        catch (InstanceNotFoundException e) {
            System.out.println(e);
        }
        catch (MBeanRegistrationException e) {
            System.out.println(e);
        }
    }

    public static void destroyMBean(GXConnection connection) {
        MBeanServer mbs = MBeanUtils.getMBeanServer();
        if (mbs == null) {
            return;
        }
        try {
            ObjectName name = new ObjectName("com.genexus.management:type=GeneXusApplicationServer.ApplicationName.DataStore.ConnectionPool.Connection,ApplicationName=" + connection.getDataSource().getNamespace() + ",DataStore=" + connection.getDataSource().name + ",ConnectionPool=R/W pool,name=" + connection.getId());
            registeredObjects.removeElement(name);
            mbs.unregisterMBean(name);
        }
        catch (MalformedObjectNameException e) {
            System.out.println(e);
        }
        catch (InstanceNotFoundException e) {
            System.out.println(e);
        }
        catch (MBeanRegistrationException e) {
            System.out.println(e);
        }
    }

    public static void destroyMBeanCache() {
        MBeanServer mbs = MBeanUtils.getMBeanServer();
        if (mbs == null) {
            return;
        }
        try {
            ObjectName name = new ObjectName("com.genexus.management:type=InProcessCache");
            registeredObjects.removeElement(name);
            mbs.unregisterMBean(name);
        }
        catch (MalformedObjectNameException e) {
            System.out.println(e);
        }
        catch (InstanceNotFoundException e) {
            System.out.println(e);
        }
        catch (MBeanRegistrationException e) {
            System.out.println(e);
        }
    }

    public static void destroyMBean(CacheValue cacheValue) {
        MBeanServer mbs = MBeanUtils.getMBeanServer();
        if (mbs == null) {
            return;
        }
        try {
            ObjectName name = new ObjectName("com.genexus.management:type=InProcessCache.Item,name=" + cacheValue.hashCode());
            registeredObjects.removeElement(name);
            mbs.unregisterMBean(name);
        }
        catch (MalformedObjectNameException e) {
            System.out.println(e);
        }
        catch (InstanceNotFoundException e) {
            System.out.println(e);
        }
        catch (MBeanRegistrationException e) {
            System.out.println(e);
        }
    }

    public static void unregisterObjects() {
        try {
            for (int i = 0; i < registeredObjects.size(); ++i) {
                mbs.unregisterMBean(registeredObjects.elementAt(i));
            }
        }
        catch (InstanceNotFoundException e) {
            System.out.println(e);
        }
        catch (MBeanRegistrationException e) {
            System.out.println(e);
        }
        mbs = null;
    }
}

