/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.management;

import com.genexus.ModelContext;
import com.genexus.db.DBConnectionManager;
import com.genexus.db.ServerUserInformation;
import com.genexus.management.MBeanUtils;
import com.genexus.management.ServerUserInformationJMXMBean;
import java.sql.SQLException;
import java.util.Date;

public class ServerUserInformationJMX
implements ServerUserInformationJMXMBean {
    ServerUserInformation serverUserInfo;
    ModelContext context;

    public ServerUserInformationJMX(ServerUserInformation serverUserInfo, ModelContext context) {
        this.serverUserInfo = serverUserInfo;
        this.context = context;
    }

    public static void CreateServerUserInformationJMX(ServerUserInformation serverUserInfo, ModelContext context) {
        try {
            MBeanUtils.createMBean(serverUserInfo, context);
        }
        catch (Exception e) {
            System.err.println("Cannot register User Information MBean." + e.toString());
        }
    }

    public static void DestroyServerUserInformationJMX(ServerUserInformation serverUserInfo) {
        try {
            MBeanUtils.destroyMBean(serverUserInfo);
        }
        catch (Exception e) {
            System.err.println("Cannot destroy User Information MBean." + e.toString());
        }
    }

    @Override
    public int getId() {
        return this.serverUserInfo.getHandle();
    }

    @Override
    public String getIP() {
        return this.serverUserInfo.getIP();
    }

    @Override
    public Date getConnectedTime() {
        return this.serverUserInfo.getConnectedSince();
    }

    @Override
    public long getIdleSeconds() {
        return this.serverUserInfo.getIdleSeconds();
    }

    @Override
    public String getLastSQLStatement() {
        return this.serverUserInfo.getLastSQL();
    }

    @Override
    public Date getLastSQLStatementTime() {
        return this.serverUserInfo.getLastSQLDateTime();
    }

    @Override
    public String getLastObject() {
        return this.serverUserInfo.getLastObjectExecuted();
    }

    @Override
    public boolean getWaitingForConnection() {
        return this.serverUserInfo.getWaitingForConnection();
    }

    @Override
    public Date getWaitingForConnectionTime() {
        return this.serverUserInfo.getWaitingForConnectionSince();
    }

    @Override
    public int getLastConnectionId() {
        return this.serverUserInfo.getLastConnectionUsed();
    }

    @Override
    public String getUserId() {
        try {
            return DBConnectionManager.getInstance().getUserName(this.context, this.serverUserInfo.getHandle(), "DEFAULT");
        }
        catch (SQLException ex) {
            return "";
        }
    }

    @Override
    public void disconnect() {
        this.serverUserInfo.disconnectUser();
    }
}

