/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.performance;

import com.genexus.Application;
import com.genexus.performance.SentenceInfo;
import com.genexus.performance.SentenceJMX;
import com.genexus.xml.XMLWriter;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class DataStoreProviderInfo {
    private long sentenceCount;
    private long sentenceSelectCount;
    private long sentenceUpdateCount;
    private long sentenceDeleteCount;
    private long sentenceInsertCount;
    private long sentenceCallCount;
    private long sentenceDirectSQLCount;
    private Hashtable<String, SentenceInfo> sentenceInfo = new Hashtable();
    private String name;

    public DataStoreProviderInfo(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public long getSentenceCount() {
        return this.sentenceCount;
    }

    public void incSentenceCount() {
        ++this.sentenceCount;
    }

    public long getSentenceSelectCount() {
        return this.sentenceSelectCount;
    }

    public void incSentenceSelectCount() {
        ++this.sentenceSelectCount;
    }

    public long getSentenceUpdateCount() {
        return this.sentenceUpdateCount;
    }

    public void incSentenceUpdateCount() {
        ++this.sentenceUpdateCount;
    }

    public long getSentenceDeleteCount() {
        return this.sentenceDeleteCount;
    }

    public void incSentenceDeleteCount() {
        ++this.sentenceDeleteCount;
    }

    public long getSentenceInsertCount() {
        return this.sentenceInsertCount;
    }

    public void incSentenceInsertCount() {
        ++this.sentenceInsertCount;
    }

    public long getSentenceCallCount() {
        return this.sentenceCallCount;
    }

    public void incSentenceCallCount() {
        ++this.sentenceCallCount;
    }

    public long getSentenceDirectSQLCount() {
        return this.sentenceDirectSQLCount;
    }

    public void incSentenceDirectSQLCount() {
        ++this.sentenceDirectSQLCount;
    }

    public void dump(PrintStream out) {
        out.println("\tDataStoreProvider : " + this.name);
        out.println("\tNumber of sentences : " + this.sentenceCount);
        out.println("\tNumber of select sentences : " + this.sentenceSelectCount);
        out.println("\tNumber of update sentences : " + this.sentenceUpdateCount);
        out.println("\tNumber of delete sentences : " + this.sentenceDeleteCount);
        out.println("\tNumber of insert sentences : " + this.sentenceInsertCount);
        out.println("\tNumber of CALL sentences : " + this.sentenceCallCount);
        out.println("\tNumber of direct SQL sentences : " + this.sentenceDirectSQLCount);
        out.println("");
        out.println("");
        Enumeration<SentenceInfo> en = this.sentenceInfo.elements();
        while (en.hasMoreElements()) {
            SentenceInfo sInfo = en.nextElement();
            sInfo.dump(out);
            out.println("");
            out.println("");
        }
    }

    public void dump(XMLWriter writer) {
        writer.writeStartElement("DataStoreProvider");
        writer.writeAttribute("Name", this.name);
        writer.writeElement("Total_SQLStatementCount", this.sentenceCount);
        writer.writeElement("Select_SQLStatementCount", this.sentenceSelectCount);
        writer.writeElement("Update_SQLStatementCount", this.sentenceUpdateCount);
        writer.writeElement("Delete_SQLStatementCount", this.sentenceDeleteCount);
        writer.writeElement("Insert_SQLStatementCount", this.sentenceInsertCount);
        writer.writeElement("StoredProcedureCount", this.sentenceCallCount);
        writer.writeElement("SQLCommandCount", this.sentenceDirectSQLCount);
        Enumeration<SentenceInfo> en = this.sentenceInfo.elements();
        while (en.hasMoreElements()) {
            SentenceInfo sInfo = en.nextElement();
            sInfo.dump(writer);
        }
        writer.writeEndElement();
    }

    public SentenceInfo addSentenceInfo(String key, String sqlSentence) {
        if (!this.sentenceInfo.containsKey(key)) {
            SentenceInfo sInfo = new SentenceInfo(sqlSentence);
            this.sentenceInfo.put(key, sInfo);
            if (Application.isJMXEnabled()) {
                SentenceJMX.CreateSentenceJMX(this, key);
            }
        }
        return this.sentenceInfo.get(key);
    }

    public SentenceInfo getSentenceInfo(String key) {
        return this.sentenceInfo.get(key);
    }
}

