/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.performance;

import com.genexus.CommonUtil;
import com.genexus.db.DataStoreProvider;
import com.genexus.performance.DataStoreProviderInfo;
import com.genexus.performance.DataStoreProviderJMXMBean;
import com.genexus.performance.MBeanUtils;
import com.genexus.xml.XMLWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;

public class DataStoreProviderJMX
implements DataStoreProviderJMXMBean {
    DataStoreProviderInfo dataStoreProvider;

    public DataStoreProviderJMX(String name) {
        this.dataStoreProvider = DataStoreProvider.getDataStoreProviderInfo(name);
    }

    public static void CreateDataStoreProviderJMX(String name) {
        try {
            MBeanUtils.createMBeanDataStoreProvider(name);
        }
        catch (Exception e) {
            System.err.println("Cannot register DataStoreProvider MBean." + e.toString());
        }
    }

    @Override
    public long getTotalSQLStatementCount() {
        return this.dataStoreProvider.getSentenceCount();
    }

    @Override
    public long getSelectSQLStatementCount() {
        return this.dataStoreProvider.getSentenceSelectCount();
    }

    @Override
    public long getUpdateSQLStatementCount() {
        return this.dataStoreProvider.getSentenceUpdateCount();
    }

    @Override
    public long getDeleteSQLStatementCount() {
        return this.dataStoreProvider.getSentenceDeleteCount();
    }

    @Override
    public long getInsertSQLStatementCount() {
        return this.dataStoreProvider.getSentenceInsertCount();
    }

    @Override
    public long getStoredProcedureCount() {
        return this.dataStoreProvider.getSentenceCallCount();
    }

    @Override
    public long getSQLCommandCount() {
        return this.dataStoreProvider.getSentenceDirectSQLCount();
    }

    public void dumpTxt() {
        try {
            PrintStream out = new PrintStream(new FileOutputStream("DataStoreProvider_" + this.dataStoreProvider.getName() + CommonUtil.getYYYYMMDDHHMMSS_nosep((Date)new Date()) + ".log", true));
            this.dataStoreProvider.dump(out);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void dumpDataStoreInformation() {
        String fileName = "DataStoreProvider_" + this.dataStoreProvider.getName() + CommonUtil.getYYYYMMDDHHMMSS_nosep((Date)new Date()) + ".xml";
        XMLWriter writer = new XMLWriter();
        writer.xmlStart(fileName);
        this.dataStoreProvider.dump(writer);
        writer.close();
    }
}

