/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.performance;

import com.genexus.performance.DataStoreProviderInfo;
import com.genexus.performance.DataStoreProviderJMX;
import com.genexus.performance.DataStoreProvidersJMX;
import com.genexus.performance.ProcedureInfo;
import com.genexus.performance.ProcedureJMX;
import com.genexus.performance.SentenceJMX;
import java.util.ArrayList;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class MBeanUtils {
    private static MBeanServer mbs = null;
    private static Vector<ObjectName> registeredObjects = new Vector();

    private static MBeanServer getMBeanServer() {
        if (mbs == null) {
            try {
                ArrayList<MBeanServer> list = MBeanServerFactory.findMBeanServer(null);
                if (list.size() > 0) {
                    mbs = list.get(0);
                }
            }
            catch (Throwable t) {
                t.printStackTrace(System.out);
                System.exit(1);
            }
        }
        return mbs;
    }

    public static void createMBeanDataStoreProviders() {
        MBeanServer mbs = MBeanUtils.getMBeanServer();
        if (mbs == null) {
            return;
        }
        try {
            ObjectName name = new ObjectName("com.genexus.performance:type=DataStoreProviders");
            registeredObjects.addElement(name);
            DataStoreProvidersJMX mbean = new DataStoreProvidersJMX();
            mbs.registerMBean(mbean, name);
        }
        catch (MalformedObjectNameException e) {
            System.out.println(e);
        }
        catch (InstanceAlreadyExistsException e) {
            System.out.println(e);
        }
        catch (MBeanRegistrationException e) {
            System.out.println(e);
        }
        catch (NotCompliantMBeanException e) {
            System.out.println(e);
        }
    }

    public static void createMBeanDataStoreProvider(String dsName) {
        MBeanServer mbs = MBeanUtils.getMBeanServer();
        if (mbs == null) {
            return;
        }
        try {
            ObjectName name = new ObjectName("com.genexus.performance:type=DataStoreProviders.DataStoreProvider,name= " + dsName);
            registeredObjects.addElement(name);
            DataStoreProviderJMX mbean = new DataStoreProviderJMX(dsName);
            mbs.registerMBean(mbean, name);
        }
        catch (MalformedObjectNameException e) {
            System.out.println(e);
        }
        catch (InstanceAlreadyExistsException e) {
            System.out.println(e);
        }
        catch (MBeanRegistrationException e) {
            System.out.println(e);
        }
        catch (NotCompliantMBeanException e) {
            System.out.println(e);
        }
    }

    public static void createMBeanSentence(DataStoreProviderInfo dsInfo, String sname) {
        MBeanServer mbs = MBeanUtils.getMBeanServer();
        if (mbs == null) {
            return;
        }
        try {
            ObjectName name = new ObjectName("com.genexus.performance:type=DataStoreProviders.DataStoreProvider.SQLStatement,DataStoreProvider=" + dsInfo.getName() + ",name= " + sname);
            registeredObjects.addElement(name);
            SentenceJMX mbean = new SentenceJMX(dsInfo, sname);
            mbs.registerMBean(mbean, name);
        }
        catch (MalformedObjectNameException e) {
            System.out.println(e);
        }
        catch (InstanceAlreadyExistsException e) {
            System.out.println(e);
        }
        catch (MBeanRegistrationException e) {
            System.out.println(e);
        }
        catch (NotCompliantMBeanException e) {
            System.out.println(e);
        }
    }

    public static void createMBeanProcedure(ProcedureInfo pInfo) {
        MBeanServer mbs = MBeanUtils.getMBeanServer();
        if (mbs == null) {
            return;
        }
        try {
            ObjectName name = new ObjectName("com.genexus.performance:type=Procedures,name= " + pInfo.getName());
            registeredObjects.addElement(name);
            ProcedureJMX mbean = new ProcedureJMX(pInfo);
            mbs.registerMBean(mbean, name);
        }
        catch (MalformedObjectNameException e) {
            System.out.println(e);
        }
        catch (InstanceAlreadyExistsException e) {
            System.out.println(e);
        }
        catch (MBeanRegistrationException e) {
            System.out.println(e);
        }
        catch (NotCompliantMBeanException e) {
            System.out.println(e);
        }
    }

    public static void unregisterObjects() {
        try {
            for (int i = 0; i < registeredObjects.size(); ++i) {
                mbs.unregisterMBean(registeredObjects.elementAt(i));
            }
        }
        catch (InstanceNotFoundException e) {
            System.out.println(e);
        }
        catch (MBeanRegistrationException e) {
            System.out.println(e);
        }
        mbs = null;
    }
}

