/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.performance;

import java.io.PrintStream;
import java.util.Date;

public class ProcedureInfo {
    private long count;
    private String name;
    private Date timeLastExecute;
    private long totalTimeExecute;
    private float averageTimeExecute;
    private long worstTimeExecute;
    private long bestTimeExecute;

    public ProcedureInfo(String name) {
        this.name = name;
    }

    public long getCount() {
        return this.count;
    }

    public void incCount() {
        ++this.count;
        this.timeLastExecute = new Date();
    }

    public String getName() {
        return this.name;
    }

    public Date getTimeLastExecute() {
        return this.timeLastExecute;
    }

    public long getTotalTimeExecute() {
        return this.totalTimeExecute;
    }

    public float getAverageTimeExecute() {
        return this.averageTimeExecute;
    }

    public long getWorstTimeExecute() {
        return this.worstTimeExecute;
    }

    public long getBestTimeExecute() {
        return this.bestTimeExecute;
    }

    public void dump(PrintStream out) {
        out.println("\t\tProcedure name : " + this.name);
        out.println("\t\tNumber of executions : " + this.count);
        out.println("\t\tLast time executed : " + this.timeLastExecute);
        out.println("\t\tTotal time : " + this.totalTimeExecute);
        out.println("\t\tAverage time : " + this.averageTimeExecute);
        out.println("\t\tWorst time : " + this.worstTimeExecute);
        out.println("\t\tBest time : " + this.bestTimeExecute);
    }

    public void setTimeExecute(long time) {
        this.totalTimeExecute += time;
        this.averageTimeExecute = this.totalTimeExecute / this.count;
        if (time > this.worstTimeExecute) {
            this.worstTimeExecute = time;
        }
        if (time < this.bestTimeExecute || this.bestTimeExecute == 0L) {
            this.bestTimeExecute = time;
        }
    }
}

