/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.performance;

import com.genexus.Application;
import com.genexus.performance.SentenceJMX;
import com.genexus.xml.XMLWriter;
import java.io.PrintStream;
import java.util.Date;

public class SentenceInfo {
    private long sentenceCount;
    private String sqlSentence;
    private Date timeLastExecute;
    private long totalTimeExecute;
    private float averageTimeExecute;
    private long worstTimeExecute;
    private long bestTimeExecute;
    private long maxTimeForNotification = 10000L;
    private boolean enableNotifications = true;
    public SentenceJMX sentenceJMX = null;

    public SentenceInfo(String sqlSentence) {
        this.sqlSentence = sqlSentence;
    }

    public long getSentenceCount() {
        return this.sentenceCount;
    }

    public void incSentenceCount() {
        ++this.sentenceCount;
        this.timeLastExecute = new Date();
    }

    public String getSQLSentence() {
        return this.sqlSentence;
    }

    public Date getTimeLastExecute() {
        return this.timeLastExecute;
    }

    public long getTotalTimeExecute() {
        return this.totalTimeExecute;
    }

    public float getAverageTimeExecute() {
        return this.averageTimeExecute;
    }

    public long getWorstTimeExecute() {
        return this.worstTimeExecute;
    }

    public long getBestTimeExecute() {
        return this.bestTimeExecute;
    }

    public long getMaxTimeForNotification() {
        return this.maxTimeForNotification;
    }

    public void setMaxTimeForNotification(long value) {
        this.maxTimeForNotification = value;
    }

    public boolean getEnableNotifications() {
        return this.enableNotifications;
    }

    public void setEnableNotifications(boolean value) {
        this.enableNotifications = value;
    }

    public void dump(PrintStream out) {
        out.println("\t\tSQL sentence : " + this.sqlSentence);
        out.println("\t\tNumber of executions : " + this.sentenceCount);
        out.println("\t\tLast time executed : " + this.timeLastExecute);
        out.println("\t\tTotal time : " + this.totalTimeExecute);
        out.println("\t\tAverage time : " + this.averageTimeExecute);
        out.println("\t\tWorst time : " + this.worstTimeExecute);
        out.println("\t\tBest time : " + this.bestTimeExecute);
    }

    public void dump(XMLWriter writer) {
        writer.writeStartElement("SQLStatement");
        writer.writeStartElement("SQLStatement");
        writer.writeCData(this.sqlSentence);
        writer.writeEndElement();
        writer.writeElement("Count", this.sentenceCount);
        writer.writeElement("LastExecute", this.timeLastExecute.toString());
        writer.writeElement("TotalTime", this.totalTimeExecute);
        writer.writeElement("AverageTime", (double)this.averageTimeExecute);
        writer.writeElement("WorstTime", this.worstTimeExecute);
        writer.writeElement("BestTime", this.bestTimeExecute);
        writer.writeEndElement();
    }

    public void setTimeExecute(long time) {
        if (Application.isJMXEnabled() && time > this.maxTimeForNotification && this.enableNotifications) {
            this.sentenceJMX.SentencePoorPerformance();
        }
        this.totalTimeExecute += time;
        this.averageTimeExecute = this.totalTimeExecute / this.sentenceCount;
        if (time > this.worstTimeExecute) {
            this.worstTimeExecute = time;
        }
        if (time < this.bestTimeExecute || this.bestTimeExecute == 0L) {
            this.bestTimeExecute = time;
        }
    }
}

