/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.performance;

import com.genexus.performance.DataStoreProviderInfo;
import com.genexus.performance.MBeanUtils;
import com.genexus.performance.SentenceInfo;
import com.genexus.performance.SentenceJMXMBean;
import java.util.Date;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;

public class SentenceJMX
extends NotificationBroadcasterSupport
implements SentenceJMXMBean {
    SentenceInfo sentenceInfo;
    private long sequenceNumber = 0L;

    public SentenceJMX(DataStoreProviderInfo dsInfo, String name) {
        this.sentenceInfo = dsInfo.getSentenceInfo(name);
        this.sentenceInfo.sentenceJMX = this;
    }

    public static void CreateSentenceJMX(DataStoreProviderInfo dsInfo, String name) {
        try {
            MBeanUtils.createMBeanSentence(dsInfo, name);
        }
        catch (Exception e) {
            System.err.println("Cannot register Sentence MBean." + e.toString());
        }
    }

    @Override
    public long getCount() {
        return this.sentenceInfo.getSentenceCount();
    }

    @Override
    public String getSQLStatement() {
        return this.sentenceInfo.getSQLSentence();
    }

    @Override
    public Date getLastExecute() {
        return this.sentenceInfo.getTimeLastExecute();
    }

    @Override
    public long getTotalTime() {
        return this.sentenceInfo.getTotalTimeExecute();
    }

    @Override
    public float getAverageTime() {
        return this.sentenceInfo.getAverageTimeExecute();
    }

    @Override
    public long getWorstTime() {
        return this.sentenceInfo.getWorstTimeExecute();
    }

    @Override
    public long getBestTime() {
        return this.sentenceInfo.getBestTimeExecute();
    }

    @Override
    public long getBeforeNotificationWaitTime() {
        return this.sentenceInfo.getMaxTimeForNotification();
    }

    @Override
    public void setBeforeNotificationWaitTime(long value) {
        this.sentenceInfo.setMaxTimeForNotification(value);
    }

    @Override
    public boolean getNotificationEnabled() {
        return this.sentenceInfo.getEnableNotifications();
    }

    @Override
    public void setNotificationEnabled(boolean value) {
        this.sentenceInfo.setEnableNotifications(value);
    }

    public void SentencePoorPerformance() {
        Notification n = new Notification("com.genexus.performance.poorperformance", this, this.sequenceNumber++, System.currentTimeMillis(), "Poor performance in SQLStatement " + this.getSQLStatement());
        this.sendNotification(n);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"com.genexus.performance.poorperformance"};
        String name = Notification.class.getName();
        String description = "Sentence with poor performance";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, name, description);
        return new MBeanNotificationInfo[]{info};
    }
}

