/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.reports;

import com.genexus.Application;
import com.genexus.GXProcedure;
import com.genexus.ModelContext;
import com.genexus.Preferences;
import com.genexus.PrivateUtilities;
import com.genexus.ProcessInterruptedException;
import com.genexus.reports.GXReportMetadata;
import com.genexus.reports.GXReportPDFCommons;
import com.genexus.reports.GXReportViewerThreaded;
import com.genexus.reports.IReportHandler;
import com.genexus.reports.PDFReportItext2;
import com.genexus.reports.PDFReportItext8;
import com.genexus.reports.PDFReportPDFBox;
import com.genexus.webpanels.BlobsCleaner;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GXReport
extends GXProcedure {
    protected static final int OUTPUT_RVIEWER = 1;
    protected static final int OUTPUT_PDF = 2;
    protected GXReportMetadata reportMetadata;
    protected IReportHandler reportHandler;
    protected int lineHeight;
    protected int Gx_line;
    protected int P_lines;
    protected int gxXPage;
    protected int gxYPage;
    protected int Gx_page;
    protected String Gx_out = "";
    protected static Logger log = LogManager.getLogger(GXReport.class);

    public GXReport(int remoteHandle, ModelContext context, String location) {
        super(remoteHandle, context, location);
    }

    public GXReport(boolean inNewUTL, int remoteHandle, ModelContext context, String location) {
        super(inNewUTL, remoteHandle, context, location);
    }

    public static byte openGXReport(String document) {
        if (document.toLowerCase().endsWith(".pdf")) {
            try {
                GXReportPDFCommons.showReport(document, false);
            }
            catch (Exception e) {
                log.error("GXReport failed to open report " + document + " : ", (Throwable)e);
                return -1;
            }
        } else {
            GXReportViewerThreaded.GxOpenDoc(document);
        }
        return 0;
    }

    public String setPrintAtClient() {
        String blobPath = Preferences.getDefaultPreferences().getBLOB_PATH();
        String fileName = PrivateUtilities.getTempFileName(blobPath, "clientReport", this.getOutputType() == 2 ? "pdf" : "gxr");
        this.getPrinter().GxSetDocName(fileName);
        this.getPrinter().GxSetDocFormat("GXR");
        BlobsCleaner.getInstance().addBlobFile(fileName);
        return fileName;
    }

    public void setPrinter(IReportHandler reportHandler) {
        this.reportHandler = reportHandler;
    }

    public IReportHandler getPrinter() {
        if (this.reportHandler == null) {
            if (this.getOutputType() == 1) {
                this.reportHandler = new GXReportViewerThreaded();
            } else if (this.getOutputType() == 2) {
                try {
                    String implementation = Application.getClientContext().getClientPreferences().getPDF_RPT_LIBRARY();
                    this.reportHandler = implementation.equals("ITEXT") ? new PDFReportItext2(this.context) : (implementation.equals("ITEXT8") ? new PDFReportItext8(this.context) : new PDFReportPDFBox(this.context));
                    ((GXReportPDFCommons)this.reportHandler).setOutputStream(this.getOutputStream());
                }
                catch (Exception e) {
                    log.error("Failed to set output stream: ", (Throwable)e);
                }
            } else {
                throw new RuntimeException("Unrecognized report type: " + this.getOutputType());
            }
        }
        return this.reportHandler;
    }

    protected void GxEndPage() throws ProcessInterruptedException {
        if (this.reportHandler != null) {
            this.reportHandler.GxEndPage();
        }
    }

    protected boolean initTextPrinter(String output, int gxXPage, int gxYPage, String iniFile, String form, String printer, int mode, int nPaperLength, int nPaperWidth, int nGridX, int nGridY, int nPageLines) {
        int[] x = new int[]{gxXPage};
        int[] y = new int[]{gxYPage};
        this.getPrinter().GxRVSetLanguage(this.localUtil._language);
        boolean ret = this.getPrinter().GxPrTextInit(output, x, y, iniFile, form, printer, mode, nPaperLength, nPaperWidth, nGridX, nGridY, nPageLines);
        this.gxXPage = x[0];
        this.gxYPage = y[0];
        return ret;
    }

    protected boolean initPrinter(String output, int gxXPage, int gxYPage, String iniFile, String form, String printer, int mode, int orientation, int pageSize, int pageLength, int pageWidth, int scale, int copies, int defSrc, int quality, int color, int duplex) {
        int[] x = new int[]{gxXPage};
        int[] y = new int[]{gxYPage};
        this.getPrinter().GxRVSetLanguage(this.localUtil._language);
        boolean ret = this.getPrinter().GxPrintInit(output, x, y, iniFile, form, printer, mode, orientation, pageSize, pageLength, pageWidth, scale, copies, defSrc, quality, color, duplex);
        this.gxXPage = x[0];
        this.gxYPage = y[0];
        return ret;
    }

    protected void endPrinter() {
        try {
            this.getPrinter().GxEndPrinter();
            this.waitPrinterEnd();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void waitPrinterEnd() {
        if (this.reportHandler != null && this.Gx_out.equals("SCR") && this.reportHandler.getModal()) {
            while (this.reportHandler.GxIsAlive()) {
            }
        }
    }

    protected int getOutputType() {
        return 1;
    }

    protected OutputStream getOutputStream() {
        throw new RuntimeException("Output stream not set");
    }

    protected void loadReportMetadata(String name) {
        this.reportMetadata = new GXReportMetadata(name, this.getPrinter());
        this.reportMetadata.load();
    }

    protected int GxDrawDynamicGetPrintBlockHeight(int printBlock) {
        return this.reportMetadata.GxDrawGetPrintBlockHeight(printBlock);
    }

    protected void GxDrawDynamicText(int printBlock, int controlId, int Gx_line) {
        this.reportMetadata.GxDrawText(printBlock, controlId, Gx_line);
    }

    protected void GxDrawDynamicText(int printBlock, int controlId, String value, int Gx_line) {
        this.reportMetadata.GxDrawText(printBlock, controlId, Gx_line, value);
    }

    protected void GxDrawDynamicLine(int printBlock, int controlId, int Gx_line) {
        this.reportMetadata.GxDrawLine(printBlock, controlId, Gx_line);
    }

    protected void GxDrawDynamicRect(int printBlock, int controlId, int Gx_line) {
        this.reportMetadata.GxDrawRect(printBlock, controlId, Gx_line);
    }

    protected void GxDrawDynamicBitMap(int printBlock, int controlId, String value, int Gx_line) {
        this.reportMetadata.GxDrawBitMap(printBlock, controlId, Gx_line, value, 0);
    }

    protected void GxDrawDynamicBitMap(int printBlock, int controlId, String value, int aspectRatio, int Gx_line) {
        this.reportMetadata.GxDrawBitMap(printBlock, controlId, Gx_line, value, aspectRatio);
    }
}

