/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.reports;

import com.genexus.Application;
import com.genexus.ModelContext;
import com.genexus.internet.HttpContext;
import com.genexus.reports.IReportHandler;
import com.genexus.webpanels.HttpContextWeb;
import com.genexus.xml.XMLReader;
import java.util.Hashtable;

public class GXReportMetadata {
    private Hashtable<Integer, Object> hash = new Hashtable();
    private Hashtable<Integer, Attris> attriHash = new Hashtable();
    private String fileName;
    private IReportHandler reportHandler;

    public GXReportMetadata(String fileName, IReportHandler reportHandler) {
        HttpContext webContext;
        this.fileName = Application.getClientContext().getClientPreferences().getPRINT_LAYOUT_METADATA_DIR() + fileName + ".rpt";
        this.reportHandler = reportHandler;
        if (ModelContext.getModelContext() != null && (webContext = (HttpContext)ModelContext.getModelContext().getHttpContext()) != null && webContext instanceof HttpContextWeb) {
            this.fileName = ((HttpContextWeb)webContext).getRealPath(this.fileName);
        }
    }

    public void load() {
        XMLReader reader = new XMLReader();
        reader.open(this.fileName);
        if (reader.getErrCode() != 0) {
            System.out.println("ERROR1");
            System.err.println("Error opening metadata file: " + this.fileName);
            return;
        }
        while (reader.readType(1, "PrintBlock") > 0) {
            this.processPrintBlock(reader);
        }
        reader.close();
    }

    private void processPrintBlock(XMLReader reader) {
        short result = reader.read();
        result = reader.read();
        while (!(reader.getName().equals("PrintBlock") && reader.getNodeType() == 2 || result == 0)) {
            if (reader.getName().equals("ReportLabel") && reader.getNodeType() == 1 && reader.getIsSimple() == 0) {
                this.processReportLabel(reader, 0);
            }
            if (reader.getName().equals("ReportAttribute") && reader.getNodeType() == 1 && reader.getIsSimple() == 0) {
                this.processReportLabel(reader, 1);
            }
            if (reader.getName().equals("ReportLine") && reader.getNodeType() == 1 && reader.getIsSimple() == 0) {
                this.processReportLine(reader);
            }
            if (reader.getName().equals("ReportRectangle") && reader.getNodeType() == 1 && reader.getIsSimple() == 0) {
                this.processReportRectangle(reader);
            }
            if (reader.getName().equals("ReportImage") && reader.getNodeType() == 1 && reader.getIsSimple() == 0) {
                this.processReportImage(reader);
            }
            if (reader.getName().equals("Properties") && reader.getNodeType() == 1 && reader.getIsSimple() == 0) {
                this.processProperties(reader);
            }
            result = reader.read();
        }
    }

    private void processReportLabel(XMLReader reader, int type) {
        int defaultWidth;
        int htmlformat = 0;
        int border = 0;
        int backMode = 1;
        short result = reader.readType(1, "RPT_ID");
        Integer key = new Integer(reader.getValue());
        result = reader.readType(1, "RPT_VISIBLE");
        boolean visible = reader.getValue().equals("True");
        result = reader.readType(1, "RPT_TEXT");
        String sTxt = reader.getValue();
        result = reader.readType(1, "RPT_X");
        int left = new Integer(reader.getValue());
        result = reader.readType(1, "RPT_Y");
        int top = new Integer(reader.getValue());
        result = reader.readType(1, "RPT_WIDTH");
        int width = new Integer(reader.getValue());
        int right = left + width;
        if (type == 0) {
            defaultWidth = width;
        } else {
            result = reader.readType(1, "RPT_WIDTH_Default");
            defaultWidth = new Integer(reader.getValue());
        }
        result = reader.readType(1, "RPT_HEIGHT");
        int bottom = top + new Integer(reader.getValue());
        result = reader.readType(1, "RPT_FORECOLOR");
        RGB foreColor = this.parseRGB(reader.getValue());
        result = reader.readType(1, "RPT_BACKCOLOR");
        RGB backColor = this.parseRGB(reader.getValue());
        if (reader.getValue().equals("Transparent, ARGB(0,255,255,255)")) {
            backMode = 0;
        }
        result = reader.readType(1, "RPT_BORDERS");
        border = reader.getValue().equals("None") ? 0 : 1;
        result = reader.readType(1, "RPT_ALIGNMENT");
        String aligment = reader.getValue();
        int valign = this.parseVerticalAlignment(aligment);
        result = reader.readType(1, "RPT_FONT");
        String fontInfo = reader.getValue();
        if (type == 1 && (result = reader.readType(1, "GxFormat")) > 0 && reader.getValue().indexOf("HTML") >= 0) {
            htmlformat = 1;
        }
        result = reader.readType(1, "RPT_WORDWRAP");
        boolean wordwrap = reader.getValue().equals("True");
        int align = this.parseAlignment(aligment, wordwrap, width, defaultWidth);
        this.parseAttris(key, fontInfo, foreColor, backMode, backColor);
        if (visible) {
            DrawText dt;
            if (type == 0) {
                result = reader.readType(2, "ReportLabel");
                dt = new DrawText(sTxt, left, top, right, bottom, align, valign, htmlformat, border);
            } else {
                result = reader.readType(2, "ReportAttribute");
                dt = new DrawText(null, left, top, right, bottom, align, valign, htmlformat, border);
            }
            this.hash.put(key, dt);
        }
    }

    private void processReportLine(XMLReader reader) {
        short result = reader.readType(1, "RPT_ID");
        Integer key = new Integer(reader.getValue());
        result = reader.readType(1, "RPT_VISIBLE");
        boolean visible = reader.getValue().equals("True");
        result = reader.readType(1, "RPT_X");
        int left = new Integer(reader.getValue());
        result = reader.readType(1, "RPT_Y");
        int top = new Integer(reader.getValue());
        result = reader.readType(1, "RPT_WIDTH");
        int right = new Integer(reader.getValue());
        result = reader.readType(1, "RPT_HEIGHT");
        int bottom = new Integer(reader.getValue());
        result = reader.readType(1, "RPT_FORECOLOR");
        RGB rgb = this.parseRGB(reader.getValue());
        result = reader.readType(1, "RPT_LINEDIRECTION");
        if (reader.getValue().equals("Horizontal")) {
            right = left + right;
            bottom = top;
        } else {
            right = left;
            bottom = top + bottom;
        }
        result = reader.readType(1, "RPT_LINEWIDTH");
        int widht = new Integer(reader.getValue());
        result = reader.readType(2, "ReportLine");
        if (visible) {
            DrawLine dl = new DrawLine(left, top, right, bottom, widht, rgb.getRed(), rgb.getGreen(), rgb.getBlue(), 0);
            this.hash.put(key, dl);
        }
    }

    private void processReportRectangle(XMLReader reader) {
        int backMode = 1;
        short result = reader.readType(1, "RPT_ID");
        Integer key = new Integer(reader.getValue());
        result = reader.readType(1, "RPT_VISIBLE");
        boolean visible = reader.getValue().equals("True");
        result = reader.readType(1, "RPT_X");
        int left = new Integer(reader.getValue());
        result = reader.readType(1, "RPT_Y");
        int top = new Integer(reader.getValue());
        result = reader.readType(1, "RPT_WIDTH");
        int right = left + new Integer(reader.getValue());
        result = reader.readType(1, "RPT_HEIGHT");
        int bottom = top + new Integer(reader.getValue());
        result = reader.readType(1, "RPT_BACKCOLOR");
        if (reader.getValue().equals("Transparent, ARGB(0,255,255,255)")) {
            backMode = 0;
        }
        RGB BackRgb = this.parseRGB(reader.getValue());
        result = reader.readType(1, "RPT_BORDERWIDTH");
        int pen = new Integer(reader.getValue());
        result = reader.readType(1, "RPT_BORDERCOLOR");
        RGB ForeRgb = this.parseRGB(reader.getValue());
        result = reader.readType(2, "ReportRectangle");
        if (visible) {
            DrawRect dr = new DrawRect(left, top, right, bottom, pen, ForeRgb.getRed(), ForeRgb.getGreen(), ForeRgb.getBlue(), backMode, BackRgb.getRed(), BackRgb.getGreen(), BackRgb.getBlue(), 0, 0, 0, 0, 0, 0, 0, 0);
            this.hash.put(key, dr);
        }
    }

    private void processReportImage(XMLReader reader) {
        short result = reader.readType(1, "RPT_ID");
        Integer key = new Integer(reader.getValue());
        result = reader.readType(1, "RPT_VISIBLE");
        boolean visible = reader.getValue().equals("True");
        result = reader.readType(1, "RPT_X");
        int left = new Integer(reader.getValue());
        result = reader.readType(1, "RPT_Y");
        int top = new Integer(reader.getValue());
        result = reader.readType(1, "RPT_WIDTH");
        int right = left + new Integer(reader.getValue());
        result = reader.readType(1, "RPT_HEIGHT");
        int bottom = top + new Integer(reader.getValue());
        result = reader.readType(2, "ReportImage");
        if (visible) {
            DrawText dt = new DrawText(null, left, top, right, bottom, 0, 0);
            this.hash.put(key, dt);
        }
    }

    private void processProperties(XMLReader reader) {
        short result = reader.readType(1, "RPT_ID");
        Integer key = new Integer(reader.getValue());
        result = reader.readType(1, "RPT_VISIBLE");
        boolean visible = reader.getValue().equals("True");
        result = reader.readType(1, "RPT_HEIGHT");
        int height = new Integer(reader.getValue());
        if (visible) {
            PrintblockProperties dt = new PrintblockProperties(height);
            this.hash.put(key, dt);
        }
    }

    private int parseAlignment(String txt, boolean wordwrap, int width, int defaultWidth) {
        if (txt.endsWith("Right")) {
            if (wordwrap) {
                return 18;
            }
            if (width != defaultWidth) {
                return 2;
            }
            return 258;
        }
        if (txt.endsWith("Center")) {
            if (wordwrap) {
                return 17;
            }
            if (width != defaultWidth) {
                return 1;
            }
            return 257;
        }
        if (txt.endsWith("Justify")) {
            if (wordwrap) {
                return 19;
            }
            if (width != defaultWidth) {
                return 3;
            }
            return 259;
        }
        if (wordwrap) {
            return 16;
        }
        if (width != defaultWidth) {
            return 0;
        }
        return 256;
    }

    private int parseVerticalAlignment(String txt) {
        if (txt.startsWith("Top")) {
            return 0;
        }
        if (txt.startsWith("Middle")) {
            return 1;
        }
        return 2;
    }

    private RGB parseRGB(String txt) {
        String[] txts = txt.substring(0, txt.length() - 1).split(",");
        RGB rgb = new RGB(new Integer(txts[2]), new Integer(txts[3]), new Integer(txts[4]));
        return rgb;
    }

    private void parseAttris(Integer key, String fontInfo, RGB foreColor, int backMode, RGB backColor) {
        boolean fontBold = false;
        boolean fontItalic = false;
        boolean fontUnderline = false;
        boolean fontStrikethru = false;
        String[] fontInfos = fontInfo.split(",", 3);
        String fontName = fontInfos[0];
        float aux = Float.parseFloat(fontInfos[1].trim().replace("pt", ""));
        int fontSize = Math.round(aux);
        if (fontInfos.length > 2) {
            if (fontInfos[2].indexOf("Bold") != -1) {
                fontBold = true;
            }
            if (fontInfos[2].indexOf("Italic") != -1) {
                fontItalic = true;
            }
            if (fontInfos[2].indexOf("Underline") != -1) {
                fontUnderline = true;
            }
            if (fontInfos[2].indexOf("Strikeout") != -1) {
                fontStrikethru = true;
            }
        }
        Attris atts = new Attris(fontName, fontSize, fontBold, fontItalic, fontUnderline, fontStrikethru, 0, foreColor, backMode, backColor);
        this.attriHash.put(key, atts);
    }

    public void GxDrawText(int printBlock, int controlId, int Gx_line) {
        DrawText dt;
        Integer key = new Integer(controlId);
        Attris att = this.attriHash.get(key);
        if (att != null) {
            this.reportHandler.GxAttris(att.fontName, att.fontSize, att.fontBold, att.fontItalic, att.fontUnderline, att.fontStrikethru, 0, att.foreColor.getRed(), att.foreColor.getGreen(), att.foreColor.getBlue(), att.backMode, att.backColor.getRed(), att.backColor.getGreen(), att.backColor.getBlue());
        }
        if ((dt = (DrawText)this.hash.get(key)) != null) {
            this.reportHandler.GxDrawText(dt.sTxt, dt.left, Gx_line + dt.top, dt.right, Gx_line + dt.bottom, dt.align, dt.htmlformat, dt.border, dt.valign);
        }
    }

    public void GxDrawText(int printBlock, int controlId, int Gx_line, String value) {
        DrawText dt;
        Integer key = new Integer(controlId);
        Attris att = this.attriHash.get(key);
        if (att != null) {
            this.reportHandler.GxAttris(att.fontName, att.fontSize, att.fontBold, att.fontItalic, att.fontUnderline, att.fontStrikethru, 0, att.foreColor.getRed(), att.foreColor.getGreen(), att.foreColor.getBlue(), att.backMode, att.backColor.getRed(), att.backColor.getGreen(), att.backColor.getBlue());
        }
        if ((dt = (DrawText)this.hash.get(key)) != null) {
            this.reportHandler.GxDrawText(value, dt.left, Gx_line + dt.top, dt.right, Gx_line + dt.bottom, dt.align, dt.htmlformat, dt.border, dt.valign);
        }
    }

    public void GxDrawLine(int printBlock, int controlId, int Gx_line) {
        Integer key = new Integer(controlId);
        DrawLine dl = (DrawLine)this.hash.get(key);
        if (dl != null) {
            this.reportHandler.GxDrawLine(dl.left, Gx_line + dl.top, dl.right, Gx_line + dl.bottom, dl.widht, dl.foreRed, dl.foreGreen, dl.foreBlue, dl.style);
        }
    }

    public void GxDrawRect(int printBlock, int controlId, int Gx_line) {
        Integer key = new Integer(controlId);
        DrawRect dr = (DrawRect)this.hash.get(key);
        if (dr != null) {
            this.reportHandler.GxDrawRect(dr.left, Gx_line + dr.top, dr.right, Gx_line + dr.bottom, dr.pen, dr.foreRed, dr.foreGreen, dr.foreBlue, dr.backMode, dr.backRed, dr.backGreen, dr.backBlue, dr.styleTop, dr.styleBottom, dr.styleRight, dr.styleLeft, dr.cornerRadioTL, dr.cornerRadioTR, dr.cornerRadioBL, dr.cornerRadioBR);
        }
    }

    public void GxDrawBitMap(int printBlock, int controlId, int Gx_line, String value, int aspectRatio) {
        Integer key = new Integer(controlId);
        DrawText db = (DrawText)this.hash.get(key);
        if (db != null) {
            this.reportHandler.GxDrawBitMap(value, db.left, Gx_line + db.top, db.right, Gx_line + db.bottom, aspectRatio);
        }
    }

    public int GxDrawGetPrintBlockHeight(int printBlock) {
        Integer key = new Integer(printBlock);
        PrintblockProperties db = (PrintblockProperties)this.hash.get(key);
        return db.height;
    }

    class PrintblockProperties {
        int height;

        public PrintblockProperties(int height) {
            this.height = height;
        }
    }

    class Attris {
        String fontName;
        int fontSize;
        boolean fontBold;
        boolean fontItalic;
        boolean fontUnderline;
        boolean fontStrikethru;
        int Pen;
        RGB foreColor;
        int backMode;
        RGB backColor;

        public Attris(String fontName, int fontSize, boolean fontBold, boolean fontItalic, boolean fontUnderline, boolean fontStrikethru, int Pen, RGB foreColor, int backMode, RGB backColor) {
            this.fontName = fontName;
            this.fontSize = fontSize;
            this.fontBold = fontBold;
            this.fontItalic = fontItalic;
            this.fontUnderline = fontUnderline;
            this.fontStrikethru = fontStrikethru;
            this.Pen = Pen;
            this.foreColor = foreColor;
            this.backMode = backMode;
            this.backColor = backColor;
        }
    }

    class RGB {
        int foreRed;
        int foreGreen;
        int foreBlue;

        public RGB(int foreRed, int foreGreen, int foreBlue) {
            this.foreRed = foreRed;
            this.foreGreen = foreGreen;
            this.foreBlue = foreBlue;
        }

        public int getRed() {
            return this.foreRed;
        }

        public int getGreen() {
            return this.foreGreen;
        }

        public int getBlue() {
            return this.foreBlue;
        }
    }

    class DrawBitMap {
        int left;
        int top;
        int right;
        int bottom;

        public DrawBitMap(int left, int top, int right, int bottom) {
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }
    }

    class DrawRect {
        int left;
        int top;
        int right;
        int bottom;
        int pen;
        int foreRed;
        int foreGreen;
        int foreBlue;
        int backMode;
        int backRed;
        int backGreen;
        int backBlue;
        int styleTop;
        int styleBottom;
        int styleRight;
        int styleLeft;
        int cornerRadioTL;
        int cornerRadioTR;
        int cornerRadioBL;
        int cornerRadioBR;

        public DrawRect(int left, int top, int right, int bottom, int pen, int foreRed, int foreGreen, int foreBlue, int backMode, int backRed, int backGreen, int backBlue, int styleTop, int styleBottom, int styleRight, int styleLeft, int cornerRadioTL, int cornerRadioTR, int cornerRadioBL, int cornerRadioBR) {
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.pen = pen;
            this.foreRed = foreRed;
            this.foreGreen = foreGreen;
            this.foreBlue = foreBlue;
            this.backMode = backMode;
            this.backRed = backRed;
            this.backGreen = backGreen;
            this.backBlue = backBlue;
            this.styleTop = styleTop;
            this.styleBottom = styleBottom;
            this.styleRight = styleRight;
            this.styleLeft = styleLeft;
            this.cornerRadioTL = cornerRadioTL;
            this.cornerRadioTR = cornerRadioTR;
            this.cornerRadioBL = cornerRadioBL;
            this.cornerRadioBR = cornerRadioBR;
        }
    }

    class DrawLine {
        int left;
        int top;
        int right;
        int bottom;
        int widht;
        int foreRed;
        int foreGreen;
        int foreBlue;
        int style;

        public DrawLine(int left, int top, int right, int bottom, int widht, int foreRed, int foreGreen, int foreBlue, int style) {
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.widht = widht;
            this.foreRed = foreRed;
            this.foreGreen = foreGreen;
            this.foreBlue = foreBlue;
            this.style = style;
        }
    }

    class DrawText {
        String sTxt;
        int left;
        int top;
        int right;
        int bottom;
        int align;
        int valign;
        int htmlformat;
        int border;

        public DrawText(String sTxt, int left, int top, int right, int bottom, int align, int valign, int htmlformat, int border) {
            this.border = border;
            this.htmlformat = htmlformat;
            this.sTxt = sTxt;
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.align = align;
            this.valign = valign;
        }

        public DrawText(String sTxt, int left, int top, int right, int bottom, int align, int valign) {
            this.sTxt = sTxt;
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.align = align;
            this.valign = valign;
        }
    }
}

