/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.reports;

import com.genexus.ModelContext;
import com.genexus.internet.HttpContext;
import com.genexus.platform.INativeFunctions;
import com.genexus.platform.NativeFunctions;
import com.genexus.reports.Const;
import com.genexus.reports.IReportHandler;
import com.genexus.reports.ParseINI;
import com.genexus.reports.fonts.Utilities;
import com.genexus.util.NullOutputStream;
import com.genexus.util.TemporaryFiles;
import com.genexus.webpanels.HttpContextWeb;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.logging.log4j.Logger;

public abstract class GXReportPDFCommons
implements IReportHandler {
    protected int lineHeight;
    protected int pageLines;
    protected boolean fontUnderline;
    protected boolean fontStrikethru;
    protected int fontSize;
    protected boolean fontBold = false;
    protected boolean fontItalic = false;
    protected Color backColor;
    protected Color foreColor;
    protected OutputStream outputStream = null;
    protected static ParseINI props = new ParseINI();
    protected ParseINI printerSettings;
    protected String form;
    protected Vector stringTotalPages;
    protected int outputType = -1;
    protected int printerOutputMode = -1;
    protected boolean modal = false;
    protected String docName = "PDFReport.pdf";
    protected static INativeFunctions nativeCode = NativeFunctions.getInstance();
    protected static Hashtable<String, String> fontSubstitutes = new Hashtable();
    protected static String configurationFile = null;
    protected static String configurationTemplateFile = null;
    protected static String defaultRelativePrepend = null;
    protected static String defaultRelativePrependINI = null;
    protected static String webAppDir = null;
    private static String predefinedSearchPath = "";
    protected float leftMargin;
    protected float topMargin;
    protected float bottomMargin;
    protected int templateFontSize;
    protected boolean backFill = true;
    protected Color templateColorFill;
    protected int pages = 0;
    protected boolean templateCreated = false;
    public static float DASHES_UNITS_ON = 10.0f;
    public static float DASHES_UNITS_OFF = 10.0f;
    public static float DOTS_UNITS_OFF = 3.0f;
    public static float DOTS_UNITS_ON = 1.0f;
    public boolean lineCapProjectingSquare = true;
    public boolean barcode128AsImage = true;
    public int justifiedType;
    protected HttpContext httpContext = null;
    protected static boolean firstTime = true;
    float[] STYLE_SOLID = new float[]{1.0f, 0.0f};
    float[] STYLE_NONE = null;
    float[] STYLE_DOTTED;
    float[] STYLE_DASHED;
    float[] STYLE_LONG_DASHED;
    float[] STYLE_LONG_DOT_DASHED;
    int STYLE_NONE_CONST = 1;
    protected static char alternateSeparator = (char)(File.separatorChar == '/' ? 92 : 47);
    protected static Logger log;
    public static final double PAGE_SCALE_Y = 20.0;
    public static final double PAGE_SCALE_X = 20.0;
    public static final double GX_PAGE_SCALE_Y_OLD = 15.45;
    public static final double GX_PAGE_SCALE_Y = 14.4;
    protected static double TO_CM_SCALE;
    protected int M_top;
    protected int M_bot;
    protected int page;
    public static final double SCALE_FACTOR = 72.0;
    protected double PPP = 96.0;

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    protected static String getAcrobatLocation() throws Exception {
        ParseINI props;
        try {
            props = new ParseINI("PDFReport.ini");
            if (new File("PDFReport.ini").length() == 0L) {
                new File("PDFReport.ini").delete();
            }
        }
        catch (IOException e) {
            props = new ParseINI();
        }
        String acrobatLocation = props.getGeneralProperty("Acrobat Location");
        if (acrobatLocation == null && NativeFunctions.isUnix()) {
            throw new Exception("Try setting Acrobat location & executable in property 'Acrobat Location' of PDFReport.ini");
        }
        return acrobatLocation;
    }

    public static void printReport(String pdfFilename, boolean silent) throws Exception {
        if (NativeFunctions.isWindows()) {
            pdfFilename = "\"" + new File(pdfFilename).getAbsolutePath() + "\"";
        }
        String[] cmd = new String[]{};
        String acrobatLocation = null;
        try {
            acrobatLocation = GXReportPDFCommons.getAcrobatLocation();
        }
        catch (Exception acrobatNotFound) {
            throw new Exception("Acrobat cannot be found in this machine: " + acrobatNotFound.getMessage());
        }
        nativeCode.executeModal(acrobatLocation + " -toPostScript " + pdfFilename, false);
        int pos = pdfFilename.lastIndexOf(".");
        pdfFilename = pdfFilename.substring(0, pos) + ".ps";
        cmd = new String[]{"lp", pdfFilename};
        Runtime.getRuntime().exec(cmd);
    }

    public static void showReport(String filename, boolean modal) throws Exception {
        String acrobatLocation;
        if (NativeFunctions.isWindows()) {
            filename = "\"" + new File(filename).getAbsolutePath() + "\"";
        }
        try {
            acrobatLocation = GXReportPDFCommons.getAcrobatLocation();
        }
        catch (Exception acrobatNotFound) {
            throw new Exception("Acrobat cannot be found in this machine: " + acrobatNotFound.getMessage());
        }
        if (modal) {
            nativeCode.executeModal(acrobatLocation + " " + filename, true);
        } else {
            Runtime.getRuntime().exec(new String[]{acrobatLocation, filename});
        }
    }

    public GXReportPDFCommons(ModelContext context) {
        this.stringTotalPages = new Vector();
        this.httpContext = (HttpContext)context.getHttpContext();
        if (defaultRelativePrepend == null) {
            String staticContentBase;
            defaultRelativePrepend = this.httpContext.getDefaultPath();
            defaultRelativePrepend = defaultRelativePrepend == null || defaultRelativePrepend.trim().equals("") ? "" : defaultRelativePrepend.replace(alternateSeparator, File.separatorChar) + File.separatorChar;
            defaultRelativePrependINI = defaultRelativePrepend;
            if (new File(defaultRelativePrepend + "WEB-INF").isDirectory()) {
                configurationFile = defaultRelativePrepend + "WEB-INF" + File.separatorChar + "PDFReport.ini";
                configurationTemplateFile = defaultRelativePrepend + "WEB-INF" + File.separatorChar + "PDFReport.template";
            } else {
                configurationFile = defaultRelativePrepend + "PDFReport.ini";
                configurationTemplateFile = defaultRelativePrepend + "PDFReport.template";
            }
            webAppDir = defaultRelativePrepend;
            if ((this.httpContext instanceof HttpContextWeb || !this.httpContext.getDefaultPath().isEmpty()) && (staticContentBase = this.httpContext.getStaticContentBase()) != null && (staticContentBase = staticContentBase.trim()).indexOf(58) == -1) {
                if ((staticContentBase = staticContentBase.replace(alternateSeparator, File.separatorChar)).startsWith(File.separator)) {
                    staticContentBase = staticContentBase.substring(1);
                }
                if (!staticContentBase.equals("") && !(defaultRelativePrepend = defaultRelativePrepend + staticContentBase).endsWith(File.separator)) {
                    defaultRelativePrepend = defaultRelativePrepend + File.separator;
                }
            }
        }
        if (firstTime) {
            this.loadProps();
            firstTime = false;
        }
    }

    protected void loadPrinterSettingsProps(String iniFile, String form, String printer, int mode, int orientation, int pageSize, int pageLength, int pageWidth, int scale, int copies, int defSrc, int quality, int color, int duplex) {
        iniFile = new File(defaultRelativePrependINI + "WEB-INF").isDirectory() ? defaultRelativePrependINI + "WEB-INF" + File.separatorChar + iniFile : defaultRelativePrependINI + iniFile;
        try {
            this.form = form;
            this.printerSettings = new ParseINI(iniFile);
        }
        catch (IOException e) {
            this.printerSettings = new ParseINI();
        }
        mode = mode == 2 ? 3 : 0;
        this.printerSettings.setupProperty(form, "Printer", printer);
        this.printerSettings.setupProperty(form, "Mode", mode + "");
        this.printerSettings.setupProperty(form, "Orientation", orientation + "");
        this.printerSettings.setupProperty(form, "PaperSize", pageSize + "");
        this.printerSettings.setupProperty(form, "PaperLength", pageLength + "");
        this.printerSettings.setupProperty(form, "PaperWidth", pageWidth + "");
        this.printerSettings.setupProperty(form, "Scale", scale + "");
        this.printerSettings.setupProperty(form, "Copies", copies + "");
        this.printerSettings.setupProperty(form, "DefaultSource", defSrc + "");
        this.printerSettings.setupProperty(form, "PrintQuality", quality + "");
        this.printerSettings.setupProperty(form, "Color", color + "");
        this.printerSettings.setupProperty(form, "Duplex", duplex + "");
    }

    protected void loadProps() {
        try {
            props = new ParseINI(configurationFile, configurationTemplateFile);
        }
        catch (IOException e) {
            props = new ParseINI();
        }
        props.setupGeneralProperty("Version", "1.0.0.0");
        props.setupGeneralProperty("Embeed Fonts", "false");
        props.setupGeneralProperty("EmbeedNotSpecifiedFonts", "false");
        props.setupGeneralProperty("SearchNewFonts", "false");
        props.setupGeneralProperty("SearchNewFontsOnce", "true");
        props.setupGeneralProperty("ServerPrinting", "false");
        props.setupGeneralProperty("AdjustToPaper", "true");
        props.setupGeneralProperty("LineCapProjectingSquare", "true");
        props.setupGeneralProperty("Barcode128AsImage", "true");
        props.setupGeneralProperty("DEBUG", "false");
        props.setupGeneralProperty("LeftMargin", "0.75");
        props.setupGeneralProperty("TopMargin", "0.75");
        props.setupGeneralProperty("MarginsInsideBorder", "false");
        props.setupGeneralProperty("BottomMargin", "6");
        props.setupGeneralProperty("OutputFileDirectory", ".");
        props.setupGeneralProperty("Leading", "2");
        props.setupGeneralProperty("RunDirection", "2");
        props.setupGeneralProperty("JustifiedTypeAll", "false");
        props.setupGeneralProperty("DottedStyle", "1;2");
        props.setupGeneralProperty("DashedStyle", "4;2");
        props.setupGeneralProperty("LongDashedStyle", "6;2");
        props.setupGeneralProperty("LongDotDashedStyle", "6;2;1;2");
        this.loadSubstituteTable();
        Utilities.addPredefinedSearchPaths(new String[]{System.getProperty("java.awt.fonts", "c:\\windows\\fonts"), System.getProperty("com.ms.windir", "c:\\windows") + "\\fonts"});
    }

    public static final void addPredefinedSearchPaths(String[] predefinedPaths) {
        String predefinedPath = "";
        for (int i = 0; i < predefinedPaths.length; ++i) {
            predefinedPath = predefinedPath + predefinedPaths[i] + ";";
        }
        predefinedSearchPath = predefinedPath + predefinedSearchPath;
    }

    public static final String getPredefinedSearchPaths() {
        return predefinedSearchPath;
    }

    protected abstract void init();

    public void GxRVSetLanguage(String lang) {
    }

    public void GxSetTextMode(int nHandle, int nGridX, int nGridY, int nPageLength) {
    }

    protected float[] parsePattern(String patternStr) {
        StringTokenizer st;
        int length;
        if (patternStr != null && (length = (st = new StringTokenizer(patternStr.trim(), ";")).countTokens()) > 0) {
            int i = 0;
            float[] pattern = new float[length];
            while (st.hasMoreTokens()) {
                pattern[i] = Float.parseFloat(st.nextToken());
                ++i;
            }
            return pattern;
        }
        return null;
    }

    protected float[] getDashedPattern(int style) {
        switch (style) {
            case 0: {
                return this.STYLE_SOLID;
            }
            case 1: {
                return this.STYLE_NONE;
            }
            case 2: {
                return this.STYLE_DOTTED;
            }
            case 3: {
                return this.STYLE_DASHED;
            }
            case 4: {
                return this.STYLE_LONG_DASHED;
            }
            case 5: {
                return this.STYLE_LONG_DOT_DASHED;
            }
        }
        return this.STYLE_SOLID;
    }

    public void GxDrawRect(int left, int top, int right, int bottom, int pen, int foreRed, int foreGreen, int foreBlue, int backMode, int backRed, int backGreen, int backBlue) {
        this.GxDrawRect(left, top, right, bottom, pen, foreRed, foreGreen, foreBlue, backMode, backRed, backGreen, backBlue, 0, 0);
    }

    public void GxDrawRect(int left, int top, int right, int bottom, int pen, int foreRed, int foreGreen, int foreBlue, int backMode, int backRed, int backGreen, int backBlue, int style, int cornerRadius) {
        this.GxDrawRect(left, top, right, bottom, pen, foreRed, foreGreen, foreBlue, backMode, backRed, backGreen, backBlue, style, style, style, style, cornerRadius, cornerRadius, cornerRadius, cornerRadius);
    }

    public abstract void GxDrawRect(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18, int var19, int var20);

    public void GxDrawLine(int left, int top, int right, int bottom, int width, int foreRed, int foreGreen, int foreBlue) {
        this.GxDrawLine(left, top, right, bottom, width, foreRed, foreGreen, foreBlue, 0);
    }

    public abstract void GxDrawLine(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public void GxDrawBitMap(String bitmap, int left, int top, int right, int bottom) {
        this.GxDrawBitMap(bitmap, left, top, right, bottom, 0);
    }

    public abstract void GxDrawBitMap(String var1, int var2, int var3, int var4, int var5, int var6);

    public String getSubstitute(String fontName) {
        Vector<String> fontSubstitutesProcessed = new Vector<String>();
        String newFontName = fontName;
        while (fontSubstitutes.containsKey(newFontName)) {
            if (!fontSubstitutesProcessed.contains(newFontName)) {
                fontSubstitutesProcessed.addElement(newFontName);
                newFontName = fontSubstitutes.get(newFontName);
                continue;
            }
            return fontSubstitutes.get(newFontName);
        }
        return newFontName;
    }

    public abstract void GxAttris(String var1, int var2, boolean var3, boolean var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    protected String getFontLocation(String fontName) {
        String fontPath = props.getProperty("Fonts Location (MS)", fontName, "");
        if (fontPath.equals("")) {
            fontPath = props.getProperty("Fonts Location (Sun)", fontName, "");
        }
        return fontPath;
    }

    protected Hashtable getFontLocations() {
        Object key;
        Enumeration e;
        Hashtable msLocations = props.getSection("Fonts Location (MS)");
        Hashtable sunLocations = props.getSection("Fonts Location (Sun)");
        Hashtable locations = new Hashtable();
        if (msLocations != null) {
            e = msLocations.keys();
            while (e.hasMoreElements()) {
                key = e.nextElement();
                locations.put(key, msLocations.get(key));
            }
        }
        if (sunLocations != null) {
            e = sunLocations.keys();
            while (e.hasMoreElements()) {
                key = e.nextElement();
                locations.put(key, sunLocations.get(key));
            }
        }
        return locations;
    }

    protected boolean isEmbeddedFont(String realFontName) {
        boolean generalEmbeedFont = props.getBooleanGeneralProperty("Embeed Fonts", false);
        boolean generalEmbeedNotSpecified = props.getBooleanGeneralProperty("EmbeedNotSpecifiedFonts", false);
        return generalEmbeedFont && props.getBooleanProperty("Embeed Fonts", realFontName, generalEmbeedNotSpecified);
    }

    public abstract void setAsianFont(String var1, String var2);

    public void GxDrawText(String sTxt, int left, int top, int right, int bottom, int align) {
        this.GxDrawText(sTxt, left, top, right, bottom, align, 0);
    }

    public void GxDrawText(String sTxt, int left, int top, int right, int bottom, int align, int htmlformat) {
        this.GxDrawText(sTxt, left, top, right, bottom, align, htmlformat, 0);
    }

    public void GxDrawText(String sTxt, int left, int top, int right, int bottom, int align, int htmlformat, int border) {
        this.GxDrawText(sTxt, left, top, right, bottom, align, htmlformat, border, 0);
    }

    public abstract void GxDrawText(String var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    boolean pageHeightExceeded(float bottomAux, float drawingPageHeight) {
        return bottomAux > drawingPageHeight;
    }

    public void GxClearAttris() {
    }

    private boolean preGxPrintInit(String output, int[] gxXPage, int[] gxYPage, String iniFile, String form, String printer, int mode, int orientation, int pageSize, int pageLength, int pageWidth, int scale, int copies, int defSrc, int quality, int color, int duplex) {
        try {
            this.PPP = gxYPage[0];
            this.loadPrinterSettingsProps(iniFile, form, printer, mode, orientation, pageSize, pageLength, pageWidth, scale, copies, defSrc, quality, color, duplex);
            if (this.outputStream != null) {
                this.outputType = output.equalsIgnoreCase("PRN") ? 4 : 3;
            } else {
                this.outputType = output.equalsIgnoreCase("SCR") ? 0 : (output.equalsIgnoreCase("PRN") ? 1 : 2);
                if (this.outputType == 2) {
                    TemporaryFiles.getInstance().removeFileFromList(this.docName);
                } else {
                    String tempPrefix = this.docName;
                    String tempExtension = "pdf";
                    int tempIndex = this.docName.lastIndexOf(46);
                    if (tempIndex != -1) {
                        tempPrefix = this.docName.substring(0, tempIndex);
                        tempExtension = (this.docName + " ").substring(tempIndex + 1).trim();
                    }
                    this.docName = TemporaryFiles.getInstance().getTemporaryFile(tempPrefix, tempExtension);
                }
                try {
                    this.setOutputStream(new FileOutputStream(this.docName));
                }
                catch (IOException accessError) {
                    log.error("preGxPrintInit: failed to set output stream", (Throwable)accessError);
                    this.outputStream = new NullOutputStream();
                    this.outputType = 2;
                }
            }
            this.printerOutputMode = mode;
            boolean ret = props.setupGeneralProperty("LeftMargin", "0.75");
            ret = props.setupGeneralProperty("TopMargin", "0.75");
            ret = props.setupGeneralProperty("BottomMargin", "6");
            this.leftMargin = (float)(TO_CM_SCALE * Double.valueOf(props.getGeneralProperty("LeftMargin")));
            this.topMargin = (float)(TO_CM_SCALE * Double.valueOf(props.getGeneralProperty("TopMargin")));
            this.bottomMargin = (float)Double.valueOf(props.getGeneralProperty("BottomMargin")).doubleValue();
            this.lineCapProjectingSquare = props.getGeneralProperty("LineCapProjectingSquare").equals("true");
            this.barcode128AsImage = props.getGeneralProperty("Barcode128AsImage").equals("true");
            this.STYLE_DOTTED = this.parsePattern(props.getGeneralProperty("DottedStyle"));
            this.STYLE_DASHED = this.parsePattern(props.getGeneralProperty("DashedStyle"));
            this.STYLE_LONG_DASHED = this.parsePattern(props.getGeneralProperty("LongDashedStyle"));
            this.STYLE_LONG_DOT_DASHED = this.parsePattern(props.getGeneralProperty("LongDotDashedStyle"));
            return true;
        }
        catch (Exception e) {
            log.error("preGxPrintInit failed", (Throwable)e);
            return false;
        }
    }

    public boolean GxPrintInit(String output, int[] gxXPage, int[] gxYPage, String iniFile, String form, String printer, int mode, int orientation, int pageSize, int pageLength, int pageWidth, int scale, int copies, int defSrc, int quality, int color, int duplex) {
        return this.preGxPrintInit(output, gxXPage, gxYPage, iniFile, form, printer, mode, orientation, pageSize, pageLength, pageWidth, scale, copies, defSrc, quality, color, duplex);
    }

    public int getPageLines() {
        log.debug("getPageLines: --> " + this.pageLines);
        return this.pageLines;
    }

    public int getLineHeight() {
        log.debug("getLineHeight: --> " + this.lineHeight);
        return this.lineHeight;
    }

    public void setPageLines(int P_lines) {
        log.debug("setPageLines: " + P_lines);
        this.pageLines = P_lines;
    }

    public void setLineHeight(int lineHeight) {
        log.debug("setLineHeight: " + lineHeight);
        this.lineHeight = lineHeight;
    }

    public int getM_top() {
        return this.M_top;
    }

    public int getM_bot() {
        return this.M_bot;
    }

    public void setM_top(int M_top) {
        this.M_top = M_top;
    }

    public void setM_bot(int M_bot) {
        this.M_bot = M_bot;
    }

    public void GxEndPage() {
    }

    public abstract void GxEndDocument();

    public void GxEndPrinter() {
    }

    public abstract void GxStartPage();

    public void GxStartDoc() {
    }

    public void GxSetDocFormat(String format) {
    }

    public void GxSetDocName(String docName) {
        this.docName = docName.trim();
        if (this.docName.indexOf(46) < 0) {
            this.docName = this.docName + ".pdf";
        }
        if (!new File(docName).isAbsolute()) {
            HttpContext webContext;
            String outputDir = props.getGeneralProperty("OutputFileDirectory", "").replace(alternateSeparator, File.separatorChar).trim();
            if (!outputDir.equalsIgnoreCase("") && !outputDir.equalsIgnoreCase(".")) {
                if (!outputDir.endsWith(File.separator)) {
                    outputDir = outputDir + File.separator;
                }
                new File(outputDir).mkdirs();
                this.docName = outputDir + this.docName;
            } else if (ModelContext.getModelContext() != null && (webContext = (HttpContext)ModelContext.getModelContext().getHttpContext()) != null && webContext instanceof HttpContextWeb) {
                outputDir = ModelContext.getModelContext().getHttpContext().getDefaultPath() + File.separator;
                this.docName = outputDir + this.docName;
            }
        }
        if (this.docName.indexOf(46) < 0) {
            this.docName = this.docName + ".pdf";
        }
        log.debug("GxSetDocName: '" + this.docName + "'");
    }

    public boolean GxPrTextInit(String ouput, int[] nxPage, int[] nyPage, String psIniFile, String psForm, String sPrinter, int nMode, int nPaperLength, int nPaperWidth, int nGridX, int nGridY, int nPageLines) {
        return true;
    }

    public boolean GxPrnCfg(String ini) {
        return true;
    }

    public boolean GxIsAlive() {
        return false;
    }

    public boolean GxIsAliveDoc() {
        return true;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public boolean getModal() {
        return this.modal;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    public void cleanup() {
    }

    public void setMetrics(String fontName, boolean bold, boolean italic, int ascent, int descent, int height, int maxAdvance, int[] sizes) {
    }

    protected void loadSubstituteTable() {
        Hashtable tempInverseMappings = new Hashtable();
        for (int i = 0; i < Const.FONT_SUBSTITUTES_TTF_TYPE1.length; ++i) {
            fontSubstitutes.put(Const.FONT_SUBSTITUTES_TTF_TYPE1[i][0], Const.FONT_SUBSTITUTES_TTF_TYPE1[i][1]);
        }
        Hashtable otherMappings = props.getSection("Fonts Substitutions");
        if (otherMappings != null) {
            Enumeration enumera = otherMappings.keys();
            while (enumera.hasMoreElements()) {
                String fontName = (String)enumera.nextElement();
                fontSubstitutes.put(fontName, (String)otherMappings.get(fontName));
                if (!tempInverseMappings.containsKey(fontName)) continue;
                String fontSubstitute = (String)otherMappings.get(fontName);
                Enumeration enum2 = ((Vector)tempInverseMappings.get(fontName)).elements();
                while (enum2.hasMoreElements()) {
                    fontSubstitutes.put((String)enum2.nextElement(), fontSubstitute);
                }
            }
        }
    }

    public void GxPrintMax() {
    }

    public void GxPrintNormal() {
    }

    public void GxPrintOnTop() {
    }

    public void GxPrnCmd(String cmd) {
    }

    public void showInformation() {
    }

    protected double convertScale(int value) {
        double result = (double)value * 72.0 / this.PPP;
        return result;
    }

    protected double convertScale(double value) {
        double result = value * 72.0 / this.PPP;
        return result;
    }

    protected float reconvertScale(float value) {
        float result = value / (float)(72.0 / this.PPP);
        return result;
    }

    protected static String replace(String s, String f, String t) {
        StringBuffer b = new StringBuffer();
        int p = 0;
        int c = 0;
        while (c > -1) {
            c = s.indexOf(f, p);
            if (c <= -1) continue;
            b.append(s.substring(p, c));
            b.append(t);
            p = c + 1;
        }
        if (p < s.length()) {
            b.append(s.substring(p));
        }
        return b.toString();
    }

    static {
        TO_CM_SCALE = 28.6;
    }

    class FontProps {
        public int horizontal;
        public int vertical;

        FontProps() {
        }
    }

    protected static enum VerticalAlign {
        TOP(0),
        MIDDLE(1),
        BOTTOM(2);

        private int intValue;

        private VerticalAlign(int val) {
            this.intValue = val;
        }

        public int value() {
            return this.intValue;
        }
    }
}

