/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.reports;

import com.genexus.CommonUtil;
import com.genexus.GXProcedure;
import com.genexus.ModelContext;
import com.genexus.Preferences;
import com.genexus.PrivateUtilities;
import com.genexus.internet.HttpContext;
import com.genexus.platform.NativeFunctions;
import com.genexus.util.NullOutputStream;
import com.genexus.webpanels.BlobsCleaner;
import com.genexus.webpanels.HttpContextWeb;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;

public abstract class GXReportText
extends GXProcedure {
    protected int lineHeight;
    protected int Gx_line;
    protected int P_lines;
    protected int gxXPage;
    protected int gxYPage;
    protected int Gx_page;
    protected String Gx_out = "";
    protected String fileName = "";
    protected boolean printAtClient = false;
    protected PrintWriter out;

    public GXReportText(int remoteHandle, ModelContext context, String location) {
        this(false, remoteHandle, context, location);
        this.out = new PrintWriter(new OutputStreamWriter((OutputStream)new NullOutputStream()));
    }

    public GXReportText(boolean inNewUTL, int remoteHandle, ModelContext context, String location) {
        super(inNewUTL, remoteHandle, context, location);
    }

    protected void setOutput(PrintStream outStream) {
        this.out = new AsciiPrintWriter(outStream);
    }

    protected void setOutput(String fileName) {
        try {
            HttpContext webContext;
            this.fileName = fileName;
            if (!this.printAtClient && !new File(fileName).isAbsolute() && ModelContext.getModelContext() != null && (webContext = (HttpContext)ModelContext.getModelContext().getHttpContext()) != null && webContext instanceof HttpContextWeb) {
                this.fileName = ModelContext.getModelContext().getHttpContext().getDefaultPath() + File.separator + fileName;
            }
            this.out = new AsciiPrintWriter(new BufferedWriter(new FileWriter(this.fileName)));
        }
        catch (IOException e) {
            System.err.println("Can't open file " + this.fileName);
            this.setOutput(System.out);
        }
    }

    public String setPrintAtClient() {
        this.printAtClient = true;
        String blobPath = Preferences.getDefaultPreferences().getBLOB_PATH();
        String fileName = PrivateUtilities.getTempFileName(blobPath, "clientReport", "txt");
        this.setOutput(fileName);
        BlobsCleaner.getInstance().addBlobFile(fileName);
        return fileName;
    }

    class AsciiPrintWriter
    extends PrintWriter {
        public String eol;
        public String formFeed;

        public AsciiPrintWriter(PrintStream out) {
            super(out);
            this.eol = System.getProperty("line.separator", "\r\n");
            this.formFeed = "\f";
        }

        public AsciiPrintWriter(Writer writer) throws IOException {
            super(writer);
            this.eol = System.getProperty("line.separator", "\r\n");
            this.formFeed = "\f";
        }

        @Override
        public void print(String str) {
            str = CommonUtil.strReplace((String)str, (String)"\n", (String)this.eol);
            str = GXReportText.this.Gx_out.equals("PRN") ? CommonUtil.strReplace((String)str, (String)"\f", (String)this.formFeed) : CommonUtil.strReplace((String)str, (String)"\f", (String)"");
            super.print(str);
        }

        @Override
        public void println(String str) {
            str = CommonUtil.strReplace((String)str, (String)"\n", (String)this.eol);
            str = GXReportText.this.Gx_out.equals("PRN") ? CommonUtil.strReplace((String)str, (String)"\f", (String)this.formFeed) : CommonUtil.strReplace((String)str, (String)"\f", (String)"");
            super.println(str);
        }

        @Override
        public void close() {
            super.close();
            if (GXReportText.this.Gx_out.equals("PRN") && !GXReportText.this.printAtClient) {
                if (!NativeFunctions.isWindows()) {
                    try {
                        String[] cmd = new String[]{"lp", GXReportText.this.fileName};
                        Runtime.getRuntime().exec(cmd);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try (FileInputStream fInput = new FileInputStream(GXReportText.this.fileName);){
                        PrintService ps = this.getDefaultPrinter();
                        DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
                        DocPrintJob pj = ps.createPrintJob();
                        SimpleDoc doc = new SimpleDoc(fInput, flavor, null);
                        pj.print(doc, null);
                    }
                    catch (FileNotFoundException e1) {
                        System.out.println("File " + GXReportText.this.fileName + " not found: " + e1.getMessage());
                    }
                    catch (PrintException e) {
                        System.out.println("Error printing report " + GXReportText.this.fileName + " " + e.getMessage());
                    }
                    catch (IOException ioe) {
                        System.out.println("Error opening file input stream of file " + GXReportText.this.fileName + " " + ioe.getMessage());
                    }
                }
            }
        }

        private PrintService getDefaultPrinter() {
            PrintService ps = PrintServiceLookup.lookupDefaultPrintService();
            if (ps == null) {
                PrintService[] ps1 = PrintServiceLookup.lookupPrintServices(null, null);
                ps = ps1[0];
            }
            return ps;
        }
    }
}

