/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.reports;

import com.genexus.CommonUtil;
import com.genexus.ModelContext;
import com.genexus.platform.NativeFunctions;
import com.genexus.reports.Const;
import com.genexus.reports.GXReportPDFCommons;
import com.genexus.reports.fonts.PDFFont;
import com.genexus.reports.fonts.PDFFontDescriptor;
import com.genexus.reports.fonts.Type1FontMetrics;
import com.genexus.webpanels.HttpContextWeb;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.html.simpleparser.HTMLWorker;
import com.lowagie.text.html.simpleparser.StyleSheet;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.Barcode128;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;

public class PDFReportItext2
extends GXReportPDFCommons {
    private Rectangle pageSize = null;
    private BaseFont baseFont;
    private Barcode barcode = null;
    private Document document = null;
    private PdfWriter writer;
    private PdfTemplate template;
    private BaseFont templateFont;
    public boolean lineCapProjectingSquare = true;
    public boolean barcode128AsImage = true;
    ConcurrentHashMap<String, Image> documentImages = new ConcurrentHashMap();
    public int runDirection = 2;

    public PDFReportItext2(ModelContext context) {
        super(context);
    }

    @Override
    protected void init() {
        Document.compress = true;
        try {
            this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)this.outputStream);
        }
        catch (DocumentException de) {
            log.error("Failed to initialize new iText2 document: ", (Throwable)de);
        }
        this.document.open();
    }

    private void drawRectangle(PdfContentByte cb, float x, float y, float w, float h, int styleTop, int styleBottom, int styleRight, int styleLeft, float radioTL, float radioTR, float radioBL, float radioBR, float penAux, boolean hideCorners) {
        float[] dashPatternTop = this.getDashedPattern(styleTop);
        float[] dashPatternBottom = this.getDashedPattern(styleBottom);
        float[] dashPatternLeft = this.getDashedPattern(styleLeft);
        float[] dashPatternRight = this.getDashedPattern(styleRight);
        if (styleBottom != this.STYLE_NONE_CONST) {
            cb.setLineDash(dashPatternBottom, 0.0f);
        }
        float b = 0.4477f;
        if (radioBL > 0.0f) {
            cb.moveTo(x + radioBL, y);
        } else if (hideCorners && styleLeft == this.STYLE_NONE_CONST && radioBL == 0.0f) {
            cb.moveTo(x + penAux, y);
        } else {
            cb.moveTo(x, y);
        }
        if (styleBottom != this.STYLE_NONE_CONST) {
            if (hideCorners && styleRight == this.STYLE_NONE_CONST && radioBR == 0.0f) {
                cb.lineTo(x + w - penAux, y);
            } else {
                cb.lineTo(x + w - radioBR, y);
            }
            if (radioBR > 0.0f && styleRight != this.STYLE_NONE_CONST) {
                cb.curveTo(x + w - radioBR * b, y, x + w, y + radioBR * b, x + w, y + radioBR);
            }
        }
        if (styleRight != this.STYLE_NONE_CONST && dashPatternRight != dashPatternBottom) {
            cb.stroke();
            cb.setLineDash(dashPatternRight, 0.0f);
            if (hideCorners && styleBottom == this.STYLE_NONE_CONST && radioBR == 0.0f) {
                cb.moveTo(x + w, y + penAux);
            } else {
                cb.moveTo(x + w, y + radioBR);
            }
        }
        if (styleRight != this.STYLE_NONE_CONST) {
            if (hideCorners && styleTop == this.STYLE_NONE_CONST && radioTR == 0.0f) {
                cb.lineTo(x + w, y + h - penAux);
            } else {
                cb.lineTo(x + w, y + h - radioTR);
            }
            if (radioTR > 0.0f && styleTop != this.STYLE_NONE_CONST) {
                cb.curveTo(x + w, y + h - radioTR * b, x + w - radioTR * b, y + h, x + w - radioTR, y + h);
            }
        }
        if (styleTop != this.STYLE_NONE_CONST && dashPatternTop != dashPatternRight) {
            cb.stroke();
            cb.setLineDash(dashPatternTop, 0.0f);
            if (hideCorners && styleRight == this.STYLE_NONE_CONST && radioTR == 0.0f) {
                cb.moveTo(x + w - penAux, y + h);
            } else {
                cb.moveTo(x + w - radioTR, y + h);
            }
        }
        if (styleTop != this.STYLE_NONE_CONST) {
            if (hideCorners && styleLeft == this.STYLE_NONE_CONST && radioTL == 0.0f) {
                cb.lineTo(x + penAux, y + h);
            } else {
                cb.lineTo(x + radioTL, y + h);
            }
            if (radioTL > 0.0f && styleLeft != this.STYLE_NONE_CONST) {
                cb.curveTo(x + radioTL * b, y + h, x, y + h - radioTL * b, x, y + h - radioTL);
            }
        }
        if (styleLeft != this.STYLE_NONE_CONST && dashPatternLeft != dashPatternTop) {
            cb.stroke();
            cb.setLineDash(dashPatternLeft, 0.0f);
            if (hideCorners && styleTop == this.STYLE_NONE_CONST && radioTL == 0.0f) {
                cb.moveTo(x, y + h - penAux);
            } else {
                cb.moveTo(x, y + h - radioTL);
            }
        }
        if (styleLeft != this.STYLE_NONE_CONST) {
            if (hideCorners && styleBottom == this.STYLE_NONE_CONST && radioBL == 0.0f) {
                cb.lineTo(x, y + penAux);
            } else {
                cb.lineTo(x, y + radioBL);
            }
            if (radioBL > 0.0f && styleBottom != this.STYLE_NONE_CONST) {
                cb.curveTo(x, y + radioBL * b, x + radioBL * b, y, x + radioBL, y);
            }
        }
        cb.stroke();
    }

    private void roundRectangle(PdfContentByte cb, float x, float y, float w, float h, float radioTL, float radioTR, float radioBL, float radioBR) {
        float b = 0.4477f;
        if (radioBL > 0.0f) {
            cb.moveTo(x + radioBL, y);
        } else {
            cb.moveTo(x, y);
        }
        cb.lineTo(x + w - radioBR, y);
        if (radioBR > 0.0f) {
            cb.curveTo(x + w - radioBR * b, y, x + w, y + radioBR * b, x + w, y + radioBR);
        }
        cb.lineTo(x + w, y + h - radioTR);
        if (radioTR > 0.0f) {
            cb.curveTo(x + w, y + h - radioTR * b, x + w - radioTR * b, y + h, x + w - radioTR, y + h);
        }
        cb.lineTo(x + radioTL, y + h);
        if (radioTL > 0.0f) {
            cb.curveTo(x + radioTL * b, y + h, x, y + h - radioTL * b, x, y + h - radioTL);
        }
        cb.lineTo(x, y + radioBL);
        if (radioBL > 0.0f) {
            cb.curveTo(x, y + radioBL * b, x + radioBL * b, y, x + radioBL, y);
        }
    }

    @Override
    public void GxDrawRect(int left, int top, int right, int bottom, int pen, int foreRed, int foreGreen, int foreBlue, int backMode, int backRed, int backGreen, int backBlue, int styleTop, int styleBottom, int styleRight, int styleLeft, int cornerRadioTL, int cornerRadioTR, int cornerRadioBL, int cornerRadioBR) {
        PdfContentByte cb = this.writer.getDirectContent();
        float penAux = (float)this.convertScale(pen);
        float rightAux = (float)this.convertScale(right);
        float bottomAux = (float)this.convertScale(bottom);
        float leftAux = (float)this.convertScale(left);
        float topAux = (float)this.convertScale(top);
        cb.saveState();
        float x1 = leftAux + this.leftMargin;
        float y1 = this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin;
        float x2 = rightAux + this.leftMargin;
        float y2 = this.pageSize.getTop() - topAux - this.topMargin - this.bottomMargin;
        cb.setLineWidth(penAux);
        cb.setLineCap(2);
        if (cornerRadioBL == 0 && cornerRadioBR == 0 && cornerRadioTL == 0 && cornerRadioTR == 0 && styleBottom == 0 && styleLeft == 0 && styleRight == 0 && styleTop == 0) {
            if (pen > 0) {
                cb.setRGBColorStroke(foreRed, foreGreen, foreBlue);
            } else {
                cb.setRGBColorStroke(backRed, backGreen, backBlue);
            }
            cb.rectangle(x1, y1, x2 - x1, y2 - y1);
            if (backMode != 0) {
                cb.setColorFill(new Color(backRed, backGreen, backBlue));
                cb.fillStroke();
            }
            cb.closePathStroke();
        } else {
            float w = x2 - x1;
            float h = y2 - y1;
            if (w < 0.0f) {
                x1 += w;
                w = -w;
            }
            if (h < 0.0f) {
                y1 += h;
                h = -h;
            }
            float cRadioTL = (float)this.convertScale(cornerRadioTL);
            float cRadioTR = (float)this.convertScale(cornerRadioTR);
            float cRadioBL = (float)this.convertScale(cornerRadioBL);
            float cRadioBR = (float)this.convertScale(cornerRadioBR);
            int max = (int)Math.min(w, h);
            cRadioTL = Math.max(0.0f, Math.min(cRadioTL, (float)(max / 2)));
            cRadioTR = Math.max(0.0f, Math.min(cRadioTR, (float)(max / 2)));
            cRadioBL = Math.max(0.0f, Math.min(cRadioBL, (float)(max / 2)));
            cRadioBR = Math.max(0.0f, Math.min(cRadioBR, (float)(max / 2)));
            if (backMode != 0) {
                cb.setRGBColorStroke(backRed, backGreen, backBlue);
                cb.setLineWidth(0.0f);
                this.roundRectangle(cb, x1, y1, w, h, cRadioTL, cRadioTR, cRadioBL, cRadioBR);
                cb.setColorFill(new Color(backRed, backGreen, backBlue));
                cb.fillStroke();
                cb.setLineWidth(penAux);
            }
            if (pen > 0) {
                cb.setRGBColorStroke(foreRed, foreGreen, foreBlue);
                this.drawRectangle(cb, x1, y1, w, h, styleTop, styleBottom, styleRight, styleLeft, cRadioTL, cRadioTR, cRadioBL, cRadioBR, penAux, false);
            }
        }
        cb.restoreState();
        log.debug("GxDrawRect -> (" + left + "," + top + ") - (" + right + "," + bottom + ")  BackMode: " + backMode + " Pen:" + pen);
    }

    @Override
    public void GxDrawLine(int left, int top, int right, int bottom, int width, int foreRed, int foreGreen, int foreBlue, int style) {
        PdfContentByte cb = this.writer.getDirectContent();
        float widthAux = (float)this.convertScale(width);
        float rightAux = (float)this.convertScale(right);
        float bottomAux = (float)this.convertScale(bottom);
        float leftAux = (float)this.convertScale(left);
        float topAux = (float)this.convertScale(top);
        log.debug("GxDrawLine -> (" + left + "," + top + ") - (" + right + "," + bottom + ") Width: " + width);
        float x1 = leftAux + this.leftMargin;
        float y1 = this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin;
        float x2 = rightAux + this.leftMargin;
        float y2 = this.pageSize.getTop() - topAux - this.topMargin - this.bottomMargin;
        cb.saveState();
        cb.setRGBColorStroke(foreRed, foreGreen, foreBlue);
        cb.setLineWidth(widthAux);
        if (this.lineCapProjectingSquare) {
            cb.setLineCap(2);
        }
        if (style != 0) {
            float[] dashPattern = this.getDashedPattern(style);
            cb.setLineDash(dashPattern, 0.0f);
        }
        cb.moveTo(x1, y1);
        cb.lineTo(x2, y2);
        cb.stroke();
        cb.restoreState();
    }

    @Override
    public void GxDrawBitMap(String bitmap, int left, int top, int right, int bottom, int aspectRatio) {
        try {
            Image image;
            try {
                if (this.documentImages != null && this.documentImages.containsKey(bitmap)) {
                    image = this.documentImages.get(bitmap);
                } else {
                    if (!NativeFunctions.isWindows() && new File(bitmap).isAbsolute() && bitmap.startsWith(this.httpContext.getStaticContentBase())) {
                        bitmap = bitmap.replace(this.httpContext.getStaticContentBase(), "");
                    }
                    if (!(new File(bitmap).isAbsolute() || bitmap.toLowerCase().startsWith("http:") || bitmap.toLowerCase().startsWith("https:"))) {
                        if (bitmap.startsWith(this.httpContext.getStaticContentBase())) {
                            bitmap = bitmap.replace(this.httpContext.getStaticContentBase(), "");
                        }
                        if ((image = Image.getInstance((String)(defaultRelativePrepend + bitmap))) == null) {
                            bitmap = webAppDir + bitmap;
                            image = Image.getInstance((String)bitmap);
                        } else {
                            bitmap = defaultRelativePrepend + bitmap;
                        }
                    } else {
                        image = Image.getInstance((String)bitmap);
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                URL url = new URL(bitmap);
                image = Image.getInstance((URL)url);
            }
            if (this.documentImages == null) {
                this.documentImages = new ConcurrentHashMap();
            }
            this.documentImages.putIfAbsent(bitmap, image);
            log.debug("GxDrawBitMap -> '" + bitmap + "' [" + left + "," + top + "] - Size: (" + (right - left) + "," + (bottom - top) + ")");
            if (image != null) {
                float rightAux = (float)this.convertScale(right);
                float bottomAux = (float)this.convertScale(bottom);
                float leftAux = (float)this.convertScale(left);
                float topAux = (float)this.convertScale(top);
                image.setAbsolutePosition(leftAux + this.leftMargin, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin);
                if (aspectRatio == 0) {
                    image.scaleAbsolute(rightAux - leftAux, bottomAux - topAux);
                } else {
                    image.scaleToFit(rightAux - leftAux, bottomAux - topAux);
                }
                PdfContentByte cb = this.writer.getDirectContent();
                cb.addImage(image);
            }
        }
        catch (DocumentException de) {
            log.error("GxDrawBitMap failed:", (Throwable)de);
        }
        catch (IOException ioe) {
            log.error("GxDrawBitMap failed:", (Throwable)ioe);
        }
        catch (Exception e) {
            log.error("GxDrawBitMap failed:", (Throwable)e);
        }
    }

    @Override
    public void GxAttris(String fontName, int fontSize, boolean fontBold, boolean fontItalic, boolean fontUnderline, boolean fontStrikethru, int Pen, int foreRed, int foreGreen, int foreBlue, int backMode, int backRed, int backGreen, int backBlue) {
        boolean isCJK = false;
        boolean embeedFont = this.isEmbeddedFont(fontName);
        String originalFontName = fontName;
        if (!embeedFont) {
            fontName = this.getSubstitute(fontName);
        }
        String fontSubstitute = "";
        if (!originalFontName.equals(fontName)) {
            fontSubstitute = "Original Font: " + originalFontName + " Substitute";
        }
        log.debug("GxAttris: ");
        log.debug("\\-> " + fontSubstitute + "Font: " + fontName + " (" + fontSize + ")" + (fontBold ? " BOLD" : "") + (fontItalic ? " ITALIC" : "") + (fontStrikethru ? " Strike" : ""));
        log.debug("\\-> Fore (" + foreRed + ", " + foreGreen + ", " + foreBlue + ")");
        log.debug("\\-> Back (" + backRed + ", " + backGreen + ", " + backBlue + ")");
        if (this.barcode128AsImage && fontName.toLowerCase().indexOf("barcode 128") >= 0 || fontName.toLowerCase().indexOf("barcode128") >= 0) {
            this.barcode = new Barcode128();
            this.barcode.setCodeType(9);
        } else {
            this.barcode = null;
        }
        this.fontUnderline = fontUnderline;
        this.fontStrikethru = fontStrikethru;
        this.fontSize = fontSize;
        this.fontBold = fontBold;
        this.fontItalic = fontItalic;
        this.foreColor = new Color(foreRed, foreGreen, foreBlue);
        this.backColor = new Color(backRed, backGreen, backBlue);
        this.backFill = backMode != 0;
        try {
            if (PDFFont.isType1(fontName)) {
                for (int i = 0; i < Type1FontMetrics.CJKNames.length; ++i) {
                    if (!Type1FontMetrics.CJKNames[i][0].equalsIgnoreCase(fontName) && !Type1FontMetrics.CJKNames[i][1].equalsIgnoreCase(fontName)) continue;
                    String style = "";
                    if (fontBold && fontItalic) {
                        style = "BoldItalic";
                    } else {
                        if (fontItalic) {
                            style = "Italic";
                        }
                        if (fontBold) {
                            style = "Bold";
                        }
                    }
                    this.setAsianFont(fontName, style);
                    isCJK = true;
                    break;
                }
                if (!isCJK) {
                    int style = 0;
                    if (fontBold && fontItalic) {
                        style += 3;
                    } else {
                        if (fontItalic) {
                            style += 2;
                        }
                        if (fontBold) {
                            ++style;
                        }
                    }
                    for (int i = 0; i < PDFFont.base14.length; ++i) {
                        if (!PDFFont.base14[i][0].equalsIgnoreCase(fontName)) continue;
                        fontName = PDFFont.base14[i][1 + style].substring(1);
                        break;
                    }
                    this.baseFont = BaseFont.createFont((String)fontName, (String)"Cp1252", (boolean)false);
                }
            } else {
                String style = "";
                if (fontBold && fontItalic) {
                    style = ",BoldItalic";
                } else {
                    if (fontItalic) {
                        style = ",Italic";
                    }
                    if (fontBold) {
                        style = ",Bold";
                    }
                }
                fontName = fontName + style;
                String fontPath = this.getFontLocation(fontName);
                boolean foundFont = true;
                if (fontPath.equals("") && (fontPath = PDFFontDescriptor.getTrueTypeFontLocation(fontName, props)).equals("")) {
                    this.baseFont = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
                    foundFont = false;
                }
                if (foundFont) {
                    this.baseFont = this.isEmbeddedFont(fontName) ? BaseFont.createFont((String)fontPath, (String)"Identity-H", (boolean)true) : BaseFont.createFont((String)(fontPath + style), (String)"Cp1252", (boolean)false);
                }
            }
        }
        catch (DocumentException de) {
            log.error("GxAttris failed: ", (Throwable)de);
        }
        catch (IOException ioe) {
            log.error("GxAttris failed: ", (Throwable)ioe);
        }
    }

    @Override
    public void setAsianFont(String fontName, String style) {
        try {
            if (style.equals("")) {
                if (fontName.equals("Japanese")) {
                    this.baseFont = BaseFont.createFont((String)"HeiseiMin-W3", (String)"UniJIS-UCS2-HW-H", (boolean)false);
                }
                if (fontName.equals("Japanese2")) {
                    this.baseFont = BaseFont.createFont((String)"HeiseiKakuGo-W5", (String)"UniJIS-UCS2-H", (boolean)false);
                }
                if (fontName.equals("SimplifiedChinese")) {
                    this.baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
                }
                if (fontName.equals("TraditionalChinese")) {
                    this.baseFont = BaseFont.createFont((String)"MHei-Medium", (String)"UniCNS-UCS2-H", (boolean)false);
                }
                if (fontName.equals("Korean")) {
                    this.baseFont = BaseFont.createFont((String)"HYSMyeongJo-Medium", (String)"UniKS-UCS2-H", (boolean)false);
                }
            } else {
                if (fontName.equals("Japanese")) {
                    this.baseFont = BaseFont.createFont((String)("HeiseiMin-W3," + style), (String)"UniJIS-UCS2-HW-H", (boolean)false);
                }
                if (fontName.equals("Japanese2")) {
                    this.baseFont = BaseFont.createFont((String)("HeiseiKakuGo-W5," + style), (String)"UniJIS-UCS2-H", (boolean)false);
                }
                if (fontName.equals("SimplifiedChinese")) {
                    this.baseFont = BaseFont.createFont((String)("STSong-Light," + style), (String)"UniGB-UCS2-H", (boolean)false);
                }
                if (fontName.equals("TraditionalChinese")) {
                    this.baseFont = BaseFont.createFont((String)("MHei-Medium," + style), (String)"UniCNS-UCS2-H", (boolean)false);
                }
                if (fontName.equals("Korean")) {
                    this.baseFont = BaseFont.createFont((String)("HYSMyeongJo-Medium," + style), (String)"UniKS-UCS2-H", (boolean)false);
                }
            }
        }
        catch (DocumentException de) {
            log.error("setAsianFont failed: ", (Throwable)de);
        }
        catch (IOException ioe) {
            log.error("setAsianFont failed: ", (Throwable)ioe);
        }
    }

    @Override
    public void GxDrawText(String sTxt, int left, int top, int right, int bottom, int align, int htmlformat, int border, int valign) {
        boolean autoResize;
        boolean printRectangle = false;
        if (props.getBooleanGeneralProperty("BackFillInControls", true)) {
            printRectangle = true;
        }
        if (printRectangle && (border == 1 || this.backFill)) {
            this.GxDrawRect(left, top, right, bottom, border, this.foreColor.getRed(), this.foreColor.getGreen(), this.foreColor.getBlue(), this.backFill ? 1 : 0, this.backColor.getRed(), this.backColor.getGreen(), this.backColor.getBlue(), 0, 0);
        }
        PdfContentByte cb = this.writer.getDirectContent();
        sTxt = CommonUtil.rtrim((String)sTxt);
        Font font = new Font(this.baseFont, (float)this.fontSize);
        cb.setFontAndSize(this.baseFont, (float)this.fontSize);
        cb.setColorFill(this.foreColor);
        int arabicOptions = 0;
        float captionHeight = this.baseFont.getFontDescriptor(2, (float)this.fontSize);
        float rectangleWidth = this.baseFont.getWidthPoint(sTxt, (float)this.fontSize);
        float lineHeight = this.baseFont.getFontDescriptor(8, (float)this.fontSize) - this.baseFont.getFontDescriptor(6, (float)this.fontSize);
        float textBlockHeight = (float)this.convertScale(bottom - top);
        int linesCount = (int)(textBlockHeight / lineHeight);
        int bottomOri = bottom;
        int topOri = top;
        if (linesCount >= 2 && (align & 0x10) != 16 && htmlformat != 1) {
            if (valign == GXReportPDFCommons.VerticalAlign.TOP.value()) {
                bottom = top + (int)this.reconvertScale(lineHeight);
            } else if (valign == GXReportPDFCommons.VerticalAlign.BOTTOM.value()) {
                top = bottom - (int)this.reconvertScale(lineHeight);
            }
        }
        float bottomAux = (float)this.convertScale(bottom) - ((float)this.convertScale(bottom - top) - captionHeight) / 2.0f;
        float topAux = (float)this.convertScale(top) + ((float)this.convertScale(bottom - top) - captionHeight) / 2.0f;
        float startHeight = bottomAux - topAux - captionHeight;
        float leftAux = (float)this.convertScale(left);
        float rightAux = (float)this.convertScale(right);
        int alignment = align & 3;
        boolean bl = autoResize = (align & 0x100) == 256;
        if (htmlformat == 1) {
            StyleSheet styles = new StyleSheet();
            Hashtable locations = this.getFontLocations();
            Enumeration e = locations.keys();
            while (e.hasMoreElements()) {
                String fontName = (String)e.nextElement();
                String fontPath = (String)locations.get(fontName);
                if (fontPath.equals("")) {
                    fontPath = PDFFontDescriptor.getTrueTypeFontLocation(fontName, props);
                }
                if (fontPath.equals("")) continue;
                FontFactory.register((String)fontPath, (String)fontName);
                styles.loadTagStyle("body", "face", fontName);
                if (this.isEmbeddedFont(fontName)) {
                    styles.loadTagStyle("body", "encoding", "Identity-H");
                    continue;
                }
                styles.loadTagStyle("body", "encoding", "Cp1252");
            }
            bottomAux = (float)this.convertScale(bottom);
            topAux = (float)this.convertScale(top);
            ColumnText Col = new ColumnText(cb);
            int colAlignment = this.columnAlignment(alignment);
            if (colAlignment != 0) {
                Col.setAlignment(colAlignment);
            }
            ColumnText simulationCol = new ColumnText(null);
            float drawingPageHeight = this.pageSize.getTop() - this.topMargin - this.bottomMargin;
            Col.setSimpleColumn(leftAux + this.leftMargin, drawingPageHeight - bottomAux, rightAux + this.leftMargin, drawingPageHeight - topAux);
            simulationCol.setSimpleColumn(leftAux + this.leftMargin, drawingPageHeight - bottomAux, rightAux + this.leftMargin, drawingPageHeight - topAux);
            try {
                ArrayList objects = HTMLWorker.parseToList((Reader)new StringReader(sTxt), (StyleSheet)styles);
                for (int k = 0; k < objects.size(); ++k) {
                    if (this.pageHeightExceeded(bottomAux, drawingPageHeight)) {
                        simulationCol.addElement((Element)objects.get(k));
                        simulationCol.go(true);
                        if (simulationCol.getYLine() < this.bottomMargin) {
                            this.GxEndPage();
                            this.GxStartPage();
                            simulationCol = new ColumnText(null);
                            simulationCol.setSimpleColumn(leftAux + this.leftMargin, drawingPageHeight - bottomAux, rightAux + this.leftMargin, drawingPageHeight - topAux);
                            simulationCol.addElement((Element)objects.get(k));
                            Col = new ColumnText(cb);
                            if (colAlignment != 0) {
                                Col.setAlignment(colAlignment);
                            }
                            Col.setSimpleColumn(leftAux + this.leftMargin, drawingPageHeight - bottomAux, rightAux + this.leftMargin, drawingPageHeight - topAux);
                            bottomAux -= drawingPageHeight;
                        }
                    }
                    if (objects.get(k) instanceof Paragraph && colAlignment != 0) {
                        ((Paragraph)objects.get(k)).setAlignment(colAlignment);
                    }
                    Col.addElement((Element)objects.get(k));
                    Col.go();
                }
            }
            catch (Exception de) {
                log.error("ERROR printing HTML text ", (Object)de.getMessage());
            }
        } else if (this.barcode != null) {
            log.debug("Barcode: --> " + this.barcode.getClass().getName());
            try {
                this.barcode.setCode(sTxt);
                this.barcode.setTextAlignment(alignment);
                Rectangle rectangle = new Rectangle(0.0f, 0.0f);
                switch (alignment) {
                    case 1: {
                        rectangle = new Rectangle((leftAux + rightAux) / 2.0f + this.leftMargin - rectangleWidth / 2.0f, this.pageSize.getTop() - (float)this.convertScale(bottom) - this.topMargin - this.bottomMargin, (leftAux + rightAux) / 2.0f + this.leftMargin + rectangleWidth / 2.0f, this.pageSize.getTop() - (float)this.convertScale(top) - this.topMargin - this.bottomMargin);
                        break;
                    }
                    case 2: {
                        rectangle = new Rectangle(rightAux + this.leftMargin - rectangleWidth, this.pageSize.getTop() - (float)this.convertScale(bottom) - this.topMargin - this.bottomMargin, rightAux + this.leftMargin, this.pageSize.getTop() - (float)this.convertScale(top) - this.topMargin - this.bottomMargin);
                        break;
                    }
                    case 0: {
                        rectangle = new Rectangle(leftAux + this.leftMargin, this.pageSize.getTop() - (float)this.convertScale(bottom) - this.topMargin - this.bottomMargin, leftAux + this.leftMargin + rectangleWidth, this.pageSize.getTop() - (float)this.convertScale(top) - this.topMargin - this.bottomMargin);
                    }
                }
                this.barcode.setAltText("");
                this.barcode.setBaseline(0.0f);
                if (this.fontSize < Const.LARGE_FONT_SIZE) {
                    this.barcode.setX(Const.OPTIMAL_MINIMU_BAR_WIDTH_SMALL_FONT);
                } else {
                    this.barcode.setX(Const.OPTIMAL_MINIMU_BAR_WIDTH_LARGE_FONT);
                }
                Image imageCode = this.barcode.createImageWithBarcode(cb, this.backFill ? this.backColor : null, this.foreColor);
                imageCode.setAbsolutePosition(leftAux + this.leftMargin, rectangle.getBottom());
                this.barcode.setBarHeight(rectangle.getHeight());
                imageCode.scaleToFit(rectangle.getWidth(), rectangle.getHeight());
                this.document.add((Element)imageCode);
            }
            catch (Exception ex) {
                log.error("GxDrawText: Error generating Barcode " + this.barcode.getClass().getName(), (Throwable)ex);
            }
        } else {
            boolean wrap;
            Rectangle underline;
            if (this.backFill) {
                Rectangle rectangle = new Rectangle(0.0f, 0.0f);
                switch (alignment) {
                    case 1: {
                        rectangle = new Rectangle((leftAux + rightAux) / 2.0f + this.leftMargin - rectangleWidth / 2.0f, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin, (leftAux + rightAux) / 2.0f + this.leftMargin + rectangleWidth / 2.0f, this.pageSize.getTop() - topAux - this.topMargin - this.bottomMargin);
                        break;
                    }
                    case 2: {
                        rectangle = new Rectangle(rightAux + this.leftMargin - rectangleWidth, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin, rightAux + this.leftMargin, this.pageSize.getTop() - topAux - this.topMargin - this.bottomMargin);
                        break;
                    }
                    case 0: {
                        rectangle = new Rectangle(leftAux + this.leftMargin, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin, leftAux + this.leftMargin + rectangleWidth, this.pageSize.getTop() - topAux - this.topMargin - this.bottomMargin);
                    }
                }
                rectangle.setBackgroundColor(this.backColor);
                try {
                    this.document.add((Element)rectangle);
                }
                catch (DocumentException de) {
                    log.error("backfill in GxDrawText failed: ", (Throwable)de);
                }
            }
            float underlineSeparation = lineHeight / 5.0f;
            int underlineHeight = (int)underlineSeparation + (int)(underlineSeparation / 4.0f);
            if (this.fontUnderline) {
                underline = new Rectangle(0.0f, 0.0f);
                switch (alignment) {
                    case 1: {
                        underline = new Rectangle((leftAux + rightAux) / 2.0f + this.leftMargin - rectangleWidth / 2.0f, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin + startHeight - underlineSeparation, (leftAux + rightAux) / 2.0f + this.leftMargin + rectangleWidth / 2.0f, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin + startHeight - (float)underlineHeight);
                        break;
                    }
                    case 2: {
                        underline = new Rectangle(rightAux + this.leftMargin - rectangleWidth, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin + startHeight - underlineSeparation, rightAux + this.leftMargin, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin + startHeight - (float)underlineHeight);
                        break;
                    }
                    case 0: {
                        underline = new Rectangle(leftAux + this.leftMargin, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin + startHeight - underlineSeparation, leftAux + this.leftMargin + rectangleWidth, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin + startHeight - (float)underlineHeight);
                    }
                }
                underline.setBackgroundColor(this.foreColor);
                try {
                    this.document.add((Element)underline);
                }
                catch (DocumentException de) {
                    log.error("fontUnderline in GxDrawText failed: ", (Throwable)de);
                }
            }
            if (this.fontStrikethru) {
                underline = new Rectangle(0.0f, 0.0f);
                float strikethruSeparation = lineHeight / 2.0f;
                switch (alignment) {
                    case 1: {
                        underline = new Rectangle((leftAux + rightAux) / 2.0f + this.leftMargin - rectangleWidth / 2.0f, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin + startHeight - underlineSeparation + strikethruSeparation, (leftAux + rightAux) / 2.0f + this.leftMargin + rectangleWidth / 2.0f, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin + startHeight - (float)underlineHeight + strikethruSeparation);
                        break;
                    }
                    case 2: {
                        underline = new Rectangle(rightAux + this.leftMargin - rectangleWidth, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin + startHeight - underlineSeparation + strikethruSeparation, rightAux + this.leftMargin, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin + startHeight - (float)underlineHeight + strikethruSeparation);
                        break;
                    }
                    case 0: {
                        underline = new Rectangle(leftAux + this.leftMargin, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin + startHeight - underlineSeparation + strikethruSeparation, leftAux + this.leftMargin + rectangleWidth, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin + startHeight - (float)underlineHeight + strikethruSeparation);
                    }
                }
                underline.setBackgroundColor(this.foreColor);
                try {
                    this.document.add((Element)underline);
                }
                catch (DocumentException de) {
                    log.error("fontStrikethru in GxDrawText failed: ", (Throwable)de);
                }
            }
            if (sTxt.trim().equalsIgnoreCase("{{Pages}}")) {
                if (!this.templateCreated) {
                    this.template = cb.createTemplate((float)(right - left), (float)(bottom - top));
                    this.templateCreated = true;
                }
                cb.addTemplate(this.template, leftAux + this.leftMargin, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin);
                this.templateFont = this.baseFont;
                this.templateFontSize = this.fontSize;
                this.templateColorFill = this.foreColor;
                return;
            }
            float textBlockWidth = rightAux - leftAux;
            float TxtWidth = this.baseFont.getWidthPoint(sTxt, (float)this.fontSize);
            boolean justified = alignment == 3 && textBlockWidth < TxtWidth;
            boolean bl2 = wrap = (align & 0x10) == 16;
            if (wrap || justified) {
                bottomAux = (float)this.convertScale(bottomOri);
                topAux = (float)this.convertScale(topOri);
                float leading = (float)Double.valueOf(props.getGeneralProperty("Leading")).doubleValue();
                Paragraph p = new Paragraph(sTxt, font);
                float llx = leftAux + this.leftMargin;
                float lly = this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin;
                float urx = rightAux + this.leftMargin;
                float ury = this.pageSize.getTop() - topAux - this.topMargin - this.bottomMargin;
                try {
                    this.DrawColumnText(cb, llx, lly, urx, ury, p, leading, this.runDirection, valign, alignment);
                }
                catch (DocumentException ex) {
                    log.error("wrap in GxDrawText failed: ", (Throwable)ex);
                }
            } else {
                startHeight = 0.0f;
                if (!autoResize) {
                    String newsTxt = sTxt;
                    while (TxtWidth > textBlockWidth && newsTxt.length() - 1 >= 0) {
                        sTxt = newsTxt;
                        newsTxt = newsTxt.substring(0, newsTxt.length() - 1);
                        TxtWidth = this.baseFont.getWidthPoint(newsTxt, (float)this.fontSize);
                    }
                }
                Phrase phrase = new Phrase(sTxt, font);
                switch (alignment) {
                    case 1: {
                        ColumnText.showTextAligned((PdfContentByte)cb, (int)1, (Phrase)phrase, (float)((leftAux + rightAux) / 2.0f + this.leftMargin), (float)(this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin + startHeight), (float)0.0f, (int)this.runDirection, (int)arabicOptions);
                        break;
                    }
                    case 2: {
                        ColumnText.showTextAligned((PdfContentByte)cb, (int)2, (Phrase)phrase, (float)(rightAux + this.leftMargin), (float)(this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin + startHeight), (float)0.0f, (int)this.runDirection, (int)arabicOptions);
                        break;
                    }
                    case 0: 
                    case 3: {
                        ColumnText.showTextAligned((PdfContentByte)cb, (int)0, (Phrase)phrase, (float)(leftAux + this.leftMargin), (float)(this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin + startHeight), (float)0.0f, (int)this.runDirection, (int)arabicOptions);
                    }
                }
            }
        }
    }

    @Override
    boolean pageHeightExceeded(float bottomAux, float drawingPageHeight) {
        return super.pageHeightExceeded(bottomAux, drawingPageHeight);
    }

    ColumnText SimulateDrawColumnText(PdfContentByte cb, Rectangle rect, Paragraph p, float leading, int runDirection, int alignment) throws DocumentException {
        ColumnText Col = new ColumnText(cb);
        Col.setRunDirection(runDirection);
        Col.setAlignment(alignment);
        Col.setLeading(leading, 1.0f);
        Col.setSimpleColumn(rect.getLeft(), rect.getBottom(), rect.getRight(), rect.getTop());
        Col.addText((Phrase)p);
        Col.go(true);
        return Col;
    }

    void DrawColumnText(PdfContentByte cb, float llx, float lly, float urx, float ury, Paragraph p, float leading, int runDirection, int valign, int alignment) throws DocumentException {
        Rectangle rect = new Rectangle(llx, lly, urx, ury);
        ColumnText ct = this.SimulateDrawColumnText(cb, rect, p, leading, runDirection, alignment);
        float y = ct.getYLine();
        int linesCount = ct.getLinesWritten();
        if (valign == GXReportPDFCommons.VerticalAlign.MIDDLE.value()) {
            ury = ury - (y - lly) / 2.0f + leading;
        } else if (valign == GXReportPDFCommons.VerticalAlign.BOTTOM.value()) {
            ury -= y - lly - leading;
        } else if (valign == GXReportPDFCommons.VerticalAlign.TOP.value()) {
            ury += leading / 2.0f;
        }
        rect = new Rectangle(llx, lly, urx, ury);
        ColumnText Col = new ColumnText(cb);
        Col.setRunDirection(runDirection);
        if (linesCount <= 1) {
            Col.setLeading(0.0f, 1.0f);
        } else {
            Col.setLeading(leading, 1.0f);
        }
        Col.setSimpleColumn(rect.getLeft(), rect.getBottom(), rect.getRight(), rect.getTop());
        Col.setAlignment(this.columnAlignment(alignment));
        Col.addText((Phrase)p);
        Col.go();
    }

    private int columnAlignment(int alignment) {
        if (alignment == 3) {
            return this.justifiedType;
        }
        return alignment;
    }

    @Override
    public boolean GxPrintInit(String output, int[] gxXPage, int[] gxYPage, String iniFile, String form, String printer, int mode, int orientation, int pageSize, int pageLength, int pageWidth, int scale, int copies, int defSrc, int quality, int color, int duplex) {
        boolean preResult = super.GxPrintInit(output, gxXPage, gxYPage, iniFile, form, printer, mode, orientation, pageSize, pageLength, pageWidth, scale, copies, defSrc, quality, color, duplex);
        this.runDirection = Integer.valueOf(props.getGeneralProperty("RunDirection"));
        this.justifiedType = props.getBooleanGeneralProperty("JustifiedTypeAll", false) ? 8 : 3;
        this.pageSize = this.computePageSize(this.leftMargin, this.topMargin, pageWidth, pageLength, props.getBooleanGeneralProperty("MarginsInsideBorder", false));
        gxXPage[0] = (int)this.pageSize.getRight();
        gxYPage[0] = props.getBooleanGeneralProperty("FixSac24437", true) ? (int)((double)pageLength / 14.4) : (int)((double)pageLength / 15.45);
        this.document = new Document(this.pageSize, 0.0f, 0.0f, 0.0f, 0.0f);
        this.init();
        if (!preResult) {
            return !preResult;
        }
        return true;
    }

    private Rectangle computePageSize(float leftMargin, float topMargin, int width, int length, boolean marginsInsideBorder) {
        if (leftMargin == 0.0f && topMargin == 0.0f || marginsInsideBorder) {
            if (length == 23818 && width == 16834) {
                return PageSize.A3;
            }
            if (length == 16834 && width == 11909) {
                return PageSize.A4;
            }
            if (length == 11909 && width == 8395) {
                return PageSize.A5;
            }
            if (length == 20016 && width == 5731) {
                return PageSize.B4;
            }
            if (length == 14170 && width == 9979) {
                return PageSize.B5;
            }
            if (length == 15120 && width == 10440) {
                return PageSize.EXECUTIVE;
            }
            if (length == 20160 && width == 12240) {
                return PageSize.LEGAL;
            }
            if (length == 15840 && width == 12240) {
                return PageSize.LETTER;
            }
            return new Rectangle((float)((int)((double)width / 20.0)), (float)((int)((double)length / 20.0)));
        }
        return new Rectangle((float)((int)((double)width / 20.0)) + leftMargin, (float)((int)((double)length / 20.0)) + topMargin);
    }

    @Override
    public void GxEndDocument() {
        if (this.document.getPageNumber() == 0) {
            this.writer.setPageEmpty(false);
        }
        if (this.template != null) {
            this.template.beginText();
            this.template.setFontAndSize(this.templateFont, (float)this.templateFontSize);
            this.template.setTextMatrix(0.0f, 0.0f);
            this.template.setColorFill(this.templateColorFill);
            this.template.showText(String.valueOf(this.pages));
            this.template.endText();
        }
        int copies = 1;
        try {
            PdfName duplexValue;
            copies = Integer.parseInt(this.printerSettings.getProperty(this.form, "Copies"));
            log.debug("Setting number of copies to " + copies);
            this.writer.addViewerPreference(PdfName.NUMCOPIES, (PdfObject)new PdfNumber(copies));
            int duplex = Integer.parseInt(this.printerSettings.getProperty(this.form, "Duplex"));
            switch (duplex) {
                case 1: {
                    duplexValue = PdfName.SIMPLEX;
                    break;
                }
                case 2: {
                    duplexValue = PdfName.DUPLEX;
                    break;
                }
                case 3: {
                    duplexValue = PdfName.DUPLEXFLIPSHORTEDGE;
                    break;
                }
                case 4: {
                    duplexValue = PdfName.DUPLEXFLIPLONGEDGE;
                    break;
                }
                default: {
                    duplexValue = PdfName.NONE;
                }
            }
            log.debug("Setting duplex to " + duplexValue.toString());
            this.writer.addViewerPreference(PdfName.DUPLEX, (PdfObject)duplexValue);
        }
        catch (Exception ex) {
            log.error("GxEndDocument failed to apply viewer preferences: ", (Throwable)ex);
        }
        String serverPrinting = props.getGeneralProperty("ServerPrinting");
        boolean fit = props.getGeneralProperty("AdjustToPaper").equals("true");
        if ((this.outputType == 1 || this.outputType == 4) && this.httpContext instanceof HttpContextWeb && serverPrinting.equals("false")) {
            this.writer.addJavaScript("var pp = this.getPrintParams();\n");
            String printerAux = this.printerSettings.getProperty(this.form, "Printer");
            String printer = PDFReportItext2.replace(printerAux, "\\", "\\\\");
            if (printer != null && !printer.equals("")) {
                this.writer.addJavaScript("pp.printerName = \"" + printer + "\";\n");
            }
            if (fit) {
                this.writer.addJavaScript("pp.pageHandling = pp.constants.handling.fit;\n");
            } else {
                this.writer.addJavaScript("pp.pageHandling = pp.constants.handling.none;\n");
            }
            if (this.printerSettings.getProperty(this.form, "Mode", "3").startsWith("0")) {
                this.writer.addJavaScript("pp.interactive = pp.constants.interactionLevel.automatic;\n");
                for (int i = 0; i < copies; ++i) {
                    this.writer.addJavaScript("this.print(pp);\n");
                }
            } else {
                this.writer.addJavaScript("pp.interactive = pp.constants.interactionLevel.full;\n");
                this.writer.addJavaScript("this.print(pp);\n");
            }
        }
        this.document.close();
        log.debug("GxEndDocument!");
        try {
            props.save();
        }
        catch (IOException printerAux) {
            // empty catch block
        }
        switch (this.outputType) {
            case 0: {
                try {
                    this.outputStream.close();
                }
                catch (IOException printerAux) {
                    // empty catch block
                }
                try {
                    PDFReportItext2.showReport(this.docName, this.modal);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 1: {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    if (this.httpContext instanceof HttpContextWeb && serverPrinting.equals("false")) break;
                    PDFReportItext2.printReport(this.docName, this.printerOutputMode == 1);
                }
                catch (Exception e) {
                    log.error("GxEndDocument: failed to show report ", (Throwable)e);
                }
                break;
            }
            case 2: {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    log.error("GxEndDocument: failed to save report to file ", (Throwable)e);
                }
                break;
            }
        }
        this.outputStream = null;
    }

    @Override
    public void GxStartPage() {
        boolean ret = this.document.newPage();
        ++this.pages;
    }

    static {
        log = LogManager.getLogger(PDFReportItext2.class);
    }
}

