/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.reports;

import com.genexus.CommonUtil;
import com.genexus.ModelContext;
import com.genexus.platform.NativeFunctions;
import com.genexus.reports.Const;
import com.genexus.reports.GXReportPDFCommons;
import com.genexus.reports.fonts.PDFFont;
import com.genexus.reports.fonts.PDFFontDescriptor;
import com.genexus.reports.fonts.Type1FontMetrics;
import com.genexus.webpanels.HttpContextWeb;
import com.itextpdf.barcodes.Barcode128;
import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.html2pdf.resolver.font.DefaultFontProvider;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfViewerPreferences;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.Style;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.properties.TextAlignment;
import com.itextpdf.layout.properties.VerticalAlignment;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.splitting.DefaultSplitCharacters;
import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;

public class PDFReportItext8
extends GXReportPDFCommons {
    private PageSize pageSize = null;
    private PdfFont baseFont;
    private Barcode128 barcode = null;
    private Document document = null;
    private PdfDocument pdfDocument = null;
    private PdfPage pdfPage;
    private PdfWriter writer;
    private PdfFormXObject template;
    private PdfFont templateFont;
    public boolean lineCapProjectingSquare = true;
    public boolean barcode128AsImage = true;
    ConcurrentHashMap<String, com.itextpdf.layout.element.Image> documentImages = new ConcurrentHashMap();
    float DEFAULT_LEADING_FACTOR = 1.2f;

    public PDFReportItext8(ModelContext context) {
        super(context);
    }

    @Override
    protected void init() {
        try {
            this.writer = new PdfWriter(this.outputStream);
            this.writer.setCompressionLevel(9);
            this.pdfDocument = new PdfDocument(this.writer);
            this.pdfDocument.setDefaultPageSize(this.pageSize);
            this.document = new Document(this.pdfDocument);
            this.document.setFontProvider((FontProvider)new DefaultFontProvider());
        }
        catch (Exception e) {
            log.error("Failed to initialize new iText7 document: ", (Throwable)e);
        }
    }

    private void drawRectangle(PdfCanvas cb, float x, float y, float w, float h, int styleTop, int styleBottom, int styleRight, int styleLeft, float radioTL, float radioTR, float radioBL, float radioBR, float penAux, boolean hideCorners) {
        try {
            float[] dashPatternTop = this.getDashedPattern(styleTop);
            float[] dashPatternBottom = this.getDashedPattern(styleBottom);
            float[] dashPatternLeft = this.getDashedPattern(styleLeft);
            float[] dashPatternRight = this.getDashedPattern(styleRight);
            if (styleBottom != this.STYLE_NONE_CONST) {
                cb.setLineDash(dashPatternBottom, 0.0f);
            }
            float b = 0.4477f;
            if (radioBL > 0.0f) {
                cb.moveTo((double)(x + radioBL), (double)y);
            } else if (hideCorners && styleLeft == this.STYLE_NONE_CONST && radioBL == 0.0f) {
                cb.moveTo((double)(x + penAux), (double)y);
            } else {
                cb.moveTo((double)x, (double)y);
            }
            if (styleBottom != this.STYLE_NONE_CONST) {
                if (hideCorners && styleRight == this.STYLE_NONE_CONST && radioBR == 0.0f) {
                    cb.lineTo((double)(x + w - penAux), (double)y);
                } else {
                    cb.lineTo((double)(x + w - radioBR), (double)y);
                }
                if (radioBR > 0.0f && styleRight != this.STYLE_NONE_CONST) {
                    cb.curveTo((double)(x + w - radioBR * b), (double)y, (double)(x + w), (double)(y + radioBR * b), (double)(x + w), (double)(y + radioBR));
                }
            }
            if (styleRight != this.STYLE_NONE_CONST && dashPatternRight != dashPatternBottom) {
                cb.stroke();
                cb.setLineDash(dashPatternRight, 0.0f);
                if (hideCorners && styleBottom == this.STYLE_NONE_CONST && radioBR == 0.0f) {
                    cb.moveTo((double)(x + w), (double)(y + penAux));
                } else {
                    cb.moveTo((double)(x + w), (double)(y + radioBR));
                }
            }
            if (styleRight != this.STYLE_NONE_CONST) {
                if (hideCorners && styleTop == this.STYLE_NONE_CONST && radioTR == 0.0f) {
                    cb.lineTo((double)(x + w), (double)(y + h - penAux));
                } else {
                    cb.lineTo((double)(x + w), (double)(y + h - radioTR));
                }
                if (radioTR > 0.0f && styleTop != this.STYLE_NONE_CONST) {
                    cb.curveTo((double)(x + w), (double)(y + h - radioTR * b), (double)(x + w - radioTR * b), (double)(y + h), (double)(x + w - radioTR), (double)(y + h));
                }
            }
            if (styleTop != this.STYLE_NONE_CONST && dashPatternTop != dashPatternRight) {
                cb.stroke();
                cb.setLineDash(dashPatternTop, 0.0f);
                if (hideCorners && styleRight == this.STYLE_NONE_CONST && radioTR == 0.0f) {
                    cb.moveTo((double)(x + w - penAux), (double)(y + h));
                } else {
                    cb.moveTo((double)(x + w - radioTR), (double)(y + h));
                }
            }
            if (styleTop != this.STYLE_NONE_CONST) {
                if (hideCorners && styleLeft == this.STYLE_NONE_CONST && radioTL == 0.0f) {
                    cb.lineTo((double)(x + penAux), (double)(y + h));
                } else {
                    cb.lineTo((double)(x + radioTL), (double)(y + h));
                }
                if (radioTL > 0.0f && styleLeft != this.STYLE_NONE_CONST) {
                    cb.curveTo((double)(x + radioTL * b), (double)(y + h), (double)x, (double)(y + h - radioTL * b), (double)x, (double)(y + h - radioTL));
                }
            }
            if (styleLeft != this.STYLE_NONE_CONST && dashPatternLeft != dashPatternTop) {
                cb.stroke();
                cb.setLineDash(dashPatternLeft, 0.0f);
                if (hideCorners && styleTop == this.STYLE_NONE_CONST && radioTL == 0.0f) {
                    cb.moveTo((double)x, (double)(y + h - penAux));
                } else {
                    cb.moveTo((double)x, (double)(y + h - radioTL));
                }
            }
            if (styleLeft != this.STYLE_NONE_CONST) {
                if (hideCorners && styleBottom == this.STYLE_NONE_CONST && radioBL == 0.0f) {
                    cb.lineTo((double)x, (double)(y + penAux));
                } else {
                    cb.lineTo((double)x, (double)(y + radioBL));
                }
                if (radioBL > 0.0f && styleBottom != this.STYLE_NONE_CONST) {
                    cb.curveTo((double)x, (double)(y + radioBL * b), (double)(x + radioBL * b), (double)y, (double)(x + radioBL), (double)y);
                }
            }
            cb.stroke();
        }
        catch (Exception e) {
            log.error("drawRectangle failed: ", (Throwable)e);
        }
    }

    private void roundRectangle(PdfCanvas cb, float x, float y, float w, float h, float radioTL, float radioTR, float radioBL, float radioBR) {
        try {
            float b = 0.4477f;
            if (radioBL > 0.0f) {
                cb.moveTo((double)(x + radioBL), (double)y);
            } else {
                cb.moveTo((double)x, (double)y);
            }
            cb.lineTo((double)(x + w - radioBR), (double)y);
            if (radioBR > 0.0f) {
                cb.curveTo((double)(x + w - radioBR * b), (double)y, (double)(x + w), (double)(y + radioBR * b), (double)(x + w), (double)(y + radioBR));
            }
            cb.lineTo((double)(x + w), (double)(y + h - radioTR));
            if (radioTR > 0.0f) {
                cb.curveTo((double)(x + w), (double)(y + h - radioTR * b), (double)(x + w - radioTR * b), (double)(y + h), (double)(x + w - radioTR), (double)(y + h));
            }
            cb.lineTo((double)(x + radioTL), (double)(y + h));
            if (radioTL > 0.0f) {
                cb.curveTo((double)(x + radioTL * b), (double)(y + h), (double)x, (double)(y + h - radioTL * b), (double)x, (double)(y + h - radioTL));
            }
            cb.lineTo((double)x, (double)(y + radioBL));
            if (radioBL > 0.0f) {
                cb.curveTo((double)x, (double)(y + radioBL * b), (double)(x + radioBL * b), (double)y, (double)(x + radioBL), (double)y);
            }
        }
        catch (Exception e) {
            log.error("drawRectangle failed: ", (Throwable)e);
        }
    }

    @Override
    public void GxDrawRect(int left, int top, int right, int bottom, int pen, int foreRed, int foreGreen, int foreBlue, int backMode, int backRed, int backGreen, int backBlue, int styleTop, int styleBottom, int styleRight, int styleLeft, int cornerRadioTL, int cornerRadioTR, int cornerRadioBL, int cornerRadioBR) {
        try {
            PdfCanvas cb = new PdfCanvas(this.pdfPage);
            float penAux = (float)this.convertScale(pen);
            float rightAux = (float)this.convertScale(right);
            float bottomAux = (float)this.convertScale(bottom);
            float leftAux = (float)this.convertScale(left);
            float topAux = (float)this.convertScale(top);
            cb.saveState();
            float x1 = leftAux + this.leftMargin;
            float y1 = this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin;
            float x2 = rightAux + this.leftMargin;
            float y2 = this.pageSize.getTop() - topAux - this.topMargin - this.bottomMargin;
            cb.setLineWidth(penAux);
            cb.setLineCapStyle(2);
            if (cornerRadioBL == 0 && cornerRadioBR == 0 && cornerRadioTL == 0 && cornerRadioTR == 0 && styleBottom == 0 && styleLeft == 0 && styleRight == 0 && styleTop == 0) {
                cb.setStrokeColorRgb((float)foreRed, (float)foreGreen, (float)foreBlue);
                Rectangle rect = new Rectangle(x1, y1, x2 - x1, y2 - y1);
                rect.increaseHeight((float)((double)this.fontSize * 0.15));
                rect.increaseWidth((float)((double)this.fontSize * 0.15));
                cb.rectangle(rect);
                if (backMode != 0) {
                    cb.setFillColorRgb((float)backRed, (float)backGreen, (float)backBlue);
                    cb.fill();
                } else {
                    cb.stroke();
                }
            } else {
                float w = x2 - x1;
                float h = y2 - y1;
                if (w < 0.0f) {
                    x1 += w;
                    w = -w;
                }
                if (h < 0.0f) {
                    y1 += h;
                    h = -h;
                }
                float cRadioTL = (float)this.convertScale(cornerRadioTL);
                float cRadioTR = (float)this.convertScale(cornerRadioTR);
                float cRadioBL = (float)this.convertScale(cornerRadioBL);
                float cRadioBR = (float)this.convertScale(cornerRadioBR);
                int max = (int)Math.min(w, h);
                cRadioTL = Math.max(0.0f, Math.min(cRadioTL, (float)(max / 2)));
                cRadioTR = Math.max(0.0f, Math.min(cRadioTR, (float)(max / 2)));
                cRadioBL = Math.max(0.0f, Math.min(cRadioBL, (float)(max / 2)));
                cRadioBR = Math.max(0.0f, Math.min(cRadioBR, (float)(max / 2)));
                if (backMode != 0) {
                    cb.setFillColorRgb((float)backRed, (float)backGreen, (float)backBlue);
                    cb.setStrokeColorRgb((float)foreRed, (float)foreGreen, (float)foreBlue);
                    cb.setLineWidth(0.0f);
                    this.roundRectangle(cb, x1, y1, w, h, cRadioTL, cRadioTR, cRadioBL, cRadioBR);
                    cb.setFillColor((com.itextpdf.kernel.colors.Color)new DeviceRgb(new Color(backRed, backGreen, backBlue)));
                    cb.fillStroke();
                    cb.setLineWidth(penAux);
                }
                if (pen > 0) {
                    cb.setFillColorRgb((float)foreRed, (float)foreGreen, (float)foreBlue);
                    cb.setStrokeColorRgb((float)foreRed, (float)foreGreen, (float)foreBlue);
                    this.drawRectangle(cb, x1, y1, w, h, styleTop, styleBottom, styleRight, styleLeft, cRadioTL, cRadioTR, cRadioBL, cRadioBR, penAux, false);
                }
            }
            cb.restoreState();
        }
        catch (Exception e) {
            log.error("GxDrawRect failed: ", (Throwable)e);
        }
        log.debug("GxDrawRect -> (" + left + "," + top + ") - (" + right + "," + bottom + ")  BackMode: " + backMode + " Pen:" + pen);
    }

    @Override
    public void GxDrawLine(int left, int top, int right, int bottom, int width, int foreRed, int foreGreen, int foreBlue, int style) {
        try {
            PdfCanvas cb = new PdfCanvas(this.pdfPage);
            float widthAux = (float)this.convertScale(width);
            float rightAux = (float)this.convertScale(right);
            float bottomAux = (float)this.convertScale(bottom);
            float leftAux = (float)this.convertScale(left);
            float topAux = (float)this.convertScale(top);
            log.debug("GxDrawLine -> (" + left + "," + top + ") - (" + right + "," + bottom + ") Width: " + width);
            float x1 = leftAux + this.leftMargin;
            float y1 = this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin;
            float x2 = rightAux + this.leftMargin;
            float y2 = this.pageSize.getTop() - topAux - this.topMargin - this.bottomMargin;
            cb.saveState();
            cb.setFillColorRgb((float)foreRed, (float)foreGreen, (float)foreBlue);
            cb.setLineWidth(widthAux);
            if (this.lineCapProjectingSquare) {
                cb.setLineCapStyle(2);
            }
            if (style != 0) {
                float[] dashPattern = this.getDashedPattern(style);
                cb.setLineDash(dashPattern, 0.0f);
            }
            cb.moveTo((double)x1, (double)y1);
            cb.lineTo((double)x2, (double)y2);
            cb.stroke();
            cb.restoreState();
        }
        catch (Exception e) {
            log.error("GxDrawLine failed:", (Throwable)e);
        }
    }

    @Override
    public void GxDrawBitMap(String bitmap, int left, int top, int right, int bottom, int aspectRatio) {
        try {
            ImageData imageData;
            try {
                if (this.documentImages != null && this.documentImages.containsKey(bitmap)) {
                    imageData = ImageDataFactory.create((String)bitmap);
                } else {
                    if (!NativeFunctions.isWindows() && new File(bitmap).isAbsolute() && bitmap.startsWith(this.httpContext.getStaticContentBase())) {
                        bitmap = bitmap.replace(this.httpContext.getStaticContentBase(), "");
                    }
                    if (!(new File(bitmap).isAbsolute() || bitmap.toLowerCase().startsWith("http:") || bitmap.toLowerCase().startsWith("https:"))) {
                        if (bitmap.startsWith(this.httpContext.getStaticContentBase())) {
                            bitmap = bitmap.replace(this.httpContext.getStaticContentBase(), "");
                        }
                        if ((imageData = ImageDataFactory.create((String)(defaultRelativePrepend + bitmap))) == null) {
                            bitmap = webAppDir + bitmap;
                            imageData = ImageDataFactory.create((String)bitmap);
                        } else {
                            bitmap = defaultRelativePrepend + bitmap;
                        }
                    } else {
                        imageData = ImageDataFactory.create((String)bitmap);
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                URL url = new URL(bitmap);
                imageData = ImageDataFactory.create((URL)url);
            }
            if (this.documentImages == null) {
                this.documentImages = new ConcurrentHashMap();
            }
            this.documentImages.putIfAbsent(bitmap, new com.itextpdf.layout.element.Image(imageData));
            log.debug("GxDrawBitMap -> '" + bitmap + "' [" + left + "," + top + "] - Size: (" + (right - left) + "," + (bottom - top) + ")");
            if (imageData != null) {
                float rightAux = (float)this.convertScale(right);
                float bottomAux = (float)this.convertScale(bottom);
                float leftAux = (float)this.convertScale(left);
                float topAux = (float)this.convertScale(top);
                com.itextpdf.layout.element.Image image = new com.itextpdf.layout.element.Image(imageData);
                image.setFixedPosition(this.page, leftAux + this.leftMargin, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin);
                if (aspectRatio == 0) {
                    image.scaleAbsolute(rightAux - leftAux, bottomAux - topAux);
                } else {
                    image.scaleToFit(rightAux - leftAux, bottomAux - topAux);
                }
                this.document.add(image);
            }
        }
        catch (IOException ioe) {
            log.error("GxDrawBitMap failed:", (Throwable)ioe);
        }
        catch (Exception e) {
            log.error("GxDrawBitMap failed:", (Throwable)e);
        }
    }

    @Override
    public void GxAttris(String fontName, int fontSize, boolean fontBold, boolean fontItalic, boolean fontUnderline, boolean fontStrikethru, int Pen, int foreRed, int foreGreen, int foreBlue, int backMode, int backRed, int backGreen, int backBlue) {
        boolean isCJK = false;
        boolean embeddedFont = this.isEmbeddedFont(fontName);
        String originalFontName = fontName;
        if (!embeddedFont) {
            fontName = this.getSubstitute(fontName);
        }
        String fontSubstitute = "";
        if (!originalFontName.equals(fontName)) {
            fontSubstitute = "Original Font: " + originalFontName + " Substitute";
        }
        log.debug("GxAttris: ");
        log.debug("\\-> " + fontSubstitute + "Font: " + fontName + " (" + fontSize + ")" + (fontBold ? " BOLD" : "") + (fontItalic ? " ITALIC" : "") + (fontStrikethru ? " Strike" : ""));
        log.debug("\\-> Fore (" + foreRed + ", " + foreGreen + ", " + foreBlue + ")");
        log.debug("\\-> Back (" + backRed + ", " + backGreen + ", " + backBlue + ")");
        if (this.barcode128AsImage && fontName.toLowerCase().indexOf("barcode 128") >= 0 || fontName.toLowerCase().indexOf("barcode128") >= 0) {
            this.barcode = new Barcode128(this.pdfDocument);
            this.barcode.setCodeType(1);
        } else {
            this.barcode = null;
        }
        this.fontUnderline = fontUnderline;
        this.fontStrikethru = fontStrikethru;
        this.fontSize = fontSize;
        this.fontBold = fontBold;
        this.fontItalic = fontItalic;
        this.foreColor = new Color(foreRed, foreGreen, foreBlue);
        this.backColor = new Color(backRed, backGreen, backBlue);
        this.backFill = backMode != 0;
        try {
            if (PDFFont.isType1(fontName)) {
                for (int i = 0; i < Type1FontMetrics.CJKNames.length; ++i) {
                    if (!Type1FontMetrics.CJKNames[i][0].equalsIgnoreCase(fontName) && !Type1FontMetrics.CJKNames[i][1].equalsIgnoreCase(fontName)) continue;
                    String style = "";
                    if (fontBold && fontItalic) {
                        style = "BoldItalic";
                    } else {
                        if (fontItalic) {
                            style = "Italic";
                        }
                        if (fontBold) {
                            style = "Bold";
                        }
                    }
                    this.setAsianFont(fontName, style);
                    isCJK = true;
                    break;
                }
                if (!isCJK) {
                    int style = 0;
                    if (fontBold && fontItalic) {
                        style += 3;
                    } else if (fontItalic) {
                        style += 2;
                    } else if (fontBold) {
                        ++style;
                    }
                    for (int i = 0; i < PDFFont.base14.length; ++i) {
                        if (!PDFFont.base14[i][0].equalsIgnoreCase(fontName)) continue;
                        fontName = PDFFont.base14[i][1 + style].substring(1);
                        break;
                    }
                    this.baseFont = PdfFontFactory.createFont((String)fontName, (String)"Cp1252", (PdfFontFactory.EmbeddingStrategy)PdfFontFactory.EmbeddingStrategy.PREFER_NOT_EMBEDDED);
                }
            } else {
                String fontPath = this.getFontLocation(fontName);
                this.baseFont = fontPath.equals("") ? ((fontPath = PDFFontDescriptor.getTrueTypeFontLocation(fontName, props)).equals("") ? PdfFontFactory.createFont((String)"Helvetica", (String)"Cp1252", (PdfFontFactory.EmbeddingStrategy)PdfFontFactory.EmbeddingStrategy.PREFER_NOT_EMBEDDED) : PdfFontFactory.createFont((String)fontPath, (String)"Cp1252", (PdfFontFactory.EmbeddingStrategy)PdfFontFactory.EmbeddingStrategy.PREFER_NOT_EMBEDDED)) : PdfFontFactory.createFont((String)fontPath, (String)"Identity-H", (PdfFontFactory.EmbeddingStrategy)PdfFontFactory.EmbeddingStrategy.PREFER_EMBEDDED);
            }
            this.document.getFontProvider().addFont(this.baseFont.getFontProgram());
        }
        catch (IOException ioe) {
            log.error("GxAttris failed: ", (Throwable)ioe);
        }
    }

    @Override
    public void setAsianFont(String fontName, String style) {
        try {
            if (fontName.equals("Japanese")) {
                this.baseFont = PdfFontFactory.createFont((String)("HeiseiMin-W3," + style), (String)"UniJIS-UCS2-HW-H", (PdfFontFactory.EmbeddingStrategy)PdfFontFactory.EmbeddingStrategy.PREFER_EMBEDDED);
            }
            if (fontName.equals("Japanese2")) {
                this.baseFont = PdfFontFactory.createFont((String)("HeiseiKakuGo-W5," + style), (String)"UniJIS-UCS2-H", (PdfFontFactory.EmbeddingStrategy)PdfFontFactory.EmbeddingStrategy.PREFER_EMBEDDED);
            }
            if (fontName.equals("SimplifiedChinese")) {
                this.baseFont = PdfFontFactory.createFont((String)("STSong-Light," + style), (String)"UniGB-UCS2-H", (PdfFontFactory.EmbeddingStrategy)PdfFontFactory.EmbeddingStrategy.PREFER_EMBEDDED);
            }
            if (fontName.equals("TraditionalChinese")) {
                this.baseFont = PdfFontFactory.createFont((String)("MHei-Medium," + style), (String)"UniCNS-UCS2-H", (PdfFontFactory.EmbeddingStrategy)PdfFontFactory.EmbeddingStrategy.PREFER_EMBEDDED);
            }
            if (fontName.equals("Korean")) {
                this.baseFont = PdfFontFactory.createFont((String)("HYSMyeongJo-Medium," + style), (String)"UniKS-UCS2-H", (PdfFontFactory.EmbeddingStrategy)PdfFontFactory.EmbeddingStrategy.PREFER_EMBEDDED);
            }
        }
        catch (IOException ioe) {
            log.error("setAsianFont failed: ", (Throwable)ioe);
        }
    }

    @Override
    public void GxDrawText(String sTxt, int left, int top, int right, int bottom, int align, int htmlformat, int border, int valign) {
        boolean autoResize;
        boolean printRectangle = false;
        if (props.getBooleanGeneralProperty("BackFillInControls", true)) {
            printRectangle = true;
        }
        if (printRectangle && (border == 1 || this.backFill)) {
            this.GxDrawRect(left, top, right, bottom, border, this.foreColor.getRed(), this.foreColor.getGreen(), this.foreColor.getBlue(), this.backFill ? 1 : 0, this.backColor.getRed(), this.backColor.getGreen(), this.backColor.getBlue(), 0, 0);
        }
        PdfCanvas cb = new PdfCanvas(this.pdfPage);
        sTxt = CommonUtil.rtrim((String)sTxt);
        PdfFont font = this.baseFont;
        cb.setFontAndSize(this.baseFont, (float)this.fontSize);
        cb.setFillColor((com.itextpdf.kernel.colors.Color)new DeviceRgb(this.foreColor));
        float captionHeight = this.baseFont.getAscent(sTxt, (float)this.fontSize) / 1000.0f;
        float rectangleWidth = this.baseFont.getWidth(sTxt, (float)this.fontSize);
        float lineHeight = 0.0f * (this.baseFont.getAscent(sTxt, (float)this.fontSize) - this.baseFont.getDescent(sTxt, (float)this.fontSize)) + (float)this.fontSize * this.DEFAULT_LEADING_FACTOR;
        float textBlockHeight = (float)this.convertScale(bottom - top);
        int linesCount = (int)(textBlockHeight / lineHeight);
        int bottomOri = bottom;
        int topOri = top;
        if (linesCount >= 2 && (align & 0x10) != 16 && htmlformat != 1) {
            if (valign == GXReportPDFCommons.VerticalAlign.TOP.value()) {
                bottom = top + (int)this.reconvertScale(lineHeight);
            } else if (valign == GXReportPDFCommons.VerticalAlign.BOTTOM.value()) {
                top = bottom - (int)this.reconvertScale(lineHeight);
            }
        }
        float bottomAux = (float)this.convertScale(bottom) - ((float)this.convertScale(bottom - top) - captionHeight) / 2.0f;
        float leftAux = (float)this.convertScale(left);
        float rightAux = (float)this.convertScale(right);
        int alignment = align & 3;
        boolean bl = autoResize = (align & 0x100) == 256;
        if (htmlformat == 1) {
            log.debug("As of now, you might experience unexpected behaviour since not all possible HTML code is supported");
            try {
                bottomAux = (float)this.convertScale(bottom);
                float topAux = (float)this.convertScale(top);
                float drawingPageHeight = this.pageSize.getTop() - this.topMargin - this.bottomMargin;
                float llx = leftAux + this.leftMargin;
                float lly = drawingPageHeight - bottomAux;
                float urx = rightAux + this.leftMargin;
                float ury = drawingPageHeight - topAux;
                Rectangle htmlRectangle = new Rectangle(llx, lly, urx - llx, ury - lly);
                YPosition yPosition = new YPosition(htmlRectangle.getTop());
                ConverterProperties converterProperties = new ConverterProperties();
                converterProperties.setFontProvider(this.document.getFontProvider());
                List elements = HtmlConverter.convertToElements((String)sTxt, (ConverterProperties)converterProperties);
                for (IElement element : elements) {
                    this.processHTMLElement(htmlRectangle, yPosition, (IBlockElement)element);
                }
            }
            catch (Exception e) {
                log.error("GxDrawText failed to print HTML text : ", (Throwable)e);
            }
        } else if (this.barcode != null) {
            log.debug("Barcode: --> " + this.barcode.getClass().getName());
            try {
                this.barcode.setCode(sTxt);
                this.barcode.setTextAlignment(alignment);
                Rectangle rectangle = new Rectangle(0.0f, 0.0f);
                switch (alignment) {
                    case 1: {
                        rectangle = new Rectangle((leftAux + rightAux) / 2.0f + this.leftMargin - rectangleWidth / 2.0f, this.pageSize.getTop() - (float)this.convertScale(bottom) - this.topMargin - this.bottomMargin, Math.abs((leftAux + rightAux) / 2.0f + this.leftMargin + rectangleWidth / 2.0f - ((leftAux + rightAux) / 2.0f + this.leftMargin - rectangleWidth / 2.0f)), Math.abs(this.pageSize.getTop() - (float)this.convertScale(top) - this.topMargin - this.bottomMargin - (this.pageSize.getTop() - (float)this.convertScale(bottom) - this.topMargin - this.bottomMargin)));
                        break;
                    }
                    case 2: {
                        rectangle = new Rectangle(rightAux + this.leftMargin - rectangleWidth, this.pageSize.getTop() - (float)this.convertScale(bottom) - this.topMargin - this.bottomMargin, Math.abs(rightAux + this.leftMargin - (rightAux + this.leftMargin - rectangleWidth)), Math.abs(this.pageSize.getTop() - (float)this.convertScale(top) - this.topMargin - this.bottomMargin - (this.pageSize.getTop() - (float)this.convertScale(bottom) - this.topMargin - this.bottomMargin)));
                        break;
                    }
                    case 0: {
                        rectangle = new Rectangle(leftAux + this.leftMargin, this.pageSize.getTop() - (float)this.convertScale(bottom) - this.topMargin - this.bottomMargin, Math.abs(leftAux + this.leftMargin + rectangleWidth - (leftAux + this.leftMargin)), Math.abs(this.pageSize.getTop() - (float)this.convertScale(top) - this.topMargin - this.bottomMargin - (this.pageSize.getTop() - (float)this.convertScale(bottom) - this.topMargin - this.bottomMargin)));
                    }
                }
                this.barcode.setAltText("");
                this.barcode.setBaseline(0.0f);
                if (this.fontSize < Const.LARGE_FONT_SIZE) {
                    this.barcode.setX(Const.OPTIMAL_MINIMU_BAR_WIDTH_SMALL_FONT);
                } else {
                    this.barcode.setX(Const.OPTIMAL_MINIMU_BAR_WIDTH_LARGE_FONT);
                }
                com.itextpdf.layout.element.Image imageCode = new com.itextpdf.layout.element.Image(ImageDataFactory.create((Image)this.barcode.createAwtImage(this.backFill ? this.backColor : null, this.foreColor), (Color)this.foreColor));
                imageCode.setFixedPosition(leftAux + this.leftMargin, rectangle.getBottom());
                this.barcode.setBarHeight(rectangle.getHeight());
                imageCode.scaleToFit(rectangle.getWidth(), rectangle.getHeight());
                this.document.add(imageCode);
            }
            catch (Exception ex) {
                log.error("GxDrawText: Error generating Barcode " + this.barcode.getClass().getName(), (Throwable)ex);
            }
        } else {
            if (sTxt.trim().equalsIgnoreCase("{{Pages}}")) {
                if (!this.templateCreated) {
                    this.template = new PdfFormXObject(new Rectangle((float)(right - left), (float)(bottom - top)));
                    this.templateCreated = true;
                }
                cb.addXObjectAt((PdfXObject)this.template, leftAux + this.leftMargin, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin);
                this.templateFont = this.baseFont;
                this.templateFontSize = this.fontSize;
                this.templateColorFill = this.foreColor;
                return;
            }
            float textBlockWidth = rightAux - leftAux;
            float TxtWidth = this.baseFont.getWidth(sTxt, (float)this.fontSize);
            boolean justified = alignment == 3 && textBlockWidth < TxtWidth;
            boolean wrap = (align & 0x10) == 16;
            float leading = (float)Double.valueOf(props.getGeneralProperty("Leading")).doubleValue();
            Style style = new Style();
            if (this.fontBold) {
                style.setBold();
            }
            if (this.fontItalic) {
                style.setItalic();
            }
            if (this.fontStrikethru) {
                style.setUnderline((float)(this.fontSize / 6), (float)(this.fontSize / 2));
            }
            if (this.fontUnderline) {
                style.setUnderline((float)(this.fontSize / 6), 0.0f);
            }
            style.setFont(font);
            style.setFontSize((float)this.fontSize);
            style.setFontColor((com.itextpdf.kernel.colors.Color)new DeviceRgb(this.foreColor));
            if (wrap || justified) {
                bottomAux = (float)this.convertScale(bottomOri);
                float topAux = (float)this.convertScale(topOri);
                float llx = leftAux + this.leftMargin;
                float lly = this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin;
                float urx = rightAux + this.leftMargin;
                float ury = this.pageSize.getTop() - topAux - this.topMargin - this.bottomMargin;
                this.DrawTextColumn(llx, lly, urx, ury, leading, sTxt, valign, alignment, style, wrap);
            } else {
                try {
                    if (!autoResize) {
                        String newsTxt = sTxt;
                        while (TxtWidth > textBlockWidth && newsTxt.length() - 1 >= 0) {
                            sTxt = newsTxt;
                            newsTxt = newsTxt.substring(0, newsTxt.length() - 1);
                            TxtWidth = this.baseFont.getWidth(newsTxt, (float)this.fontSize);
                        }
                    }
                    Paragraph p = new Paragraph(sTxt);
                    p.addStyle(style);
                    switch (alignment) {
                        case 1: {
                            this.document.showTextAligned(p, (leftAux + rightAux) / 2.0f + this.leftMargin, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin, this.page, TextAlignment.CENTER, VerticalAlignment.MIDDLE, 0.0f);
                            break;
                        }
                        case 2: {
                            this.document.showTextAligned(p, rightAux + this.leftMargin, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin, this.page, TextAlignment.RIGHT, VerticalAlignment.MIDDLE, 0.0f);
                            break;
                        }
                        case 0: 
                        case 3: {
                            this.document.showTextAligned(p, leftAux + this.leftMargin, this.pageSize.getTop() - bottomAux - this.topMargin - this.bottomMargin, this.page, TextAlignment.LEFT, VerticalAlignment.MIDDLE, 0.0f);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("GxDrawText failed to draw simple text: ", (Throwable)e);
                }
            }
        }
    }

    void processHTMLElement(Rectangle htmlRectangle, YPosition currentYPosition, IBlockElement blockElement) {
        float availableSpace;
        float blockElementHeight;
        if (blockElement instanceof Div) {
            Div div = (Div)blockElement;
            for (IElement child : div.getChildren()) {
                if (!(child instanceof IBlockElement)) continue;
                this.processHTMLElement(htmlRectangle, currentYPosition, (IBlockElement)child);
            }
        }
        if ((blockElementHeight = this.getBlockElementHeight(blockElement, htmlRectangle)) > (availableSpace = currentYPosition.getCurrentYPosition() - htmlRectangle.getBottom())) {
            log.error("You are trying to render an element of height " + blockElementHeight + " in a space of height " + availableSpace);
            return;
        }
        if (blockElement instanceof Paragraph) {
            Paragraph p = (Paragraph)blockElement;
            p.setFixedPosition(this.page, htmlRectangle.getX(), currentYPosition.getCurrentYPosition() - blockElementHeight, htmlRectangle.getWidth());
            this.document.add((IBlockElement)p);
        } else if (blockElement instanceof Table) {
            Table table = (Table)blockElement;
            table.setFixedPosition(this.page, htmlRectangle.getX(), currentYPosition.getCurrentYPosition() - blockElementHeight, htmlRectangle.getWidth());
            this.document.add((IBlockElement)table);
        } else if (blockElement instanceof com.itextpdf.layout.element.List) {
            com.itextpdf.layout.element.List list = (com.itextpdf.layout.element.List)blockElement;
            list.setFixedPosition(this.page, htmlRectangle.getX(), currentYPosition.getCurrentYPosition() - blockElementHeight, htmlRectangle.getWidth());
            this.document.add((IBlockElement)list);
        }
        currentYPosition.setCurrentYPosition(currentYPosition.getCurrentYPosition() - blockElementHeight);
    }

    private float getBlockElementHeight(IBlockElement blockElement, Rectangle htmlRectangle) throws RuntimeException {
        if (blockElement instanceof Paragraph) {
            Paragraph p = (Paragraph)blockElement;
            return p.createRendererSubTree().setParent((IRenderer)this.document.getRenderer()).layout(new LayoutContext(new LayoutArea(this.page, htmlRectangle))).getOccupiedArea().getBBox().getHeight();
        }
        if (blockElement instanceof Table) {
            Table table = (Table)blockElement;
            return table.createRendererSubTree().setParent((IRenderer)this.document.getRenderer()).layout(new LayoutContext(new LayoutArea(this.page, htmlRectangle))).getOccupiedArea().getBBox().getHeight();
        }
        if (blockElement instanceof com.itextpdf.layout.element.List) {
            com.itextpdf.layout.element.List list = (com.itextpdf.layout.element.List)blockElement;
            return list.createRendererSubTree().setParent((IRenderer)this.document.getRenderer()).layout(new LayoutContext(new LayoutArea(this.page, htmlRectangle))).getOccupiedArea().getBBox().getHeight();
        }
        if (blockElement instanceof Div) {
            Div div = (Div)blockElement;
            return div.createRendererSubTree().setParent((IRenderer)this.document.getRenderer()).layout(new LayoutContext(new LayoutArea(this.page, htmlRectangle))).getOccupiedArea().getBBox().getHeight();
        }
        throw new RuntimeException("getBlockElementHeight failed, you might be trying to render something that is not a <p>, <table> or a <li>");
    }

    @Override
    boolean pageHeightExceeded(float bottomAux, float drawingPageHeight) {
        return super.pageHeightExceeded(bottomAux, drawingPageHeight);
    }

    private TextAlignment getTextAlignment(int alignment) {
        switch (alignment) {
            case 1: {
                return TextAlignment.CENTER;
            }
            case 2: {
                return TextAlignment.RIGHT;
            }
            case 0: 
            case 3: {
                return TextAlignment.LEFT;
            }
        }
        return TextAlignment.JUSTIFIED;
    }

    void DrawTextColumn(float llx, float lly, float urx, float ury, float leading, String text, int valign, int alignment, Style style, boolean wrap) {
        Paragraph p = new Paragraph(text);
        if (valign == GXReportPDFCommons.VerticalAlign.MIDDLE.value()) {
            ury += leading;
            p.setVerticalAlignment(VerticalAlignment.MIDDLE);
        } else if (valign == GXReportPDFCommons.VerticalAlign.BOTTOM.value()) {
            ury += leading;
            p.setVerticalAlignment(VerticalAlignment.BOTTOM);
        } else if (valign == GXReportPDFCommons.VerticalAlign.TOP.value()) {
            ury += leading / 2.0f;
            p.setVerticalAlignment(VerticalAlignment.TOP);
        }
        Rectangle rect = new Rectangle(llx, lly, urx - llx, ury - lly);
        p.setTextAlignment(this.getTextAlignment(alignment));
        p.addStyle(style);
        if (wrap) {
            p.setProperty(62, (Object)new CustomSplitCharacters());
            Table table = new Table(1);
            table.setFixedPosition(this.page, rect.getX(), rect.getY(), rect.getWidth());
            Cell cell = new Cell();
            cell.setWidth(rect.getWidth());
            cell.setHeight(rect.getHeight());
            cell.setBorder(Border.NO_BORDER);
            cell.setVerticalAlignment(VerticalAlignment.MIDDLE);
            cell.add((IBlockElement)p);
            table.addCell(cell);
            this.document.add((IBlockElement)table);
        } else {
            try {
                PdfCanvas pdfCanvas = new PdfCanvas(this.pdfPage);
                Canvas canvas = new Canvas(pdfCanvas, rect);
                canvas.add((IBlockElement)p);
                canvas.close();
            }
            catch (Exception e) {
                log.error("GxDrawText failed to justify text column: ", (Throwable)e);
            }
        }
    }

    @Override
    public boolean GxPrintInit(String output, int[] gxXPage, int[] gxYPage, String iniFile, String form, String printer, int mode, int orientation, int pageSize, int pageLength, int pageWidth, int scale, int copies, int defSrc, int quality, int color, int duplex) {
        boolean preResult = super.GxPrintInit(output, gxXPage, gxYPage, iniFile, form, printer, mode, orientation, pageSize, pageLength, pageWidth, scale, copies, defSrc, quality, color, duplex);
        try {
            this.pageSize = this.computePageSize(this.leftMargin, this.topMargin, pageWidth, pageLength, props.getBooleanGeneralProperty("MarginsInsideBorder", false));
            gxXPage[0] = (int)this.pageSize.getRight();
            gxYPage[0] = props.getBooleanGeneralProperty("FixSac24437", true) ? (int)((double)pageLength / 14.4) : (int)((double)pageLength / 15.45);
            this.init();
            if (!preResult) {
                return !preResult;
            }
            return true;
        }
        catch (Exception e) {
            log.error("GxPrintInit failed", (Throwable)e);
            return false;
        }
    }

    private PageSize computePageSize(float leftMargin, float topMargin, int width, int length, boolean marginsInsideBorder) {
        if (leftMargin == 0.0f && topMargin == 0.0f || marginsInsideBorder) {
            if (length == 23818 && width == 16834) {
                return PageSize.A3;
            }
            if (length == 16834 && width == 11909) {
                return PageSize.A4;
            }
            if (length == 11909 && width == 8395) {
                return PageSize.A5;
            }
            if (length == 20016 && width == 5731) {
                return PageSize.B4;
            }
            if (length == 14170 && width == 9979) {
                return PageSize.B5;
            }
            if (length == 15120 && width == 10440) {
                return PageSize.EXECUTIVE;
            }
            if (length == 20160 && width == 12240) {
                return PageSize.LEGAL;
            }
            if (length == 15840 && width == 12240) {
                return PageSize.LETTER;
            }
            return new PageSize(new Rectangle((float)((int)((double)width / 20.0)), (float)((int)((double)length / 20.0))));
        }
        return new PageSize(new Rectangle((float)((int)((double)width / 20.0)) + leftMargin, (float)((int)((double)length / 20.0)) + topMargin));
    }

    @Override
    public void GxEndDocument() {
        if (this.pdfDocument.getNumberOfPages() == 0) {
            this.pdfPage = this.pdfDocument.addNewPage();
            ++this.pages;
        }
        if (this.template != null) {
            PdfCanvas cb = new PdfCanvas(this.pdfPage);
            cb.beginText();
            cb.setFontAndSize(this.templateFont, (float)this.templateFontSize);
            cb.setTextMatrix(0.0f, 0.0f);
            cb.setFillColor((com.itextpdf.kernel.colors.Color)new DeviceRgb(this.templateColorFill));
            cb.showText(String.valueOf(this.pages));
            cb.endText();
        }
        int copies = 1;
        try {
            PdfViewerPreferences.PdfViewerPreferencesConstants duplexValue;
            copies = Integer.parseInt(this.printerSettings.getProperty(this.form, "Copies"));
            log.debug("Setting number of copies to " + copies);
            PdfViewerPreferences viewerPreferences = new PdfViewerPreferences();
            viewerPreferences.setNumCopies(copies);
            int duplex = Integer.parseInt(this.printerSettings.getProperty(this.form, "Duplex"));
            switch (duplex) {
                case 1: {
                    duplexValue = PdfViewerPreferences.PdfViewerPreferencesConstants.SIMPLEX;
                    break;
                }
                case 2: 
                case 3: {
                    duplexValue = PdfViewerPreferences.PdfViewerPreferencesConstants.DUPLEX_FLIP_SHORT_EDGE;
                    break;
                }
                case 4: {
                    duplexValue = PdfViewerPreferences.PdfViewerPreferencesConstants.DUPLEX_FLIP_LONG_EDGE;
                    break;
                }
                default: {
                    duplexValue = PdfViewerPreferences.PdfViewerPreferencesConstants.NONE;
                }
            }
            log.debug("Setting duplex to " + duplexValue);
            viewerPreferences.setDuplex(duplexValue);
            this.pdfDocument.getCatalog().setViewerPreferences(viewerPreferences);
        }
        catch (Exception ex) {
            log.error("GxEndDocument failed to add viewer preferences: ", (Throwable)ex);
        }
        String serverPrinting = props.getGeneralProperty("ServerPrinting");
        boolean fit = props.getGeneralProperty("AdjustToPaper").equals("true");
        if ((this.outputType == 1 || this.outputType == 4) && this.httpContext instanceof HttpContextWeb && serverPrinting.equals("false")) {
            this.pdfDocument.getCatalog().setAdditionalAction(PdfName.WC, PdfAction.createJavaScript((String)"var pp = this.getPrintParams();\n"));
            String printerAux = this.printerSettings.getProperty(this.form, "Printer");
            String printer = PDFReportItext8.replace(printerAux, "\\", "\\\\");
            if (printer != null && !printer.equals("")) {
                this.pdfDocument.getCatalog().setAdditionalAction(PdfName.WC, PdfAction.createJavaScript((String)("pp.printerName = \"" + printer + "\";\n")));
            }
            if (fit) {
                this.pdfDocument.getCatalog().setAdditionalAction(PdfName.WC, PdfAction.createJavaScript((String)"pp.pageHandling = pp.constants.handling.fit;\n"));
            } else {
                this.pdfDocument.getCatalog().setAdditionalAction(PdfName.WC, PdfAction.createJavaScript((String)"pp.pageHandling = pp.constants.handling.none;\n"));
            }
            if (this.printerSettings.getProperty(this.form, "Mode", "3").startsWith("0")) {
                this.pdfDocument.getCatalog().setAdditionalAction(PdfName.WC, PdfAction.createJavaScript((String)"pp.interactive = pp.constants.interactionLevel.automatic;\n"));
                for (int i = 0; i < copies; ++i) {
                    this.pdfDocument.getCatalog().setAdditionalAction(PdfName.WC, PdfAction.createJavaScript((String)"this.print(pp);\n"));
                }
            } else {
                this.pdfDocument.getCatalog().setAdditionalAction(PdfName.WC, PdfAction.createJavaScript((String)"pp.interactive = pp.constants.interactionLevel.full;\n"));
                this.pdfDocument.getCatalog().setAdditionalAction(PdfName.WC, PdfAction.createJavaScript((String)"this.print(pp);\n"));
            }
        }
        this.document.close();
        log.debug("GxEndDocument!");
        try {
            props.save();
        }
        catch (IOException printerAux) {
            // empty catch block
        }
        switch (this.outputType) {
            case 0: {
                try {
                    this.outputStream.close();
                }
                catch (IOException printerAux) {
                    // empty catch block
                }
                try {
                    PDFReportItext8.showReport(this.docName, this.modal);
                }
                catch (Exception e) {
                    log.error("GxEndDocument: failed to show report on screen ", (Throwable)e);
                }
                break;
            }
            case 1: {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    if (this.httpContext instanceof HttpContextWeb && serverPrinting.equals("false")) break;
                    PDFReportItext8.printReport(this.docName, this.printerOutputMode == 1);
                }
                catch (Exception e) {
                    log.error("GxEndDocument: failed to show report ", (Throwable)e);
                }
                break;
            }
            case 2: {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    log.error("GxEndDocument: failed to save report to file ", (Throwable)e);
                }
                break;
            }
        }
        this.outputStream = null;
    }

    @Override
    public void GxStartPage() {
        this.pdfPage = this.pdfDocument.addNewPage();
        ++this.pages;
    }

    static {
        log = LogManager.getLogger(PDFReportItext8.class);
    }

    private static class CustomSplitCharacters
    extends DefaultSplitCharacters {
        private CustomSplitCharacters() {
        }

        public boolean isSplitCharacter(GlyphLine text, int glyphPos) {
            if (!text.get(glyphPos).hasValidUnicode()) {
                return false;
            }
            boolean baseResult = super.isSplitCharacter(text, glyphPos);
            boolean myResult = false;
            Glyph glyph = text.get(glyphPos);
            if (glyph.getUnicode() == 95) {
                myResult = true;
            }
            return myResult || baseResult;
        }
    }

    public class YPosition {
        float currentYPosition;

        public YPosition(float currentYPosition) {
            this.currentYPosition = currentYPosition;
        }

        public float getCurrentYPosition() {
            return this.currentYPosition;
        }

        public void setCurrentYPosition(float currentYPosition) {
            this.currentYPosition = currentYPosition;
        }
    }
}

