/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.reports;

import com.genexus.CommonUtil;
import com.genexus.ModelContext;
import com.genexus.platform.NativeFunctions;
import com.genexus.reports.GXReportPDFCommons;
import com.genexus.reports.fonts.PDFFont;
import com.genexus.reports.fonts.PDFFontDescriptor;
import com.genexus.reports.fonts.Type1FontMetrics;
import com.genexus.webpanels.HttpContextWeb;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.IIOException;
import org.apache.logging.log4j.LogManager;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDDestinationOrAction;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionJavaScript;
import org.apache.pdfbox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;
import org.apache.pdfbox.util.Matrix;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class PDFReportPDFBox
extends GXReportPDFCommons {
    private PDRectangle pageSize = null;
    private PDFont baseFont;
    private String baseFontName;
    private BitMatrix barcode = null;
    private String barcodeType = null;
    private PDDocument document = null;
    private PDDocumentCatalog writer;
    private PDPageContentStream template;
    private PDFormXObject formXObjecttemplate;
    private PDType0Font templateFont;
    public boolean lineCapProjectingSquare = true;
    public boolean barcode128AsImage = true;
    ConcurrentHashMap<String, PDImageXObject> documentImages;
    public int runDirection = 0;
    private int page;
    private final float DEFAULT_PDFBOX_LEADING = 1.2f;
    private Set<String> supportedHTMLTags = new HashSet<String>();

    public PDFReportPDFBox(ModelContext context) {
        super(context);
        this.documentImages = new ConcurrentHashMap();
    }

    @Override
    protected void init() {
        try {
            this.document = new PDDocument();
        }
        catch (Exception e) {
            log.error("Failed to initialize new PDFBox document: ", (Throwable)e);
        }
    }

    private void drawRectangle(PDPageContentStream cb, float x, float y, float w, float h, int styleTop, int styleBottom, int styleRight, int styleLeft, float radioTL, float radioTR, float radioBL, float radioBR, float penAux, boolean hideCorners) {
        float[] dashPatternTop = this.getDashedPattern(styleTop);
        float[] dashPatternBottom = this.getDashedPattern(styleBottom);
        float[] dashPatternLeft = this.getDashedPattern(styleLeft);
        float[] dashPatternRight = this.getDashedPattern(styleRight);
        try {
            if (styleBottom != this.STYLE_NONE_CONST) {
                cb.setLineDashPattern(dashPatternBottom, 0.0f);
            }
            float b = 0.4477f;
            if (radioBL > 0.0f) {
                cb.moveTo(x + radioBL, y);
            } else if (hideCorners && styleLeft == this.STYLE_NONE_CONST && radioBL == 0.0f) {
                cb.moveTo(x + penAux, y);
            } else {
                cb.moveTo(x, y);
            }
            if (styleBottom != this.STYLE_NONE_CONST) {
                if (hideCorners && styleRight == this.STYLE_NONE_CONST && radioBR == 0.0f) {
                    cb.lineTo(x + w - penAux, y);
                } else {
                    cb.lineTo(x + w - radioBR, y);
                }
                if (radioBR > 0.0f && styleRight != this.STYLE_NONE_CONST) {
                    cb.curveTo(x + w - radioBR * b, y, x + w, y + radioBR * b, x + w, y + radioBR);
                }
            }
            if (styleRight != this.STYLE_NONE_CONST && dashPatternRight != dashPatternBottom) {
                cb.stroke();
                cb.setLineDashPattern(dashPatternRight, 0.0f);
                if (hideCorners && styleBottom == this.STYLE_NONE_CONST && radioBR == 0.0f) {
                    cb.moveTo(x + w, y + penAux);
                } else {
                    cb.moveTo(x + w, y + radioBR);
                }
            }
            if (styleRight != this.STYLE_NONE_CONST) {
                if (hideCorners && styleTop == this.STYLE_NONE_CONST && radioTR == 0.0f) {
                    cb.lineTo(x + w, y + h - penAux);
                } else {
                    cb.lineTo(x + w, y + h - radioTR);
                }
                if (radioTR > 0.0f && styleTop != this.STYLE_NONE_CONST) {
                    cb.curveTo(x + w, y + h - radioTR * b, x + w - radioTR * b, y + h, x + w - radioTR, y + h);
                }
            }
            if (styleTop != this.STYLE_NONE_CONST && dashPatternTop != dashPatternRight) {
                cb.stroke();
                cb.setLineDashPattern(dashPatternTop, 0.0f);
                if (hideCorners && styleRight == this.STYLE_NONE_CONST && radioTR == 0.0f) {
                    cb.moveTo(x + w - penAux, y + h);
                } else {
                    cb.moveTo(x + w - radioTR, y + h);
                }
            }
            if (styleTop != this.STYLE_NONE_CONST) {
                if (hideCorners && styleLeft == this.STYLE_NONE_CONST && radioTL == 0.0f) {
                    cb.lineTo(x + penAux, y + h);
                } else {
                    cb.lineTo(x + radioTL, y + h);
                }
                if (radioTL > 0.0f && styleLeft != this.STYLE_NONE_CONST) {
                    cb.curveTo(x + radioTL * b, y + h, x, y + h - radioTL * b, x, y + h - radioTL);
                }
            }
            if (styleLeft != this.STYLE_NONE_CONST && dashPatternLeft != dashPatternTop) {
                cb.stroke();
                cb.setLineDashPattern(dashPatternLeft, 0.0f);
                if (hideCorners && styleTop == this.STYLE_NONE_CONST && radioTL == 0.0f) {
                    cb.moveTo(x, y + h - penAux);
                } else {
                    cb.moveTo(x, y + h - radioTL);
                }
            }
            if (styleLeft != this.STYLE_NONE_CONST) {
                if (hideCorners && styleBottom == this.STYLE_NONE_CONST && radioBL == 0.0f) {
                    cb.lineTo(x, y + penAux);
                } else {
                    cb.lineTo(x, y + radioBL);
                }
                if (radioBL > 0.0f && styleBottom != this.STYLE_NONE_CONST) {
                    cb.curveTo(x, y + radioBL * b, x + radioBL * b, y, x + radioBL, y);
                }
            }
            cb.stroke();
        }
        catch (IOException ioe) {
            log.error("roundRectangle failed: ", (Throwable)ioe);
        }
    }

    private void roundRectangle(PDPageContentStream cb, float x, float y, float w, float h, float radioTL, float radioTR, float radioBL, float radioBR) {
        try {
            float b = 0.4477f;
            if (radioBL > 0.0f) {
                cb.moveTo(x + radioBL, y);
            } else {
                cb.moveTo(x, y);
            }
            cb.lineTo(x + w - radioBR, y);
            if (radioBR > 0.0f) {
                cb.curveTo(x + w - radioBR * b, y, x + w, y + radioBR * b, x + w, y + radioBR);
            }
            cb.lineTo(x + w, y + h - radioTR);
            if (radioTR > 0.0f) {
                cb.curveTo(x + w, y + h - radioTR * b, x + w - radioTR * b, y + h, x + w - radioTR, y + h);
            }
            cb.lineTo(x + radioTL, y + h);
            if (radioTL > 0.0f) {
                cb.curveTo(x + radioTL * b, y + h, x, y + h - radioTL * b, x, y + h - radioTL);
            }
            cb.lineTo(x, y + radioBL);
            if (radioBL > 0.0f) {
                cb.curveTo(x, y + radioBL * b, x + radioBL * b, y, x + radioBL, y);
            }
        }
        catch (IOException ioe) {
            log.error("drawRectangle failed: ", (Throwable)ioe);
        }
    }

    @Override
    public void GxDrawRect(int left, int top, int right, int bottom, int pen, int foreRed, int foreGreen, int foreBlue, int backMode, int backRed, int backGreen, int backBlue, int styleTop, int styleBottom, int styleRight, int styleLeft, int cornerRadioTL, int cornerRadioTR, int cornerRadioBL, int cornerRadioBR) {
        try (PDPageContentStream cb = new PDPageContentStream(this.document, this.document.getPage(this.page - 1), PDPageContentStream.AppendMode.APPEND, false);){
            float penAux = (float)this.convertScale(pen);
            float rightAux = (float)this.convertScale(right);
            float bottomAux = (float)this.convertScale(bottom);
            float leftAux = (float)this.convertScale(left);
            float topAux = (float)this.convertScale(top);
            cb.saveGraphicsState();
            float x1 = leftAux + this.leftMargin;
            float y1 = this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin;
            float x2 = rightAux + this.leftMargin;
            float y2 = this.pageSize.getUpperRightY() - topAux - this.topMargin - this.bottomMargin;
            cb.setLineWidth(penAux);
            cb.setLineCapStyle(2);
            if (cornerRadioBL == 0 && cornerRadioBR == 0 && cornerRadioTL == 0 && cornerRadioTR == 0 && styleBottom == 0 && styleLeft == 0 && styleRight == 0 && styleTop == 0) {
                if (pen > 0) {
                    cb.setStrokingColor(foreRed, foreGreen, foreBlue);
                } else {
                    cb.setStrokingColor(backRed, backGreen, backBlue);
                }
                cb.addRect(x1, y1, x2 - x1, y2 - y1);
                if (backMode != 0) {
                    cb.setNonStrokingColor(new Color(backRed, backGreen, backBlue));
                    cb.fillAndStroke();
                }
                cb.closePath();
                cb.stroke();
            } else {
                float w = x2 - x1;
                float h = y2 - y1;
                if (w < 0.0f) {
                    x1 += w;
                    w = -w;
                }
                if (h < 0.0f) {
                    y1 += h;
                    h = -h;
                }
                float cRadioTL = (float)this.convertScale(cornerRadioTL);
                float cRadioTR = (float)this.convertScale(cornerRadioTR);
                float cRadioBL = (float)this.convertScale(cornerRadioBL);
                float cRadioBR = (float)this.convertScale(cornerRadioBR);
                int max = (int)Math.min(w, h);
                cRadioTL = Math.max(0.0f, Math.min(cRadioTL, (float)(max / 2)));
                cRadioTR = Math.max(0.0f, Math.min(cRadioTR, (float)(max / 2)));
                cRadioBL = Math.max(0.0f, Math.min(cRadioBL, (float)(max / 2)));
                cRadioBR = Math.max(0.0f, Math.min(cRadioBR, (float)(max / 2)));
                if (backMode != 0) {
                    cb.setStrokingColor(backRed, backGreen, backBlue);
                    cb.setLineWidth(0.0f);
                    this.roundRectangle(cb, x1, y1, w, h, cRadioTL, cRadioTR, cRadioBL, cRadioBR);
                    cb.setNonStrokingColor(new Color(backRed, backGreen, backBlue));
                    cb.fillAndStroke();
                    cb.setLineWidth(penAux);
                }
                if (pen > 0) {
                    cb.setStrokingColor(foreRed, foreGreen, foreBlue);
                    this.drawRectangle(cb, x1, y1, w, h, styleTop, styleBottom, styleRight, styleLeft, cRadioTL, cRadioTR, cRadioBL, cRadioBR, penAux, false);
                }
            }
            cb.restoreGraphicsState();
            log.debug("GxDrawRect -> (" + left + "," + top + ") - (" + right + "," + bottom + ")  BackMode: " + backMode + " Pen:" + pen);
        }
        catch (Exception e) {
            log.error("GxDrawRect failed: ", (Throwable)e);
        }
    }

    @Override
    public void GxDrawLine(int left, int top, int right, int bottom, int width, int foreRed, int foreGreen, int foreBlue, int style) {
        try (PDPageContentStream cb = new PDPageContentStream(this.document, this.document.getPage(this.page - 1), PDPageContentStream.AppendMode.APPEND, false);){
            float widthAux = (float)this.convertScale(width);
            float rightAux = (float)this.convertScale(right);
            float bottomAux = (float)this.convertScale(bottom);
            float leftAux = (float)this.convertScale(left);
            float topAux = (float)this.convertScale(top);
            log.debug("GxDrawLine -> (" + left + "," + top + ") - (" + right + "," + bottom + ") Width: " + width);
            float x1 = leftAux + this.leftMargin;
            float y1 = this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin;
            float x2 = rightAux + this.leftMargin;
            float y2 = this.pageSize.getUpperRightY() - topAux - this.topMargin - this.bottomMargin;
            cb.saveGraphicsState();
            cb.setStrokingColor(foreRed, foreGreen, foreBlue);
            cb.setLineWidth(widthAux);
            if (this.lineCapProjectingSquare) {
                cb.setLineCapStyle(2);
            }
            if (style != 0) {
                float[] dashPattern = this.getDashedPattern(style);
                cb.setLineDashPattern(dashPattern, 0.0f);
            }
            cb.moveTo(x1, y1);
            cb.lineTo(x2, y2);
            cb.stroke();
            cb.restoreGraphicsState();
        }
        catch (IOException ioe) {
            log.error("GxDrawLine failed:", (Throwable)ioe);
        }
    }

    @Override
    public void GxDrawBitMap(String bitmap, int left, int top, int right, int bottom, int aspectRatio) {
        try (PDPageContentStream cb = new PDPageContentStream(this.document, this.document.getPage(this.page - 1), PDPageContentStream.AppendMode.APPEND, false);){
            PDImageXObject image;
            try {
                if (this.documentImages != null && this.documentImages.containsKey(bitmap)) {
                    image = this.documentImages.get(bitmap);
                } else {
                    if (!NativeFunctions.isWindows() && new File(bitmap).isAbsolute() && bitmap.startsWith(this.httpContext.getStaticContentBase())) {
                        bitmap = bitmap.replace(this.httpContext.getStaticContentBase(), "");
                    }
                    if (!(new File(bitmap).isAbsolute() || bitmap.toLowerCase().startsWith("http:") || bitmap.toLowerCase().startsWith("https:"))) {
                        if (bitmap.startsWith(this.httpContext.getStaticContentBase())) {
                            bitmap = bitmap.replace(this.httpContext.getStaticContentBase(), "");
                        }
                        if ((image = PDImageXObject.createFromFile((String)(defaultRelativePrepend + bitmap), (PDDocument)this.document)) == null) {
                            bitmap = webAppDir + bitmap;
                            image = PDImageXObject.createFromFile((String)bitmap, (PDDocument)this.document);
                        } else {
                            bitmap = defaultRelativePrepend + bitmap;
                        }
                    } else {
                        image = PDImageXObject.createFromFile((String)bitmap, (PDDocument)this.document);
                    }
                }
            }
            catch (IllegalArgumentException ex) {
                URL url = new URL(bitmap);
                image = PDImageXObject.createFromByteArray((PDDocument)this.document, (byte[])IOUtils.toByteArray((InputStream)url.openStream()), (String)bitmap);
            }
            if (this.documentImages == null) {
                this.documentImages = new ConcurrentHashMap();
            }
            this.documentImages.putIfAbsent(bitmap, image);
            log.debug("GxDrawBitMap -> '" + bitmap + "' [" + left + "," + top + "] - Size: (" + (right - left) + "," + (bottom - top) + ")");
            if (image != null) {
                float rightAux = (float)this.convertScale(right);
                float bottomAux = (float)this.convertScale(bottom);
                float leftAux = (float)this.convertScale(left);
                float topAux = (float)this.convertScale(top);
                float x = leftAux + this.leftMargin;
                float y = this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin;
                if (aspectRatio == 0) {
                    cb.drawImage(image, x, y, rightAux - leftAux, bottomAux - topAux);
                } else {
                    cb.drawImage(image, x, y, (rightAux - leftAux) * (float)aspectRatio, (bottomAux - topAux) * (float)aspectRatio);
                }
            }
        }
        catch (IOException ioe) {
            log.error("GxDrawBitMap failed:", (Throwable)ioe);
        }
    }

    @Override
    public void GxAttris(String fontName, int fontSize, boolean fontBold, boolean fontItalic, boolean fontUnderline, boolean fontStrikethru, int Pen, int foreRed, int foreGreen, int foreBlue, int backMode, int backRed, int backGreen, int backBlue) {
        boolean isCJK = false;
        boolean embeedFont = this.isEmbeddedFont(fontName);
        String originalFontName = fontName;
        if (!embeedFont) {
            fontName = this.getSubstitute(fontName);
        }
        String fontSubstitute = "";
        if (!originalFontName.equals(fontName)) {
            fontSubstitute = "Original Font: " + originalFontName + " Substitute";
        }
        log.debug("GxAttris: ");
        log.debug("\\-> " + fontSubstitute + "Font: " + fontName + " (" + fontSize + ")" + (fontBold ? " BOLD" : "") + (fontItalic ? " ITALIC" : "") + (fontStrikethru ? " Strike" : ""));
        log.debug("\\-> Fore (" + foreRed + ", " + foreGreen + ", " + foreBlue + ")");
        log.debug("\\-> Back (" + backRed + ", " + backGreen + ", " + backBlue + ")");
        if (this.barcode128AsImage && fontName.toLowerCase().indexOf("barcode 128") >= 0 || fontName.toLowerCase().indexOf("barcode128") >= 0) {
            this.barcodeType = "barcode128";
        }
        this.fontUnderline = fontUnderline;
        this.fontStrikethru = fontStrikethru;
        this.fontSize = fontSize;
        this.fontBold = fontBold;
        this.fontItalic = fontItalic;
        this.foreColor = new Color(foreRed, foreGreen, foreBlue);
        this.backColor = new Color(backRed, backGreen, backBlue);
        this.backFill = backMode != 0;
        try {
            if (PDFFont.isType1(fontName)) {
                for (int i = 0; i < Type1FontMetrics.CJKNames.length; ++i) {
                    if (!Type1FontMetrics.CJKNames[i][0].equalsIgnoreCase(fontName) && !Type1FontMetrics.CJKNames[i][1].equalsIgnoreCase(fontName)) continue;
                    String style = "";
                    if (fontBold && fontItalic) {
                        style = "BoldItalic";
                    } else {
                        if (fontItalic) {
                            style = "Italic";
                        }
                        if (fontBold) {
                            style = "Bold";
                        }
                    }
                    this.setAsianFont(fontName, style);
                    isCJK = true;
                    break;
                }
                if (!isCJK) {
                    int style = 0;
                    if (fontBold && fontItalic) {
                        style += 3;
                    } else {
                        if (fontItalic) {
                            style += 2;
                        }
                        if (fontBold) {
                            ++style;
                        }
                    }
                    for (int i = 0; i < PDFFont.base14.length; ++i) {
                        if (!PDFFont.base14[i][0].equalsIgnoreCase(fontName)) continue;
                        fontName = PDFFont.base14[i][1 + style].substring(1);
                        break;
                    }
                    this.baseFont = PDFReportPDFBox.createPDType1FontFromName(fontName);
                    if (this.baseFont != null) {
                        this.baseFontName = this.baseFont.getName();
                    }
                    if (this.baseFont == null) {
                        this.baseFont = PDType0Font.load((PDDocument)this.document, (File)new File(this.getFontLocation(fontName)));
                        this.baseFontName = fontName;
                    }
                }
            } else {
                String style = "";
                if (fontBold && fontItalic) {
                    style = ",BoldItalic";
                } else {
                    if (fontItalic) {
                        style = ",Italic";
                    }
                    if (fontBold) {
                        style = ",Bold";
                    }
                }
                fontName = fontName + style;
                String fontPath = this.getFontLocation(fontName);
                boolean foundFont = true;
                if (fontPath.equals("") && (fontPath = PDFFontDescriptor.getTrueTypeFontLocation(fontName, props)).equals("")) {
                    this.baseFont = PDType1Font.HELVETICA;
                    this.baseFontName = this.baseFont.getName();
                    foundFont = false;
                }
                if (foundFont) {
                    this.baseFont = PDFReportPDFBox.createPDType1FontFromName(fontName);
                    if (this.baseFont != null) {
                        this.baseFontName = this.baseFont.getName();
                    } else {
                        this.baseFont = PDType0Font.load((PDDocument)this.document, (File)new File(this.getFontLocation(fontName)));
                        this.baseFontName = fontName;
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("GxAttris failed: ", (Throwable)e);
        }
    }

    private static PDType1Font createPDType1FontFromName(String fontName) {
        switch (fontName) {
            case "Times-Roman": {
                return PDType1Font.TIMES_ROMAN;
            }
            case "Times-Bold": {
                return PDType1Font.TIMES_BOLD;
            }
            case "Times-Italic": {
                return PDType1Font.TIMES_ITALIC;
            }
            case "Times-BoldItalic": {
                return PDType1Font.TIMES_BOLD_ITALIC;
            }
            case "Helvetica": {
                return PDType1Font.HELVETICA;
            }
            case "Helvetica-Bold": {
                return PDType1Font.HELVETICA_BOLD;
            }
            case "Helvetica-Oblique": {
                return PDType1Font.HELVETICA_OBLIQUE;
            }
            case "Helvetica-BoldOblique": {
                return PDType1Font.HELVETICA_BOLD_OBLIQUE;
            }
            case "Courier": {
                return PDType1Font.COURIER;
            }
            case "Courier-Bold": {
                return PDType1Font.COURIER_BOLD;
            }
            case "Courier-Oblique": {
                return PDType1Font.COURIER_OBLIQUE;
            }
            case "Courier-BoldOblique": {
                return PDType1Font.COURIER_BOLD_OBLIQUE;
            }
            case "Symbol": {
                return PDType1Font.SYMBOL;
            }
            case "ZapfDingbats": {
                return PDType1Font.ZAPF_DINGBATS;
            }
        }
        return null;
    }

    @Override
    public void setAsianFont(String fontName, String style) {
        try {
            String fontPath = this.getFontLocation(fontName);
            this.baseFont = PDType0Font.load((PDDocument)this.document, (File)new File(fontPath));
            this.baseFontName = fontName;
        }
        catch (Exception e) {
            log.error("setAsianFont failed: ", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void GxDrawText(String sTxt, int left, int top, int right, int bottom, int align, int htmlformat, int border, int valign) {
        try (PDPageContentStream cb = new PDPageContentStream(this.document, this.document.getPage(this.page - 1), PDPageContentStream.AppendMode.APPEND, false);){
            boolean wrap;
            PDPageContentStream contentStream;
            PDRectangle underline;
            boolean autoResize;
            boolean printRectangle = false;
            if (props.getBooleanGeneralProperty("BackFillInControls", true)) {
                printRectangle = true;
            }
            if (printRectangle && (border == 1 || this.backFill)) {
                this.GxDrawRect(left, top, right, bottom, border, this.foreColor.getRed(), this.foreColor.getGreen(), this.foreColor.getBlue(), this.backFill ? 1 : 0, this.backColor.getRed(), this.backColor.getGreen(), this.backColor.getBlue(), 0, 0);
            }
            sTxt = CommonUtil.rtrim((String)sTxt);
            PDType1Font font = PDFReportPDFBox.createPDType1FontFromName(this.baseFont.getFontDescriptor().getFontName());
            if (font == null) {
                font = PDType0Font.load((PDDocument)this.document, (File)new File(this.getFontLocation(this.baseFontName)));
            }
            cb.setFont((PDFont)font, (float)this.fontSize);
            cb.setNonStrokingColor(this.foreColor);
            float captionHeight = this.baseFont.getFontMatrix().transformPoint((float)0.0f, (float)font.getFontDescriptor().getCapHeight()).y * (float)this.fontSize;
            float rectangleWidth = this.baseFont.getStringWidth(sTxt) / 1000.0f * (float)this.fontSize;
            float lineHeight = (this.baseFont.getFontDescriptor().getFontBoundingBox().getUpperRightY() - this.baseFont.getFontDescriptor().getFontBoundingBox().getLowerLeftY()) / 1000.0f * (float)this.fontSize;
            float textBlockHeight = (float)this.convertScale(bottom - top);
            int linesCount = (int)(textBlockHeight / lineHeight);
            int bottomOri = bottom;
            int topOri = top;
            if (linesCount >= 2 && (align & 0x10) != 16 && htmlformat != 1) {
                if (valign == GXReportPDFCommons.VerticalAlign.TOP.value()) {
                    bottom = top + (int)this.reconvertScale(lineHeight);
                } else if (valign == GXReportPDFCommons.VerticalAlign.BOTTOM.value()) {
                    top = bottom - (int)this.reconvertScale(lineHeight);
                }
            }
            float bottomAux = (float)this.convertScale(bottom) - ((float)this.convertScale(bottom - top) - captionHeight) / 2.0f;
            float topAux = (float)this.convertScale(top) + ((float)this.convertScale(bottom - top) - captionHeight) / 2.0f;
            float startHeight = bottomAux - topAux - captionHeight;
            float leftAux = (float)this.convertScale(left);
            float rightAux = (float)this.convertScale(right);
            int alignment = align & 3;
            boolean bl = autoResize = (align & 0x100) == 256;
            if (htmlformat == 1) {
                log.debug("WARNING: HTML rendering is not natively supported by PDFBOX 2.0.27. Handcrafted support is provided but it is not intended to cover all possible use cases");
                try {
                    bottomAux = (float)this.convertScale(bottom);
                    topAux = (float)this.convertScale(top);
                    float drawingPageHeight = this.pageSize.getUpperRightY() - this.topMargin - this.bottomMargin;
                    float llx = leftAux + this.leftMargin;
                    float lly = drawingPageHeight - bottomAux;
                    float urx = rightAux + this.leftMargin;
                    float ury = drawingPageHeight - topAux;
                    PDRectangle htmlRectangle = new PDRectangle();
                    htmlRectangle.setLowerLeftX(llx);
                    htmlRectangle.setLowerLeftY(lly);
                    htmlRectangle.setUpperRightX(urx);
                    htmlRectangle.setUpperRightY(ury);
                    SpaceHandler spaceHandler = new SpaceHandler(htmlRectangle.getUpperRightY(), htmlRectangle.getHeight());
                    this.loadSupportedHTMLTags();
                    Document document = Jsoup.parse((String)sTxt);
                    Elements allElements = document.getAllElements();
                    Iterator iterator = allElements.iterator();
                    while (iterator.hasNext()) {
                        Element element = (Element)iterator.next();
                        if (!this.supportedHTMLTags.contains(element.normalName())) continue;
                        this.processHTMLElement(cb, htmlRectangle, spaceHandler, element);
                    }
                    return;
                }
                catch (Exception e) {
                    log.error("GxDrawText failed to print HTML text : ", (Throwable)e);
                    return;
                }
            }
            if (this.barcodeType != null) {
                log.debug("Barcode: --> " + this.barcode.getClass().getName());
                try {
                    PDRectangle rectangle = new PDRectangle();
                    switch (alignment) {
                        case 1: {
                            rectangle.setLowerLeftX((leftAux + rightAux) / 2.0f + this.leftMargin - rectangleWidth / 2.0f);
                            rectangle.setLowerLeftY(this.pageSize.getUpperRightY() - (float)this.convertScale(bottom) - this.topMargin - this.bottomMargin);
                            rectangle.setUpperRightX((leftAux + rightAux) / 2.0f + this.leftMargin + rectangleWidth / 2.0f);
                            rectangle.setUpperRightY(this.pageSize.getUpperRightY() - (float)this.convertScale(top) - this.topMargin - this.bottomMargin);
                            break;
                        }
                        case 2: {
                            rectangle.setLowerLeftX(rightAux + this.leftMargin - rectangleWidth);
                            rectangle.setLowerLeftY(this.pageSize.getUpperRightY() - (float)this.convertScale(bottom) - this.topMargin - this.bottomMargin);
                            rectangle.setUpperRightX(rightAux + this.leftMargin);
                            rectangle.setUpperRightY(this.pageSize.getUpperRightY() - (float)this.convertScale(top) - this.topMargin - this.bottomMargin);
                            break;
                        }
                        case 0: {
                            rectangle.setLowerLeftX(leftAux + this.leftMargin);
                            rectangle.setLowerLeftY(this.pageSize.getUpperRightY() - (float)this.convertScale(bottom) - this.topMargin - this.bottomMargin);
                            rectangle.setUpperRightX(leftAux + this.leftMargin + rectangleWidth);
                            rectangle.setUpperRightY(this.pageSize.getUpperRightY() - (float)this.convertScale(top) - this.topMargin - this.bottomMargin);
                            break;
                        }
                    }
                    if (this.barcodeType.equals("barcode128")) {
                        Code128Writer barcodeWriter = new Code128Writer();
                        this.barcode = barcodeWriter.encode(sTxt, BarcodeFormat.CODE_128, Math.round(rectangle.getWidth()), Math.round(rectangle.getHeight()));
                    }
                    BufferedImage imageCode = new BufferedImage(this.barcode.getWidth(), this.barcode.getHeight(), 1);
                    int x = 0;
                    while (true) {
                        if (x >= this.barcode.getWidth()) {
                            float scale = Math.min(rectangle.getHeight() / (float)imageCode.getHeight(), 1.0f);
                            float newImageWidth = (float)imageCode.getWidth() * scale;
                            float newImageHeight = (float)imageCode.getHeight() * scale;
                            cb.drawImage(LosslessFactory.createFromImage((PDDocument)this.document, (BufferedImage)imageCode), leftAux + this.leftMargin, rectangle.getLowerLeftY(), newImageWidth, newImageHeight);
                            return;
                        }
                        for (int y = 0; y < this.barcode.getHeight(); ++y) {
                            int color = this.foreColor == null || this.backColor == null ? Color.BLACK.getRGB() : (this.barcode.get(x, y) ? this.foreColor.getRGB() : this.backColor.getRGB());
                            imageCode.setRGB(x, y, color);
                        }
                        ++x;
                    }
                }
                catch (Exception ex) {
                    log.error("GxDrawText: Error generating Barcode " + this.barcode.getClass().getName(), (Throwable)ex);
                    return;
                }
            }
            if (this.backFill) {
                PDRectangle rectangle = new PDRectangle();
                switch (alignment) {
                    case 1: {
                        rectangle.setLowerLeftX((leftAux + rightAux) / 2.0f + this.leftMargin - rectangleWidth / 2.0f);
                        rectangle.setLowerLeftY(this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin);
                        rectangle.setUpperRightX((leftAux + rightAux) / 2.0f + this.leftMargin + rectangleWidth / 2.0f);
                        rectangle.setUpperRightY(this.pageSize.getUpperRightY() - topAux - this.topMargin - this.bottomMargin);
                        break;
                    }
                    case 2: {
                        rectangle.setLowerLeftX(rightAux + this.leftMargin - rectangleWidth);
                        rectangle.setLowerLeftY(this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin);
                        rectangle.setUpperRightX(rightAux + this.leftMargin);
                        rectangle.setUpperRightY(this.pageSize.getUpperRightY() - topAux - this.topMargin - this.bottomMargin);
                        break;
                    }
                    case 0: {
                        rectangle.setLowerLeftX(leftAux + this.leftMargin);
                        rectangle.setLowerLeftY(this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin);
                        rectangle.setUpperRightX(leftAux + this.leftMargin + rectangleWidth);
                        rectangle.setUpperRightY(this.pageSize.getUpperRightY() - topAux - this.topMargin - this.bottomMargin);
                        break;
                    }
                }
                PDPageContentStream contentStream2 = new PDPageContentStream(this.document, this.document.getPage(this.page - 1), PDPageContentStream.AppendMode.APPEND, false);
                contentStream2.setNonStrokingColor(this.backColor);
                contentStream2.addRect(rectangle.getLowerLeftX(), rectangle.getLowerLeftY(), rectangle.getWidth(), rectangle.getHeight());
                contentStream2.fill();
                contentStream2.close();
            }
            float underlineSeparation = lineHeight / 5.0f;
            int underlineHeight = (int)underlineSeparation + (int)(underlineSeparation / 4.0f);
            if (this.fontUnderline) {
                underline = new PDRectangle();
                switch (alignment) {
                    case 1: {
                        underline.setLowerLeftX((leftAux + rightAux) / 2.0f + this.leftMargin - rectangleWidth / 2.0f);
                        underline.setLowerLeftY(this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin + startHeight - underlineSeparation);
                        underline.setUpperRightX((leftAux + rightAux) / 2.0f + this.leftMargin + rectangleWidth / 2.0f);
                        underline.setUpperRightY(this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin + startHeight - (float)underlineHeight);
                        break;
                    }
                    case 2: {
                        underline.setLowerLeftX(rightAux + this.leftMargin - rectangleWidth);
                        underline.setLowerLeftY(this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin + startHeight - underlineSeparation);
                        underline.setUpperRightX(rightAux + this.leftMargin);
                        underline.setUpperRightY(this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin + startHeight - (float)underlineHeight);
                        break;
                    }
                    case 0: {
                        underline.setLowerLeftX(leftAux + this.leftMargin);
                        underline.setLowerLeftY(this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin + startHeight - underlineSeparation);
                        underline.setUpperRightX(leftAux + this.leftMargin + rectangleWidth);
                        underline.setUpperRightY(this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin + startHeight - (float)underlineHeight);
                        break;
                    }
                }
                PDPageContentStream contentStream3 = new PDPageContentStream(this.document, this.document.getPage(this.page - 1), PDPageContentStream.AppendMode.APPEND, false);
                contentStream3.setNonStrokingColor(this.foreColor);
                contentStream3.addRect(underline.getLowerLeftX(), underline.getLowerLeftY(), underline.getWidth(), underline.getHeight());
                contentStream3.fill();
                contentStream3.close();
            }
            if (this.fontStrikethru) {
                underline = new PDRectangle();
                float strikethruSeparation = lineHeight / 2.0f;
                switch (alignment) {
                    case 1: {
                        underline.setLowerLeftX((leftAux + rightAux) / 2.0f + this.leftMargin - rectangleWidth / 2.0f);
                        underline.setLowerLeftY(this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin + startHeight - underlineSeparation + strikethruSeparation);
                        underline.setUpperRightX((leftAux + rightAux) / 2.0f + this.leftMargin + rectangleWidth / 2.0f);
                        underline.setUpperRightY(this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin + startHeight - (float)underlineHeight + strikethruSeparation);
                        break;
                    }
                    case 2: {
                        underline.setLowerLeftX(rightAux + this.leftMargin - rectangleWidth);
                        underline.setLowerLeftY(this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin + startHeight - underlineSeparation + strikethruSeparation);
                        underline.setUpperRightX(rightAux + this.leftMargin);
                        underline.setUpperRightY(this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin + startHeight - (float)underlineHeight + strikethruSeparation);
                        break;
                    }
                    case 0: {
                        underline.setLowerLeftX(leftAux + this.leftMargin);
                        underline.setLowerLeftY(this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin + startHeight - underlineSeparation + strikethruSeparation);
                        underline.setUpperRightX(leftAux + this.leftMargin + rectangleWidth);
                        underline.setUpperRightY(this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin + startHeight - (float)underlineHeight + strikethruSeparation);
                        break;
                    }
                }
                contentStream = new PDPageContentStream(this.document, this.document.getPage(this.page - 1), PDPageContentStream.AppendMode.APPEND, false);
                contentStream.setNonStrokingColor(this.foreColor);
                contentStream.addRect(underline.getLowerLeftX(), underline.getLowerLeftY() - strikethruSeparation * 1.0f / 3.0f, underline.getWidth(), underline.getHeight());
                contentStream.fill();
                contentStream.close();
            }
            if (sTxt.trim().equalsIgnoreCase("{{Pages}}")) {
                if (!this.templateCreated) {
                    this.formXObjecttemplate = new PDFormXObject(this.document);
                    this.template = new PDPageContentStream(this.document, this.formXObjecttemplate, this.outputStream);
                    this.formXObjecttemplate.setResources(new PDResources());
                    this.formXObjecttemplate.setBBox(new PDRectangle((float)(right - left), (float)(bottom - top)));
                    this.templateCreated = true;
                }
                PDFormXObject form = new PDFormXObject(this.document);
                contentStream = new PDPageContentStream(this.document, this.document.getPage(this.page - 1), PDPageContentStream.AppendMode.APPEND, false);
                contentStream.transform(Matrix.getTranslateInstance((float)(leftAux + this.leftMargin), (float)(leftAux + this.leftMargin)));
                contentStream.drawForm(form);
                contentStream.close();
                this.templateFont = new PDType0Font(this.baseFont.getCOSObject());
                this.templateFontSize = this.fontSize;
                this.templateColorFill = this.foreColor;
                return;
            }
            float textBlockWidth = rightAux - leftAux;
            float TxtWidth = this.baseFont.getStringWidth(sTxt) / 1000.0f * (float)this.fontSize;
            boolean justified = alignment == 3 && textBlockWidth < TxtWidth;
            boolean bl2 = wrap = (align & 0x10) == 16;
            if (wrap || justified) {
                bottomAux = (float)this.convertScale(bottomOri);
                topAux = (float)this.convertScale(topOri);
                float llx = leftAux + this.leftMargin;
                float lly = this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin;
                float urx = rightAux + this.leftMargin;
                float ury = this.pageSize.getUpperRightY() - topAux - this.topMargin - this.bottomMargin;
                this.showWrappedTextAligned(cb, (PDFont)font, alignment, sTxt, llx, lly, urx, ury);
                return;
            }
            startHeight = 0.0f;
            if (!autoResize) {
                String newsTxt = sTxt;
                while (TxtWidth > textBlockWidth && newsTxt.length() - 1 >= 0) {
                    sTxt = newsTxt;
                    newsTxt = newsTxt.substring(0, newsTxt.length() - 1);
                    TxtWidth = this.baseFont.getStringWidth(newsTxt) / 1000.0f * (float)this.fontSize;
                }
            }
            switch (alignment) {
                case 1: {
                    this.showTextAligned(cb, (PDFont)font, alignment, sTxt, (leftAux + rightAux) / 2.0f + this.leftMargin, this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin + startHeight);
                    return;
                }
                case 2: {
                    this.showTextAligned(cb, (PDFont)font, alignment, sTxt, rightAux + this.leftMargin, this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin + startHeight);
                    return;
                }
                case 0: 
                case 3: {
                    this.showTextAligned(cb, (PDFont)font, alignment, sTxt, leftAux + this.leftMargin, this.pageSize.getUpperRightY() - bottomAux - this.topMargin - this.bottomMargin + startHeight);
                    return;
                }
            }
            return;
        }
        catch (Exception ioe) {
            log.error("GxDrawText failed: ", (Throwable)ioe);
        }
    }

    private void loadSupportedHTMLTags() {
        this.supportedHTMLTags.add("p");
        this.supportedHTMLTags.add("ol");
        this.supportedHTMLTags.add("ul");
        this.supportedHTMLTags.add("div");
        this.supportedHTMLTags.add("h1");
        this.supportedHTMLTags.add("h2");
        this.supportedHTMLTags.add("h3");
        this.supportedHTMLTags.add("h4");
        this.supportedHTMLTags.add("img");
        this.supportedHTMLTags.add("a");
    }

    private void processHTMLElement(PDPageContentStream cb, PDRectangle htmlRectangle, SpaceHandler spaceHandler, Element blockElement) throws Exception {
        this.fontBold = false;
        String tagName = blockElement.normalName();
        PDType1Font htmlFont = PDType1Font.TIMES_ROMAN;
        if (tagName.equals("div") || tagName.equals("span")) {
            for (Node child : blockElement.childNodes()) {
                if (!(child instanceof Element)) continue;
                this.processHTMLElement(cb, htmlRectangle, spaceHandler, (Element)child);
            }
        }
        if (spaceHandler.getAvailableSpace() <= 0.0f) {
            log.error("You ran out of available space while rendering HTML");
            return;
        }
        float lineHeight = PDType1Font.TIMES_ROMAN.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * (float)this.fontSize * 1.2f;
        float leading = (float)Double.valueOf(props.getGeneralProperty("Leading")).doubleValue();
        float llx = htmlRectangle.getLowerLeftX();
        float lly = htmlRectangle.getLowerLeftY();
        float urx = htmlRectangle.getUpperRightX();
        float fontSize = 16.0f;
        cb.setFont((PDFont)htmlFont, 16.0f);
        if (tagName.equals("h1")) {
            cb.setFont((PDFont)htmlFont, 32.0f);
            fontSize = 32.0f;
            tagName = "h";
        } else if (tagName.equals("h2")) {
            cb.setFont((PDFont)htmlFont, 24.0f);
            fontSize = 24.0f;
            tagName = "h";
        } else if (tagName.equals("h3")) {
            cb.setFont((PDFont)htmlFont, 18.72f);
            fontSize = 18.72f;
            tagName = "h";
        } else if (tagName.equals("h4")) {
            cb.setFont((PDFont)htmlFont, 16.0f);
            fontSize = 16.5f;
            tagName = "h";
        }
        spaceHandler.setCurrentYPosition(spaceHandler.getCurrentYPosition() - fontSize / 2.0f);
        if (tagName.equals("h")) {
            this.fontBold = true;
            float lines = this.renderHTMLContent(cb, blockElement.text(), fontSize, llx, lly, urx, spaceHandler.getCurrentYPosition());
            float totalTextHeight = lineHeight * lines * 1.2f * leading;
            spaceHandler.setCurrentYPosition(spaceHandler.getCurrentYPosition() - totalTextHeight);
        } else if (tagName.equals("p")) {
            float lines = this.renderHTMLContent(cb, blockElement.text(), fontSize, llx, lly, urx, spaceHandler.getCurrentYPosition());
            float totalTextHeight = lineHeight * lines * 1.2f * leading;
            spaceHandler.setCurrentYPosition(spaceHandler.getCurrentYPosition() - totalTextHeight);
        } else if (tagName.equals("ul") || tagName.equals("ol")) {
            int i = 0;
            for (Element listItem : blockElement.select("li")) {
                String text = tagName.equals("ul") ? "\u2022 " + listItem.text() : i + ". " + listItem.text();
                ++i;
                float lines = this.renderHTMLContent(cb, text, fontSize, llx, lly, urx, spaceHandler.getCurrentYPosition());
                float totalTextHeight = lineHeight * lines * 1.2f;
                spaceHandler.setCurrentYPosition(spaceHandler.getCurrentYPosition() - totalTextHeight);
            }
        } else if (tagName.equals("a")) {
            cb.setNonStrokingColor(new Color(0, 0, 255));
            float lines = this.renderHTMLContent(cb, blockElement.attr("href"), fontSize, llx, lly, urx, spaceHandler.getCurrentYPosition());
            float totalTextHeight = lineHeight * lines * 1.2f * leading;
            spaceHandler.setCurrentYPosition(spaceHandler.getCurrentYPosition() - totalTextHeight);
            cb.setStrokingColor(new Color(0, 0, 0));
        } else if (tagName.equals("img")) {
            PDImageXObject image;
            String bitmap = blockElement.attr("src");
            float height = blockElement.attr("height") != "" ? Float.parseFloat(blockElement.attr("height")) : 0.0f;
            float width = blockElement.attr("width") != "" ? Float.parseFloat(blockElement.attr("width")) : 0.0f;
            try {
                if (!NativeFunctions.isWindows() && new File(bitmap).isAbsolute() && bitmap.startsWith(this.httpContext.getStaticContentBase())) {
                    bitmap = bitmap.replace(this.httpContext.getStaticContentBase(), "");
                }
                if (!(new File(bitmap).isAbsolute() || bitmap.toLowerCase().startsWith("http:") || bitmap.toLowerCase().startsWith("https:"))) {
                    if (bitmap.startsWith(this.httpContext.getStaticContentBase())) {
                        bitmap = bitmap.replace(this.httpContext.getStaticContentBase(), "");
                    }
                    if ((image = PDImageXObject.createFromFile((String)(defaultRelativePrepend + bitmap), (PDDocument)this.document)) == null) {
                        bitmap = webAppDir + bitmap;
                        image = PDImageXObject.createFromFile((String)bitmap, (PDDocument)this.document);
                    } else {
                        bitmap = defaultRelativePrepend + bitmap;
                    }
                } else {
                    image = PDImageXObject.createFromFile((String)bitmap, (PDDocument)this.document);
                }
            }
            catch (FileNotFoundException | IllegalArgumentException | IIOException e) {
                URL url = new URL(bitmap);
                image = PDImageXObject.createFromByteArray((PDDocument)this.document, (byte[])IOUtils.toByteArray((InputStream)url.openStream()), (String)bitmap);
            }
            if (height == 0.0f) {
                height = image.getHeight();
            }
            if (width == 0.0f) {
                width = image.getWidth();
            }
            cb.drawImage(image, llx, spaceHandler.getCurrentYPosition() - height, width, height);
            spaceHandler.setCurrentYPosition(spaceHandler.getCurrentYPosition() - height - 10.0f);
        }
        float availableSpace = spaceHandler.getCurrentYPosition() - lly;
        spaceHandler.setAvailableSpace(availableSpace);
    }

    private float renderHTMLContent(PDPageContentStream contentStream, String text, float fontSize, float llx, float lly, float urx, float ury) {
        try {
            PDType1Font defaultHTMLFont = PDType1Font.TIMES_ROMAN;
            ArrayList<String> lines = new ArrayList<String>();
            String[] words = text.split(" ");
            StringBuilder currentLine = new StringBuilder();
            for (String word : words) {
                float currentLineWidth = defaultHTMLFont.getStringWidth(currentLine + " " + word) / 1000.0f * fontSize;
                if (currentLineWidth < urx - llx) {
                    if (currentLine.length() > 0) {
                        currentLine.append(" ");
                    }
                    currentLine.append(word);
                    continue;
                }
                lines.add(currentLine.toString());
                currentLine.setLength(0);
                currentLine.append(word);
            }
            lines.add(currentLine.toString());
            float leading = lines.size() == 1 ? fontSize : 1.2f * fontSize;
            float startY = ury;
            if (fontSize > 16.0f) {
                contentStream.setLineWidth(fontSize * 0.05f);
                contentStream.setRenderingMode(RenderingMode.FILL_STROKE);
            }
            contentStream.beginText();
            float lineHeight = (defaultHTMLFont.getFontDescriptor().getFontBoundingBox().getUpperRightY() - defaultHTMLFont.getFontDescriptor().getFontBoundingBox().getLowerLeftY()) / 1000.0f * fontSize;
            contentStream.newLineAtOffset(llx, startY);
            for (String line : lines) {
                contentStream.showText(line);
                startY = startY - leading - lineHeight;
                contentStream.newLineAtOffset(0.0f, startY);
            }
            contentStream.endText();
            contentStream.setLineWidth(1.0f);
            contentStream.setRenderingMode(RenderingMode.FILL);
            return lines.size();
        }
        catch (IOException ioe) {
            log.error("failed to draw wrapped text: ", (Throwable)ioe);
            return -1.0f;
        }
    }

    private void resolveTextStyling(PDPageContentStream contentStream, String text, float x, float y, boolean isWrapped) {
        try {
            if (this.fontBold && this.fontItalic) {
                contentStream.setStrokingColor(this.foreColor);
                contentStream.setLineWidth((float)this.fontSize * 0.05f);
                contentStream.setRenderingMode(RenderingMode.FILL_STROKE);
                contentStream.beginText();
                contentStream.moveTextPositionByAmount(x, y);
                contentStream.setTextMatrix(new Matrix(1.0f, 0.0f, 0.2f, 1.0f, x + 0.2f * y, y));
                contentStream.newLineAtOffset(-0.2f * y, 0.0f);
            } else if (this.fontBold && !this.fontItalic) {
                contentStream.setStrokingColor(this.foreColor);
                contentStream.setLineWidth((float)this.fontSize * 0.05f);
                contentStream.setRenderingMode(RenderingMode.FILL_STROKE);
                contentStream.beginText();
                contentStream.moveTextPositionByAmount(x, y);
            } else if (!this.fontBold && this.fontItalic) {
                contentStream.beginText();
                contentStream.moveTextPositionByAmount(x, y);
                contentStream.setTextMatrix(new Matrix(1.0f, 0.0f, 0.2f, 1.0f, x + 0.2f * y, y));
                contentStream.newLineAtOffset(-0.2f * y, 0.0f);
            } else {
                contentStream.beginText();
                contentStream.newLineAtOffset(x, y);
            }
            contentStream.showText(text);
            if (isWrapped) {
                contentStream.newLineAtOffset(-x, -((float)Double.valueOf(props.getGeneralProperty("Leading")).doubleValue()));
            }
            contentStream.endText();
            contentStream.setLineWidth(1.0f);
            contentStream.setRenderingMode(RenderingMode.FILL);
            contentStream.moveTo(x, y);
        }
        catch (IOException ioe) {
            log.error("failed to apply text styling: ", (Throwable)ioe);
        }
    }

    private void showWrappedTextAligned(PDPageContentStream contentStream, PDFont font, int alignment, String text, float llx, float lly, float urx, float ury) {
        try {
            ArrayList<String> lines = new ArrayList<String>();
            String[] words = text.split(" ");
            StringBuilder currentLine = new StringBuilder();
            for (String word : words) {
                float currentLineWidth = font.getStringWidth(currentLine + " " + word) / 1000.0f * (float)this.fontSize;
                if (currentLineWidth < urx - llx) {
                    if (currentLine.length() > 0) {
                        currentLine.append(" ");
                    }
                    currentLine.append(word);
                    continue;
                }
                lines.add(currentLine.toString());
                currentLine.setLength(0);
                currentLine.append(word);
            }
            lines.add(currentLine.toString());
            float leading = lines.size() == 1 ? (float)this.fontSize : 1.2f * (float)this.fontSize;
            float totalTextHeight = (float)(this.fontSize * lines.size()) + leading * (float)(lines.size() - 1);
            float startY = lines.size() == 1 ? lly + (ury - lly - totalTextHeight) / 2.0f : lly + (ury - lly - totalTextHeight) / 2.0f + (float)(lines.size() - 1) * ((float)this.fontSize + leading) + font.getFontDescriptor().getDescent() / 1000.0f * (float)this.fontSize;
            for (String line : lines) {
                float startX;
                float lineWidth = font.getStringWidth(line) / 1000.0f * (float)this.fontSize;
                switch (alignment) {
                    case 1: {
                        startX = llx + (urx - llx - lineWidth) / 2.0f;
                        break;
                    }
                    case 2: {
                        startX = urx - lineWidth;
                        break;
                    }
                    default: {
                        startX = llx;
                    }
                }
                this.resolveTextStyling(contentStream, line, startX, startY, true);
                startY -= leading;
            }
        }
        catch (IOException ioe) {
            log.error("failed to draw wrapped text: ", (Throwable)ioe);
        }
    }

    private void showTextAligned(PDPageContentStream contentStream, PDFont font, int alignment, String text, float x, float y) {
        try {
            contentStream.setLeading((float)Double.valueOf(props.getGeneralProperty("Leading")).doubleValue());
            float textWidth = font.getStringWidth(text) / 1000.0f * (float)this.fontSize;
            switch (alignment) {
                case 0: 
                case 3: {
                    break;
                }
                case 1: {
                    x -= textWidth / 2.0f;
                    break;
                }
                case 2: {
                    x -= textWidth;
                }
            }
            this.resolveTextStyling(contentStream, text, x, y, false);
        }
        catch (IOException ioe) {
            log.error("failed to draw aligned text: ", (Throwable)ioe);
        }
    }

    @Override
    public boolean GxPrintInit(String output, int[] gxXPage, int[] gxYPage, String iniFile, String form, String printer, int mode, int orientation, int pageSize, int pageLength, int pageWidth, int scale, int copies, int defSrc, int quality, int color, int duplex) {
        try {
            boolean preResult = super.GxPrintInit(output, gxXPage, gxYPage, iniFile, form, printer, mode, orientation, pageSize, pageLength, pageWidth, scale, copies, defSrc, quality, color, duplex);
            this.runDirection = Integer.valueOf(props.getGeneralProperty("RunDirection"));
            this.pageSize = this.computePageSize(this.leftMargin, this.topMargin, pageWidth, pageLength, props.getBooleanGeneralProperty("MarginsInsideBorder", false));
            gxXPage[0] = (int)this.pageSize.getUpperRightX();
            gxYPage[0] = props.getBooleanGeneralProperty("FixSac24437", true) ? (int)((double)pageLength / 14.4) : (int)((double)pageLength / 15.45);
            this.init();
            if (!preResult) {
                return !preResult;
            }
            return true;
        }
        catch (Exception e) {
            log.error("GxPrintInit failed", (Throwable)e);
            return false;
        }
    }

    private PDRectangle computePageSize(float leftMargin, float topMargin, int width, int length, boolean marginsInsideBorder) {
        if (leftMargin == 0.0f && topMargin == 0.0f || marginsInsideBorder) {
            if (length == 23818 && width == 16834) {
                return PDRectangle.A3;
            }
            if (length == 16834 && width == 11909) {
                return PDRectangle.A4;
            }
            if (length == 11909 && width == 8395) {
                return PDRectangle.A5;
            }
            if (length == 20016 && width == 5731) {
                return new PDRectangle(250.0f, 353.0f);
            }
            if (length == 14170 && width == 9979) {
                return new PDRectangle(176.0f, 250.0f);
            }
            if (length == 15120 && width == 10440) {
                return new PDRectangle(184.15f, 266.7f);
            }
            if (length == 20160 && width == 12240) {
                return PDRectangle.LEGAL;
            }
            if (length == 15840 && width == 12240) {
                return PDRectangle.LETTER;
            }
            return new PDRectangle((float)((int)((double)width / 20.0)), (float)((int)((double)length / 20.0)));
        }
        return new PDRectangle((float)((int)((double)width / 20.0)) + leftMargin, (float)((int)((double)length / 20.0)) + topMargin);
    }

    @Override
    public void GxEndDocument() {
        try {
            if (this.document.getNumberOfPages() == 0) {
                this.document.addPage(new PDPage(this.pageSize));
                ++this.pages;
            }
            if (this.template != null) {
                try {
                    this.template.beginText();
                    this.template.setFont(this.baseFont, (float)this.fontSize);
                    this.template.setTextMatrix(new Matrix());
                    this.template.setNonStrokingColor(this.templateColorFill);
                    this.template.showText(String.valueOf(this.pages));
                    this.template.endText();
                    this.template.close();
                    for (PDPage page : this.document.getPages()) {
                        try (PDPageContentStream templatePainter = new PDPageContentStream(this.document, page, PDPageContentStream.AppendMode.APPEND, false);){
                            templatePainter.drawForm(this.formXObjecttemplate);
                        }
                    }
                    this.template.close();
                }
                catch (IOException e) {
                    log.error("GxEndDocument: failed to apply template", (Throwable)e);
                }
            }
            int copies = 1;
            try {
                COSName duplexValue;
                copies = Integer.parseInt(this.printerSettings.getProperty(this.form, "Copies"));
                log.debug("Setting number of copies to " + copies);
                this.writer = this.document.getDocumentCatalog();
                COSDictionary dict = new COSDictionary();
                if (this.writer.getViewerPreferences() != null && this.writer.getViewerPreferences().getCOSObject() != null) {
                    dict = this.writer.getViewerPreferences().getCOSObject();
                }
                PDViewerPreferences viewerPreferences = new PDViewerPreferences(dict);
                viewerPreferences.setPrintScaling(PDViewerPreferences.PRINT_SCALING.None);
                dict.setInt("NumCopies", copies);
                this.writer.setViewerPreferences(viewerPreferences);
                int duplex = Integer.parseInt(this.printerSettings.getProperty(this.form, "Duplex"));
                switch (duplex) {
                    case 1: {
                        duplexValue = COSName.HELV;
                        break;
                    }
                    case 2: {
                        duplexValue = COSName.DUPLEX;
                        break;
                    }
                    case 3: {
                        duplexValue = COSName.DUPLEX;
                        break;
                    }
                    case 4: {
                        duplexValue = COSName.DUPLEX;
                        break;
                    }
                    default: {
                        duplexValue = COSName.NONE;
                    }
                }
                log.debug("Setting duplex to " + duplexValue);
                this.writer = this.document.getDocumentCatalog();
                dict = this.writer.getViewerPreferences().getCOSObject();
                if (dict == null) {
                    dict = new COSDictionary();
                }
                viewerPreferences = new PDViewerPreferences(dict);
                viewerPreferences.setPrintScaling(PDViewerPreferences.PRINT_SCALING.None);
                dict.setName(COSName.DUPLEX, duplexValue.toString());
                this.writer.setViewerPreferences(viewerPreferences);
            }
            catch (Exception e) {
                log.error("GxEndDocument: failed to apply viewer preferences ", (Throwable)e);
            }
            String serverPrinting = props.getGeneralProperty("ServerPrinting");
            boolean fit = props.getGeneralProperty("AdjustToPaper").equals("true");
            if ((this.outputType == 1 || this.outputType == 4) && this.httpContext instanceof HttpContextWeb && serverPrinting.equals("false")) {
                PDDocumentCatalog catalog = this.document.getDocumentCatalog();
                StringBuffer jsActions = new StringBuffer();
                jsActions.append("var pp = this.getPrintParams();\n");
                String printerAux = this.printerSettings.getProperty(this.form, "Printer");
                String printer = PDFReportPDFBox.replace(printerAux, "\\", "\\\\");
                if (printer != null && !printer.equals("")) {
                    jsActions.append("pp.printerName = \"" + printer + "\";\n");
                }
                if (fit) {
                    jsActions.append("pp.pageHandling = pp.constants.handling.fit;\n");
                } else {
                    jsActions.append("pp.pageHandling = pp.constants.handling.none;\n");
                }
                if (this.printerSettings.getProperty(this.form, "Mode", "3").startsWith("0")) {
                    jsActions.append("pp.interactive = pp.constants.interactionLevel.automatic;\n");
                    for (int i = 0; i < copies; ++i) {
                        jsActions.append("this.print(pp);\n");
                    }
                } else {
                    jsActions.append("pp.interactive = pp.constants.interactionLevel.full;\n");
                    jsActions.append("this.print(pp);\n");
                }
                PDActionJavaScript openActions = new PDActionJavaScript(jsActions.toString());
                catalog.setOpenAction((PDDestinationOrAction)openActions);
            }
            try {
                this.document.save(this.outputStream);
                this.document.close();
            }
            catch (IOException ioe) {
                log.error("GxEndDocument: failed to save document to the output stream", (Throwable)ioe);
            }
            log.debug("GxEndDocument!");
            try {
                props.save();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            switch (this.outputType) {
                case 0: {
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        PDFReportPDFBox.showReport(this.docName, this.modal);
                    }
                    catch (Exception e) {
                        log.error("GxEndDocument: failed to show report ", (Throwable)e);
                    }
                    break;
                }
                case 1: {
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        if (this.httpContext instanceof HttpContextWeb && serverPrinting.equals("false")) break;
                        PDFReportPDFBox.printReport(this.docName, this.printerOutputMode == 1);
                    }
                    catch (Exception e) {
                        log.error("GxEndDocument: failed to print report ", (Throwable)e);
                    }
                    break;
                }
                case 2: {
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException e) {
                        log.error("GxEndDocument: failed to save report to file ", (Throwable)e);
                    }
                    break;
                }
            }
            this.outputStream = null;
        }
        catch (Exception e) {
            log.error("GxEndDocument failed: ", (Throwable)e);
        }
    }

    @Override
    public void GxStartPage() {
        this.document.addPage(new PDPage(this.pageSize));
        ++this.pages;
        ++this.page;
    }

    static {
        log = LogManager.getLogger(PDFReportPDFBox.class);
    }

    private class SpaceHandler {
        float currentYPosition;
        float availableSpace;

        public SpaceHandler(float currentYPosition, float availableSpace) {
            this.currentYPosition = currentYPosition;
            this.availableSpace = availableSpace;
        }

        public float getCurrentYPosition() {
            return this.currentYPosition;
        }

        public void setCurrentYPosition(float currentYPosition) {
            this.currentYPosition = currentYPosition;
        }

        public float getAvailableSpace() {
            return this.availableSpace;
        }

        public void setAvailableSpace(float availableSpace) {
            this.availableSpace = availableSpace;
        }
    }
}

