/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.reports.fonts;

import com.genexus.reports.ParseINI;
import com.genexus.reports.fonts.TrueTypeFontCache;
import com.genexus.reports.fonts.Utilities;
import java.io.File;
import java.util.Enumeration;

public class PDFFontDescriptor {
    public static String getTrueTypeFontLocation(String fontName, ParseINI props) {
        String fontLocation;
        String stripedFontName = fontName;
        if (fontName.indexOf(",") != -1) {
            stripedFontName = fontName.substring(0, fontName.indexOf(","));
        }
        if ((fontLocation = props.getProperty("Fonts Location (Sun)", fontName)) != null) {
            return fontLocation;
        }
        Enumeration<String> enumera = Utilities.parseLine(Utilities.getPredefinedSearchPaths(), ";").elements();
        while (enumera.hasMoreElements()) {
            File dir = new File(enumera.nextElement());
            File[] files = dir.listFiles();
            if (files == null) continue;
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().toUpperCase().endsWith(".TTF") && !files[i].getName().toUpperCase().endsWith(".TTC")) continue;
                String absolutePath = files[i].getAbsolutePath();
                String mapped = TrueTypeFontCache.getFontFamilyName(files[i], 0, false);
                if (mapped == null || !mapped.equalsIgnoreCase(stripedFontName)) continue;
                if (files[i].getName().toUpperCase().endsWith(".TTC")) {
                    absolutePath = absolutePath + ",0";
                }
                props.setProperty("Fonts Location (Sun)", fontName, absolutePath);
                return absolutePath;
            }
        }
        return "";
    }
}

