/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.reports.fonts;

import java.awt.Font;
import java.io.File;
import java.util.HashMap;

public class TrueTypeFontCache {
    private static HashMap<String, String> fontCache = new HashMap();

    public static String getFontFamilyName(File fontFile, int fontFormat, boolean isCopy) {
        String absolutePath = fontFile.getAbsolutePath();
        String cacheKey = "";
        String familyName = "";
        cacheKey = absolutePath + String.valueOf(fontFormat) + String.valueOf(isCopy);
        familyName = TrueTypeFontCache.getFromCache(cacheKey);
        if (familyName != null) {
            return familyName;
        }
        try {
            familyName = Font.createFont(0, fontFile).getFamily();
        }
        catch (Exception ex) {
            System.err.println("TrueTypeFontCache Error: Wrapper not found");
            ex.printStackTrace();
            return null;
        }
        if (cacheKey == null || cacheKey.equals("") || familyName == null || familyName.equals("")) {
            return null;
        }
        TrueTypeFontCache.putToCache(cacheKey, familyName);
        return familyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putToCache(String cacheKey, String cacheValue) {
        HashMap<String, String> hashMap = fontCache;
        synchronized (hashMap) {
            fontCache.put(cacheKey, cacheValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFromCache(String cacheKey) {
        HashMap<String, String> hashMap = fontCache;
        synchronized (hashMap) {
            return fontCache.get(cacheKey);
        }
    }

    public static void cleanup() {
        fontCache.clear();
        fontCache = null;
    }
}

