/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.sap;

import com.genexus.diagnostics.Log;
import com.sap.conn.jco.ext.DestinationDataEventListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.ext.ServerDataEventListener;
import com.sap.conn.jco.ext.ServerDataProvider;
import java.util.Hashtable;
import java.util.Properties;

public class DestinationProvider
implements DestinationDataProvider,
ServerDataProvider {
    private static DestinationProvider _instance;
    private static final String SAP_SERVER = "SAP_SERVER";
    private static final String SAP_DOC_SERVER = "DMS_SERVER";
    private Properties connectionProperties;
    private Hashtable<String, Properties> connectionList = new Hashtable();
    private DestinationDataEventListener eventListener;

    public static DestinationProvider Instance() {
        if (_instance == null) {
            _instance = new DestinationProvider();
        }
        return _instance;
    }

    public Properties getDestinationProperties(String sessionName) {
        if (sessionName != null) {
            return this.connectionList.get(sessionName);
        }
        return null;
    }

    public boolean supportsEvents() {
        return true;
    }

    public void setDestinationDataEventListener(DestinationDataEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public Properties getServerProperties(String serverName) {
        if (serverName != null) {
            return this.connectionList.get(serverName);
        }
        return null;
    }

    public void setServerDataEventListener(ServerDataEventListener arg0) {
    }

    public void removeServerProperties(String serverName) {
        if (this.eventListener != null) {
            this.eventListener.deleted(serverName);
        }
        this.connectionProperties = null;
        this.connectionList.remove(serverName);
    }

    public void setServerProperties(String serverName, Properties properties) {
        if (serverName == null || serverName.equals("")) {
            serverName = SAP_DOC_SERVER;
        }
        if (!Environment.isServerDataProviderRegistered()) {
            Environment.registerServerDataProvider((ServerDataProvider)this);
        }
        if (properties == null) {
            if (this.eventListener != null) {
                this.eventListener.deleted(serverName);
            }
            this.connectionProperties = null;
            this.connectionList.remove(serverName);
        } else {
            Log.info((String)("GX SAP Doc Server - Setting Properties : " + serverName + " total : " + this.connectionList.size()));
            this.connectionProperties = properties;
            this.connectionList.put(serverName, this.connectionProperties);
            if (this.eventListener != null) {
                this.eventListener.updated(serverName);
            }
        }
    }

    public void removeConnectionProperties(String sessionName) {
        if (this.eventListener != null) {
            this.eventListener.deleted(sessionName);
        }
        this.connectionProperties = null;
        this.connectionList.remove(sessionName);
    }

    public void setConnectionProperties(String sessionName, Properties properties) {
        if (sessionName == null || sessionName.equals("")) {
            sessionName = SAP_SERVER;
        }
        if (!Environment.isDestinationDataProviderRegistered()) {
            Environment.registerDestinationDataProvider((DestinationDataProvider)this);
        }
        if (properties == null) {
            if (this.eventListener != null) {
                this.eventListener.deleted(sessionName);
            }
            this.connectionProperties = null;
            this.connectionList.remove(sessionName);
        } else {
            Log.info((String)("GX SAP - Setting Properties : " + sessionName + " total : " + this.connectionList.size()));
            this.connectionProperties = properties;
            this.connectionList.put(sessionName, this.connectionProperties);
            if (this.eventListener != null) {
                this.eventListener.updated(sessionName);
            }
        }
    }
}

