/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.sap;

import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerContextInfo;
import com.sap.conn.jco.server.JCoServerErrorListener;
import com.sap.conn.jco.server.JCoServerExceptionListener;
import com.sap.conn.jco.server.JCoServerFunctionHandler;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class DocumentClient {
    private static final int BLOB_LENGTH = 1022;

    static class FTP_CLIENT_TO_R3Handler
    implements JCoServerFunctionHandler {
        FTP_CLIENT_TO_R3Handler() {
        }

        public void handleRequest(JCoServerContext serverCtx, JCoFunction function) {
            String fname = function.getImportParameterList().getString("FNAME");
            fname = fname.replace("#", "");
            Path inputFile = Paths.get(fname, new String[0]);
            try (InputStream source = Files.newInputStream(inputFile, new OpenOption[0]);){
                int bytesread;
                byte[] file2 = new byte[1022];
                int totallenght = 0;
                InputStream source2 = Files.newInputStream(inputFile, new OpenOption[0]);
                JCoTable blobtable = function.getTableParameterList().getTable("BLOB");
                while ((bytesread = source2.read(file2, 0, file2.length)) > 0) {
                    blobtable.appendRow();
                    blobtable.setValue("LINE", file2);
                    totallenght += bytesread;
                }
                JCoParameterList exports = function.getExportParameterList();
                exports.setValue("LENGTH", totallenght);
            }
            catch (IOException e) {
                e.printStackTrace();
                function.getExportParameterList().setValue("ERROR", 3);
            }
        }
    }

    static class FTP_R3_TO_CLIENTHandler
    implements JCoServerFunctionHandler {
        FTP_R3_TO_CLIENTHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRequest(JCoServerContext serverCtx, JCoFunction function) {
            block16: {
                JCoParameterList imports = function.getImportParameterList();
                String fname = imports.getString("FNAME");
                int length = imports.getInt("LENGTH");
                JCoTable blob = function.getTableParameterList().getTable("BLOB");
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(fname);
                    boolean hasNextRow = false;
                    if (!blob.isEmpty()) {
                        hasNextRow = true;
                        blob.firstRow();
                    }
                    while (length > 1022) {
                        if (hasNextRow) {
                            out.write(blob.getByteArray(0), 0, 1022);
                            length -= 1022;
                            hasNextRow = blob.nextRow();
                            continue;
                        }
                        throw new IOException("Not enough data in table BLOB (" + 1022 * blob.getNumRows() + ") for requested file size (" + length + ")");
                    }
                    if (length <= 0) break block16;
                    if (hasNextRow) {
                        out.write(blob.getByteArray(0), 0, length);
                        break block16;
                    }
                    throw new IOException("Not enough data in table BLOB (" + 1022 * blob.getNumRows() + ") for requested file size (" + length + ")");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    function.getExportParameterList().setValue("ERROR", 3);
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    static class ErrorHandler
    implements JCoServerErrorListener,
    JCoServerExceptionListener {
        ErrorHandler() {
        }

        public void serverExceptionOccurred(JCoServer server, String connectionID, JCoServerContextInfo serverCtx, Exception error) {
            error.printStackTrace();
        }

        public void serverErrorOccurred(JCoServer server, String connectionID, JCoServerContextInfo serverCtx, Error error) {
            error.printStackTrace();
        }
    }
}

