/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.sap;

import com.genexus.ModelContext;
import com.genexus.diagnostics.Log;
import com.genexus.sap.DocumentClient;
import com.sap.conn.jco.JCo;
import com.sap.conn.jco.JCoCustomRepository;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.server.DefaultServerHandlerFactory;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerCallHandlerFactory;
import com.sap.conn.jco.server.JCoServerErrorListener;
import com.sap.conn.jco.server.JCoServerExceptionListener;
import com.sap.conn.jco.server.JCoServerFactory;

public class DocumentReceiver {
    private String serverName;
    private String repositoryName;
    private ModelContext _context;
    JCoServer receiver = null;

    public DocumentReceiver(String server, String repository, ModelContext context) {
        this.serverName = server;
        this.repositoryName = repository;
        this._context = context;
    }

    public void start() {
        Log.info((String)("GX SAP - DMS Receiver Start " + this.serverName + " " + this.repositoryName));
        try {
            this.receiver = this.setupServerDownload(this.serverName, this.repositoryName);
            this.receiver.start();
        }
        catch (JCoException ex) {
            Log.error((String)("GX SAP - Error Starting " + (Object)((Object)ex)));
        }
    }

    public void stop() {
        String receiverName = "";
        if (this.serverName == null || this.serverName.equals("")) {
            Object receiverObj = this._context.getContextProperty("SAPReceiverServerName");
            if (receiverObj != null) {
                receiverName = (String)receiverObj;
            }
        } else {
            receiverName = this.serverName;
        }
        try {
            if (!receiverName.equals("")) {
                this.receiver = JCoServerFactory.getServer((String)receiverName);
                if (this.receiver != null) {
                    this.receiver.stop();
                }
                Log.info((String)("GX SAP - DMS Receiver stop " + receiverName));
            } else {
                Log.error((String)"GX SAP - Error Stopping receiver.");
            }
        }
        catch (JCoException ex) {
            Log.error((String)("GX SAP - Error Stopping " + (Object)((Object)ex)));
        }
    }

    public JCoServer setupServerDownload(String serverName, String repositoryName) throws JCoException {
        JCoServer server = JCoServerFactory.getServer((String)serverName);
        JCoCustomRepository repo = JCo.createCustomRepository((String)repositoryName);
        JCoListMetaData imports = JCo.createListMetaData((String)"IMPORTING");
        imports.add("FNAME", 0, 256, 512, 2);
        imports.add("LENGTH", 8, 4, 4, 2);
        imports.add("MODE", 0, 1, 2, 3);
        imports.lock();
        JCoListMetaData exports = JCo.createListMetaData((String)"EXPORTING");
        exports.add("ERROR", 8, 4, 4, 4);
        exports.add("LENGTH", 8, 4, 4, 4);
        exports.lock();
        JCoRecordMetaData tabLine = JCo.createRecordMetaData((String)"BLOB");
        tabLine.add("LINE", 4, 1022, 0, 1022, 0);
        tabLine.lock();
        JCoListMetaData tables = JCo.createListMetaData((String)"TABLES");
        tables.add("BLOB", 99, tabLine, 0);
        tables.lock();
        JCoFunctionTemplate FTP_R3_TO_CLIENT = JCo.createFunctionTemplate((String)"FTP_R3_TO_CLIENT", (JCoListMetaData)imports, (JCoListMetaData)exports, null, (JCoListMetaData)tables, null);
        repo.addFunctionTemplateToCache(FTP_R3_TO_CLIENT);
        server.setRepository((JCoRepository)repo);
        DefaultServerHandlerFactory.FunctionHandlerFactory handlerFactory = new DefaultServerHandlerFactory.FunctionHandlerFactory();
        handlerFactory.registerHandler("FTP_R3_TO_CLIENT", (Object)new DocumentClient.FTP_R3_TO_CLIENTHandler());
        server.setCallHandlerFactory((JCoServerCallHandlerFactory)handlerFactory);
        DocumentClient.ErrorHandler hdl = new DocumentClient.ErrorHandler();
        server.addServerErrorListener((JCoServerErrorListener)hdl);
        server.addServerExceptionListener((JCoServerExceptionListener)hdl);
        return server;
    }
}

