/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.sap;

import com.genexus.ModelContext;
import com.genexus.diagnostics.Log;
import com.genexus.sap.DocumentClient;
import com.sap.conn.jco.JCo;
import com.sap.conn.jco.JCoCustomRepository;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.server.DefaultServerHandlerFactory;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerCallHandlerFactory;
import com.sap.conn.jco.server.JCoServerErrorListener;
import com.sap.conn.jco.server.JCoServerExceptionListener;
import com.sap.conn.jco.server.JCoServerFactory;

public class DocumentSender {
    private String serverName;
    private String repositoryName;
    private ModelContext _context;
    JCoServer sender = null;

    public DocumentSender(String server, String repository, ModelContext context) {
        this.serverName = server;
        this.repositoryName = repository;
        this._context = context;
    }

    public void start() {
        Log.info((String)("GX SAP - DMS Sender Start " + this.serverName + " " + this.repositoryName));
        try {
            this.sender = this.setupServerUpload(this.serverName, this.repositoryName);
            this.sender.start();
        }
        catch (JCoException ex) {
            Log.error((String)("GX SAP - Error Starting " + (Object)((Object)ex)));
        }
    }

    public void stop() {
        String senderName = "";
        if (this.serverName == null || this.serverName.equals("")) {
            Object senderObj = this._context.getContextProperty("SAPSenderServerName");
            if (senderObj != null) {
                senderName = (String)senderObj;
            }
        } else {
            senderName = this.serverName;
        }
        try {
            if (!senderName.equals("")) {
                this.sender = JCoServerFactory.getServer((String)senderName);
                if (this.sender != null) {
                    this.sender.stop();
                }
                Log.info((String)("GX SAP - DMS Sender stop " + senderName));
            } else {
                Log.error((String)"GX SAP - Error Stopping sender");
            }
        }
        catch (JCoException ex) {
            Log.error((String)("GX SAP - Error Stopping " + (Object)((Object)ex)));
        }
    }

    public JCoServer setupServerUpload(String serverName, String repositoryName) throws JCoException {
        JCoServer server = JCoServerFactory.getServer((String)serverName);
        JCoCustomRepository repo = JCo.createCustomRepository((String)repositoryName);
        JCoListMetaData imports = JCo.createListMetaData((String)"IMPORTING");
        imports.add("FNAME", 0, 256, 512, 2);
        imports.add("MODE", 0, 1, 2, 3);
        imports.lock();
        JCoListMetaData exports = JCo.createListMetaData((String)"EXPORTING");
        exports.add("ERROR", 8, 4, 4, 4);
        exports.add("LENGTH", 8, 4, 4, 4);
        exports.lock();
        JCoRecordMetaData tabLine = JCo.createRecordMetaData((String)"BLOB");
        tabLine.add("LINE", 4, 1022, 0, 1022, 0);
        tabLine.lock();
        JCoListMetaData tables = JCo.createListMetaData((String)"TABLES");
        tables.add("BLOB", 99, tabLine, 0);
        tables.lock();
        JCoFunctionTemplate FTP_CLIENT_TO_R3 = JCo.createFunctionTemplate((String)"FTP_CLIENT_TO_R3", (JCoListMetaData)imports, (JCoListMetaData)exports, null, (JCoListMetaData)tables, null);
        repo.addFunctionTemplateToCache(FTP_CLIENT_TO_R3);
        server.setRepository((JCoRepository)repo);
        DefaultServerHandlerFactory.FunctionHandlerFactory handlerFactory = new DefaultServerHandlerFactory.FunctionHandlerFactory();
        handlerFactory.registerHandler("FTP_CLIENT_TO_R3", (Object)new DocumentClient.FTP_CLIENT_TO_R3Handler());
        server.setCallHandlerFactory((JCoServerCallHandlerFactory)handlerFactory);
        DocumentClient.ErrorHandler hdl = new DocumentClient.ErrorHandler();
        server.addServerErrorListener((JCoServerErrorListener)hdl);
        server.addServerExceptionListener((JCoServerExceptionListener)hdl);
        return server;
    }
}

