/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.sap;

import com.genexus.GXSimpleCollection;
import com.genexus.ModelContext;
import com.genexus.internet.IGxJSONAble;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import json.org.json.IJsonFormattable;
import json.org.json.JSONArray;
import json.org.json.JSONException;
import json.org.json.JSONObject;

public class EnterpriseConnect {
    static final String DESTINATION_NAME = "SAP_SERVER";
    static final int BLOB_LENGTH = 1022;
    JCoFunction function = null;
    String destinationName = "SAP_SERVER";

    public EnterpriseConnect(ModelContext context) {
        Object destination = context.getContextProperty("SAPSessionName");
        if (destination != null) {
            this.destinationName = (String)destination;
        }
    }

    public void setValue(String parameterName, String value) {
        boolean setvalue = false;
        if (value != null && !value.trim().equals("")) {
            setvalue = true;
            this.function.getImportParameterList().setValue(parameterName, value);
        }
        this.function.getImportParameterList().setActive(parameterName, setvalue);
    }

    public void setValue(String parameterName, int value) {
        this.function.getImportParameterList().setValue(parameterName, value);
        this.function.getImportParameterList().setActive(parameterName, true);
    }

    public void setValue(String parameterName, long value) {
        this.function.getImportParameterList().setValue(parameterName, value);
        this.function.getImportParameterList().setActive(parameterName, true);
    }

    public void setValue(String parameterName, BigDecimal value) {
        this.function.getImportParameterList().setValue(parameterName, value);
        this.function.getImportParameterList().setActive(parameterName, true);
    }

    public void setValue(String parameterName, double value) {
        this.function.getImportParameterList().setValue(parameterName, value);
        this.function.getImportParameterList().setActive(parameterName, true);
    }

    public void setValue(String parameterName, Date value) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(0, 0, 0);
        Date baseDate = calendar.getTime();
        if (value != null && value.after(baseDate)) {
            this.function.getImportParameterList().setValue(parameterName, (Object)value);
            this.function.getImportParameterList().setActive(parameterName, true);
        } else {
            this.function.getImportParameterList().setActive(parameterName, false);
        }
    }

    public void setValue(String parameterName, GXSimpleCollection<?>[] value, Boolean inOut) {
        if (value != null && value.length > 0) {
            this.setValue(parameterName, value[0], inOut);
        }
    }

    public void setValue(String parameterName, GXSimpleCollection<?>[] value) {
        if (value != null && value.length > 0) {
            this.setValue(parameterName, value[0]);
        }
    }

    public void setValue(String parameterName, IGxJSONAble[] value) {
        if (value != null && value.length > 0) {
            this.setValue(parameterName, value[0]);
        }
    }

    public void setValue(String parameterName, GXSimpleCollection<?> value) {
        this.setValue(parameterName, value, (Boolean)false);
    }

    public void setValue(String parameterName, GXSimpleCollection<?> value, Boolean inOut) {
        JCoTable jTable = this.function.getTableParameterList().getTable(parameterName);
        boolean setValues = false;
        try {
            for (int i = 1; i <= value.getItemCount(); ++i) {
                IGxJSONAble item = (IGxJSONAble)value.item(i);
                if (item == null) continue;
                setValues = true;
                JSONObject jObj = (JSONObject)item.GetJSONObject();
                jTable.appendRow();
                jTable.lastRow();
                Iterator keys = jObj.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    int jcoType = jTable.getRecordMetaData().getType(key);
                    int dec = jTable.getRecordMetaData().getDecimals(key);
                    if (jObj.get(key) instanceof String) {
                        String obj_value = jObj.getString(key);
                        if (jcoType == 6 && dec == 0 && !obj_value.trim().equals("")) {
                            String sValue = new DecimalFormat("#").format(new BigDecimal(obj_value));
                            jTable.setValue(key, sValue);
                            continue;
                        }
                        jTable.setValue(key, obj_value);
                        continue;
                    }
                    if (jcoType == 6 || jcoType == 8) {
                        jTable.setValue(key, jObj.getLong(key));
                        continue;
                    }
                    if (jcoType == 7 || jcoType == 2) {
                        jTable.setValue(key, jObj.getDouble(key));
                        continue;
                    }
                    if (jcoType == 1) {
                        jTable.setValue(key, jObj.getString(key));
                        continue;
                    }
                    if (jcoType == 9 || jcoType == 10 || jcoType == 4) {
                        jTable.setValue(key, jObj.getInt(key));
                        continue;
                    }
                    System.out.println(key + " Invalid Type " + jcoType);
                }
            }
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex.toString());
        }
        if (setValues) {
            this.function.getTableParameterList().setActive(parameterName, true);
        } else {
            this.function.getTableParameterList().setActive(parameterName, inOut.booleanValue());
        }
    }

    public void setValue(String parameterName, IGxJSONAble value) {
        try {
            JCoStructure jStruct = this.function.getImportParameterList().getStructure(parameterName);
            if (value != null) {
                JSONObject jObj = (JSONObject)value.GetJSONObject();
                Iterator keys = jObj.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    int jcoType = jStruct.getMetaData().getType(key);
                    if (jObj.get(key) instanceof String) {
                        jStruct.setValue(key, jObj.getString(key));
                        continue;
                    }
                    if (jcoType == 6 || jcoType == 8) {
                        jStruct.setValue(key, jObj.getLong(key));
                        continue;
                    }
                    if (jcoType == 7 || jcoType == 2) {
                        jStruct.setValue(key, jObj.getDouble(key));
                        continue;
                    }
                    if (jcoType == 1) {
                        jStruct.setValue(key, jObj.getString(key));
                        continue;
                    }
                    if (jcoType == 9 || jcoType == 10 || jcoType == 4) {
                        jStruct.setValue(key, jObj.getInt(key));
                        continue;
                    }
                    System.out.println(key + " Invalid Type " + jcoType);
                }
                this.function.getImportParameterList().setActive(parameterName, true);
            } else {
                this.function.getImportParameterList().setActive(parameterName, false);
            }
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public void getValue(String parameterName, GXSimpleCollection<?>[] value) {
        if (value.length != 0) {
            GXSimpleCollection<?> col = value[0];
            col.clear();
            JCoTable tbl = this.function.getTableParameterList().getTable(parameterName);
            JSONArray jCol = new JSONArray();
            try {
                for (int i = 0; i < tbl.getNumRows(); ++i) {
                    JSONObject jRow = new JSONObject();
                    tbl.setRow(i);
                    for (JCoField field : tbl) {
                        if (field.getType() == 8 || field.getType() == 6 && field.getDecimals() == 0) {
                            jRow.put(field.getName(), field.getLong());
                            continue;
                        }
                        if (field.getType() == 9 || field.getType() == 10 || field.getType() == 4) {
                            jRow.put(field.getName(), field.getInt());
                            continue;
                        }
                        if (field.getType() == 6 || field.getType() == 7 || field.getType() == 2) {
                            jRow.put(field.getName(), field.getDouble());
                            continue;
                        }
                        jRow.put(field.getName(), (Object)field.getString());
                    }
                    jCol.put((Object)jRow);
                }
                col.FromJSONObject((IJsonFormattable)jCol);
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex.toString());
            }
        }
    }

    public void getValue(String parameterName, IGxJSONAble[] value) {
        try {
            IGxJSONAble struct = value[0];
            JCoStructure jStruct = this.function.getExportParameterList().getStructure(parameterName);
            JSONObject jRow = new JSONObject();
            for (JCoField field : jStruct) {
                if (field.getType() == 6 || field.getType() == 7 || field.getType() == 2) {
                    jRow.put(field.getName(), field.getDouble());
                    continue;
                }
                jRow.put(field.getName(), (Object)field.getString());
            }
            struct.FromJSONObject((IJsonFormattable)jRow);
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public void getValue(String parameterName, String[] value) {
        value[0] = this.function.getExportParameterList().getString(parameterName);
    }

    public void getValue(String parameterName, Date[] value) {
        value[0] = this.function.getExportParameterList().getDate(parameterName);
    }

    public void getValue(String parameterName, int[] value) {
        value[0] = this.function.getExportParameterList().getInt(parameterName);
    }

    public void getValue(String parameterName, long[] value) {
        value[0] = this.function.getExportParameterList().getLong(parameterName);
    }

    public void getValue(String parameterName, float[] value) {
        value[0] = this.function.getExportParameterList().getFloat(parameterName);
    }

    public void getValue(String parameterName, double[] value) {
        value[0] = this.function.getExportParameterList().getDouble(parameterName);
    }

    public void getValue(String parameterName, BigDecimal[] value) {
        value[0] = this.function.getExportParameterList().getBigDecimal(parameterName);
    }

    public int getIntValue(String parameterName) {
        return this.function.getExportParameterList().getInt(parameterName);
    }

    public void executeStart(String functionName) {
        try {
            this.executeStart(functionName, false);
        }
        catch (JCoException e) {
            throw new RuntimeException("JCoException: " + (Object)((Object)e));
        }
    }

    public void executeStart(String functionName, boolean isTransaction) throws JCoException {
        try {
            JCoDestination destination = JCoDestinationManager.getDestination((String)this.destinationName);
            if (isTransaction) {
                JCoContext.begin((JCoDestination)destination);
            }
            this.function = destination.getRepository().getFunction(functionName);
            if (this.function == null) {
                throw new RuntimeException("GeneXus cannot find SAP function " + functionName);
            }
        }
        catch (AbapException e) {
            throw new RuntimeException(" ABAP Exception: " + (Object)((Object)e));
        }
    }

    public int executeFunction(String functionName) {
        try {
            return this.executeFunction(functionName, false);
        }
        catch (JCoException e) {
            throw new RuntimeException("JCoException excecuting: " + (Object)((Object)e));
        }
    }

    public int executeFunction(String functionName, boolean isTransaction) throws JCoException {
        try {
            JCoDestination destination = JCoDestinationManager.getDestination((String)this.destinationName);
            this.function.execute(destination);
            if (isTransaction) {
                JCoFunction commitFnc = destination.getRepository().getFunction("BAPI_TRANSACTION_COMMIT");
                commitFnc.execute(destination);
                JCoContext.end((JCoDestination)destination);
            }
        }
        catch (AbapException e) {
            throw new RuntimeException("ABAP exception executing: " + (Object)((Object)e));
        }
        return 0;
    }
}

