/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.sap;

import com.genexus.ModelContext;
import com.genexus.diagnostics.Log;
import com.genexus.sap.DestinationProvider;
import com.genexus.sap.SessionManager;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import java.util.Properties;

public class ServerConnection {
    ModelContext _context;
    SessionManager _manager;
    DestinationProvider destinationProvider = null;
    private Integer errorCode = 0;
    private String errorMessage = "";
    private String hashedSession = "";

    public ServerConnection(SessionManager manager, ModelContext context) {
        this._manager = manager;
        this._context = context;
    }

    public void connect(Properties connectionProperties) {
        if (this.destinationProvider == null) {
            this.destinationProvider = DestinationProvider.Instance();
        }
        if (this._manager.getMessageHost() == null || this._manager.getMessageHost().equals("")) {
            connectionProperties.setProperty("jco.client.ashost", this._manager.getRouterString() + this._manager.getAppServer());
        } else if (this._manager.getPort() == null || this._manager.getPort().equals("")) {
            connectionProperties.setProperty("jco.client.mshost", this._manager.getMessageHost());
            connectionProperties.setProperty("jco.client.msserv", this._manager.getMessageSrv());
        } else {
            connectionProperties.setProperty("jco.client.mshost", this._manager.getMessageHost() + ":" + this._manager.getPort());
            if (!this._manager.getMessageSrv().equals("")) {
                connectionProperties.setProperty("jco.client.msserv", this._manager.getMessageSrv() + ":" + this._manager.getPort());
            }
        }
        connectionProperties.setProperty("jco.client.r3name", this._manager.getSystemId());
        connectionProperties.setProperty("jco.client.saprouter", this._manager.getSAPRouter());
        connectionProperties.setProperty("jco.client.group", this._manager.getGroup());
        connectionProperties.setProperty("jco.server.gwhost", this._manager.getGatewayHost());
        connectionProperties.setProperty("jco.server.gwserv", this._manager.getGatewaySrv());
        connectionProperties.setProperty("jco.server.progid", this._manager.getProgramID());
        connectionProperties.setProperty("jco.server.connection_count", this._manager.getRegistrationCount());
        connectionProperties.setProperty("jco.client.sysnr", this._manager.getInstanceNumber());
        connectionProperties.setProperty("jco.client.client", this._manager.getClientNumber());
        connectionProperties.setProperty("jco.client.user", this._manager.getUserName());
        connectionProperties.setProperty("jco.client.passwd", this._manager.getPassword());
        connectionProperties.setProperty("jco.destination.pool_capacity", this._manager.getPoolCapacity());
        connectionProperties.setProperty("jco.destination.peak_limit", this._manager.getPeekLimit());
        if (!this._manager.getLanguage().equals("")) {
            connectionProperties.setProperty("jco.client.lang", this._manager.getLanguage());
        }
        this.hashedSession = this._manager.getSessionName() + "H" + Integer.toString(connectionProperties.values().toString().hashCode()).replace("-", "0");
        Log.info((String)("GX SAP - Connecting " + this._manager.getSessionName()));
        this.destinationProvider.setConnectionProperties(this.hashedSession, connectionProperties);
        this.destinationProvider.setServerProperties(this._manager.getServerName(), connectionProperties);
        this._context.setContextProperty("SAPSessionName", (Object)this.hashedSession);
        this._context.setContextProperty("SAPReceiverServerName", (Object)this._manager.getServerName());
        this._context.setContextProperty("SAPReceiverRepositoryName", (Object)this._manager.getRepositoryName());
        this._context.setContextProperty("SAPSenderServerName", (Object)this._manager.getServerName());
        this._context.setContextProperty("SAPSenderRepositoryName", (Object)this._manager.getRepositoryName());
        try {
            JCoDestination destination = JCoDestinationManager.getDestination((String)this.hashedSession);
            destination.ping();
        }
        catch (AbapException ex) {
            this.errorCode = ex.getGroup();
            this.errorMessage = ex.toString();
            Log.warning((String)("GX SAP - Error Connecting " + this._manager.getSessionName() + " " + ex.toString()));
        }
        catch (JCoException ex) {
            if (ex.getGroup() == 108) {
                Log.error((String)("GX SAP - Error Connecting " + this._manager.getSessionName() + " " + ex.toString()));
                throw new RuntimeException(ex.toString());
            }
            this.errorCode = ex.getGroup();
            this.errorMessage = ex.toString();
            Log.warning((String)("GX SAP - Error Connecting " + this._manager.getSessionName() + " " + ex.toString()));
        }
        catch (Exception ex) {
            Log.error((String)("GX SAP - Error Connecting " + this._manager.getSessionName() + " " + ex.toString()));
            throw new RuntimeException(ex.toString());
        }
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

