/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.sap;

import com.genexus.ModelContext;
import com.genexus.diagnostics.Log;
import com.genexus.sap.DocumentReceiver;
import com.genexus.sap.DocumentSender;
import com.genexus.sap.ServerConnection;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import java.util.Properties;

public class SessionManager {
    private String msHost = "";
    private String msServ = "";
    private String group = "";
    private String sapRouter = "";
    private String gatewayHost = "";
    private String gatewayService = "";
    private String port = "";
    private String userName = "";
    private String password = "";
    private String instanceNumber = "";
    private String appServer = "";
    private String routerString = "";
    private String clientNumber = "";
    private String systemId = "";
    private String sessionName = "";
    private String sapGUI = "";
    private Integer errorCode = 0;
    private String errorMessage = "";
    private String language = "";
    private String poolCapacity = "10";
    private String peekLimit = "10";
    private String registrationCount = "3";
    private String programID = "";
    private String serverName = "";
    private String repositoryName = "";
    private ModelContext _context = null;
    Properties connectionProperties = null;
    DocumentReceiver documentReceiver = null;
    DocumentSender documentSender = null;

    public SessionManager(ModelContext context) {
        this._context = context;
    }

    public void Disconnect() {
        this.errorCode = 0;
        this.errorMessage = "";
    }

    public void ConnectSession(String destination, String scope) {
        Log.info((String)("GX SAP - Connecting to Destination" + destination));
        this.ConnectInternal(destination, destination, scope);
    }

    public void ConnectInternal(String session, String sessionName, String scope) {
        this.errorCode = 0;
        this.errorMessage = "";
        this._context.setContextProperty("SAPSessionName", (Object)session);
        this._context.setContextProperty("SAPSessionScope", (Object)scope);
        try {
            JCoDestination destination = null;
            destination = scope == null || scope.length() == 0 ? JCoDestinationManager.getDestination((String)session) : JCoDestinationManager.getDestination((String)session, (String)scope);
            destination.ping();
        }
        catch (AbapException ex) {
            this.errorCode = ex.getGroup();
            this.errorMessage = ex.toString();
            Log.warning((String)("GX SAP - Error Connecting " + sessionName + " " + (Object)((Object)ex)));
        }
        catch (JCoException ex) {
            if (ex.getGroup() == 108) {
                Log.error((String)("GX SAP - Error Connecting " + sessionName + " " + (Object)((Object)ex)));
                throw new RuntimeException(ex.toString());
            }
            this.errorCode = ex.getGroup();
            this.errorMessage = ex.toString();
            Log.warning((String)("GX SAP - Error Connecting " + sessionName + " " + (Object)((Object)ex)));
        }
        catch (Exception ex) {
            Log.error((String)("GX SAP - Error Connecting " + sessionName + " " + ex));
            throw new RuntimeException(ex.toString());
        }
    }

    public void Connect() {
        this.errorCode = 0;
        this.errorMessage = "";
        this.connectionProperties = new Properties();
        ServerConnection connection = new ServerConnection(this, this._context);
        connection.connect(this.connectionProperties);
    }

    public void DocumentReceiverStart() {
        this.documentReceiver = new DocumentReceiver(this.serverName, this.repositoryName, this._context);
        this.documentReceiver.start();
    }

    public void DocumentReceiverStop() {
        this.documentReceiver.stop();
    }

    public void DocumentSenderStart() {
        this.documentSender = new DocumentSender(this.serverName, this.repositoryName, this._context);
        this.documentSender.start();
    }

    public void DocumentSenderStop() {
        this.documentSender.stop();
    }

    public void TransactionBegin() {
        Object destinationObj = this._context.getContextProperty("SAPSessionName");
        Object scopeObj = this._context.getContextProperty("SAPSessionScope");
        String destinationName = "";
        String scopeName = "";
        if (destinationObj != null) {
            try {
                destinationName = (String)destinationObj;
                scopeName = (String)scopeObj;
                Log.info((String)("GX SAP - Begin Transaction " + destinationName));
                JCoDestination destination = null;
                destination = scopeName.length() == 0 ? JCoDestinationManager.getDestination((String)destinationName) : JCoDestinationManager.getDestination((String)destinationName, (String)scopeName);
                JCoContext.begin((JCoDestination)destination);
            }
            catch (JCoException e) {
                throw new RuntimeException(e.toString());
            }
        }
    }

    public void TransactionCommit() {
        Object destinationObj = this._context.getContextProperty("SAPSessionName");
        Object scopeObject = this._context.getContextProperty("SAPSessionScope");
        String destinationName = "";
        String scopeName = "";
        if (destinationObj != null) {
            try {
                JCoDestination destination = null;
                destinationName = (String)destinationObj;
                if (scopeObject == null || ((String)scopeObject).length() == 0) {
                    destination = JCoDestinationManager.getDestination((String)destinationName);
                } else {
                    scopeName = (String)scopeObject;
                    destination = JCoDestinationManager.getDestination((String)destinationName, (String)scopeName);
                }
                Log.info((String)("GX SAP - Commit Transaction " + destinationName));
                JCoFunction commitFnc = destination.getRepository().getFunction("BAPI_TRANSACTION_COMMIT");
                commitFnc.execute(destination);
                JCoContext.end((JCoDestination)destination);
            }
            catch (JCoException e) {
                throw new RuntimeException(e.toString());
            }
        }
    }

    public void Save() {
    }

    public void Load() {
    }

    public String getPort() {
        return this.port;
    }

    public String getMessageHost() {
        return this.msHost;
    }

    public String getMessageSrv() {
        return this.msServ;
    }

    public String getSAPRouter() {
        return this.sapRouter;
    }

    public String getGatewayHost() {
        return this.gatewayHost;
    }

    public String getGatewaySrv() {
        return this.gatewayService;
    }

    public String getGroup() {
        return this.group;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getInstanceNumber() {
        return this.instanceNumber;
    }

    public String getAppServer() {
        return this.appServer;
    }

    public String getRouterString() {
        return this.routerString;
    }

    public String getClientNumber() {
        return this.clientNumber;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public String getSAPGUI() {
        return this.sapGUI;
    }

    public String getPeekLimit() {
        return this.peekLimit;
    }

    public String getPoolCapacity() {
        return this.poolCapacity;
    }

    public String getLanguage() {
        return this.language;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getRegistrationCount() {
        return this.registrationCount;
    }

    public String getProgramID() {
        return this.programID;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setPort(String value) {
        this.port = value;
    }

    public void setMessageHost(String value) {
        this.msHost = value;
    }

    public void setMessageSrv(String value) {
        this.msServ = value;
    }

    public void setSAPRouter(String value) {
        this.sapRouter = value;
    }

    public void setGatewayHost(String value) {
        this.gatewayHost = value;
    }

    public void setGatewaySrv(String value) {
        this.gatewayService = value;
    }

    public void setGroup(String value) {
        this.group = value;
    }

    public void setUserName(String value) {
        this.userName = value;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public void setInstanceNumber(String value) {
        this.instanceNumber = value;
    }

    public void setAppServer(String value) {
        this.appServer = value;
    }

    public void setRouterString(String value) {
        this.routerString = value;
    }

    public void setClientNumber(String value) {
        this.clientNumber = value;
    }

    public void setSystemId(String value) {
        this.systemId = value;
    }

    public void setSessionName(String value) {
        this.sessionName = value;
    }

    public void setSAPGUI(String value) {
        this.sapGUI = value;
    }

    public void setPeekLimit(String value) {
        this.peekLimit = value;
    }

    public void setPoolCapacity(String value) {
        this.poolCapacity = value;
    }

    public void setLanguage(String value) {
        this.language = value;
    }

    public void setErrorCode(Integer value) {
        this.errorCode = value;
    }

    public void setErrorMessage(String value) {
        this.errorMessage = value;
    }

    public void setRegistrationCount(String value) {
        this.registrationCount = value;
    }

    public void setProgramID(String value) {
        this.programID = value;
    }

    public void setServerName(String value) {
        this.serverName = value;
    }

    public void setRepositoryName(String value) {
        this.repositoryName = value;
    }
}

