/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.specific.java;

import com.genexus.BaseProvider;
import com.genexus.CacheFactory;
import com.genexus.CommonUtil;
import com.genexus.GXSmartCacheProvider;
import com.genexus.ICacheService;
import com.genexus.ICacheService2;
import com.genexus.Preferences;
import com.genexus.common.interfaces.IExtensionGXSmartCacheProvider;
import com.genexus.common.interfaces.IGXSmartCacheProvider;
import com.genexus.diagnostics.Log;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class GXSmartCacheProvider
implements IExtensionGXSmartCacheProvider {
    public IGXSmartCacheProvider createCache() {
        return new JavaSmartCacheProvider();
    }

    public class JavaSmartCacheProvider
    extends BaseProvider {
        ICacheService updatedTables;
        GXSmartCacheProvider.SmartCacheStatus status = GXSmartCacheProvider.SmartCacheStatus.Unknown;
        Object syncLock = new Object();
        ConcurrentHashMap<Integer, Vector<String>> tablesUpdatedInUTL = new ConcurrentHashMap();

        public void invalidateAll() {
            if (this.isEnabled()) {
                this.getUpdatedTables().set(CacheFactory.CACHE_SD, "SD", (Object)CommonUtil.now((boolean)false, (boolean)false));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ICacheService getUpdatedTables() {
            if (this.updatedTables == null) {
                Object object = this.syncLock;
                synchronized (object) {
                    if (this.updatedTables == null) {
                        this.updatedTables = CacheFactory.getInstance();
                    }
                }
            }
            return this.updatedTables;
        }

        public void invalidate(String item) {
            if (this.isEnabled()) {
                this.getUpdatedTables().clear(CacheFactory.CACHE_SD, this.normalizeKey(item));
            }
        }

        public void recordUpdates(int handle) {
            if (this.isEnabled() && this.tablesUpdatedInUTL.containsKey(handle)) {
                Vector<String> tablesUpdatedInUTLHandle = this.getTablesUpdatedInUTL(handle);
                Date dt = CommonUtil.now((boolean)false, (boolean)false);
                if (!tablesUpdatedInUTLHandle.isEmpty()) {
                    ICacheService updTables = this.getUpdatedTables();
                    this.normalizeKey(tablesUpdatedInUTLHandle);
                    if (updTables instanceof ICacheService2) {
                        ((ICacheService2)updTables).setAll(CacheFactory.CACHE_SD, tablesUpdatedInUTLHandle.toArray(new String[tablesUpdatedInUTLHandle.size()]), Collections.nCopies(tablesUpdatedInUTLHandle.size(), dt).toArray(), 0);
                    } else {
                        for (String tbl : tablesUpdatedInUTLHandle) {
                            updTables.set(CacheFactory.CACHE_SD, tbl, (Object)dt);
                        }
                    }
                    this.tablesUpdatedInUTL.remove(handle);
                }
            }
        }

        public GXSmartCacheProvider.DataUpdateStatus CheckDataStatus(String queryId, Date dateLastModified, Date[] dateUpdated_arr) {
            try {
                if (this.isEnabled()) {
                    Vector<Date> dateUpdates;
                    Date dateUpdated;
                    ICacheService updTables = this.getUpdatedTables();
                    ConcurrentHashMap qryTables = this.queryTables();
                    dateUpdated_arr[0] = dateUpdated = this.startupDate;
                    if (!qryTables.containsKey(queryId)) {
                        return GXSmartCacheProvider.DataUpdateStatus.Unknown;
                    }
                    Vector qTables = (Vector)qryTables.get(queryId);
                    String[] qTablesArray = qTables.toArray(new String[qTables.size()]);
                    if (updTables instanceof ICacheService2) {
                        dateUpdates = ((ICacheService2)updTables).getAll(CacheFactory.CACHE_SD, qTablesArray, Date.class);
                    } else {
                        dateUpdates = new Vector();
                        for (String qTable : qTables) {
                            if (!updTables.containtsKey(CacheFactory.CACHE_SD, qTable)) continue;
                            dateUpdates.add((Date)updTables.get(CacheFactory.CACHE_SD, qTable, Date.class));
                        }
                    }
                    Date maxDateUpdated = this.MaxDate(dateUpdates);
                    if (maxDateUpdated != null && maxDateUpdated.after(dateUpdated)) {
                        dateUpdated = maxDateUpdated;
                    }
                    dateUpdated_arr[0] = dateUpdated;
                    if (dateUpdated.after(dateLastModified) || qTables.size() == 0) {
                        return GXSmartCacheProvider.DataUpdateStatus.Invalid;
                    }
                    if (dateLastModified != null && dateLastModified.after(new Date())) {
                        return GXSmartCacheProvider.DataUpdateStatus.Invalid;
                    }
                    return GXSmartCacheProvider.DataUpdateStatus.UpToDate;
                }
            }
            catch (Exception e) {
                Log.error((String)"Could not check Request Cache status", (String)"GXSmartCacheProvider", (Throwable)e);
            }
            return GXSmartCacheProvider.DataUpdateStatus.Unknown;
        }

        private Date MaxDate(List<Date> dates) {
            if (dates != null) {
                while (dates.remove(null)) {
                }
                if (dates.size() > 0) {
                    return Collections.max(dates);
                }
            }
            return null;
        }

        public void discardUpdates(int handle) {
            if (this.isEnabled() && this.tablesUpdatedInUTL.containsKey(handle)) {
                this.tablesUpdatedInUTL.remove(handle);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEnabled() {
            if (this.status == GXSmartCacheProvider.SmartCacheStatus.Unknown) {
                Object object = this.syncLock;
                synchronized (object) {
                    if (this.status == GXSmartCacheProvider.SmartCacheStatus.Unknown) {
                        this.status = Preferences.getDefaultPreferences().getSMART_CACHING() ? GXSmartCacheProvider.SmartCacheStatus.Enabled : GXSmartCacheProvider.SmartCacheStatus.Disabled;
                    }
                }
            }
            return this.status == GXSmartCacheProvider.SmartCacheStatus.Enabled;
        }

        public void setUpdated(String table, int handle) {
            Vector<String> tablesUpdatedInUTLHandle = this.getTablesUpdatedInUTL(handle);
            if (this.isEnabled() && !tablesUpdatedInUTLHandle.contains(table)) {
                tablesUpdatedInUTLHandle.add(table);
            }
        }

        private Vector<String> getTablesUpdatedInUTL(Integer handle) {
            if (this.tablesUpdatedInUTL.containsKey(handle)) {
                return this.tablesUpdatedInUTL.get(handle);
            }
            Vector<String> tablesUpdated = new Vector<String>();
            this.tablesUpdatedInUTL.put(handle, tablesUpdated);
            return tablesUpdated;
        }
    }
}

