/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.specific.java;

import com.genexus.Application;
import com.genexus.CommonUtil;
import com.genexus.ModelContext;
import com.genexus.PrivateUtilities;
import com.genexus.common.interfaces.IExtensionGXutil;
import com.genexus.db.IDataStoreProvider;
import com.genexus.internet.IGxJSONSerializable;
import com.genexus.util.CacheAPI;
import com.genexus.xml.GXXMLSerializable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;
import json.org.json.JSONException;
import json.org.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GXutil
implements IExtensionGXutil {
    private static Logger logger = LogManager.getLogger(GXutil.class);

    private ZonedDateTime getZonedDateTime(Date value, TimeZone tz) {
        ZonedDateTime zdt;
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(value);
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            int dayOfMonth = calendar.get(5);
            int hour = calendar.get(11);
            int minute = calendar.get(12);
            int second = calendar.get(13);
            int nanoOfSecond = calendar.get(14) * 1000000;
            zdt = ZonedDateTime.of(LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond), tz.toZoneId());
        }
        catch (Exception e) {
            zdt = ZonedDateTime.ofInstant(value.toInstant(), ZoneId.systemDefault());
            logger.error(String.format("Failed to find TimeZone: %s. Using default Timezone", tz.getID()), (Throwable)e);
        }
        return zdt;
    }

    public Date DateTimeToUTC(Date value, TimeZone tz) {
        if (tz.getID() == "GMT") {
            return value;
        }
        ZonedDateTime zdt = this.getZonedDateTime(value, tz);
        Timestamp t = Timestamp.valueOf(zdt.withZoneSameInstant(ZoneOffset.UTC).toLocalDateTime());
        return new Date(t.getTime());
    }

    public Date DateTimeFromUTC(Date value, TimeZone tz) {
        if (tz.getID() == "GMT") {
            return value;
        }
        if (CommonUtil.emptyDate((Date)value)) {
            return value;
        }
        ZonedDateTime zdtUTC = this.getZonedDateTime(value, TimeZone.getTimeZone("UTC"));
        Timestamp t = Timestamp.valueOf(zdtUTC.withZoneSameInstant(ZoneId.of(tz.getID())).toLocalDateTime());
        return new Date(t.getTime());
    }

    public Calendar getCalendar() {
        return CommonUtil.getCalendar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date now(boolean useClientTimeZone, boolean millisecond) {
        Calendar cal;
        ModelContext context = ModelContext.getModelContext();
        Calendar calendar = cal = this.getCalendar();
        synchronized (calendar) {
            cal.setTime(new Date());
            if (!millisecond) {
                cal.set(14, 0);
            }
            if (Application.getClientPreferences().useTimezoneFix() && useClientTimeZone) {
                return context.toContextTz(cal.getTime());
            }
            return cal.getTime();
        }
    }

    public String serverTime(SimpleDateFormat time_df, Object context, int handle, String dataSource) {
        return time_df.format(Application.getServerDateTime((ModelContext)context, handle, dataSource));
    }

    public String serverTime(SimpleDateFormat time_df, Object context, int handle, Object dataStore) {
        return time_df.format(((IDataStoreProvider)dataStore).serverNow());
    }

    public String removeDiacritics(String s) {
        Pattern pattern = Pattern.compile("[\\p{InCombiningDiacriticalMarks}\\p{IsLm}\\p{IsSk}]+");
        try {
            int i;
            Class<?> normalizerClass = Class.forName("java.text.Normalizer");
            Class<?> normalizerFormClass = null;
            Class<?>[] nestedClasses = normalizerClass.getDeclaredClasses();
            for (i = 0; i < nestedClasses.length; ++i) {
                Class<?> nestedClass = nestedClasses[i];
                if (!nestedClass.getName().equals("java.text.Normalizer$Form")) continue;
                normalizerFormClass = nestedClass;
            }
            assert (normalizerFormClass.isEnum());
            Method methodNormalize = normalizerClass.getDeclaredMethod("normalize", CharSequence.class, normalizerFormClass);
            Object nfcNormalization = null;
            ?[] constants = normalizerFormClass.getEnumConstants();
            for (i = 0; i < constants.length; ++i) {
                Object constant = constants[i];
                if (!constant.toString().equals("NFD")) continue;
                nfcNormalization = constant;
            }
            s = (String)methodNormalize.invoke(null, s, nfcNormalization);
            return pattern.matcher(s).replaceAll("");
        }
        catch (Exception e) {
            return s;
        }
    }

    public boolean shouldConvertDateTime(Date value, boolean isRest) {
        return isRest;
    }

    public String getRelativeURL(String path) {
        if (CommonUtil.isAbsoluteURL((String)path) || CommonUtil.isUploadPrefix((String)path)) {
            return path;
        }
        String baseName = FilenameUtils.getBaseName((String)path);
        String relativeUrl = CommonUtil.getRelativeBlobFile((String)path);
        return CommonUtil.replaceLast((String)relativeUrl, (String)baseName, (String)PrivateUtilities.encodeFileName(baseName));
    }

    public Date serverDate(Object context, int handle, String dataSource) {
        return CommonUtil.resetTime((Date)Application.getServerDateTime((ModelContext)context, handle, dataSource));
    }

    public Date serverDate(Object context, int handle, Object dataStore) {
        if (dataStore == null) {
            return this.serverDate(context, handle, "DEFAULT");
        }
        return CommonUtil.resetTime((Date)((IDataStoreProvider)dataStore).serverNow());
    }

    public void checkEncoding(String encoding) throws Throwable {
        if (!Charset.isSupported(encoding)) {
            throw new Throwable("Invalid encoding");
        }
    }

    public String getUploadValue(String value) {
        String uploadValue = this.getUploadValue(value, "path");
        if (uploadValue == null || uploadValue.isEmpty()) {
            return value;
        }
        return uploadValue;
    }

    public String getUploadExtensionValue(String value) {
        return this.getUploadValue(value, "fileExtension");
    }

    public String getUploadNameValue(String value) {
        return this.getUploadValue(value, "fileName");
    }

    public String getUploadValue(String value, String fieldName) {
        String uploadId = value.replace("gxupload:", "");
        if (CommonUtil.isUploadPrefix((String)value) && CacheAPI.files().contains(uploadId)) {
            String uploadValueJson = CacheAPI.files().get(uploadId);
            try {
                JSONObject json = new JSONObject(uploadValueJson);
                value = (String)json.get(fieldName);
            }
            catch (JSONException e) {
                LogManager.getLogger(GXutil.class).debug("Error Getting Upload Value", (Throwable)e);
            }
        } else {
            value = "";
        }
        return value;
    }

    public Date serverNow(Object context, int handle, String dataSource) {
        Date d = Application.getServerDateTime((ModelContext)context, handle, dataSource);
        if (Application.getClientPreferences().useTimezoneFix()) {
            d = ((ModelContext)context).toContextTz(d);
        }
        return CommonUtil.resetMillis((Date)d);
    }

    public Date serverNow(Object context, int handle, Object dataStore, boolean millisecond) {
        Date d = ((IDataStoreProvider)dataStore).serverNow();
        if (Application.getClientPreferences().useTimezoneFix()) {
            d = ((ModelContext)context).toContextTz(d);
        }
        if (millisecond) {
            return d;
        }
        return CommonUtil.resetMillis((Date)d);
    }

    public String getDatabaseName(Object context, int handle, String dataSource) {
        return Application.getDatabaseName((ModelContext)context, handle, dataSource);
    }

    public Object convertObjectTo(Class<?> toClass, String objStr) {
        try {
            if (IGxJSONSerializable.class.isAssignableFrom(toClass)) {
                Object parmObj = null;
                parmObj = GXXMLSerializable.class.isAssignableFrom(toClass) ? (GXXMLSerializable)toClass.getConstructor(ModelContext.class).newInstance(ModelContext.getModelContext((Class)Application.gxCfg)) : (IGxJSONSerializable)toClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                parmObj.fromJSonString(objStr);
                return parmObj;
            }
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }

    public String URLDecode(String url) {
        return com.genexus.GXutil.URLDecode(url);
    }

    public Date charToTimeREST(String string) {
        return com.genexus.GXutil.charToTimeREST(string);
    }

    public String timeToCharREST(Date prop) {
        return com.genexus.GXutil.timeToCharREST(prop);
    }

    public byte[] toByteArray(InputStream input) throws IOException {
        return IOUtils.toByteArray((InputStream)input);
    }

    public String readFileToString(File themesJsonFile, String normalizeEncodingName) throws IOException {
        return FileUtils.readFileToString((File)themesJsonFile, (String)normalizeEncodingName);
    }

    public String getClassName(String lowerCase) {
        return com.genexus.GXutil.getClassName(lowerCase);
    }

    public Date DateTimefromTimeZone(Date d, String id, ModelContext modelContext) {
        return com.genexus.GXutil.DateTimefromTimeZone(d, id, modelContext);
    }

    public String getTempFileName(String extension) {
        return PrivateUtilities.getTempFileName(extension);
    }
}

