/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.specific.java;

import com.genexus.ApplicationContext;
import com.genexus.ClientPreferences;
import com.genexus.CommonUtil;
import com.genexus.IHttpContext;
import com.genexus.ISessionInstances;
import com.genexus.ModelContext;
import com.genexus.ServerPreferences;
import com.genexus.SessionInstances;
import com.genexus.common.classes.AbstractDataSource;
import com.genexus.common.interfaces.IClientPreferences;
import com.genexus.common.interfaces.IExtensionModelContext;
import com.genexus.common.interfaces.IPreferences;
import com.genexus.db.DBConnection;
import com.genexus.db.driver.DataSource;
import com.genexus.internet.HttpContext;
import com.genexus.internet.HttpContextNull;
import com.genexus.util.GXTimeZone;
import com.genexus.webpanels.WebSession;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.TimeZone;

public class JavaModelContextExtension
implements IExtensionModelContext {
    private static String[] copyKeys = new String[]{"GAMConCli", "GAMSession", "GAMError", "GAMErrorURL", "GAMRemote"};
    int GX_NULL_TIMEZONEOFFSET = 9999;
    static String GX_REQUEST_TIMEZONE = "GxTZOffset";

    public boolean isTimezoneSet(ModelContext ctx) {
        return !ctx.isNullHttpContext();
    }

    public void initPackageClass(ModelContext ctx, Class packageClass) {
        ctx.packageClass = ModelContext.gxcfgPackageClass != null ? ModelContext.gxcfgPackageClass : (ModelContext.threadModelContext.get() == null ? packageClass : ModelContext.getModelContext().packageClass);
    }

    public IHttpContext getNullHttpContext() {
        return new HttpContextNull();
    }

    public AbstractDataSource beforeGetConnection(ModelContext context, int handle, AbstractDataSource dataSource) {
        DataSource returnDataSource = null;
        String proc = context.getPreferences().getEvent("before_connect");
        if (!proc.equals("")) {
            try {
                int remoteHandle = -2;
                if (ApplicationContext.getInstance().isApplicationServer()) {
                    String pkgName = context.getPackageName();
                    if (!pkgName.equals("")) {
                        proc = pkgName + "." + proc;
                    }
                    remoteHandle = handle;
                } else {
                    proc = CommonUtil.getClassName((String)proc);
                }
                Class<?> c = Class.forName(proc);
                Class[] parTypes = new Class[]{Integer.TYPE, ModelContext.class};
                Constructor<?> ct = c.getConstructor(parTypes);
                Object[] arglist = new Object[]{new Integer(remoteHandle), context};
                Object obj = ct.newInstance(arglist);
                Class[] parameterTypes = new Class[]{DBConnection[].class};
                DBConnection[] aP1 = new DBConnection[]{DBConnection.getDataStore(dataSource.getName(), handle)};
                Object[] arguments = new Object[]{aP1};
                Method m = c.getMethod("execute", parameterTypes);
                m.invoke(obj, arguments);
                aP1 = (DBConnection[])arguments[0];
                returnDataSource = aP1[0].getDataSource();
                return returnDataSource;
            }
            catch (ClassNotFoundException e) {
                System.out.println(e);
                return null;
            }
            catch (InstantiationException e) {
                System.out.println(e);
                return null;
            }
            catch (NoSuchMethodException e) {
                System.out.println(e);
                return null;
            }
            catch (IllegalAccessException e) {
                System.out.println(e);
                return null;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public void afterGetConnection(ModelContext modelContext, int handle, AbstractDataSource dataSource) {
        String proc = modelContext.getPreferences().getEvent("after_connect");
        ModelContext.getModelContext().setAfterConnectHandle(handle);
        if (!proc.equals("")) {
            try {
                if (ApplicationContext.getInstance().isApplicationServer()) {
                    String pkgName = modelContext.getPackageName();
                    if (!pkgName.equals("")) {
                        proc = pkgName + "." + proc;
                    }
                } else {
                    proc = CommonUtil.getClassName((String)proc);
                }
                Class<?> c = Class.forName(proc);
                Class[] parTypes = new Class[]{Integer.TYPE, ModelContext.class};
                Constructor<?> ct = c.getConstructor(parTypes);
                Object[] arglist = new Object[]{new Integer(handle), modelContext};
                Object obj = ct.newInstance(arglist);
                Class[] parameterTypes = new Class[]{String.class};
                String aP0 = dataSource.name;
                Object[] arguments = new Object[]{aP0};
                Method m = c.getMethod("execute", parameterTypes);
                m.invoke(obj, arguments);
            }
            catch (ClassNotFoundException e) {
                System.out.println(e);
            }
            catch (InstantiationException e) {
                System.out.println(e);
            }
            catch (NoSuchMethodException e) {
                System.out.println(e);
            }
            catch (IllegalAccessException e) {
                System.out.println(e);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public ModelContext submitCopy(ModelContext modelContext) {
        ModelContext newContext = new ModelContext(modelContext);
        newContext.setHttpContext((IHttpContext)new HttpContextNull());
        JavaModelContextExtension.initializeSubmitSession(modelContext, newContext);
        HttpContext ctx = (HttpContext)modelContext.getHttpContext();
        if (ctx != null) {
            HttpContext newHttpContext = (HttpContext)newContext.getHttpContext();
            newHttpContext.setDefaultPath(ctx.getDefaultPath());
            newHttpContext.setContextPath(ctx.getContextPath());
            newHttpContext.setStaticContentBase(ctx.getStaticContentBase());
            newHttpContext.setClientId(ctx.getClientId());
            newHttpContext.setLanguage(ctx.getLanguage());
        }
        return newContext;
    }

    public ModelContext copy(ModelContext modelContext) {
        ModelContext ret = new ModelContext(ModelContext.getModelContextPackageClass());
        ret.setHttpContext(modelContext.getHttpContext());
        ret.setGUIContext(modelContext.getGUIContext());
        ret.poolConnections = modelContext.poolConnections;
        ret.setSessionInstances(modelContext.getSessionInstances());
        ret.globals = modelContext.globals;
        return ret;
    }

    public ISessionInstances createSessionInstances() {
        return new SessionInstances();
    }

    private static void initializeSubmitSession(ModelContext oldContext, ModelContext newContext) {
        HttpContext httpCtx = (HttpContext)oldContext.getHttpContext();
        HttpContext newHttpCtx = (HttpContext)newContext.getHttpContext();
        if (httpCtx != null && newHttpCtx != null) {
            WebSession ws = newHttpCtx.getWebSession();
            for (int i = 0; i < copyKeys.length && ws != null; ++i) {
                Object value = httpCtx.getSessionValue(copyKeys[i]);
                if (value == null) continue;
                ws.setValue(copyKeys[i], value.toString());
            }
        }
    }

    public Date toContextTz(ModelContext context, Date dt) {
        return ((ClientPreferences)context.getClientPreferences()).useTimezoneFix() ? CommonUtil.ConvertDateTime((Date)dt, (TimeZone)GXTimeZone.getDefault(), (TimeZone)this.getClientTimeZone(context)) : dt;
    }

    public Date local2DBserver(ModelContext context, Date dt) {
        int storagePty = ((ClientPreferences)context.getClientPreferences()).getStorageTimezonePty();
        if (CommonUtil.nullDate().equals(dt) || storagePty == 0) {
            return dt;
        }
        TimeZone ToTimezone = storagePty == 1 ? TimeZone.getTimeZone("GMT") : CommonUtil.defaultTimeZone;
        return CommonUtil.ConvertDateTime((Date)dt, (TimeZone)this.getClientTimeZone(context), (TimeZone)ToTimezone);
    }

    public Date local2DBserver(ModelContext context, Date dt, boolean hasMilliSeconds) {
        return this.local2DBserver(context, dt);
    }

    public Date DBserver2local(ModelContext context, Date dt) {
        int storagePty = ((ClientPreferences)context.getClientPreferences()).getStorageTimezonePty();
        if (CommonUtil.nullDate().equals(dt) || storagePty == 0) {
            return dt;
        }
        TimeZone FromTimezone = storagePty == 1 ? TimeZone.getTimeZone("GMT") : CommonUtil.defaultTimeZone;
        return CommonUtil.ConvertDateTime((Date)dt, (TimeZone)FromTimezone, (TimeZone)this.getClientTimeZone(context));
    }

    public Date DBserver2local(ModelContext context, Date dt, boolean hasMilliSeconds) {
        return this.DBserver2local(context, dt);
    }

    public IPreferences createPreferences(Class packageClass) {
        return ApplicationContext.getInstance().isApplicationServer() ? ServerPreferences.getInstance(packageClass) : ClientPreferences.getInstance(packageClass);
    }

    public IPreferences getServerPreferences(Class packageClass) {
        return ServerPreferences.getInstance(packageClass);
    }

    public IClientPreferences getClientPreferences(Class packageClass) {
        return ClientPreferences.getInstance(packageClass);
    }

    public boolean isLocalGXDB(ModelContext context) {
        return context.getPreferences().getREMOTE_CALLS() == 0;
    }

    public TimeZone getClientTimeZone(ModelContext context) {
        return TimeZone.getTimeZone(this.getTimeZone(context));
    }

    private TimeZone _getClientTimeZone(ModelContext model) {
        if (model != null && model.getCurrentTimeZone() != null) {
            return model.getCurrentTimeZone();
        }
        String sTZ = null;
        HttpContext httpContext = (HttpContext)model.getHttpContext();
        if (httpContext != null && ((sTZ = httpContext.getHeader(GX_REQUEST_TIMEZONE)) == null || sTZ.equals(""))) {
            sTZ = httpContext.getCookie(GX_REQUEST_TIMEZONE);
        }
        try {
            model.setCurrentTimeZone(sTZ.equals("") || sTZ == null ? GXTimeZone.getDefaultOriginal() : TimeZone.getTimeZone(sTZ));
        }
        catch (Exception e) {
            model.setCurrentTimeZone(GXTimeZone.getDefaultOriginal());
        }
        return model.getCurrentTimeZone();
    }

    public String getTimeZone(ModelContext context) {
        String TZ = null;
        HttpContext httpContext = (HttpContext)context.getHttpContext();
        if (context != null) {
            TZ = (String)httpContext.getSessionValue("GXTimezone");
        }
        if (TZ != null && !TZ.equals("")) {
            this.setTimeZone(context, TZ);
        }
        if (context.getCurrentTimeZone() == null) {
            context.setCurrentTimeZone(this._getClientTimeZone(context));
        }
        return context.getCurrentTimeZone().getID();
    }

    public Boolean setTimeZone(ModelContext model, String sTz) {
        HttpContext httpContext = (HttpContext)model.getHttpContext();
        TimeZone tz = TimeZone.getTimeZone(sTz = CommonUtil.rtrim((String)sTz));
        Boolean ret = tz.getID().equals(sTz);
        if (ret.booleanValue()) {
            model.setCurrentTimeZone(tz);
            httpContext.webPutSessionValue("GXTimezone", tz.getID());
        }
        return ret;
    }
}

