/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import com.genexus.CacheFactory;
import com.genexus.ICacheService;

public class CacheAPI {
    static final String DEFAULT_CACHE_ID = "DefaultCache";
    private static ICacheService cache = CacheFactory.getInstance();
    private String cacheId;

    public static CacheAPI database() {
        return new CacheAPI(CacheFactory.CACHE_DB);
    }

    public static CacheAPI smartdevices() {
        return new CacheAPI(CacheFactory.CACHE_SD);
    }

    public static CacheAPI files() {
        return new CacheAPI(CacheFactory.CACHE_FL);
    }

    public CacheAPI() {
        this.cacheId = DEFAULT_CACHE_ID;
    }

    public CacheAPI(String name) {
        this.cacheId = name;
    }

    public static CacheAPI getCache(String name) {
        return new CacheAPI(name);
    }

    public static void clearAllCaches() {
        cache.clearAllCaches();
    }

    public void set(String key, String value, int durationMinutes) {
        cache.set(this.cacheId, key, (Object)value, durationMinutes * 60);
    }

    public boolean contains(String key) {
        return cache.containtsKey(this.cacheId, key);
    }

    public String get(String key) {
        String value = (String)cache.get(this.cacheId, key, String.class);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void remove(String key) {
        if (this.cacheId == CacheFactory.CACHE_SD && key != null && !key.equals("")) {
            key = key.toLowerCase();
        }
        cache.clear(this.cacheId, key);
    }

    public void clear() {
        cache.clearCache(this.cacheId);
    }
}

