/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import java.util.concurrent.ConcurrentHashMap;

public class DoubleLinkedQueue {
    private LinkedNode first;
    private LinkedNode last;
    private LinkedNode empty;
    private ConcurrentHashMap<Object, LinkedNode> itemNodesMapping = new ConcurrentHashMap();

    public DoubleLinkedQueue() {
        this.first = this.last = (this.empty = new LinkedNode());
    }

    public synchronized void insert(Object item) {
        LinkedNode node = new LinkedNode();
        node.item = item;
        node.prev = this.empty;
        node.next = this.first;
        this.itemNodesMapping.put(item, node);
        if (this.first == this.empty) {
            this.last = node;
        } else {
            node.next.prev = node;
        }
        this.first = node;
    }

    public synchronized void moveToStart(Object item) {
        LinkedNode node = this.itemNodesMapping.get(item);
        if (node == null) {
            this.insert(item);
            return;
        }
        if (node == this.first) {
            return;
        }
        node.next.prev = node.prev;
        node.prev.next = node.next;
        node.prev = this.empty;
        node.next = this.first;
        this.first.prev = node;
        this.first = node;
    }

    public synchronized Object takeFromStart() {
        if (this.isEmpty()) {
            return null;
        }
        Object item = this.first.item;
        this.first = this.first == this.last ? (this.last = this.empty) : this.first.next;
        this.itemNodesMapping.remove(item);
        return item;
    }

    public synchronized Object takeFromEnd() {
        if (this.isEmpty()) {
            return null;
        }
        Object item = this.last.item;
        if (this.first == this.last) {
            this.first = this.last = this.empty;
        } else {
            this.last = this.last.prev;
        }
        this.itemNodesMapping.remove(item);
        return item;
    }

    public synchronized void remove(Object item) {
        LinkedNode node = this.itemNodesMapping.remove(item);
        if (node == null) {
            return;
        }
        if (node == this.first) {
            this.first = this.last = this.empty;
            return;
        }
        node.next.prev = node.prev;
        node.prev.next = node.next;
    }

    public boolean isEmpty() {
        return this.first == this.empty;
    }

    class LinkedNode {
        LinkedNode next;
        LinkedNode prev;
        Object item;

        LinkedNode() {
        }
    }
}

