/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import com.genexus.Application;
import com.genexus.CommonUtil;
import com.genexus.IHttpContext;
import com.genexus.ModelContext;
import com.genexus.PrivateUtilities;
import com.genexus.common.classes.AbstractGXFile;
import com.genexus.common.interfaces.SpecificImplementation;
import com.genexus.db.driver.ExternalProvider;
import com.genexus.db.driver.ResourceAccessControlList;
import com.genexus.util.Codecs;
import com.genexus.util.GXExternalFileInfo;
import com.genexus.util.GXFileInfo;
import com.genexus.util.GxFileInfoSourceType;
import com.genexus.util.ICleanupFile;
import com.genexus.util.IGXFileInfo;
import com.genexus.util.XSLT;
import com.genexus.webpanels.BlobsCleaner;
import com.genexus.webpanels.HttpContextWeb;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GXFile
extends AbstractGXFile {
    private static Logger log = LogManager.getLogger(HttpContextWeb.class);
    private IGXFileInfo FileSource;
    private int ErrCode;
    private String ErrDescription;
    private boolean ret;
    private boolean isExternal = false;
    private String uploadFileId;
    public static ICleanupFile CleanUp;
    private FileWriterWithEncoding fileWriter;
    private LineIterator lineIterator;

    public GXFile() {
    }

    public GXFile(String fileName) {
        this(fileName, ResourceAccessControlList.Default);
    }

    @Deprecated
    public GXFile(String fileName, boolean isPrivate) {
        this(fileName, isPrivate ? ResourceAccessControlList.Private : ResourceAccessControlList.Default, GxFileInfoSourceType.Unknown);
    }

    public GXFile(String fileName, ResourceAccessControlList fileAcl) {
        this(fileName, fileAcl, GxFileInfoSourceType.Unknown);
    }

    public GXFile(String fileName, ResourceAccessControlList fileAcl, GxFileInfoSourceType sourceType) {
        this("", fileName, fileAcl, sourceType);
    }

    @Deprecated
    public GXFile(String fileName, ResourceAccessControlList fileAcl, boolean isLocalFile) {
        this("", fileName, fileAcl, isLocalFile ? GxFileInfoSourceType.LocalFile : GxFileInfoSourceType.Unknown);
    }

    public GXFile(String baseDirectoryPath, String fileName, ResourceAccessControlList fileAcl, GxFileInfoSourceType sourceType) {
        if (CommonUtil.isUploadPrefix((String)fileName)) {
            this.uploadFileId = fileName;
            fileName = SpecificImplementation.GXutil.getUploadValue(fileName);
        }
        switch (sourceType) {
            case LocalFile: {
                this.createFileSourceLocal(baseDirectoryPath, fileName);
                break;
            }
            case ExternalFile: {
                this.FileSource = new GXExternalFileInfo(fileName, Application.getExternalProvider(), true, fileAcl);
                break;
            }
            case Unknown: {
                ExternalProvider storageProvider = Application.getExternalProvider();
                if (storageProvider == null || PrivateUtilities.isAbsoluteFilePath(fileName)) {
                    this.createFileSourceLocal(baseDirectoryPath, fileName);
                    break;
                }
                this.FileSource = new GXExternalFileInfo(fileName, storageProvider, true, fileAcl);
            }
        }
    }

    private void createFileSourceLocal(String baseDirectoryPath, String fileName) {
        boolean isAbsolutePath = PrivateUtilities.isAbsoluteFilePath(fileName);
        String absoluteOrRelativePath = isAbsolutePath ? fileName : Paths.get(baseDirectoryPath, fileName).toString();
        this.FileSource = new GXFileInfo(new File(absoluteOrRelativePath));
    }

    public GXFile(IGXFileInfo fileInfo) {
        this.FileSource = fileInfo;
    }

    public static String getgxFilename(String fileName) {
        return new GXFile(fileName, ResourceAccessControlList.Default, GxFileInfoSourceType.LocalFile).getNameNoExt();
    }

    public static String getgxFileext(String fileName) {
        return new GXFile(fileName).getExt();
    }

    public static String getCompleteFileName(String name, String type) {
        if (name.length() == 0) {
            return "";
        }
        if (type.length() == 0) {
            return name;
        }
        return name + "." + type;
    }

    public void setFileInfo(IGXFileInfo fileInfo) {
        this.FileSource = fileInfo;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    public void setSource(String FileName) {
        boolean isUpload = CommonUtil.isUploadPrefix((String)FileName);
        if (isUpload) {
            this.uploadFileId = FileName;
            FileName = SpecificImplementation.GXutil.getUploadValue(FileName);
        }
        if (Application.getGXServices().get("Storage") != null && (isUpload || this.isExternal)) {
            this.FileSource = new GXExternalFileInfo(FileName, Application.getExternalProvider());
        } else {
            String absoluteFileName = FileName;
            try {
                IHttpContext webContext;
                if (!(ModelContext.getModelContext() == null || new File(absoluteFileName).isAbsolute() || (webContext = ModelContext.getModelContext().getHttpContext()) == null || !(webContext instanceof HttpContextWeb) && webContext.getDefaultPath().isEmpty() || FileName.isEmpty())) {
                    absoluteFileName = ModelContext.getModelContext().getHttpContext().getDefaultPath() + File.separator + FileName;
                }
                URI uriFile = URI.create(absoluteFileName);
                this.FileSource = new GXFileInfo(new File(uriFile));
            }
            catch (Exception e) {
                this.FileSource = new GXFileInfo(new File(absoluteFileName));
            }
        }
    }

    public String getSource() {
        if (this.FileSource == null) {
            return "";
        }
        return this.FileSource.getName();
    }

    public void create() {
        this.resetErrors();
        try {
            if (this.FileSource.exists() && this.FileSource.isFile()) {
                this.ErrCode = 1;
                this.ErrDescription = "File already exists";
            } else {
                try {
                    this.ret = this.FileSource.createNewFile();
                }
                catch (IOException e) {
                    this.ErrCode = 100;
                    this.ErrDescription = e.getMessage();
                }
                catch (SecurityException e) {
                    this.ErrCode = 100;
                    this.ErrDescription = e.getMessage();
                }
            }
        }
        catch (Exception e) {
            this.setUnknownError(e);
        }
    }

    public boolean create(InputStream input) {
        return this.create(input, false);
    }

    public boolean create(InputStream input, boolean overwrite) {
        this.resetErrors();
        try {
            if (!overwrite && this.FileSource.exists() && this.FileSource.isFile()) {
                this.ErrCode = 1;
                this.ErrDescription = "File already exists";
            } else {
                try {
                    this.ret = this.FileSource.createNewFile(input);
                }
                catch (IOException e) {
                    this.ErrCode = 100;
                    this.ErrDescription = e.getMessage();
                }
                catch (SecurityException e) {
                    this.ErrCode = 100;
                    this.ErrDescription = e.getMessage();
                }
            }
        }
        catch (Exception e) {
            this.setUnknownError(e);
        }
        return this.ErrCode == 0;
    }

    public void delete() {
        block7: {
            if (this.sourceSeted()) {
                this.resetErrors();
                try {
                    if (!this.FileSource.isFile() || !this.FileSource.exists()) {
                        this.ErrCode = 2;
                        this.ErrDescription = "The file couldn't be deleted; file does not exist";
                        break block7;
                    }
                    try {
                        this.ret = this.FileSource.delete();
                        if (!this.ret) {
                            this.setUnknownError();
                        }
                    }
                    catch (SecurityException e) {
                        this.ErrCode = 100;
                        this.ErrDescription = e.getMessage();
                    }
                }
                catch (Exception e) {
                    this.setUnknownError(e);
                }
            }
        }
    }

    public boolean exists() {
        if (this.sourceSeted()) {
            try {
                this.resetErrors();
                return this.FileSource.exists();
            }
            catch (SecurityException e) {
                this.ErrCode = 100;
                this.ErrDescription = e.getMessage();
                return false;
            }
            catch (Exception e) {
                this.setUnknownError(e);
                return false;
            }
        }
        return false;
    }

    public void setExt(String FileExt) {
        String FileName = this.getAbsoluteName();
        if (FileExt.trim().length() == 0 || CommonUtil.getFileType((String)FileName).compareToIgnoreCase(FileExt) == 0) {
            this.ErrCode = 0;
        } else {
            String sFilePath = this.FileSource == null ? "" : this.FileSource.getParent();
            this.rename(sFilePath + File.separator + CommonUtil.getFileName((String)FileName) + "." + FileExt);
        }
    }

    public void setBlobToDelete() {
        BlobsCleaner.getInstance().addBlobFile(this.getAbsoluteName());
    }

    public void rename(String FileName) {
        if (this.sourceSeted()) {
            this.resetErrors();
            try {
                if (this.FileSource == null || !this.FileSource.isFile() || !this.FileSource.exists()) {
                    this.ErrCode = 2;
                    this.ErrDescription = "The file couldn't be renamed; file does not exist";
                } else if (new GXFile(FileName).exists()) {
                    this.ErrCode = 3;
                    this.ErrDescription = "File already exists";
                } else {
                    try {
                        this.ret = this.FileSource.renameTo(FileName);
                    }
                    catch (SecurityException e) {
                        this.ErrCode = 100;
                        this.ErrDescription = e.getMessage();
                    }
                }
            }
            catch (Exception e) {
                this.setUnknownError(e);
            }
        }
    }

    public void copy(String FileName) {
        if (this.sourceSeted()) {
            this.resetErrors();
            try {
                if (this.FileSource == null || !this.FileSource.isFile() || !this.FileSource.exists()) {
                    this.ErrCode = 2;
                    this.ErrDescription = "The file couldn't be copied; file does not exist";
                } else {
                    try {
                        this.FileSource.copy(this.FileSource.getFilePath(), FileName);
                    }
                    catch (IOException e) {
                        this.setUnknownError(e);
                    }
                }
            }
            catch (Exception e) {
                this.resetErrors();
                try {
                    this.FileSource.copy(this.FileSource.getName(), FileName);
                }
                catch (Exception ex) {
                    this.setUnknownError(e);
                }
            }
        }
    }

    public String getName() {
        if (this.sourceSeted()) {
            this.resetErrors();
            if (this.uploadFileId != null) {
                return SpecificImplementation.GXutil.getUploadNameValue(this.uploadFileId);
            }
            try {
                if (this.FileSource == null || !this.FileSource.isFile() || !this.FileSource.exists()) {
                    this.ErrCode = 2;
                    this.ErrDescription = "File does not exist";
                    return "";
                }
                return this.FileSource.getName();
            }
            catch (Exception e) {
                this.setUnknownError(e);
            }
        }
        return "";
    }

    public String getExtension() {
        return this.getExt();
    }

    public boolean hasExtension() {
        return !this.getExt().equals("");
    }

    public String getExt() {
        if (this.uploadFileId != null) {
            return SpecificImplementation.GXutil.getUploadExtensionValue(this.uploadFileId);
        }
        String sExtension = this.FileSource.getName();
        int pos = sExtension.lastIndexOf(".");
        if (pos == -1 || pos == sExtension.length()) {
            return "";
        }
        return sExtension.substring(pos + 1, sExtension.length());
    }

    public String getNameNoExt() {
        int pos;
        String FName = this.FileSource.getName();
        if (this.uploadFileId != null) {
            FName = SpecificImplementation.GXutil.getUploadNameValue(this.uploadFileId);
        }
        if ((pos = FName.lastIndexOf(".")) < 1) {
            return FName;
        }
        return FName.substring(0, pos);
    }

    public String getAbsoluteName() {
        if (this.sourceSeted()) {
            if (this.FileSource.getName().toLowerCase().startsWith("http")) {
                return this.FileSource.getName();
            }
            this.resetErrors();
            try {
                return this.FileSource.getFilePath();
            }
            catch (SecurityException e) {
                this.ErrCode = 100;
                this.ErrDescription = e.getMessage();
                return "";
            }
        }
        return "";
    }

    public String getURI() {
        try {
            return this.FileSource.getAbsolutePath();
        }
        catch (Exception e) {
            this.setUnknownError(e);
            return "";
        }
    }

    public String getFilePath() {
        try {
            return this.FileSource.getFilePath();
        }
        catch (Exception e) {
            this.setUnknownError(e);
            return "";
        }
    }

    public String getAbsolutePath() {
        try {
            return this.FileSource.getAbsolutePath();
        }
        catch (Exception e) {
            this.setUnknownError(e);
            return "";
        }
    }

    public long getLength() {
        if (this.sourceSeted()) {
            this.resetErrors();
            try {
                if (this.FileSource == null || !this.FileSource.isFile() || !this.FileSource.exists()) {
                    this.ErrCode = 2;
                    this.ErrDescription = "File does not exist";
                    return 0L;
                }
                try {
                    return this.FileSource.length();
                }
                catch (SecurityException e) {
                    this.ErrCode = 100;
                    this.ErrDescription = e.getMessage();
                    return 0L;
                }
            }
            catch (Exception e) {
                this.setUnknownError(e);
            }
        }
        return 0L;
    }

    public Date getLastModified() {
        if (this.sourceSeted()) {
            this.resetErrors();
            try {
                if (this.FileSource == null || !this.FileSource.isFile() || !this.FileSource.exists()) {
                    this.ErrCode = 2;
                    this.ErrDescription = "File does not exist";
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.set(0, 0, 0);
                    return calendar.getTime();
                }
                try {
                    return this.FileSource.lastModified();
                }
                catch (SecurityException e) {
                    this.ErrCode = 100;
                    this.ErrDescription = e.getMessage();
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.set(0, 0, 0);
                    return calendar.getTime();
                }
            }
            catch (Exception e) {
                this.setUnknownError(e);
            }
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(0, 0, 0);
        return calendar.getTime();
    }

    public InputStream getStream() {
        if (this.sourceSeted()) {
            this.resetErrors();
            try {
                if (this.FileSource == null || !this.FileSource.exists()) {
                    this.ErrCode = 2;
                    this.ErrDescription = "File does not exist";
                    return null;
                }
                return this.FileSource.getStream();
            }
            catch (Exception e) {
                this.setUnknownError(e);
            }
        }
        return null;
    }

    public String getSeparator() {
        this.resetErrors();
        if (this.FileSource != null) {
            return this.FileSource.getSeparator();
        }
        return File.separator;
    }

    public int getErrCode() {
        return this.ErrCode;
    }

    public String getErrDescription() {
        return this.ErrDescription;
    }

    public String getPath() {
        return this.FileSource.getPath();
    }

    public String htmlClean() {
        if (CleanUp != null) {
            return CleanUp.htmlCleanFile(this.getAbsoluteName());
        }
        return "";
    }

    public String XSLTApply(String xslt) {
        this.resetErrors();
        if (this.sourceSeted()) {
            if (!this.FileSource.isFile()) {
                this.ErrDescription = "Source file does not exist";
                this.ErrCode = 4;
                return "";
            }
            if (!new File(xslt).isFile()) {
                this.ErrDescription = "Stylesheet file does not exist";
                this.ErrCode = 5;
                return "";
            }
            try {
                return XSLT.XSLTApplyFromFiles((String)this.FileSource.getAbsolutePath(), (String)xslt);
            }
            catch (NoClassDefFoundError cnfe) {
                this.ErrDescription = "Xalan was not found in classpath";
                System.err.println(cnfe.toString());
                this.ErrCode = 6;
            }
            catch (Exception e) {
                this.ErrDescription = e.toString();
                System.err.println(e.toString());
            }
        }
        return "";
    }

    private void resetErrors() {
        this.ErrCode = 0;
        this.ErrDescription = "Ok";
    }

    private boolean sourceSeted() {
        if (this.FileSource == null) {
            this.ErrCode = 1;
            this.ErrDescription = "Invalid File instance";
            return false;
        }
        return true;
    }

    private void setUnknownError() {
        this.ErrCode = -1;
        this.ErrDescription = "Unknown error";
    }

    private void setUnknownError(Exception e) {
        this.ErrCode = -1;
        this.ErrDescription = e.getMessage();
        log.error("Unknown error", (Throwable)e);
    }

    public byte[] toBytes() {
        byte[] data = new byte[]{};
        if (this.FileSource != null && this.FileSource.isFile()) {
            try {
                data = this.FileSource.toBytes();
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading " + this.FileSource.getName() + " : " + e.getMessage());
            }
        }
        return data;
    }

    public String toBase64() {
        return new String(Codecs.base64Encode((byte[])this.toBytes()));
    }

    public Boolean fromBytes(byte[] data) {
        if (this.FileSource == null) {
            return false;
        }
        try {
            this.FileSource.fromBytes(data);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading " + this.FileSource.getName() + " : " + e.getMessage());
        }
        return true;
    }

    public Boolean fromBase64(String base64String) {
        Boolean ok = true;
        try {
            ok = this.fromBytes(Codecs.base64Decode((byte[])base64String.getBytes()));
        }
        catch (Exception e) {
            this.setUnknownError(e);
            ok = false;
        }
        return ok;
    }

    public String readAllText(String encoding) {
        if (this.sourceSeted()) {
            this.resetErrors();
            if (this.FileSource == null || !this.FileSource.isFile() || !this.FileSource.exists()) {
                this.ErrCode = 2;
                this.ErrDescription = "File does not exist";
                return "";
            }
            try {
                if (encoding.equals("")) {
                    return this.FileSource.readAllText("UTF8");
                }
                return this.FileSource.readAllText(CommonUtil.normalizeEncodingName((String)encoding));
            }
            catch (IOException e) {
                this.setUnknownError(e);
            }
        }
        return "";
    }

    public Vector<String> readAllLines() {
        return this.readAllLines("");
    }

    public Vector<String> readAllLines(String encoding) {
        Vector<String> strColl = new Vector<String>();
        if (this.sourceSeted()) {
            this.resetErrors();
            if (this.FileSource == null || !this.FileSource.isFile() || !this.FileSource.exists()) {
                this.ErrCode = 2;
                this.ErrDescription = "File does not exist";
                return strColl;
            }
            try {
                List result = encoding.equals("") ? this.FileSource.readLines("UTF8") : this.FileSource.readLines(CommonUtil.normalizeEncodingName((String)encoding));
                if (result != null) {
                    Iterator j = result.iterator();
                    while (j.hasNext()) {
                        strColl.add((String)j.next());
                    }
                }
            }
            catch (IOException e) {
                this.setUnknownError(e);
            }
        }
        return strColl;
    }

    public void writeAllText(String value, String encoding) {
        this.writeAllText(value, encoding, false);
    }

    public void writeAllText(String value, String encoding, boolean append) {
        if (this.sourceSeted()) {
            this.resetErrors();
            try {
                if (encoding.equals("")) {
                    this.FileSource.writeStringToFile(value, "UTF8", append);
                } else {
                    this.FileSource.writeStringToFile(value, CommonUtil.normalizeEncodingName((String)encoding), append);
                }
            }
            catch (Exception e) {
                this.setUnknownError(e);
            }
        }
    }

    public void writeAllLines(Vector value, String encoding) {
        this.writeAllLines(value, encoding, false);
    }

    public void writeAllLines(Vector value, String encoding, boolean append) {
        if (this.sourceSeted()) {
            this.resetErrors();
            try {
                if (encoding.equals("")) {
                    this.FileSource.writeLines("UTF8", value, append);
                } else {
                    this.FileSource.writeLines(CommonUtil.normalizeEncodingName((String)encoding), value, append);
                }
            }
            catch (Exception e) {
                this.setUnknownError(e);
            }
        }
    }

    public void appendAllText(String value, String encoding) {
        this.writeAllText(value, encoding, true);
    }

    public void appendAllLines(Vector value, String encoding) {
        this.writeAllLines(value, encoding, true);
    }

    public void open(String encoding) {
        this.openWrite(encoding);
        this.openRead(encoding);
    }

    public void openWrite(String encoding) {
        if (this.sourceSeted()) {
            this.resetErrors();
            try {
                this.fileWriter = encoding.equals("") ? new FileWriterWithEncoding(this.FileSource.getFileInstance(), "UTF8", this.FileSource.exists()) : new FileWriterWithEncoding(this.FileSource.getFileInstance(), CommonUtil.normalizeEncodingName((String)encoding), this.FileSource.exists());
            }
            catch (Exception e) {
                this.setUnknownError(e);
            }
        }
    }

    public void openRead(String encoding) {
        if (this.sourceSeted()) {
            this.resetErrors();
            try {
                this.lineIterator = encoding.equals("") ? FileUtils.lineIterator((File)this.FileSource.getFileInstance(), (String)"UTF8") : FileUtils.lineIterator((File)this.FileSource.getFileInstance(), (String)CommonUtil.normalizeEncodingName((String)encoding));
            }
            catch (Exception e) {
                this.setUnknownError(e);
            }
        }
    }

    public void writeLine(String value) {
        if (this.fileWriter != null) {
            try {
                this.fileWriter.append((CharSequence)(value + CommonUtil.newLine()));
            }
            catch (Exception e) {
                this.setUnknownError(e);
            }
        } else {
            this.ErrCode = 1;
            this.ErrDescription = "Invalid File instance";
        }
    }

    public String readLine() {
        if (this.lineIterator != null) {
            try {
                return this.lineIterator.nextLine();
            }
            catch (Exception e) {
                this.setUnknownError(e);
            }
        } else {
            this.ErrCode = 1;
            this.ErrDescription = "Invalid File instance";
        }
        return "";
    }

    public boolean getEof() {
        if (this.lineIterator != null) {
            return !this.lineIterator.hasNext();
        }
        return true;
    }

    public void close() {
        if (this.fileWriter != null) {
            try {
                this.fileWriter.close();
                this.fileWriter = null;
            }
            catch (Exception e) {
                this.setUnknownError(e);
            }
        }
        try {
            if (this.getStream() != null) {
                this.getStream().close();
            }
            if (this.lineIterator != null) {
                this.lineIterator.close();
                this.lineIterator = null;
            }
        }
        catch (IOException e) {
            this.setUnknownError();
            e.printStackTrace();
        }
    }
}

