/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import com.genexus.Application;
import com.genexus.ModelContext;
import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.util.GXProperties;
import com.genexus.util.GXQueueMessage;
import com.genexus.xml.XMLReader;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class GXQueue
implements MessageListener {
    public final int ERROR = 1;
    public static final ILogger logger = LogManager.getLogger(GXQueue.class);
    private int errCode;
    private String errDescription = "";
    private static Hashtable<QueueSession, QueueSession> qsessions = new Hashtable();
    private static Hashtable<TopicSession, TopicSession> tsessions = new Hashtable();
    private static final String QUEUE = "Queue";
    private static final String TOPIC = "Topic";
    private String provider;
    private String user;
    private String password;
    private boolean eof;
    private Enumeration messages;
    private String query;
    private boolean browse;
    private String type;
    private String durable;
    private String clientId;
    private String subscriptionName;
    private String driver;
    private String url;
    private String jndiID;
    private String queueName;
    private String queueAutoCommit;
    private Queue queue;
    private QueueSession qsession;
    private QueueConnection qconnection;
    private QueueReceiver reciver;
    private Topic topic;
    private TopicSession tsession;
    private TopicConnection tconnection;
    private TopicSubscriber suscriber;
    private Vector<GXQueueMessage> topicMessages = new Vector();

    public GXQueue() {
        Application.usingQueue = true;
        this.query = "";
        this.browse = false;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setQuerystring(String query) {
        this.query = query;
    }

    public void setBrowse(boolean browse) {
        this.browse = browse;
    }

    public boolean eof() {
        return this.eof;
    }

    public GXQueueMessage first() {
        if (this.browse && this.type.equals(QUEUE)) {
            this.messages = null;
            GXQueueMessage result = new GXQueueMessage();
            this.browse();
            if (this.messages.hasMoreElements()) {
                Message message = (Message)this.messages.nextElement();
                if (message instanceof TextMessage) {
                    TextMessage txtMessage = (TextMessage)message;
                    try {
                        result.setText(txtMessage.getText());
                        result.setPriority(txtMessage.getJMSPriority());
                        result.setCorrelationId(txtMessage.getJMSCorrelationID());
                        result.setMessageID(txtMessage.getJMSMessageID());
                        GXProperties msgProps = new GXProperties();
                        Enumeration props = txtMessage.getPropertyNames();
                        while (props.hasMoreElements()) {
                            String propName = (String)props.nextElement();
                            String propValue = txtMessage.getStringProperty(propName);
                            msgProps.add(propName, propValue);
                        }
                        result.setProperties(msgProps);
                    }
                    catch (JMSException e) {
                        this.handleJMSException("GXQueue First method error: ", (Exception)((Object)e));
                        return null;
                    }
                }
                this.eof = false;
                return result;
            }
            this.eof = true;
            return null;
        }
        try {
            if (this.type.equals(QUEUE)) {
                this.reciver = this.qsession.createReceiver(this.queue, this.query);
                this.qconnection.start();
            }
            return this.receive();
        }
        catch (JMSException e) {
            this.handleJMSException("GXQueue First method error: ", (Exception)((Object)e));
            return null;
        }
    }

    public GXQueueMessage next() {
        if (this.browse && this.type.equals(QUEUE)) {
            GXQueueMessage result = new GXQueueMessage();
            if (this.messages.hasMoreElements()) {
                Message message = (Message)this.messages.nextElement();
                if (message instanceof TextMessage) {
                    TextMessage txtMessage = (TextMessage)message;
                    try {
                        result.setText(txtMessage.getText());
                        result.setPriority(txtMessage.getJMSPriority());
                        result.setCorrelationId(txtMessage.getJMSCorrelationID());
                        result.setMessageID(txtMessage.getJMSMessageID());
                        GXProperties msgProps = new GXProperties();
                        Enumeration props = txtMessage.getPropertyNames();
                        while (props.hasMoreElements()) {
                            String propName = (String)props.nextElement();
                            String propValue = txtMessage.getStringProperty(propName);
                            msgProps.add(propName, propValue);
                        }
                        result.setProperties(msgProps);
                    }
                    catch (JMSException e) {
                        this.handleJMSException("GXQueue Next method error: ", (Exception)((Object)e));
                        return null;
                    }
                }
                this.eof = false;
                return result;
            }
            this.eof = true;
            return null;
        }
        return this.receive();
    }

    private boolean readProvider() {
        char alternateSeparator;
        String configurationFile = "jms.xml";
        String path = ModelContext.getModelContext().getHttpContext().getDefaultPath();
        if (!path.equals("") && new File((path = path.replace(alternateSeparator = File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar) + File.separatorChar) + "WEB-INF" + File.separatorChar + "jms.xml").exists()) {
            configurationFile = path + "WEB-INF" + File.separatorChar + "jms.xml";
        }
        XMLReader oReader = new XMLReader();
        oReader.open(configurationFile);
        oReader.readType(1, "Name");
        while (!this.provider.trim().equals(oReader.getValue())) {
            oReader.readType(1, "Name");
            if (!oReader.getEof()) continue;
            oReader.close();
            return false;
        }
        oReader.readType(1, "User");
        this.user = oReader.getValue();
        oReader.readType(1, "Password");
        this.password = oReader.getValue();
        oReader.readType(1, "Type");
        this.type = oReader.getValue();
        short ok = oReader.readType(1, "Durable");
        if (ok == 1) {
            this.durable = oReader.getValue().toUpperCase();
            oReader.readType(1, "ClientID");
            this.clientId = oReader.getValue();
            oReader.readType(1, "SubscriptionName");
            this.subscriptionName = oReader.getValue();
        } else {
            this.durable = "NO";
        }
        oReader.readType(1, "Factory");
        this.driver = oReader.getValue();
        oReader.readType(1, "URL");
        this.url = oReader.getValue();
        oReader.readType(1, "JNDI_ID");
        this.jndiID = oReader.getValue();
        oReader.readType(1, "Queue_Name");
        this.queueName = oReader.getValue();
        oReader.readType(1, "Queue_AutoCommit");
        this.queueAutoCommit = oReader.getValue().toUpperCase();
        oReader.close();
        return true;
    }

    public boolean connect() {
        if (!this.readProvider()) {
            this.errCode = 1;
            this.errDescription = "GXQueue Connect method error: Provider doesn't exist";
            logger.error(this.errDescription);
            return false;
        }
        InitialContext ctx = null;
        this.qsession = null;
        this.tsession = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.principal", this.user);
        env.put("java.naming.security.credentials", this.password);
        env.put("java.naming.provider.url", this.url);
        env.put("java.naming.factory.initial", this.driver);
        try {
            ctx = new InitialContext(env);
            if (this.type.equals(QUEUE)) {
                QueueConnectionFactory factory = (QueueConnectionFactory)ctx.lookup(this.jndiID);
                this.queue = (Queue)ctx.lookup(this.queueName);
                this.qconnection = factory.createQueueConnection();
                if (this.queueAutoCommit.equals("NO")) {
                    this.qsession = this.qconnection.createQueueSession(true, 1);
                    qsessions.put(this.qsession, this.qsession);
                } else {
                    this.qsession = this.qconnection.createQueueSession(false, 1);
                }
            } else {
                TopicConnectionFactory tfactory = (TopicConnectionFactory)ctx.lookup(this.jndiID);
                this.topic = (Topic)ctx.lookup(this.queueName);
                this.tconnection = tfactory.createTopicConnection();
                if (!this.durable.equals("NO")) {
                    this.tconnection.setClientID(this.clientId);
                }
                if (this.queueAutoCommit.equals("NO")) {
                    this.tsession = this.tconnection.createTopicSession(true, 1);
                    tsessions.put(this.tsession, this.tsession);
                } else {
                    this.tsession = this.tconnection.createTopicSession(false, 1);
                }
                this.suscriber = this.durable.equals("NO") ? this.tsession.createSubscriber(this.topic, this.query, false) : this.tsession.createDurableSubscriber(this.topic, this.subscriptionName, this.query, false);
                this.suscriber.setMessageListener((MessageListener)this);
                this.tconnection.start();
            }
        }
        catch (NamingException e) {
            this.handleJMSException("GXQueue Connect method error: ", e);
            return false;
        }
        catch (JMSException e) {
            this.handleJMSException("GXQueue Connect method error: ", (Exception)((Object)e));
            return false;
        }
        return true;
    }

    public String send(GXQueueMessage qmessage) {
        int priority = qmessage.getPriority();
        String text = qmessage.getText();
        String correlationId = qmessage.getCorrelationId();
        String messageId = qmessage.getMessageID();
        GXProperties properties = qmessage.getProperties();
        try {
            TextMessage message;
            if (this.type.equals(QUEUE)) {
                QueueSender sender = this.qsession.createSender(this.queue);
                sender.setPriority(priority);
                message = this.qsession.createTextMessage();
                message.setText(text);
                message.setJMSCorrelationID(correlationId);
                message.setJMSMessageID(messageId);
                message.setText(text);
                if (properties != null) {
                    for (int index = 0; index < properties.count(); ++index) {
                        message.setStringProperty(properties.item((int)index).name, properties.item((int)index).value);
                    }
                }
                sender.send((Message)message);
            } else {
                TopicPublisher publisher = this.tsession.createPublisher(this.topic);
                message = this.tsession.createTextMessage();
                message.setText(text);
                message.setJMSPriority(priority);
                message.setJMSCorrelationID(correlationId);
                message.setJMSMessageID(messageId);
                if (properties != null) {
                    for (int index = 0; index < properties.count(); ++index) {
                        message.setStringProperty(properties.item((int)index).name, properties.item((int)index).value);
                    }
                }
                publisher.publish((Message)message);
            }
            return message.getJMSMessageID();
        }
        catch (JMSException e) {
            this.handleJMSException("GXQueue Send method error: ", (Exception)((Object)e));
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GXQueueMessage receive() {
        GXQueueMessage result = new GXQueueMessage();
        try {
            if (this.type.equals(QUEUE)) {
                Message message = this.reciver.receiveNoWait();
                if (message == null) {
                    this.eof = true;
                    return result;
                }
                if (message instanceof TextMessage) {
                    TextMessage txtMessage = (TextMessage)message;
                    result.setText(txtMessage.getText());
                    result.setPriority(txtMessage.getJMSPriority());
                    result.setCorrelationId(txtMessage.getJMSCorrelationID());
                    result.setMessageID(txtMessage.getJMSMessageID());
                    GXProperties msgProps = new GXProperties();
                    Enumeration props = txtMessage.getPropertyNames();
                    while (props.hasMoreElements()) {
                        String propName = (String)props.nextElement();
                        String propValue = txtMessage.getStringProperty(propName);
                        msgProps.add(propName, propValue);
                    }
                    result.setProperties(msgProps);
                }
            } else {
                if (this.topicMessages.size() <= 0) {
                    this.eof = true;
                    return result;
                }
                result = this.topicMessages.elementAt(0);
                this.topicMessages.removeElementAt(0);
            }
            this.eof = false;
            return result;
        }
        catch (JMSException e) {
            this.handleJMSException("GXQueue Receive method error: ", (Exception)((Object)e));
            return result;
        }
    }

    public void onMessage(Message message) {
        try {
            GXQueueMessage result = new GXQueueMessage();
            if (message instanceof TextMessage) {
                TextMessage txtMessage = (TextMessage)message;
                result.setText(txtMessage.getText());
                result.setPriority(txtMessage.getJMSPriority());
                result.setCorrelationId(txtMessage.getJMSCorrelationID());
                result.setMessageID(txtMessage.getJMSMessageID());
                GXProperties msgProps = new GXProperties();
                Enumeration props = txtMessage.getPropertyNames();
                while (props.hasMoreElements()) {
                    String propName = (String)props.nextElement();
                    String propValue = txtMessage.getStringProperty(propName);
                    msgProps.add(propName, propValue);
                }
                result.setProperties(msgProps);
                this.topicMessages.addElement(result);
            }
        }
        catch (JMSException e) {
            this.handleJMSException("GXQueue OnMessage method error: ", (Exception)((Object)e));
        }
    }

    public void browse() {
        try {
            if (this.type.equals(QUEUE)) {
                QueueBrowser browser = this.qsession.createBrowser(this.queue, this.query);
                this.qconnection.start();
                this.messages = browser.getEnumeration();
            }
        }
        catch (JMSException e) {
            this.handleJMSException("GXQueue Browse method error: ", (Exception)((Object)e));
        }
    }

    public byte disconnect() {
        try {
            if (this.type.equals(QUEUE)) {
                if (this.queueAutoCommit.equals("NO")) {
                    qsessions.remove(this.qsession);
                }
                this.qsession.close();
                this.qconnection.close();
            } else {
                if (this.queueAutoCommit.equals("NO")) {
                    tsessions.remove(this.tsession);
                }
                this.tsession.close();
                this.tconnection.close();
            }
        }
        catch (JMSException e) {
            this.handleJMSException("GXQueue Disconnect method error: ", (Exception)((Object)e));
            return 0;
        }
        return 1;
    }

    public static void commitAll() {
        Enumeration<QueueSession> enumera = qsessions.keys();
        while (enumera.hasMoreElements()) {
            try {
                enumera.nextElement().commit();
            }
            catch (JMSException e) {
                logger.error("GXQueue CommitAll method error: ", (Throwable)e);
            }
        }
        enumera = tsessions.keys();
        while (enumera.hasMoreElements()) {
            try {
                ((TopicSession)enumera.nextElement()).commit();
            }
            catch (JMSException e) {
                logger.error("GXQueue CommitAll method error: ", (Throwable)e);
            }
        }
    }

    public static void rollbackAll() {
        Enumeration<QueueSession> enumera = qsessions.keys();
        while (enumera.hasMoreElements()) {
            try {
                enumera.nextElement().rollback();
            }
            catch (JMSException e) {
                logger.error("GXQueue RollbackAll method error: ", (Throwable)e);
            }
        }
        enumera = tsessions.keys();
        while (enumera.hasMoreElements()) {
            try {
                ((TopicSession)enumera.nextElement()).rollback();
            }
            catch (JMSException e) {
                logger.error("GXQueue RollbackAll method error: ", (Throwable)e);
            }
        }
    }

    public void commit() {
        if (this.queueAutoCommit.equals("NO")) {
            try {
                if (this.type.equals(QUEUE)) {
                    this.qsession.commit();
                } else {
                    this.tsession.commit();
                }
            }
            catch (JMSException e) {
                this.handleJMSException("GXQueue Commit method error: ", (Exception)((Object)e));
            }
        }
    }

    public void rollback() {
        if (this.queueAutoCommit.equals("NO")) {
            try {
                if (this.type.equals(QUEUE)) {
                    this.qsession.rollback();
                } else {
                    this.tsession.rollback();
                }
            }
            catch (JMSException e) {
                this.handleJMSException("GXQueue Rollback method error: ", (Exception)((Object)e));
            }
        }
    }

    private void handleJMSException(String methodName, Exception e) {
        this.errCode = 1;
        this.errDescription = e.getMessage();
        logger.error(methodName, (Throwable)e);
    }

    public short getErrCode() {
        return (short)this.errCode;
    }

    public String getErrDescription() {
        return this.errDescription;
    }
}

