/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class GxUtilsLoader
extends ClassLoader {
    public static String GXUTILS_FILE = "GxUtils.jar";
    private static GxUtilsLoader loader = null;
    private String source;
    private ZipFile zipFile = null;
    private Hashtable<String, Class> classes = new Hashtable();
    private int loadDepth;

    public static void runDeveloperMenu(String[] arg) {
        try {
            Class c = GxUtilsLoader.getClass("com.genexus.gx.deployment.developermenu");
            c.getMethod("start", String[].class).invoke(c.newInstance(), new Object[]{arg});
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void runServerConfig(String[] fileName) {
        try {
            Class c = GxUtilsLoader.getClass("com.genexus.gx.deployment.usrvcfg");
            c.getMethod("execute", String[].class).invoke(c.getConstructor(Integer.TYPE).newInstance(new Integer(-1)), new Object[]{fileName});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void runClientConfig(String[] fileName) {
        try {
            Class c = GxUtilsLoader.getClass("com.genexus.gx.deployment.uclicfg");
            c.getMethod("execute", String[].class).invoke(c.getConstructor(Integer.TYPE).newInstance(new Integer(-1)), new Object[]{fileName});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Class getClass(String className) throws Exception {
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            GxUtilsLoader.setLoader();
            return loader.loadClass(className);
        }
    }

    private static void setLoader() throws Exception {
        if (loader == null) {
            System.err.println("Utilities jar file (" + GXUTILS_FILE + ") is not included in classpath");
            System.err.println("Automatically loading " + GXUTILS_FILE + "...");
            loader = new GxUtilsLoader("GxUtils.jar");
        }
    }

    public GxUtilsLoader(String location) {
        this.source = location.trim().toLowerCase();
        this.loadDepth = 0;
        this.openJar();
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        Class cls = this.loadClass(className, true);
        return cls;
    }

    private void openJar() {
        block3: {
            if (this.zipFile == null) {
                try {
                    this.zipFile = new ZipFile(this.source);
                }
                catch (IOException e) {
                    if (this.source.length() == 0) break block3;
                    System.err.println("Could not open JAR File: " + this.source);
                    System.err.println(e.toString());
                }
            }
        }
        ++this.loadDepth;
    }

    private void closeJar() {
        --this.loadDepth;
        if (this.loadDepth > 0) {
            return;
        }
        try {
            if (this.zipFile != null) {
                this.zipFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.zipFile = null;
    }

    public synchronized Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        try {
            Class<?> result = super.findSystemClass(className);
            return result;
        }
        catch (Throwable throwable) {
            Class<?> result = this.classes.get(className);
            if (result != null) {
                return result;
            }
            byte[] classBytes = this.loadBytes(className);
            if (classBytes == null) {
                this.closeJar();
                try {
                    result = this.getClass().getClassLoader().loadClass(className);
                    return result;
                }
                catch (Throwable throwable2) {
                    throw new ClassNotFoundException(className);
                }
            }
            result = this.defineClass(className, classBytes, 0, classBytes.length);
            if (result == null) {
                this.closeJar();
                throw new ClassFormatError();
            }
            if (resolveIt) {
                this.resolveClass(result);
            }
            this.classes.put(className, result);
            return result;
        }
    }

    private byte[] loadBytes(String className) {
        if (this.zipFile == null) {
            throw new NoClassDefFoundError(className);
        }
        byte[] result = null;
        className = className.replace('.', '/') + ".class";
        try {
            ZipEntry theEntry = this.zipFile.getEntry(className);
            if (theEntry != null) {
                result = new byte[(int)theEntry.getSize()];
                InputStream theStream = this.zipFile.getInputStream(theEntry);
                new DataInputStream(new BufferedInputStream(theStream)).readFully(result);
                theStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static String getClassUniqueId(Class classType) {
        URL resource = classType.getResource(classType.getSimpleName() + ".class");
        try {
            long lastModified;
            block21: {
                String path;
                if (resource == null) {
                    throw new IllegalStateException("Failed to find class file for class: " + classType.getName());
                }
                if (resource.getProtocol().equals("file")) {
                    lastModified = new File(resource.toURI()).lastModified();
                } else if (resource.getProtocol().equals("jar")) {
                    path = resource.getPath();
                    lastModified = new File(path.substring(5, path.indexOf("!"))).lastModified();
                } else {
                    if (resource.getProtocol().equals("zip")) {
                        path = resource.getPath();
                        File jarFileOnDisk = new File(path.substring(0, path.indexOf("!")));
                        try (JarFile jf = new JarFile(jarFileOnDisk);){
                            ZipEntry ze = jf.getEntry(path.substring(path.indexOf("!") + 2));
                            lastModified = ze.getTime();
                            break block21;
                        }
                        catch (Exception e) {
                            throw new IllegalStateException("Failed to find class file in zip for class: " + classType.getName());
                        }
                    }
                    throw new IllegalArgumentException("Unhandled url protocol: " + resource.getProtocol() + " for class: " + classType.getName() + " resource: " + resource.toString());
                }
            }
            long ticks = new Date(lastModified).getTime();
            return "?" + new Long(ticks).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid url: " + resource.getProtocol() + " for class: " + classType.getName() + " resource: " + resource.toString());
        }
    }
}

