/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import com.genexus.specific.java.Connect;
import com.genexus.specific.java.LogManager;
import com.genexus.xml.XMLWriter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class JavaInspector {
    public static void main(String[] args) {
        new JavaInspector().execute(args);
    }

    private void execute(String[] args) {
        try {
            Connect.init();
            LogManager.initialize((String)".");
            XMLWriter writer = new XMLWriter();
            writer.setEncoding("UTF8");
            writer.xmlStart("JavaInspector.xml");
            writer.writeStartDocument("UTF-8");
            writer.writeStartElement("ArrayOfClassDefinition");
            writer.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            writer.writeAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            System.out.println("Inspection proccess started");
            if (args[0].toUpperCase().endsWith(".JAR") || args[0].toUpperCase().endsWith(".ZIP")) {
                this.processJarFile(writer, args[0]);
            } else {
                System.out.print("Inspecting " + args[0] + "...");
                this.printClass(writer, Class.forName(args[0]));
            }
            writer.writeEndElement();
            writer.close();
            System.out.println("Inspection proccess succeeded");
        }
        catch (Throwable e) {
            System.out.println("failed");
            System.out.println("Error: " + e.toString());
            System.out.println("Inspection proccess failed");
        }
    }

    private void processJarFile(XMLWriter writer, String jarFile) throws Throwable {
        System.out.println("Inspecting " + jarFile);
        try (JarInputStream jis = new JarInputStream((InputStream)new FileInputStream(jarFile), true);){
            JarEntry je;
            while ((je = jis.getNextJarEntry()) != null) {
                String classMain = je.getName();
                if (!classMain.endsWith(".class")) continue;
                classMain = classMain.replace('/', '.').substring(0, classMain.length() - 6);
                System.out.print("Inspecting " + classMain + "...");
                Class<?> cl = Class.forName(classMain, false, this.getClass().getClassLoader());
                this.printClass(writer, cl);
            }
        }
    }

    private void printClass(XMLWriter writer, Class cls) {
        Package pkg = cls.getPackage();
        String className = cls.getName();
        if (pkg != null) {
            className = className.replaceFirst(pkg.getName() + ".", "");
        }
        writer.writeStartElement("ClassDefinition");
        writer.writeElement("Name", className);
        if (pkg != null) {
            writer.writeElement("PackageName", pkg.getName());
        } else {
            writer.writeElement("PackageName", "");
        }
        this.printConstructors(writer, cls);
        this.printAttributes(writer, cls);
        this.printMethods(writer, cls);
        writer.writeEndElement();
        System.out.println("success");
    }

    private void printConstructors(XMLWriter writer, Class cls) {
        writer.writeStartElement("Constructors");
        Constructor<?>[] constructor = cls.getConstructors();
        for (int i = 0; i < constructor.length; ++i) {
            Constructor<?> construct = constructor[i];
            writer.writeStartElement("Constructor");
            String defaultParametersString = this.buildDefaultParametersInit(construct.getParameterTypes());
            writer.writeElement("DefaultParametersString", defaultParametersString);
            this.printParameters(writer, construct.getParameterTypes());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private String buildDefaultParametersInit(Class[] pvec) {
        String returnValue = "";
        for (int j = 0; j < pvec.length; ++j) {
            returnValue = pvec[j].isPrimitive() ? returnValue + this.getPrimitiveDefaultValue(pvec[j].getName()) : returnValue + "null";
            if (j >= pvec.length - 1) continue;
            returnValue = returnValue + " ,";
        }
        return returnValue;
    }

    private String getPrimitiveDefaultValue(String value) {
        if (value.equals("char")) {
            return "";
        }
        if (value.equals("byte") || value.equals("short") || value.equals("int") || value.equals("long") || value.equals("float") || value.equals("double")) {
            return "0";
        }
        if (value.equals("boolean")) {
            return "false";
        }
        return "";
    }

    private void printAttributes(XMLWriter writer, Class cls) {
        writer.writeStartElement("Attributes");
        Field[] fieldlist = cls.getDeclaredFields();
        for (int i = 0; i < fieldlist.length; ++i) {
            Field fld = fieldlist[i];
            int mod = fld.getModifiers();
            if (!Modifier.isPublic(mod) || Modifier.isFinal(mod)) continue;
            writer.writeStartElement("Attribute");
            writer.writeElement("Name", fld.getName());
            writer.writeStartElement("Type");
            this.printType(writer, fld.getType());
            writer.writeEndElement();
            writer.writeElement("AccessType", "member");
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void printMethods(XMLWriter writer, Class cls) {
        Method[] methlist = cls.getDeclaredMethods();
        writer.writeStartElement("Methods");
        for (int i = 0; i < methlist.length; ++i) {
            Method m = methlist[i];
            int mod = m.getModifiers();
            if (!Modifier.isPublic(mod)) continue;
            writer.writeStartElement("Method");
            writer.writeElement("Name", m.getName());
            if (Modifier.isStatic(mod)) {
                writer.writeElement("IsStatic", "true");
            } else {
                writer.writeElement("IsStatic", "false");
            }
            this.printParameters(writer, m.getParameterTypes());
            writer.writeStartElement("ReturnType");
            this.printType(writer, m.getReturnType());
            writer.writeEndElement();
            Class<?>[] evec = m.getExceptionTypes();
            if (evec.length == 0) {
                writer.writeElement("Exceptions", "No");
            } else {
                writer.writeElement("Exceptions", "Yes");
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void printParameters(XMLWriter writer, Class[] pvec) {
        writer.writeStartElement("Parameters");
        for (int j = 0; j < pvec.length; ++j) {
            writer.writeStartElement("Parameter");
            writer.writeElement("Name", "param" + j);
            writer.writeStartElement("Type");
            boolean isArray = this.printType(writer, pvec[j]);
            writer.writeEndElement();
            if (isArray) {
                writer.writeElement("InOut", "inout");
            } else {
                writer.writeElement("InOut", "in");
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private boolean printType(XMLWriter writer, Class classType) {
        boolean isArray = false;
        if (classType.getName().charAt(0) == '[') {
            isArray = true;
        }
        GXType gxt = new GXType(classType, isArray);
        writer.writeElement("Name", classType.getName());
        writer.writeElement("Type", gxt.type);
        writer.writeElement("Length", (long)gxt.length);
        writer.writeElement("Decimals", (long)gxt.decimals);
        writer.writeElement("Sign", (long)gxt.sign);
        writer.writeElement("PlatformType", gxt.platformType);
        writer.writeElement("IsCollection", gxt.isCollection);
        return isArray;
    }

    class GXType {
        String name;
        String type;
        int length;
        int decimals;
        int sign;
        String isCollection = "false";
        String platformType;

        public GXType(Class returnType, boolean isArray) {
            this.platformType = !isArray ? returnType.getName() : this.getArrayType(returnType.getName());
            if (returnType == Character.class || returnType.getName().equals("char") || returnType.getName().equals("[C")) {
                this.type = "char";
                this.length = 1;
                this.decimals = 0;
                this.sign = 0;
            } else if (returnType == String.class || returnType.getName().equals("[Ljava.lang.String;")) {
                this.type = "char";
                this.length = 100;
                this.decimals = 0;
                this.sign = 0;
            } else if (returnType == Byte.class || returnType.getName().equals("byte") || returnType.getName().equals("[B")) {
                this.type = "int";
                this.length = 2;
                this.decimals = 0;
                this.sign = 0;
            } else if (returnType == Short.class || returnType.getName().equals("short") || returnType.getName().equals("[S")) {
                this.type = "int";
                this.length = 4;
                this.decimals = 0;
                this.sign = 0;
            } else if (returnType == Integer.class || returnType.getName().equals("int") || returnType.getName().equals("[I")) {
                this.type = "int";
                this.length = 9;
                this.decimals = 0;
                this.sign = 0;
            } else if (returnType == Long.class || returnType.getName().equals("long") || returnType.getName().equals("[J")) {
                this.type = "int";
                this.length = 12;
                this.decimals = 0;
                this.sign = 0;
            } else if (returnType == Float.class || returnType.getName().equals("float") || returnType.getName().equals("[F")) {
                this.type = "int";
                this.length = 19;
                this.decimals = 8;
                this.sign = 0;
            } else if (returnType == Double.class || returnType.getName().equals("double") || returnType.getName().equals("[D")) {
                this.type = "int";
                this.length = 19;
                this.decimals = 8;
                this.sign = 0;
            } else if (returnType == BigDecimal.class || returnType.getName().equals("[Ljava.math.BigDecimal;")) {
                this.type = "int";
                this.length = 19;
                this.decimals = 8;
                this.sign = 0;
            } else if (returnType == Date.class || returnType.getName().equals("[Ljava.util.Date;")) {
                this.type = "dtime";
                this.length = 0;
                this.decimals = 0;
                this.sign = 0;
            } else if (returnType == Boolean.class || returnType.getName().equals("boolean") || returnType.getName().equals("[Z")) {
                this.type = "bool";
                this.length = 0;
                this.decimals = 0;
                this.sign = 0;
            } else if (returnType == Vector.class || returnType == ArrayList.class) {
                this.type = "o(object)";
                this.length = 0;
                this.decimals = 0;
                this.sign = 0;
                this.isCollection = "true";
            } else if (returnType == Void.class || returnType.getName().equals("void")) {
                this.type = "void";
                this.length = 0;
                this.decimals = 0;
                this.sign = 0;
            }
        }

        private String getArrayType(String returnType) {
            String arrayType = returnType.substring(1).equals("Z") ? "boolean" : (returnType.substring(1).equals("B") ? "byte" : (returnType.substring(1).equals("C") ? "char" : (returnType.substring(1).equals("D") ? "double" : (returnType.substring(1).equals("F") ? "float" : (returnType.substring(1).equals("I") ? "int" : (returnType.substring(1).equals("J") ? "long" : (returnType.substring(1).equals("S") ? "short" : returnType.substring(2, returnType.length() - 1))))))));
            return arrayType;
        }
    }
}

