/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import com.genexus.diagnostics.core.ILogger;
import com.genexus.diagnostics.core.LogManager;
import com.genexus.util.GXProperties;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LDAPClient {
    private static final ILogger logger = LogManager.getLogger(LDAPClient.class);
    String ldapHost;
    int port = 389;
    String authentication = "simple";
    String user = "";
    String password = "";
    byte secure;
    DirContext ctx;

    public void setHost(String host) {
        this.ldapHost = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAuthenticationMethod(String authentication) {
        this.authentication = authentication;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSecure(byte secure) {
        this.secure = secure;
    }

    public byte connect() {
        Hashtable<String, String> env = new Hashtable<String, String>(5);
        if (this.ldapHost.equals("")) {
            return 0;
        }
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        String host = "ldap://" + this.ldapHost + ":" + this.port;
        env.put("java.naming.provider.url", host);
        env.put("java.naming.security.authentication", this.authentication);
        env.put("java.naming.security.principal", this.user);
        env.put("java.naming.security.credentials", this.password);
        if (this.secure == 1) {
            env.put("java.naming.security.protocol", "ssl");
        }
        try {
            this.ctx = new InitialDirContext(env);
        }
        catch (NamingException e) {
            logger.error("Error in connect", (Throwable)e);
            return 0;
        }
        return 1;
    }

    public void disconnect() {
        try {
            this.ctx.close();
        }
        catch (NamingException e) {
            logger.error("Error in disconnect", (Throwable)e);
        }
    }

    public Vector<String> getAttribute(String attName, String context, GXProperties ldapAttributes) {
        Vector<String> strResult = new Vector<String>();
        BasicAttributes matchAttrs = new BasicAttributes(true);
        String searchFilter = "";
        if (ldapAttributes.count() > 0) {
            searchFilter = "(&";
            for (int i = 0; i < ldapAttributes.count(); ++i) {
                searchFilter = searchFilter + "(" + ldapAttributes.item((int)i).name + "=" + ldapAttributes.item((int)i).value + ")";
            }
            searchFilter = searchFilter + ")";
        }
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            NamingEnumeration<SearchResult> resultSearch = this.ctx.search(context, searchFilter, searchControls);
            while (resultSearch.hasMoreElements()) {
                SearchResult sr = resultSearch.next();
                Attributes resultAtts = sr.getAttributes();
                Attribute resultAtt = resultAtts.get(attName);
                if (resultAtt == null) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("Attribute " + attName + " not found");
                    NamingEnumeration<String> validAtts = resultAtts.getIDs();
                    logger.error("Valid attributes are:");
                    while (validAtts.hasMoreElements()) {
                        String validAtt = validAtts.next();
                        logger.error(" " + validAtt);
                    }
                    continue;
                }
                for (int j = 0; j < resultAtt.size(); ++j) {
                    strResult.addElement((String)resultAtt.get(j));
                }
            }
            return strResult;
        }
        catch (NamingException e) {
            logger.error("Error in getAttribute", (Throwable)e);
            return strResult;
        }
    }
}

