/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import com.genexus.GXParameterPacker;
import com.genexus.GXParameterUnpacker;
import com.genexus.ISubmitteable;
import com.genexus.ModelContext;
import com.genexus.Preferences;
import com.genexus.util.SubmitThread;
import java.util.Vector;

public class SubmitThreadPool {
    public static final String SUBMIT_THREAD = "SubmitThread-";
    private static SubmitThread[] threadPool = null;
    private static Vector<Object[]> submitQueue = new Vector();
    private static int poolId = -1;
    private static int remainingSubmits = 0;
    private static GXParameterPacker parameterPacker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void submit(final ISubmitteable proc, final int id, final Object[] submitParms, final ModelContext ctx) {
        if (threadPool == null) {
            threadPool = new SubmitThread[Preferences.getDefaultPreferences().getSUBMIT_POOL_SIZE()];
            parameterPacker = new GXParameterPacker();
        }
        SubmitThreadPool.incRemainingSubmits();
        if (threadPool.length == 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (ModelContext.threadModelContext.get() == null) {
                        ModelContext.threadModelContext.set((Object)ctx);
                    }
                    proc.submit(id, submitParms, ctx);
                    SubmitThreadPool.decRemainingSubmits();
                }
            }, SUBMIT_THREAD + id).start();
            return;
        }
        parameterPacker.reset();
        parameterPacker.writeObject((Object)submitParms);
        for (int i = 0; i < threadPool.length; ++i) {
            if (threadPool[i] == null) {
                SubmitThreadPool.threadPool[i] = new SubmitThread(i);
                threadPool[i].start();
                while (!threadPool[i].isInitialized()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            SubmitThread submitThread = threadPool[i];
            synchronized (submitThread) {
                if (threadPool[i].inUse()) {
                    continue;
                }
                threadPool[i].setProc(proc, id, (Object[])new GXParameterUnpacker(parameterPacker.toByteArray()).readObject(), ctx);
                threadPool[i].notify();
                return;
            }
        }
        submitQueue.addElement(new Object[]{proc, new Integer(id), parameterPacker.toByteArray()});
    }

    protected static synchronized void incRemainingSubmits() {
        ++remainingSubmits;
    }

    protected static synchronized void decRemainingSubmits() {
        --remainingSubmits;
        SubmitThreadPool.class.notify();
    }

    public static int getRemainingSubmits() {
        return remainingSubmits;
    }

    public static synchronized void waitForEnd() {
        if (remainingSubmits > 0) {
            System.err.println("Waiting for " + remainingSubmits + " submitted procs to end...");
        }
        while (remainingSubmits > 0) {
            try {
                SubmitThreadPool.class.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        SubmitThreadPool.destroyPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void destroyPool() {
        if (threadPool != null) {
            for (int i = 0; i < threadPool.length; ++i) {
                if (threadPool[i] == null) continue;
                SubmitThread submitThread = threadPool[i];
                synchronized (submitThread) {
                    threadPool[i].setExit();
                    threadPool[i].notify();
                    SubmitThreadPool.threadPool[i] = null;
                    continue;
                }
            }
        }
        threadPool = null;
    }

    protected static synchronized Object[] getNextSubmit() {
        if (submitQueue.size() > 0) {
            Object[] nextSubmit = submitQueue.firstElement();
            submitQueue.removeElement(nextSubmit);
            return nextSubmit;
        }
        return null;
    }
}

