/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.util;

import com.genexus.reports.SunGXReportViewer;
import com.genexus.util.ICommandQueue;
import com.genexus.util.RunnableFlag;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ThreadedCommandQueue
implements ICommandQueue,
Runnable {
    private ConcurrentLinkedQueue<RunnableFlag> queue;
    private Thread thread;
    private boolean isDispatching;

    public void startDispatching() {
        this.isDispatching = true;
        this.queue = new ConcurrentLinkedQueue();
        this.thread = new Thread((Runnable)this, "Report viewer queue");
        this.thread.start();
    }

    private void restartDispatching() {
        this.isDispatching = true;
        this.thread = new Thread((Runnable)this, "Report viewer queue");
        this.thread.start();
    }

    public void addCommandNowait(Runnable cmd) {
        try {
            if (!this.isDispatching) {
                this.restartDispatching();
            }
            this.queue.add(new RunnableFlag(cmd, true));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(Runnable cmd) {
        RunnableFlag cmdr = new RunnableFlag(cmd);
        try {
            if (!this.isDispatching) {
                this.restartDispatching();
            }
            this.queue.add(cmdr);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        RunnableFlag runnableFlag = cmdr;
        synchronized (runnableFlag) {
            cmdr.setFlag(true);
            try {
                cmdr.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean consume(RunnableFlag o) {
        boolean ret = false;
        RunnableFlag cmdr = o;
        if (cmdr != null) {
            ret = true;
            while (!cmdr.getFlag()) {
                Thread.yield();
            }
            cmdr.runnable.run();
            RunnableFlag runnableFlag = cmdr;
            synchronized (runnableFlag) {
                cmdr.notifyAll();
            }
        }
        return ret;
    }

    @Override
    public void run() {
        while (true) {
            RunnableFlag rf;
            if ((rf = this.queue.peek()) != null) {
                try {
                    rf = this.queue.poll();
                    if (rf.getRunCleanup()) {
                        this.isDispatching = false;
                        this.thread.join();
                        return;
                    }
                    this.consume(rf);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            new SunGXReportViewer().gxIsAlive();
        }
    }

    public void cleanup() {
        try {
            RunnableFlag cleanupCmd = new RunnableFlag(null);
            cleanupCmd.setRunCleanup(true);
            this.queue.add(cleanupCmd);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

