/*
 * Decompiled with CFR 0.152.
 */
package com.genexus.webpanels;

import com.genexus.ModelContext;
import com.genexus.internet.HttpContext;
import com.genexus.util.GXFile;
import com.genexus.webpanels.HttpContextWeb;
import com.genexus.webpanels.WebSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public class BlobsCleaner {
    private static BlobsCleaner instance = null;
    private Hashtable<String, ArrayList<String>> blobsTable = new Hashtable();
    private static Object syncRoot = new Object();

    private BlobsCleaner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlobsCleaner getInstance() {
        if (instance == null) {
            Object object = syncRoot;
            synchronized (object) {
                if (instance == null) {
                    instance = new BlobsCleaner();
                }
            }
        }
        return instance;
    }

    public static void endBlobCleaner() {
        instance = null;
    }

    private synchronized void sessionCreated(String sessionId) {
        try {
            if (this.blobsTable.get(sessionId) == null) {
                this.blobsTable.put(sessionId, new ArrayList());
            }
        }
        catch (Throwable e) {
            System.err.println("*** ERROR *** Adding session for blobs to be deleted:\n" + e.getMessage());
        }
    }

    public synchronized void sessionDestroyed(String sessionId) {
        try {
            this.removeSessionFiles(sessionId);
        }
        catch (Throwable e) {
            System.err.println("*** ERROR *** Deleting blobs on session destroyed:\n" + e.getMessage());
        }
    }

    public synchronized void contextDestroyed() {
        try {
            this.removeAllFiles();
        }
        catch (Throwable e) {
            System.err.println("*** ERROR *** Deleting blobs on context destroyed:\n" + e.getMessage());
        }
    }

    public synchronized void addBlobFile(String filePath) {
        if (filePath.trim().equals("")) {
            return;
        }
        try {
            String sId;
            ArrayList<String> obj;
            WebSession session = this.getCurrentSession();
            if (session != null && (obj = this.blobsTable.get(sId = session.getId().toString())) != null) {
                obj.add(filePath);
            }
        }
        catch (Throwable e) {
            System.err.println("*** ERROR *** Adding blob to be deleted:\n" + e.getMessage());
        }
    }

    private synchronized void setCurrentSessionInUse(WebSession session) {
        String sId = session.getId().toString();
        this.sessionCreated(sId);
        session.setAttribute("GX_SESSION_DESTROY_FLAG", "1");
    }

    private WebSession getCurrentSession() {
        WebSession session = null;
        HttpContext webContext = (HttpContext)ModelContext.getModelContext().getHttpContext();
        if (webContext != null && webContext instanceof HttpContextWeb) {
            session = webContext.getWebSession();
            this.setCurrentSessionInUse(session);
        }
        return session;
    }

    private void removeSessionFiles(String sessionId) {
        ArrayList<String> obj = this.blobsTable.get(sessionId);
        if (obj != null) {
            this.deleteAllFiles(obj);
            this.blobsTable.remove(sessionId);
        }
    }

    private void removeAllFiles() {
        Collection<ArrayList<String>> filesLists = this.blobsTable.values();
        Iterator<ArrayList<String>> it = filesLists.iterator();
        while (it.hasNext()) {
            this.deleteAllFiles(it.next());
        }
        this.blobsTable.clear();
    }

    private void deleteAllFiles(ArrayList<String> files) {
        Iterator<String> it = files.iterator();
        while (it.hasNext()) {
            GXFile tempFile = new GXFile(it.next().toString());
            if (!tempFile.exists()) continue;
            try {
                tempFile.delete();
            }
            catch (Throwable e) {
                System.err.println("*** ERROR *** Deleting file:\n" + tempFile.getAbsolutePath());
            }
        }
        files.clear();
    }
}

